/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.adapter.user.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.eclipse.mddi.modelbus.adapter.infrastructure.AdapterContainerImpl;
import org.eclipse.mddi.modelbus.adapter.infrastructure.DeploymentException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.RootLogger;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.DescriptionUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.GlobalResourceRegistry;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.ModelUtil;
import org.eclipse.mddi.modelbus.adapter.infrastructure.model_manipulation.Xmi2EmfConversion;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceClient;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.notification.NotifServiceNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.DefaultToolSelector;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryClient;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.RegistryNotAvailableException;
import org.eclipse.mddi.modelbus.adapter.infrastructure.registry.ToolSelectionStrategy;
import org.eclipse.mddi.modelbus.adapter.infrastructure.serialize.ModelSerializerFactory;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.DefaultTransportManager;
import org.eclipse.mddi.modelbus.adapter.infrastructure.transport.ws.TransportManager;
import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;
import org.eclipse.mddi.modelbus.adapter.user.ToolStub;
import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;
import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;
import org.eclipse.mddi.modelbus.adapter.user.consumer.SpecificConsumer;
import org.eclipse.mddi.modelbus.adapter.user.consumer.SpecificInterfaceManager;
import org.eclipse.mddi.modelbus.adapter.user.consumer.impl.GenericConsumerImpl;
import org.eclipse.mddi.modelbus.adapter.user.impl.ToolStubImpl;
import org.eclipse.mddi.modelbus.adapter.user.notification.NotificationPublisher;
import org.eclipse.mddi.modelbus.description.concrete.Tool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdapterStubImpl
implements AdapterStub {
    Properties properties = null;
    Tool toolDescription = null;
    private GenericConsumerImpl si = new GenericConsumerImpl(this);
    ToolStub toolStub = new ToolStubImpl();
    ToolSelectionStrategy toolSelector = new DefaultToolSelector();
    TransportManager transportManager;

    public AdapterStubImpl(Properties initProperties) throws DeploymentException {
        String ns_loc;
        this.properties = initProperties;
        String registry_loc = this.properties.getProperty("registry_location");
        this.transportManager = new DefaultTransportManager(this);
        DeploymentException ex = new DeploymentException();
        if (registry_loc != null) {
            try {
                RegistryManager.getInstance().getRegistryClient(registry_loc);
            }
            catch (RegistryNotAvailableException e) {
                ex.addProblem("RegistryNotAvailable", e);
            }
        }
        if ((ns_loc = this.properties.getProperty("notification_service_location")) != null) {
            try {
                NotifServiceManager.getInstance().getNotificationServiceClient(ns_loc);
            }
            catch (NotifServiceNotAvailableException e) {
                ex.addProblem("NotifServiceNotAvaiable", e);
            }
        }
        try {
            this.loadDescription();
        }
        catch (IOException e) {
            ex.addProblem("Bad tool description file", e);
        }
        if (ex.hasProblems()) {
            throw ex;
        }
    }

    private void loadDescription() throws IOException {
        String toolDescFile = this.properties.getProperty("tool_desc_file");
        if (toolDescFile == null) {
            return;
        }
        Collection emfobjs = Xmi2EmfConversion.convertFromFile(toolDescFile, false);
        Collection col = ModelUtil.findElementByType(emfobjs, "Tool");
        if (col.isEmpty()) {
            throw new IOException("No tool description found in " + toolDescFile);
        }
        if (col.size() > 1) {
            RootLogger.getLogger().log(Level.WARNING, "Warning. Several Tool Descriptions were found in " + toolDescFile);
        }
        this.toolDescription = (Tool)col.iterator().next();
        DescriptionUtil.importAllMetamodels(this.toolDescription, GlobalResourceRegistry.GLOBAL_URI_PREFIX_SET);
    }

    @Override
    public GenericConsumer getGenericServiceInvocation() {
        return this.getGenericConsumer();
    }

    @Override
    public GenericConsumer getGenericConsumer() {
        return this.si;
    }

    @Override
    public SpecificConsumer getSpecificServiceInvocation(String modelingServiceInterfaceName) throws NoToolAvailableException {
        SpecificConsumer i = SpecificInterfaceManager.getInstance().getSpecificInterface(modelingServiceInterfaceName);
        if (i != null) {
            return i;
        }
        throw new NoToolAvailableException("for ModelingServiceInterface " + modelingServiceInterfaceName);
    }

    @Override
    public NotificationPublisher getNotificationPublisher() throws NotifServiceNotAvailableException {
        String notif_loc = this.properties.getProperty("notification_service_location");
        if (notif_loc == null) {
            throw new NotifServiceNotAvailableException("no location specified", null);
        }
        NotifServiceClient pub = NotifServiceManager.getInstance().getNotificationServiceClient(notif_loc);
        return pub;
    }

    @Override
    public ToolStub getToolStub() {
        return this.toolStub;
    }

    @Override
    public Tool getToolDescription() {
        return this.toolDescription;
    }

    @Override
    public void setToolDescription(Tool toolDescription) {
        this.toolDescription = toolDescription;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public ToolSelectionStrategy getToolSelector() {
        return this.toolSelector;
    }

    @Override
    public void setToolSelector(ToolSelectionStrategy toolSelector) {
        this.toolSelector = toolSelector;
    }

    @Override
    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    @Override
    public void deploy() throws DeploymentException {
        AdapterContainerImpl.getInstance().deployAdapter(this);
    }

    @Override
    public void undeploy() throws DeploymentException {
        AdapterContainerImpl.getInstance().undeployAdapter(this);
    }

    @Override
    public void setDefaultModelSerializerFactory(ModelSerializerFactory f) {
        this.getTransportManager().setDefaultModelSerializerFactory(f);
    }

    public Tool findToolDescription(String serviceName) throws RegistryNotAvailableException, ServiceUnknownException {
        RegistryClient rc = this.getRegistryClient();
        return rc.lookupToolByModelingService(serviceName, this.getToolSelector());
    }

    @Override
    public List<Tool> findToolDescriptions(String serviceName) throws RegistryNotAvailableException, ServiceUnknownException {
        RegistryClient rc = this.getRegistryClient();
        return rc.lookupToolsByModelingService(serviceName);
    }

    @Override
    public RegistryClient getRegistryClient() throws RegistryNotAvailableException {
        String registryLocation = this.getProperties().getProperty("registry_location");
        if (registryLocation == null) {
            throw new RegistryNotAvailableException("no Registry URL specified");
        }
        RegistryClient rc = RegistryManager.getInstance().getRegistryClient(registryLocation);
        return rc;
    }

    @Override
    public void setTransportManager(TransportManager transportManager) {
        this.transportManager = transportManager;
    }
}

