/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.description.impl.DescriptionPackageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptionModelLoader {
    protected ModelBusPackaging model = null;
    protected ArrayList<ModelingServiceInterface> modelingServicesInterfaces = null;
    protected Tool tool = null;
    private String output_package = "";
    private ArrayList<EPackage> metaClasses = null;

    public DescriptionModelLoader(String fileName) throws IOException {
        DescriptionPackageImpl.init();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        ResourceSetImpl rSet = new ResourceSetImpl();
        Resource res = rSet.createResource(URI.createURI((String)"modelbus"));
        FileInputStream in = new FileInputStream(fileName);
        res.load((InputStream)in, new HashMap());
        in.close();
        this.analyseResource(res);
        this.modelingServicesInterfaces = new ArrayList();
        this.createModelBusPackaging(this.model);
        this.searchTool(this.model);
    }

    public void setOutputPackage(String outputpackage) {
        this.output_package = outputpackage;
    }

    public String getOutputPackage() {
        return this.output_package;
    }

    public ModelingServiceInterface[] getModelingServiceInterfaces() {
        ModelingServiceInterface[] retour = new ModelingServiceInterface[this.modelingServicesInterfaces.size()];
        retour = this.modelingServicesInterfaces.toArray(retour);
        return retour;
    }

    public Tool getTool() {
        return this.tool;
    }

    private void createModelBusPackaging(ModelBusPackaging mp) {
        EList contents = mp.eContents();
        int i = 0;
        while (i < contents.size()) {
            if (contents.get(i) instanceof ModelingServiceInterface) {
                this.modelingServicesInterfaces.add((ModelingServiceInterface)contents.get(i));
            }
            if (contents.get(i) instanceof ModelBusPackaging) {
                this.createModelBusPackaging((ModelBusPackaging)contents.get(i));
            }
            ++i;
        }
    }

    private void searchTool(ModelBusPackaging mp) {
        EList contents = mp.getContent();
        int i = 0;
        while (i < contents.size()) {
            if (contents.get(i) instanceof Tool) {
                this.tool = (Tool)contents.get(i);
                return;
            }
            if (contents.get(i) instanceof ModelBusPackaging) {
                this.searchTool((ModelBusPackaging)contents.get(i));
            }
            ++i;
        }
    }

    private void analyseResource(Resource resource) {
        this.model = (ModelBusPackaging)resource.getContents().get(0);
        this.metaClasses = new ArrayList();
        if (resource.getContents().size() > 1) {
            int i = 1;
            while (i < resource.getContents().size()) {
                this.metaClasses.add((EPackage)resource.getContents().get(i));
                ++i;
            }
        }
    }

    public ModelBusPackaging getModelBusPackaging() {
        return this.model;
    }

    public ArrayList<EPackage> getMetaClasses() {
        return this.metaClasses;
    }
}

