/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapterFactory;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.importer.ecore.EcoreImporter;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.jet.ImplTemplate;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.jet.InterfaceTemplate;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.jet.ProviderTemplate;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.jet.StubTemplate;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.jet.WSDLModelingInterfaceTemplate;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.EException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ETException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MPException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSIException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MetaSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.PException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ToolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Toolkit {
    protected static final String HELP_OPTION = "-help";
    protected static final String OUTPUT_DIRECTORY_OPTION = "-directory";
    protected static final String OUTPUT_PACKAGE_OPTION = "-package";
    protected static final String JAVADOC_OPTION = "-javadoc";
    public static boolean javadoc = false;
    protected static final String PROVIDER_OPTION = "-provider";
    public static boolean provider = false;
    protected static final String STUB_OPTION = "-stub";
    public static boolean stub = false;
    protected static final String IMPL_OPTION = "-impl";
    public static boolean impl = false;
    protected static final String ASYNC_OPTION = "-async";
    public static boolean async = false;
    protected static final String WSDL_OPTION = "-wsdl";
    public static boolean wsdl = false;
    protected static String outputDirectory;
    protected static String outputPackage;
    protected static String filelocation;
    protected ArrayList<EPackage> metaclasses;
    private static IProject project;

    public Toolkit() {
        filelocation = "";
        outputDirectory = ".";
        outputPackage = "";
        GeneratorAdapterFactory.Descriptor.Registry.INSTANCE.addDescriptor("http://www.eclipse.org/emf/2002/GenModel", GenModelGeneratorAdapterFactory.DESCRIPTOR);
        EcorePlugin.getPlatformResourceMap().put("project", URI.createURI((String)outputDirectory));
    }

    public static void main(String[] args) {
        try {
            Hashtable<String, String> arguments = new Hashtable<String, String>();
            int i = 1;
            while (i < args.length) {
                if (args[i].compareTo(OUTPUT_DIRECTORY_OPTION) == 0 || args[i].compareTo(OUTPUT_PACKAGE_OPTION) == 0) {
                    arguments.put(args[i], args[i + 1]);
                    ++i;
                } else if (args[i].equals(JAVADOC_OPTION)) {
                    javadoc = true;
                } else if (args[i].equals(IMPL_OPTION)) {
                    impl = true;
                } else if (args[i].equals(PROVIDER_OPTION)) {
                    provider = true;
                } else if (args[i].equals(STUB_OPTION)) {
                    stub = true;
                } else if (args[i].equals(ASYNC_OPTION)) {
                    async = true;
                } else if (args[i].equals(WSDL_OPTION)) {
                    wsdl = true;
                } else {
                    throw new Exception();
                }
                ++i;
            }
            String fileName = args[0];
            outputDirectory = (String)arguments.get(OUTPUT_DIRECTORY_OPTION);
            outputPackage = (String)arguments.get(OUTPUT_PACKAGE_OPTION);
            if (outputDirectory == null) {
                outputDirectory = ".";
            }
            if (outputPackage == null) {
                outputPackage = "";
            }
            DescriptionModelLoader modelLoader = new DescriptionModelLoader(fileName);
            Validation.globalValidation(modelLoader.getModelBusPackaging());
            System.out.println("Tool description validated");
        }
        catch (Exception e) {
            Toolkit.printHelp();
            System.err.println(e.getMessage());
        }
    }

    public void generateSources() {
        try {
            DescriptionModelLoader modelLoader = new DescriptionModelLoader(filelocation);
            Validation.globalValidation(modelLoader.getModelBusPackaging());
            modelLoader.setOutputPackage(outputPackage);
            this.generateSources(modelLoader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String validate() {
        try {
            DescriptionModelLoader modelLoader = new DescriptionModelLoader(filelocation);
            Validation.globalValidation(modelLoader.getModelBusPackaging());
        }
        catch (MPException e) {
            return e.getMessage();
        }
        catch (MSIException e) {
            return e.getMessage();
        }
        catch (TException e) {
            return e.getMessage();
        }
        catch (EException e) {
            return e.getMessage();
        }
        catch (ETException e) {
            return e.getMessage();
        }
        catch (NameFormatException e) {
            return e.getMessage();
        }
        catch (MetaSException e) {
            return e.getMessage();
        }
        catch (MSException e) {
            return e.getMessage();
        }
        catch (PException e) {
            return e.getMessage();
        }
        catch (ToolException e) {
            return e.getMessage();
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return null;
    }

    public void generateSources(DescriptionModelLoader modelLoader) {
        try {
            Object providerTemplate;
            this.generateModelCode();
            InterfaceTemplate interfaceTemplate = new InterfaceTemplate();
            ModelingServiceInterface[] modelingServiceInterfaceArray = modelLoader.getModelingServiceInterfaces();
            int n = modelingServiceInterfaceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelingServiceInterface msi = modelingServiceInterfaceArray[n2];
                File file = new File(String.valueOf(outputDirectory) + File.separator + msi.getName() + ".java");
                ArrayList<String> values = new ArrayList<String>();
                values.add(outputPackage);
                values.add((String)msi);
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(interfaceTemplate.generate(values).getBytes());
                fos.close();
                ++n2;
            }
            System.out.println("Interfaces Generated");
            if (impl) {
                ImplTemplate implTemplate = new ImplTemplate();
                File file = new File(String.valueOf(outputDirectory) + File.separator + modelLoader.getTool().getName() + "Impl.java");
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(implTemplate.generate(modelLoader).getBytes());
                fos.close();
                System.out.println("Impl Generated");
            }
            if (provider) {
                providerTemplate = new ProviderTemplate();
                File file = new File(String.valueOf(outputDirectory) + File.separator + modelLoader.getTool().getName() + "Provider.java");
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(((ProviderTemplate)providerTemplate).generate(modelLoader).getBytes());
                fos.close();
                System.out.println("Provider Generated");
            }
            if (stub) {
                providerTemplate = new StubTemplate();
                File file = new File(String.valueOf(outputDirectory) + File.separator + modelLoader.getTool().getName() + ".java");
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(((StubTemplate)providerTemplate).generate(modelLoader).getBytes());
                fos.close();
                System.out.println("Stub Generated");
            }
            if (wsdl) {
                WSDLModelingInterfaceTemplate wsdlTemplate = new WSDLModelingInterfaceTemplate();
                File file = new File(String.valueOf(outputDirectory) + File.separator + modelLoader.getTool().getName() + ".wsdl");
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(wsdlTemplate.generate(modelLoader).getBytes());
                fos.close();
                System.out.println("WSDL Generated");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void generateModelCode() {
        System.out.println("Generate ModelCode of MetaClasses...");
        if (!this.metaclasses.isEmpty()) {
            try {
                EcoreImporter imp = new EcoreImporter();
                imp.getEPackages().addAll(this.metaclasses);
                ResourceSet resourceSet = imp.createResourceSet();
                Resource resource = resourceSet.createResource(URI.createFileURI((String)"toolkit.genmodel"));
                resource.save((OutputStream)System.out, null);
                imp.computeEPackages((Monitor)new BasicMonitor.Printing(System.out));
                GenModel genmodel = imp.getGenModel();
                genmodel.createGenPackage().setPrefix("Test");
                int i = 0;
                while (i < this.metaclasses.size()) {
                    EPackage epackage = this.metaclasses.get(i);
                    GenPackage genpackage = genmodel.createGenPackage();
                    genpackage.setEcorePackage(epackage);
                    genpackage.setPrefix(epackage.getName());
                    genmodel.getGenPackages().add((Object)genpackage);
                    ++i;
                }
                genmodel.setCopyrightFields(false);
                genmodel.setImporterID(imp.getID());
                EcorePlugin.getPlatformResourceMap().put(project.getName(), URI.createPlatformResourceURI((String)outputDirectory, (boolean)true));
                genmodel.setModelName("ToolkitGenModel");
                genmodel.setComplianceLevel(GenJDKLevel.JDK50_LITERAL);
                genmodel.setModelPluginID("MetaClass");
                genmodel.setModelDirectory(String.valueOf(project.getName()) + "/src");
                System.out.println("Project directory: " + genmodel.getModelDirectory());
                genmodel.setValidateModel(true);
                resource.getContents().add((Object)genmodel);
                genmodel.eResource().save((OutputStream)System.out, null);
                genmodel.setForceOverwrite(true);
                Generator generator = new Generator();
                genmodel.reconcile();
                genmodel.setCanGenerate(true);
                generator.getOptions();
                generator.setInput((Object)genmodel);
                System.out.println(genmodel.getModelDirectory());
                boolean value = generator.canGenerate((Object)genmodel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject");
                System.out.println("Can Generate? :" + value);
                Diagnostic diagnostic = generator.generate((Object)genmodel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)new BasicMonitor.Printing(System.out));
                System.out.println("Message: " + diagnostic.getMessage());
                System.out.println("Code: " + diagnostic.getCode());
                System.out.println("Source :" + diagnostic.getSource());
                System.out.println("Exception :" + diagnostic.getException());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("No MetaClasses found...");
        }
    }

    protected static void printHelp() {
        System.out.println("Usage: java -classpath \"path_to_org.eclipse.mddi.modelbus.toolkit.jar\" org.eclipse.mddi.modelbus.toolkit.Toolkit \"path_to_myTool.description\" [-options]\n\nwhere options include:\n\t-directory\tto specify an existing output directory for the generated files\n\t-package\tto specify the package name for the generated files\n\t-help\t\tto print this message\n\t-provider\tto generate the service provider class\n\t-stub\t\tto generate the service stub class\n\t-impl\t\tto generate the service implementaiton skeleton\n\t-javadoc\tto generate javadoc template in generated files\n\n-wsdl\tto generate the WSDL service definition\n\nFor further help please see the user manual\n");
    }

    public void SetOutputDirectory(String directory) {
        outputDirectory = directory;
    }

    public void SetOutputPackage(String packagename) {
        outputPackage = packagename;
    }

    public void SetDescriptionFileLocation(String location) {
        filelocation = location;
    }

    public void SetProvider(boolean value) {
        provider = value;
    }

    public void SetStub(boolean value) {
        stub = value;
    }

    public void SetImpl(boolean value) {
        impl = value;
    }

    public void SetJavaDoc(boolean value) {
        javadoc = value;
    }

    public void SetMetaClasses(ArrayList<EPackage> epackages) {
        this.metaclasses = epackages;
    }

    public void SetProject(IProject project) {
        Toolkit.project = project;
    }
}

