/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.generator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.toolkit.DescriptionModelLoader;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.AbstractGenerator;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.InputHolder;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.OutputHolder;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.OutputHolderClass;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.TypeConversion;
import org.eclipse.mddi.modelbus.toolkit.adapter.generator.exception.BadModeException;

public class StubGenerator
extends AbstractGenerator {
    protected static final int INTERFACE_MODE = 0;
    protected static final int STUB_MODE = 1;
    protected static final int CONSUME_METHOD_TYPE = 0;
    protected static final int CONSUME_ASYNC_METHOD_TYPE = 1;
    protected static final int IS_RESULT_READY_METHOD_TYPE = 2;
    protected static final int GET_RESULT_METHOD_TYPE = 3;
    protected static final String STUB_POSTFIX_NAME = "Stub";
    protected static final String OUTPUT_HOLDER_NAME = "OutputHolder_";
    protected static final String CONSUME_METHOD_NAME = "consume_";
    protected static final String CONSUME_ASYNC_METHOD_NAME = "consumeAsync_";
    protected static final String IS_RESULT_READY_METHOD_NAME = "isResultReady_";
    protected static final String GET_RESULT_METHOD_NAME = "getResult_";
    protected static final String LICENCE = "/*\n* Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.\n* All rights reserved.\n*\n* This software is published under the terms of the ModelBus Software License\n* in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even\n* the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n* A copy of ModelBus Software License is provided with this distribution in\n* doc/LICENSE.txt file.\n*/\n";
    protected static final String CVS = "/*\n* $RCSfile: StubGenerator.java,v $\n* $Date: 2007/05/10 11:35:20 $\n* $Revision: 1.5 $\n* $Author: xblanc $\n*/\n";
    protected DescriptionModelLoader modelLoader;
    protected Hashtable outputHolderClasses;
    protected String adapterName;
    protected int mode;

    public StubGenerator(DescriptionModelLoader modelLoader) {
        this.modelLoader = modelLoader;
        this.outputHolderClasses = new Hashtable();
    }

    protected void setMode(int mode) throws BadModeException {
        if (mode != 0 && mode != 1) {
            throw new BadModeException();
        }
        this.mode = mode;
    }

    protected String generateAdapterCode(ModelingServiceInterface msi) {
        StringBuffer sb = new StringBuffer();
        switch (this.mode) {
            case 0: {
                this.adapterName = msi.getName();
                break;
            }
            case 1: {
                this.adapterName = String.valueOf(msi.getName()) + STUB_POSTFIX_NAME;
            }
        }
        sb.append("import java.util.Collection;\n");
        sb.append("import java.util.Properties;\n");
        sb.append("import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelBusCommunicationException;\n");
        sb.append("import org.eclipse.mddi.modelbus.adapter.user.consumer.ModelTypeMismatchException;\n");
        sb.append("import org.eclipse.mddi.modelbus.adapter.user.consumer.NoToolAvailableException;\n");
        sb.append("import org.eclipse.mddi.modelbus.adapter.user.consumer.ServiceUnknownException;\n");
        sb.append("import org.eclipse.mddi.modelbus.adapter.infrastructure.DeploymentException;\n");
        sb.append("import org.eclipse.mddi.modelbus.adapter.user.impl.AdapterStubImpl;\n");
        sb.append("import org.eclipse.mddi.modelbus.adapter.user.AdapterStub;\n");
        sb.append("import org.eclipse.mddi.modelbus.adapter.user.consumer.GenericConsumer;\n\n");
        sb.append("/**\n");
        sb.append(" * " + this.adapterName + ".java\n");
        sb.append(" *\n");
        sb.append(" * @author auto-generated\n");
        sb.append(" *\n");
        sb.append(" * @version $Revision: 1.5 $ $Date: 2007/05/10 11:35:20 $\n");
        sb.append(" **/\n");
        sb.append("public ");
        switch (this.mode) {
            case 0: {
                sb.append("interface");
                break;
            }
            case 1: {
                sb.append("class");
            }
        }
        sb.append(" " + this.adapterName);
        switch (this.mode) {
            case 1: {
                sb.append(" implements " + msi.getName());
            }
        }
        sb.append(" {\n");
        switch (this.mode) {
            case 1: {
                sb.append("\tpublic AdapterStub adapter;\n\tpublic GenericConsumer consumer;\n\n\t/**\n\t *\n\t * @param pro Adapter properties\n\t * @throws DeploymentException\n\t **/\n\tpublic " + this.adapterName + "(Properties pro) throws DeploymentException {\n" + "\t\tadapter = new AdapterStubImpl(pro);\n" + "\t\tconsumer = adapter.getGenericConsumer();\n" + "\t}\n\n");
            }
        }
        EList services = msi.eContents();
        int i = 0;
        while (i < services.size()) {
            ModelingService ms = (ModelingService)services.get(i);
            sb.append(this.generateService(ms, this.modelLoader.getTool().getName(), msi.getName()));
            sb.append("\n");
            ++i;
        }
        sb.append("}\n");
        return sb.toString();
    }

    protected void generateOutputHolders(String outputDirectory, String outputPackageName) throws IOException {
        Set outputHolderClassesSet = this.outputHolderClasses.entrySet();
        Iterator iter = outputHolderClassesSet.iterator();
        while (iter.hasNext()) {
            StringBuffer sb = new StringBuffer();
            OutputHolderClass classe = (OutputHolderClass)iter.next().getValue();
            sb.append(LICENCE);
            if (outputPackageName.compareTo("") != 0) {
                sb.append("\npackage " + outputPackageName + ";\n\n");
            }
            sb.append("/**\n");
            sb.append(" * " + classe.getName() + ".java\n");
            sb.append(" *\n");
            sb.append(" * @author auto-generated\n");
            sb.append(" *\n");
            sb.append(" * @version $Revision: 1.5 $ $Date: 2007/05/10 11:35:20 $\n");
            sb.append(" **/\n");
            sb.append("public class ");
            sb.append(classe.getName());
            sb.append(" {\n\n");
            Vector params = classe.getParametres();
            int j = 0;
            while (j < params.size()) {
                Parameter parameter = (Parameter)params.elementAt(j);
                String pName = parameter.getName();
                String pType = TypeConversion.generateType(parameter);
                sb.append("\t/**\n");
                sb.append("\t * " + pType + " " + pName + "\n");
                sb.append("\t **/\n");
                sb.append("\tpublic ");
                sb.append(pType);
                sb.append(" ");
                sb.append(pName);
                sb.append(";\n\n");
                ++j;
            }
            sb.append("}\n");
            File file = new File(String.valueOf(outputDirectory) + File.separator + classe.getName() + ".java");
            try {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(sb.toString().getBytes());
                fos.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    protected String generateMethod(ModelingService ms, String toolName, String modelingServiceInterfaceName, int methodType) {
        StringBuffer sb = new StringBuffer();
        InputHolder[] inputs = this.createInputHolders(ms);
        OutputHolder[] outputs = this.createOutputHolders(ms);
        String generatedInput = this.generateInput(inputs);
        String generatedOutput = this.generateOutput(outputs);
        String nomService = ms.getName();
        sb.append("\n\t/**\n");
        sb.append("\t *\n");
        sb.append("\t * ");
        switch (methodType) {
            case 2: {
                sb.append(IS_RESULT_READY_METHOD_NAME);
                break;
            }
            case 1: {
                sb.append(CONSUME_ASYNC_METHOD_NAME);
                break;
            }
            case 0: {
                sb.append(CONSUME_METHOD_NAME);
                break;
            }
            case 3: {
                sb.append(GET_RESULT_METHOD_NAME);
            }
        }
        sb.append(String.valueOf(nomService) + "\n");
        sb.append("\t *\n");
        switch (methodType) {
            case 2: {
                break;
            }
            default: {
                int i = 0;
                while (i < inputs.length) {
                    sb.append("\t * @param " + inputs[i].name + "\n");
                    ++i;
                }
                break block6;
            }
        }
        switch (methodType) {
            case 2: {
                sb.append("\t * @return boolean\n");
                break;
            }
            case 1: {
                break;
            }
            default: {
                sb.append("\t * @return " + generatedOutput + "\n");
            }
        }
        sb.append("\t * @throws ModelBusCommunicationException\n");
        sb.append("\t * @throws ServiceUnknownException\n");
        sb.append("\t * @throws NoToolAvailableException\n");
        sb.append("\t * @throws ModelTypeMismatchException\n");
        sb.append("\t * @throws Exception\n");
        sb.append("\t **/\n");
        sb.append("\tpublic ");
        switch (methodType) {
            case 2: {
                sb.append("boolean");
                break;
            }
            case 1: {
                sb.append("void");
                break;
            }
            default: {
                sb.append(generatedOutput);
            }
        }
        sb.append(" ");
        switch (methodType) {
            case 2: {
                sb.append(IS_RESULT_READY_METHOD_NAME);
                break;
            }
            case 1: {
                sb.append(CONSUME_ASYNC_METHOD_NAME);
                break;
            }
            case 3: {
                sb.append(GET_RESULT_METHOD_NAME);
            }
        }
        sb.append(nomService);
        sb.append("(");
        switch (methodType) {
            case 2: {
                break;
            }
            default: {
                sb.append(generatedInput);
            }
        }
        sb.append(") ");
        sb.append("throws ModelBusCommunicationException, ServiceUnknownException, NoToolAvailableException, ModelTypeMismatchException, Exception ");
        switch (this.mode) {
            case 0: {
                sb.append(";");
                break;
            }
            case 1: {
                int i;
                String serviceName = String.valueOf(toolName) + "." + modelingServiceInterfaceName + "." + nomService;
                sb.append("{\n");
                sb.append("\t\tString serviceName = \"" + serviceName + "\";\n");
                switch (methodType) {
                    case 2: {
                        sb.append("\t\treturn consumer.isResultReady(serviceName);\n");
                        break;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        sb.append("\t\tObject[] inputs = new Object[" + inputs.length + "];\n");
                        i = 0;
                        while (i < inputs.length) {
                            sb.append("\t\tinputs[" + i + "] = " + inputs[i].getName() + ";\n");
                            ++i;
                        }
                        switch (methodType) {
                            case 1: {
                                sb.append("\t\tconsumer.consumeAsync(serviceName, inputs);\n");
                            }
                        }
                    }
                }
                switch (methodType) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        sb.append("\t\tObject[] outputs = consumer.");
                        switch (methodType) {
                            case 0: {
                                sb.append("consume(serviceName, inputs);\n");
                                break;
                            }
                            case 3: {
                                sb.append("getResult(serviceName);\n");
                            }
                        }
                        if (outputs.length == 1) {
                            if (outputs[0].getType().compareTo("void") == 0) break;
                            sb.append("\t\treturn (" + outputs[0].getType() + ")outputs[0];\n");
                            break;
                        }
                        sb.append("\t\t" + outputs[0].getClassName() + " outputHolder = new " + outputs[0].getClassName() + "();\n");
                        i = 0;
                        while (i < outputs.length) {
                            sb.append("\t\toutputHolder." + outputs[i].getName() + " = (" + outputs[i].getType() + ")outputs[" + i + "];\n");
                            ++i;
                        }
                        sb.append("\t\treturn outputHolder;\n");
                    }
                }
                sb.append("\t}\n");
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    protected String generateService(ModelingService ms, String ToolName, String ModelingInterfaceName) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.generateMethod(ms, ToolName, ModelingInterfaceName, 0));
        sb.append(this.generateMethod(ms, ToolName, ModelingInterfaceName, 1));
        sb.append(this.generateMethod(ms, ToolName, ModelingInterfaceName, 2));
        sb.append(this.generateMethod(ms, ToolName, ModelingInterfaceName, 3));
        return sb.toString();
    }

    protected String generateInput(InputHolder[] inputHolders) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < inputHolders.length) {
            sb.append(String.valueOf(inputHolders[i].getType()) + " " + inputHolders[i].getName());
            if (i != inputHolders.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    protected String generateOutput(OutputHolder[] outputHolders) {
        if (outputHolders.length == 1) {
            return outputHolders[0].getType();
        }
        return outputHolders[0].getClassName();
    }

    protected void generateInternal(String outputDirectory, String outputPackageName, int mode) throws BadModeException, IOException {
        int i = 0;
        while (i < this.modelLoader.getModelingServiceInterfaces().length) {
            this.setMode(mode);
            String code = this.generateAdapterCode(this.modelLoader.getModelingServiceInterfaces()[i]);
            code = "/*\n* $RCSfile: StubGenerator.java,v $\n* $Date: 2007/05/10 11:35:20 $\n* $Revision: 1.5 $\n* $Author: xblanc $\n*/\n\n" + code;
            code = "/*\n* Copyright (c) 2002-2003 IST-2004-2006-511731 ModelWare - ModelBus.\n* All rights reserved.\n*\n* This software is published under the terms of the ModelBus Software License\n* in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even\n* the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n* A copy of ModelBus Software License is provided with this distribution in\n* doc/LICENSE.txt file.\n*/\n\n" + code;
            if (outputPackageName.compareTo("") != 0) {
                code = "\npackage " + outputPackageName + ";\n\n" + code;
            }
            File file = new File(String.valueOf(outputDirectory) + File.separator + this.adapterName + ".java");
            try {
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(code.getBytes());
                fos.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public static void generateAdapter(DescriptionModelLoader modelLoader, String outputDirectory, String outputPackageName) throws IOException {
        StubGenerator gen = new StubGenerator(modelLoader);
        try {
            gen.generateInternal(outputDirectory, outputPackageName, 0);
            gen.generateInternal(outputDirectory, outputPackageName, 1);
            gen.generateOutputHolders(outputDirectory, outputPackageName);
        }
        catch (BadModeException badModeException) {}
    }

    public String getStubName() {
        return String.valueOf(this.modelLoader.getTool().getInterface().getName()) + STUB_POSTFIX_NAME;
    }

    public String getServiceInterfaceName() {
        return this.modelLoader.getTool().getInterface().getName();
    }
}

