/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.generator;

import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.PrimitiveType;
import org.eclipse.mddi.modelbus.description.abstract_.Type;

public class TypeConversion {
    public static final String STRING_JAVA = "java.lang.String";
    public static final String BOOLEAN_JAVA = "java.lang.Boolean";
    public static final String INTEGER_JAVA = "java.lang.Integer";
    public static final String DOUBLE_JAVA = "java.lang.Double";
    public static final String COLLECTION_JAVA = "EObject";
    public static final String BINARY_JAVA = "java.io.InputStream";
    public static final String STRING_STRING = "string";
    public static final String BOOLEAN_STRING = "boolean";
    public static final String INTEGER_STRING = "integer";
    public static final String DOUBLE_STRING = "double";
    public static final String BINARY_STRING = "binary";
    public static final String UML_STRING = "uml.";
    public static final String UML_JAVA = "org.eclipse.uml2.";

    public static String convertSinglePrimitive(String string) {
        if (string.equalsIgnoreCase(STRING_STRING)) {
            return STRING_JAVA;
        }
        if (string.equalsIgnoreCase(BOOLEAN_STRING)) {
            return BOOLEAN_JAVA;
        }
        if (string.equalsIgnoreCase(INTEGER_STRING)) {
            return INTEGER_JAVA;
        }
        if (string.equalsIgnoreCase(DOUBLE_STRING)) {
            return DOUBLE_JAVA;
        }
        if (string.equalsIgnoreCase(BINARY_STRING)) {
            return BINARY_JAVA;
        }
        return "// no type found";
    }

    public static String convertMultiPrimitive(String string) {
        if (string.equalsIgnoreCase(STRING_STRING)) {
            return "java.lang.String[]";
        }
        if (string.equalsIgnoreCase(BOOLEAN_STRING)) {
            return "java.lang.Boolean[]";
        }
        if (string.equalsIgnoreCase(INTEGER_STRING)) {
            return "java.lang.Integer[]";
        }
        if (string.equalsIgnoreCase(DOUBLE_STRING)) {
            return "java.lang.Double[]";
        }
        if (string.equalsIgnoreCase(BINARY_STRING)) {
            return "java.io.InputStream[]";
        }
        return "// no type found";
    }

    public static String convertSingleModel(String string) {
        if (string.substring(0, 4).equalsIgnoreCase(UML_STRING)) {
            return UML_JAVA + string;
        }
        return COLLECTION_JAVA;
    }

    public static String convertMultiModel() {
        return "EObject[]";
    }

    public static boolean isPrimitive(Parameter parameter) {
        Type type = parameter.getType();
        return type instanceof PrimitiveType;
    }

    public static String generateType(Parameter parameter) {
        Type type = parameter.getType();
        if (type instanceof PrimitiveType) {
            if (parameter.getUpper() == -1 || parameter.getUpper() > 1) {
                return TypeConversion.convertMultiPrimitive(type.getName());
            }
            return TypeConversion.convertSinglePrimitive(type.getName());
        }
        if (parameter.getUpper() == -1 || parameter.getUpper() > 1) {
            return TypeConversion.convertMultiModel();
        }
        return TypeConversion.convertSingleModel(type.getName());
    }

    public static String generateTypeCreation(Parameter parameter) {
        Type type = parameter.getType();
        if (type instanceof PrimitiveType) {
            if (parameter.getUpper() == -1 || parameter.getUpper() > 1) {
                return TypeConversion.convertMultiPrimitive(type.getName());
            }
            return "new " + TypeConversion.convertSinglePrimitive(type.getName());
        }
        if (parameter.getUpper() == -1 || parameter.getUpper() > 1) {
            return "new Vector";
        }
        if (type.getName().substring(0, 4).equalsIgnoreCase(UML_STRING)) {
            return "org.eclipse.uml2.uml.UMLFactory.eINSTANCE.create" + type.getName().substring(4);
        }
        return "EMFFactory.eINSTANCE.create" + type.getName();
    }
}

