/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.generator;

import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.PrimitiveType;
import org.eclipse.mddi.modelbus.description.abstract_.Type;

public class TypeConversion4XMLSchema {
    public static final String STRING_XMLSchema = "\"xsd:string\"";
    public static final String BOOLEAN_XMLSchema = "\"xsd:boolean\"";
    public static final String INTEGER_XMLSchema = "\"xsd:integer\"";
    public static final String DOUBLE_XMLSchema = "\"xsd:double\"";
    public static final String BINARY_XMLSchema = "\"cdata\"";
    public static final String MODEL_XMLSchema = "\"mbns:model\"";
    public static final String STRING_SET_XMLSchema = "\"mbns:stringset\"";
    public static final String BOOLEAN_SET_XMLSchema = "\"mbns:booleanset\"";
    public static final String INTEGER_SET_XMLSchema = "\"mbns:integerset\"";
    public static final String DOUBLE_SET_XMLSchema = "\"mbns:doubleset\"";
    public static final String BINARY_SET_XMLSchema = "\"cdata\"";
    public static final String MODEL_SET_XMLSchema = "\"mbns:modelset\"";
    public static final String STRING_STRING = "string";
    public static final String BOOLEAN_STRING = "boolean";
    public static final String INTEGER_STRING = "integer";
    public static final String DOUBLE_STRING = "double";
    public static final String BINARY_STRING = "binary";
    public static final String UML_STRING = "uml.";
    public static final String UML_JAVA = "org.eclipse.uml2.";

    public static String convertSinglePrimitive(String string) {
        if (string.equalsIgnoreCase(STRING_STRING)) {
            return STRING_XMLSchema;
        }
        if (string.equalsIgnoreCase(BOOLEAN_STRING)) {
            return BOOLEAN_XMLSchema;
        }
        if (string.equalsIgnoreCase(INTEGER_STRING)) {
            return INTEGER_XMLSchema;
        }
        if (string.equalsIgnoreCase(DOUBLE_STRING)) {
            return DOUBLE_XMLSchema;
        }
        if (string.equalsIgnoreCase(BINARY_STRING)) {
            return "\"cdata\"";
        }
        return "// no type found";
    }

    public static String convertMultiPrimitive(String string) {
        if (string.equalsIgnoreCase(STRING_STRING)) {
            return STRING_SET_XMLSchema;
        }
        if (string.equalsIgnoreCase(BOOLEAN_STRING)) {
            return BOOLEAN_SET_XMLSchema;
        }
        if (string.equalsIgnoreCase(INTEGER_STRING)) {
            return INTEGER_SET_XMLSchema;
        }
        if (string.equalsIgnoreCase(DOUBLE_STRING)) {
            return DOUBLE_SET_XMLSchema;
        }
        if (string.equalsIgnoreCase(BINARY_STRING)) {
            return "\"cdata\"";
        }
        return "// no type found";
    }

    public static String convertSingleModel(String string) {
        return MODEL_XMLSchema;
    }

    public static String convertMultiModel() {
        return MODEL_SET_XMLSchema;
    }

    public static boolean isPrimitive(Parameter parameter) {
        Type type = parameter.getType();
        return type instanceof PrimitiveType;
    }

    public static String generateType(Parameter parameter) {
        Type type = parameter.getType();
        if (type instanceof PrimitiveType) {
            if (parameter.getUpper() == -1 || parameter.getUpper() > 1) {
                return TypeConversion4XMLSchema.convertMultiPrimitive(type.getName());
            }
            return TypeConversion4XMLSchema.convertSinglePrimitive(type.getName());
        }
        if (parameter.getUpper() == -1 || parameter.getUpper() > 1) {
            return TypeConversion4XMLSchema.convertMultiModel();
        }
        return TypeConversion4XMLSchema.convertSingleModel(type.getName());
    }
}

