/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.Event;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ETException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;

public class EventTypeValidation {
    public static void validationET(ModelBusPackaging mp) throws ETException {
        EList mpListContents = mp.getContent();
        ModelingServiceInterface msi = null;
        int j = 0;
        while (j < mpListContents.size()) {
            Object content = mpListContents.get(j);
            if (content instanceof ModelingServiceInterface) {
                msi = (ModelingServiceInterface)content;
            }
            if (msi != null) {
                EList eventsList = msi.getPublishedEvent();
                int i = 0;
                while (i < eventsList.size()) {
                    Event event = (Event)eventsList.get(i);
                    try {
                        Validation.validateName(event.getName(), "Event");
                    }
                    catch (NameFormatException e) {
                        throw new ETException(e.getMessage());
                    }
                    EList types = event.getEventInfo();
                    if (types.isEmpty()) {
                        throw new ETException("Event \"" + event.getName() + "\" has an empty type(eventType) attribute, it must have at least one type referenced");
                    }
                    ++i;
                }
            }
            ++j;
        }
    }
}

