/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.Event;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.abstract_.Type;
import org.eclipse.mddi.modelbus.description.concrete.Tool;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.ModelingServiceInterfaceValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.TypeValidation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.EException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ETException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MPException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MSIException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.MetaSException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.PException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.ToolException;

public class ModelBusPackagingValidation {
    static boolean msiFound = false;
    static int toolsFound = 0;

    public static synchronized void validateMP(ModelBusPackaging mP) throws MPException, MSIException, TException, EException, ETException, NameFormatException, MetaSException, MSException, PException, ToolException {
        int someToolsFound = 0;
        EList mPContents = mP.getContent();
        int i = 0;
        while (i < mPContents.size()) {
            Object mPContent = mPContents.get(i);
            if (mPContent instanceof ModelBusPackaging) {
                Validation.globalValidationRec((ModelBusPackaging)mPContent);
            } else if (mPContent instanceof ModelingServiceInterface) {
                msiFound = true;
                ModelingServiceInterfaceValidation.validateMSI(mP);
            } else if (mPContent instanceof Type) {
                TypeValidation.validationT(mP);
            } else if (mPContent instanceof Tool) {
                System.out.println("Some Tools found:" + ++someToolsFound);
            } else if (!(mPContent instanceof Event)) {
                throw new MPException("The ModebusPackaging \"" + mP.getName() + "\" has a wrong content, it must contains only :" + " at least one ModelingServiceinterface or ModelBusPackaging," + " Event and Type elements if needed");
            }
            ++i;
        }
        toolsFound = someToolsFound;
    }

    public static boolean isMsiFound() {
        return msiFound;
    }

    public static synchronized int getToolsFound() {
        System.out.println("get Tools found:" + toolsFound);
        return toolsFound;
    }
}

