/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mddi.modelbus.toolkit.adapter.validator;

import org.eclipse.emf.common.util.EList;
import org.eclipse.mddi.modelbus.description.ModelBusPackaging;
import org.eclipse.mddi.modelbus.description.abstract_.Error;
import org.eclipse.mddi.modelbus.description.abstract_.Event;
import org.eclipse.mddi.modelbus.description.abstract_.ModelType;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingService;
import org.eclipse.mddi.modelbus.description.abstract_.ModelingServiceInterface;
import org.eclipse.mddi.modelbus.description.abstract_.Parameter;
import org.eclipse.mddi.modelbus.description.abstract_.PrimitiveType;
import org.eclipse.mddi.modelbus.description.abstract_.Type;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.Validation;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.NameFormatException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TException;
import org.eclipse.mddi.modelbus.toolkit.adapter.validator.exception.TypeFormatException;

public class TypeValidation {
    public static void validationT(ModelBusPackaging mp) throws TException {
        EList mpListContents = mp.getContent();
        ModelingServiceInterface msi = null;
        int j = 0;
        while (j < mpListContents.size()) {
            Object content = mpListContents.get(j);
            if (content instanceof ModelingServiceInterface) {
                msi = (ModelingServiceInterface)content;
                EList servicesList = msi.getService();
                EList eventsList = msi.getPublishedEvent();
                int i = 0;
                while (i < servicesList.size()) {
                    ModelingService service = (ModelingService)servicesList.get(i);
                    EList parametersList = service.getParameter();
                    EList errorsList = service.getServiceError();
                    TypeValidation.checkTypeParameters(parametersList);
                    TypeValidation.checkTypeErrors(errorsList);
                    ++i;
                }
                int x = 0;
                while (x < eventsList.size()) {
                    Event event = (Event)eventsList.get(x);
                    EList eventsTypeList = event.getEventInfo();
                    TypeValidation.checkEventsType(eventsTypeList);
                    ++x;
                }
            }
            ++j;
        }
    }

    private static void checkEventsType(EList eventsTypeList) throws TException {
        int i = 0;
        while (i < eventsTypeList.size()) {
            Type type = (Type)eventsTypeList.get(i);
            TypeValidation.checkTypes(type);
            ++i;
        }
    }

    private static void checkTypeErrors(EList errorsList) throws TException {
        int i = 0;
        while (i < errorsList.size()) {
            Error erreur = (Error)errorsList.get(i);
            Type typeError = erreur.getType();
            TypeValidation.checkTypes(typeError);
            ++i;
        }
    }

    private static void checkTypeParameters(EList parametersList) throws TException {
        int i = 0;
        while (i < parametersList.size()) {
            Parameter parameter = (Parameter)parametersList.get(i);
            Type typeParameter = parameter.getType();
            TypeValidation.checkTypes(typeParameter);
            ++i;
        }
    }

    private static void checkTypes(Type type) throws TException {
        if (type == null) {
            throw new TException("A Type is not referenced");
        }
        if (!(type instanceof PrimitiveType)) {
            if (type instanceof ModelType) {
                try {
                    Validation.validateName(type.getName(), "ModelType");
                }
                catch (NameFormatException e) {
                    throw new TException(e.getMessage());
                }
                try {
                    Validation.validateName(((ModelType)type).getName(), "ModelType");
                }
                catch (NameFormatException e) {
                    throw new TException(e.getMessage());
                }
            }
            throw new TException("Type \"" + type.getName() + "\" must be a ModelType or a PrimitiveType");
        }
        try {
            Validation.validateName(type.getName(), "PrimitiveType");
        }
        catch (NameFormatException e) {
            throw new TException(e.getMessage());
        }
        try {
            Validation.validateType(type, "Type");
        }
        catch (TypeFormatException e) {
            throw new TException(e.getMessage());
        }
    }
}

