/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.m2m.atl.engine.emfvm.Messages;
import org.eclipse.m2m.atl.engine.emfvm.VMException;
import org.eclipse.m2m.atl.engine.emfvm.lib.TransientLink;
import org.eclipse.m2m.atl.engine.emfvm.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientLinkSet {
    private List<TransientLink> links = new ArrayList<TransientLink>();
    private Map<String, List<TransientLink>> linksByRule = new HashMap<String, List<TransientLink>>();
    private Map<Object, TransientLink> linksBySourceElement = new HashMap<Object, TransientLink>();
    private Map<String, Map<Object, TransientLink>> linksBySourceElementByRule = new HashMap<String, Map<Object, TransientLink>>();

    public void addLink(TransientLink tl) {
        this.addLink2(tl, true);
    }

    public void addLink2(TransientLink tl, boolean isDefault) {
        this.links.add(tl);
        List<TransientLink> linkList = this.linksByRule.get(tl.getRule());
        if (linkList == null) {
            linkList = new ArrayList<TransientLink>();
            this.linksByRule.put(tl.getRule(), linkList);
        }
        linkList.add(tl);
        Map<Object, TransientLink> linksBySourceElementForRule = this.linksBySourceElementByRule.get(tl.getRule());
        if (linksBySourceElementForRule == null) {
            linksBySourceElementForRule = new HashMap<Object, TransientLink>();
            this.linksBySourceElementByRule.put(tl.getRule(), linksBySourceElementForRule);
        }
        for (Object e : tl.getSourceElements().values()) {
            linksBySourceElementForRule.put(e, tl);
        }
        if (isDefault) {
            Object se = null;
            se = tl.getSourceElements().size() == 1 ? tl.getSourceElements().values().iterator().next() : new Tuple(tl.getSourceElements());
            TransientLink other = this.linksBySourceElement.get(se);
            if (other != null) {
                throw new VMException(null, Messages.getString("TransientLinkSet.DUPLICATESRULES", se, other.getRule(), tl.getRule()));
            }
            this.linksBySourceElement.put(se, tl);
        }
    }

    public List<TransientLink> getLinksByRule(Object rule) {
        List<TransientLink> ret = this.linksByRule.get(rule);
        if (ret == null) {
            ret = Collections.emptyList();
        }
        return ret;
    }

    public TransientLink getLinkBySourceElement(Object sourceElement) {
        TransientLink ret = this.linksBySourceElement.get(sourceElement);
        return ret;
    }

    public TransientLink getLinkByRuleAndSourceElement(Object rule, Object sourceElement) {
        Map<Object, TransientLink> map = this.linksBySourceElementByRule.get(rule);
        TransientLink ret = null;
        if (map != null) {
            ret = map.get(sourceElement);
        }
        return ret;
    }
}

