/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.tools.tge.outline;

import org.eclipse.am3.tools.tge.outline.OutlineNode;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionChangedListener
implements ISelectionChangedListener {
    private ITextEditor textEditor;
    private boolean stopListener;
    private boolean fullStop;

    public SelectionChangedListener(ITextEditor textEditor) {
        this.textEditor = textEditor;
        this.stopListener = false;
        this.fullStop = true;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.fullStop || this.stopListener || event.getSelection().isEmpty()) {
            return;
        }
        if (event.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty()) {
                this.textEditor.resetHighlightRange();
            } else if (selection.getFirstElement() instanceof OutlineNode) {
                OutlineNode noeud = (OutlineNode)selection.getFirstElement();
                if (noeud.getBegin() != null) {
                    try {
                        this.textEditor.setHighlightRange(noeud.getBegin().getOffset(), noeud.getLength(), false);
                        this.textEditor.selectAndReveal(noeud.getBegin().getOffset(), noeud.getLength());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.textEditor.resetHighlightRange();
                    }
                } else {
                    this.textEditor.resetHighlightRange();
                }
            }
        }
    }

    public void stopListener(boolean isStop) {
        this.stopListener = isStop;
    }

    public void fullStop() {
        this.fullStop = true;
    }

    public void start() {
        this.fullStop = false;
    }
}

