/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.m2m.atl.engine.vm.NativeOperation;
import org.eclipse.m2m.atl.engine.vm.NativeStackFrame;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBag;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMMap;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSet;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class InstanceNativeOperation
extends NativeOperation {
    private List parameters;
    private boolean translateTypes;
    private boolean dontUseFrame;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public InstanceNativeOperation(Method method, boolean translateTypes, boolean dontUseFrame, List parameters, ASMOclType returnType, ASMOclType contextType) {
        super(method, parameters, returnType, contextType);
        this.translateTypes = translateTypes;
        this.dontUseFrame = dontUseFrame;
    }

    public ASMOclAny exec(StackFrame frame) {
        ASMOclAny ret = null;
        try {
            Object self = null;
            ArrayList args = new ArrayList();
            boolean isFirst = true;
            Iterator i = frame.getArgs().iterator();
            Iterator<Class<?>> j = Arrays.asList(this.getMethod().getParameterTypes()).iterator();
            while (i.hasNext()) {
                if (isFirst) {
                    self = i.next();
                    isFirst = false;
                    continue;
                }
                Object o = i.next();
                Class<?> type = j.next();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isAssignableFrom(type)) {
                    if (!this.translateTypes) {
                        frame.printStackTrace("ERROR: type translation not allowed but " + o + " is of type " + o.getClass() + ".");
                    } else {
                        Class<?> clazz2 = class$1;
                        if (clazz2 == null) {
                            try {
                                clazz2 = Class.forName("java.lang.String");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (type.equals(clazz2) && o instanceof ASMString) {
                            o = ((ASMString)o).getSymbol();
                        } else if (type.isPrimitive() && type.getName().equals("int") && o instanceof ASMInteger) {
                            o = new Integer(((ASMInteger)o).getSymbol());
                        } else if (type.isPrimitive() && type.getName().equals("boolean") && o instanceof ASMBoolean) {
                            o = new Boolean(((ASMBoolean)o).getSymbol());
                        } else {
                            frame.printStackTrace("ERROR: cannot convert " + o + " to " + type + ".");
                        }
                    }
                }
                args.add(o);
            }
            if (!this.dontUseFrame) {
                args.add(0, frame);
            }
            Object r = this.getMethod().invoke(self, args.toArray());
            ret = this.java2ASM(frame, r);
        }
        catch (IllegalAccessException iae) {
            frame.printStackTrace(iae);
            ret = null;
        }
        catch (IllegalArgumentException iae2) {
            frame.printStackTrace(iae2);
            ret = null;
        }
        catch (InvocationTargetException ite) {
            frame.printStackTrace(ite);
            ret = null;
        }
        ((NativeStackFrame)frame).setRet(ret);
        frame.leaveFrame();
        return ret;
    }

    private ASMOclAny java2ASM(StackFrame frame, Object r) {
        ASMOclAny ret = null;
        if (r == null) {
            ret = null;
        } else if (r instanceof ASMOclAny) {
            ret = (ASMOclAny)r;
        } else if (r instanceof Boolean) {
            ret = new ASMBoolean((Boolean)r);
        } else if (r instanceof Integer) {
            ret = new ASMInteger((Integer)r);
        } else if (r instanceof String) {
            ret = new ASMString((String)r);
        } else if (r instanceof List) {
            ret = new ASMSequence();
            Iterator i = ((List)r).iterator();
            while (i.hasNext()) {
                ((ASMSequence)ret).add(this.java2ASM(frame, i.next()));
            }
        } else if (r instanceof Set) {
            ret = new ASMSet();
            Iterator i = ((Set)r).iterator();
            while (i.hasNext()) {
                ((ASMSet)ret).add(this.java2ASM(frame, i.next()));
            }
        } else if (r instanceof Collection) {
            ret = new ASMBag();
            Iterator i = ((Collection)r).iterator();
            while (i.hasNext()) {
                ((ASMBag)ret).add(this.java2ASM(frame, i.next()));
            }
        } else if (r instanceof Map) {
            ret = new ASMMap();
            Iterator i = ((Map)r).keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                Object value = ((Map)r).get(key);
                ((ASMMap)ret).put(this.java2ASM(frame, key), this.java2ASM(frame, value));
            }
        } else {
            frame.printStackTrace("ERROR: cannot convert " + r + " to ASMOclAny.");
        }
        return ret;
    }

    public List getParameters() {
        return this.parameters;
    }
}

