/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.tests.unit;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.m2m.atl.tests.AtlTestPlugin;
import org.eclipse.m2m.atl.tests.util.FileUtils;
import org.osgi.framework.Bundle;

public abstract class TestNonRegression
extends TestCase {
    protected static final String INPUT_PATH = "/data/inputs/";
    private Properties properties;
    protected File baseDirectory;

    public void testNonRegression() throws Exception {
        File inputDir = null;
        this.baseDirectory = CoreService.isEclipseRunning() ? FileLocator.getBundleFile((Bundle)AtlTestPlugin.getDefault().getBundle()) : new File(AtlTestPlugin.class.getResource("").toURI()).getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
        inputDir = new File(this.baseDirectory + INPUT_PATH);
        File[] directories = FileUtils.listDirectories(inputDir);
        TestNonRegression.assertNotNull((Object)directories);
        int i = 0;
        while (i < directories.length) {
            this.compareSnapshots(directories[i], true);
            ++i;
        }
    }

    protected void compareSnapshots(File directory, boolean useEmfCompare) throws IOException {
        int i;
        String[] testsToJump = this.getTestsToJump(directory);
        if (testsToJump != null) {
            i = 0;
            while (i < testsToJump.length) {
                String testToJump = testsToJump[i];
                if (testToJump.equals(directory.getName())) {
                    return;
                }
                ++i;
            }
        }
        if (FileUtils.listDirectories(directory).length != 0) {
            i = 0;
            while (i < FileUtils.listDirectories(directory).length) {
                this.compareSnapshots(FileUtils.listDirectories(directory)[i], useEmfCompare);
                ++i;
            }
        } else {
            this.singleTest(directory);
        }
    }

    private String[] getTestsToJump(File directory) throws IOException {
        String[] res = null;
        if (this.properties == null) {
            return null;
        }
        Set<Object> testsToJump = this.properties.keySet();
        int i = 0;
        res = new String[testsToJump.size()];
        for (String string : testsToJump) {
            res[i] = string.trim();
            ++i;
        }
        return res;
    }

    protected abstract void singleTest(File var1);

    protected void setProperties(Properties properties) {
        this.properties = properties;
    }

    public static void fail(String msg, Throwable thrown) {
        System.err.println(msg);
        thrown.printStackTrace();
        TestNonRegression.fail((String)msg);
    }

    public static void info(String msg) {
        System.out.println(msg);
    }
}

