/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.tests.unit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.engine.parser.AtlParser;
import org.eclipse.m2m.atl.tests.unit.TestNonRegression;
import org.eclipse.m2m.atl.tests.util.FileUtils;
import org.eclipse.m2m.atl.tests.util.ModelUtils;

public class TestNonRegressionParser
extends TestNonRegression {
    protected void setUp() throws Exception {
        super.setUp();
        Properties properties = new Properties();
        properties.load(TestNonRegressionParser.class.getResourceAsStream("TestNonRegressionParser.properties"));
        this.setProperties(properties);
    }

    protected void singleTest(File directory) {
        File expectedDir = new File(directory.getPath().replaceFirst("inputs", "expected"));
        String transfoPath = directory + File.separator + directory.getName() + ".atl";
        String expectedPath = expectedDir + File.separator + directory.getName() + ".atl.xmi";
        if (!new File(transfoPath).exists()) {
            TestNonRegressionParser.info("ATL file " + transfoPath + " does not exist. Skipped");
            return;
        }
        try {
            EObject result = AtlParser.getDefault().parse((InputStream)new FileInputStream(transfoPath));
            if (new File(expectedPath).exists()) {
                TestNonRegressionParser.assertEquals((String)FileUtils.readFileAsString(new File(expectedPath)), (String)ModelUtils.serialize(result));
            } else {
                FileWriter fw = new FileWriter(expectedPath);
                fw.write(ModelUtils.serialize(result));
                fw.close();
            }
        }
        catch (Exception e) {
            TestNonRegressionParser.fail((String)("Failed to parse " + transfoPath + ": " + e));
        }
    }
}

