/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.tests.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchParser {
    private URL atlUrl;
    private URL asmUrl;
    private Map<String, URL> libsFromConfig;
    private List<URL> superimpose;
    private Map<String, String> input;
    private Map<String, String> output;
    private Map<String, String> modelHandler;
    private Map<String, String> path;
    private Map<String, Object> options;
    private File baseDirectory;
    private List<String> orderedInput;
    private List<String> orderedOutput;

    private String convertPath(String pathParam) {
        if (!pathParam.startsWith("uri:") && !pathParam.startsWith("#")) {
            return new Path(this.baseDirectory.getPath()).append(new Path(pathParam).removeFirstSegments(1).toString()).toString();
        }
        return pathParam;
    }

    public void parseConfiguration(File baseDirectory, String launchPath) throws IOException, ParserConfigurationException, SAXException {
        this.baseDirectory = baseDirectory;
        this.libsFromConfig = new HashMap<String, URL>();
        this.superimpose = new ArrayList<URL>();
        this.input = new HashMap<String, String>();
        this.output = new HashMap<String, String>();
        this.orderedInput = new ArrayList<String>();
        this.orderedOutput = new ArrayList<String>();
        this.modelHandler = new HashMap<String, String>();
        this.path = new HashMap<String, String>();
        this.options = new HashMap<String, Object>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document document = docBuilder.parse(new File(launchPath));
        Element root = (Element)document.getFirstChild();
        NodeList nodeList = root.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                Element entry;
                Element entry2;
                Node nodeEntry;
                Element element = (Element)node;
                String key = element.getAttribute("key");
                if (element.getNodeName().equals("booleanAttribute")) {
                    this.options.put(key, element.getAttribute("value"));
                } else if (key.equals("ATL File Name")) {
                    String asmFilePath = element.getAttribute("value");
                    this.atlUrl = new URL("file:" + this.convertPath(asmFilePath));
                    if (asmFilePath.endsWith(".atl")) {
                        asmFilePath = String.valueOf(asmFilePath.substring(0, asmFilePath.length() - 4)) + ".asm";
                    }
                    this.asmUrl = new URL("file:" + this.convertPath(asmFilePath));
                } else if (key.equals("Superimpose")) {
                    NodeList entriesList = element.getChildNodes();
                    int j = 0;
                    while (j < entriesList.getLength()) {
                        nodeEntry = entriesList.item(j);
                        if (nodeEntry instanceof Element) {
                            entry2 = (Element)nodeEntry;
                            URL moduleUrl = new URL("file:" + this.convertPath(entry2.getAttribute("value")));
                            this.superimpose.add(moduleUrl);
                        }
                        ++j;
                    }
                } else if (key.equals("OrderedInput")) {
                    NodeList entriesList = element.getChildNodes();
                    int j = 0;
                    while (j < entriesList.getLength()) {
                        nodeEntry = entriesList.item(j);
                        if (nodeEntry instanceof Element) {
                            entry2 = (Element)nodeEntry;
                            this.orderedInput.add(entry2.getAttribute("value"));
                        }
                        ++j;
                    }
                } else if (key.equals("OrderedOutput")) {
                    NodeList entriesList = element.getChildNodes();
                    int j = 0;
                    while (j < entriesList.getLength()) {
                        nodeEntry = entriesList.item(j);
                        if (nodeEntry instanceof Element) {
                            entry2 = (Element)nodeEntry;
                            this.orderedOutput.add(entry2.getAttribute("value"));
                        }
                        ++j;
                    }
                } else if (key.equals("Libs")) {
                    NodeList nodes = element.getChildNodes();
                    int j = 0;
                    while (j < nodes.getLength()) {
                        nodeEntry = nodes.item(j);
                        if (nodeEntry instanceof Element) {
                            entry2 = (Element)nodeEntry;
                            this.libsFromConfig.put(entry2.getAttribute("key"), new URL("file:" + this.convertPath(entry2.getAttribute("value"))));
                        }
                        ++j;
                    }
                } else if (key.equals("Path")) {
                    int j = 0;
                    while (j < element.getChildNodes().getLength()) {
                        Node nodeEntry2 = element.getChildNodes().item(j);
                        if (nodeEntry2 instanceof Element) {
                            entry = (Element)nodeEntry2;
                            String pathParam = entry.getAttribute("value");
                            if (!(pathParam = this.convertPath(pathParam)).startsWith("uri:") && !pathParam.startsWith("#")) {
                                pathParam = "ext:" + pathParam;
                            }
                            this.path.put(entry.getAttribute("key"), pathParam);
                        }
                        ++j;
                    }
                } else if (key.equals("Input")) {
                    int j = 0;
                    while (j < element.getChildNodes().getLength()) {
                        Node nodeEntry3 = element.getChildNodes().item(j);
                        if (nodeEntry3 instanceof Element) {
                            entry = (Element)nodeEntry3;
                            this.input.put(entry.getAttribute("key"), entry.getAttribute("value"));
                        }
                        ++j;
                    }
                } else if (key.equals("Output")) {
                    int j = 0;
                    while (j < element.getChildNodes().getLength()) {
                        Node nodeEntry4 = element.getChildNodes().item(j);
                        if (nodeEntry4 instanceof Element) {
                            entry = (Element)nodeEntry4;
                            this.output.put(entry.getAttribute("key"), entry.getAttribute("value"));
                        }
                        ++j;
                    }
                } else if (key.equals("Model Handler")) {
                    int j = 0;
                    while (j < element.getChildNodes().getLength()) {
                        Node nodeEntry5 = element.getChildNodes().item(j);
                        if (nodeEntry5 instanceof Element) {
                            entry = (Element)nodeEntry5;
                            this.modelHandler.put(entry.getAttribute("key"), entry.getAttribute("value"));
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public URL getAtlUrl() {
        return this.atlUrl;
    }

    public URL getAsmUrl() {
        return this.asmUrl;
    }

    public Map<String, URL> getLibsFromConfig() {
        return this.libsFromConfig;
    }

    public List<URL> getSuperimpose() {
        return this.superimpose;
    }

    public Map<String, String> getInput() {
        return this.input;
    }

    public Map<String, String> getOutput() {
        return this.output;
    }

    public Map<String, String> getModelHandler() {
        return this.modelHandler;
    }

    public Map<String, String> getPath() {
        return this.path;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setAsmUrl(URL asmUrl) {
        this.asmUrl = asmUrl;
    }

    public List<String> getOrderedInput() {
        return this.orderedInput;
    }

    public List<String> getOrderedOutput() {
        return this.orderedOutput;
    }
}

