/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtrelation.cs2as;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.basecs.ElementCS;
import org.eclipse.ocl.examples.xtext.base.basecs.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.cs2as.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.essentialocl.cs2as.ImplicitSourceTypeIterator;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialoclcs.NavigationRole;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtrelation.QVTrelationPackage;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomainAssignment;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.xtext.qvtrelation.qvtrelationcs.CollectionTemplateCS;
import org.eclipse.qvtd.xtext.qvtrelation.qvtrelationcs.DefaultValueCS;
import org.eclipse.qvtd.xtext.qvtrelation.qvtrelationcs.ObjectTemplateCS;
import org.eclipse.qvtd.xtext.qvtrelation.qvtrelationcs.TransformationCS;
import org.eclipse.qvtd.xtext.qvtrelation.qvtrelationcs.util.AbstractQVTrelationCSLeft2RightVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTrelationCSLeft2RightVisitor
extends AbstractQVTrelationCSLeft2RightVisitor {
    public QVTrelationCSLeft2RightVisitor(@NonNull CS2PivotConversion context) {
        super(context);
    }

    protected ImplicitSourceTypeIterator createImplicitSourceTypeIterator(@NonNull ElementCS csElement) {
        return new ImplicitSourceTypeIterator(csElement){

            protected boolean doNext(@NonNull ElementCS csParent, @NonNull ElementCS csChild) {
                if (csParent instanceof TransformationCS) {
                    Transformation asContext = (Transformation)PivotUtil.getPivot(Transformation.class, (Pivotable)((TransformationCS)csParent));
                    if (asContext != null) {
                        this.next = asContext;
                    }
                    return true;
                }
                return super.doNext(csParent, csChild);
            }
        };
    }

    @Nullable
    private Relation getBestRelation(@NonNull List<NamedElement> invocations) {
        for (NamedElement invocation : invocations) {
            if (!(invocation instanceof Relation)) continue;
            return (Relation)invocation;
        }
        return null;
    }

    @Nullable
    private Function getBestFunction(@NonNull List<NamedElement> invocations) {
        for (NamedElement invocation : invocations) {
            if (!(invocation instanceof Function)) continue;
            return (Function)invocation;
        }
        return null;
    }

    @Nullable
    protected List<NamedElement> getInvocations(@NonNull Type asType, @NonNull String name, int iteratorCount, int expressionCount) {
        if (asType instanceof Transformation) {
            Rule rule = (Rule)DomainUtil.getNamedElement((Iterable)((Transformation)asType).getRule(), (String)name);
            if (rule != null) {
                return Collections.singletonList(rule);
            }
            Operation function = (Operation)DomainUtil.getNamedElement((Iterable)((Transformation)asType).getOwnedOperation(), (String)name);
            if (function != null) {
                return Collections.singletonList(function);
            }
            return null;
        }
        return super.getInvocations(asType, name, iteratorCount, expressionCount);
    }

    protected void resolveRelationArguments(@NonNull InvocationExpCS csInvocationExp, @Nullable OCLExpression source, @NonNull Relation relation, @NonNull RelationCallExp relationCallExp) {
        ArrayList<OCLExpression> pivotArguments = new ArrayList<OCLExpression>();
        EList csArguments = csInvocationExp.getArgument();
        EList ownedDomains = relation.getDomain();
        int domainsCount = ownedDomains.size();
        int csArgumentCount = csArguments.size();
        if (csArgumentCount > 0) {
            if (((NavigatingArgCS)csArguments.get(0)).getRole() != NavigationRole.EXPRESSION) {
                ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csInvocationExp, "Relation calls can only specify expressions");
            }
            int argIndex = 0;
            while (argIndex < csArgumentCount) {
                OCLExpression arg;
                NavigatingArgCS csArgument = (NavigatingArgCS)csArguments.get(argIndex);
                if (csArgument.getInit() != null) {
                    ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csArgument, "Unexpected initializer for expression");
                }
                if (csArgument.getOwnedType() != null) {
                    ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csArgument, "Unexpected type for expression");
                }
                if ((arg = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (ElementCS)csArgument)) != null) {
                    pivotArguments.add(arg);
                }
                ++argIndex;
            }
        }
        if (csArgumentCount != domainsCount && relation != this.metaModelManager.getOclInvalidOperation()) {
            String boundMessage = DomainUtil.bind((String)OCLMessages.MismatchedArgumentCount_ERROR_, (Object[])new Object[]{csArgumentCount, domainsCount});
            ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csInvocationExp, boundMessage);
        }
        ((CS2PivotConversion)this.context).refreshList((List)relationCallExp.getArgument(), pivotArguments);
    }

    @Nullable
    protected OCLExpression resolveBestInvocation(@Nullable OCLExpression sourceExp, @NonNull InvocationExpCS csInvocationExp, @NonNull List<NamedElement> invocations) {
        if (sourceExp == null) {
            Relation relation = this.getBestRelation(invocations);
            if (relation != null) {
                RelationCallExp relationCallExp = (RelationCallExp)((CS2PivotConversion)this.context).refreshModelElement(RelationCallExp.class, QVTrelationPackage.Literals.RELATION_CALL_EXP, (ModelElementCS)csInvocationExp);
                relationCallExp.setReferredRelation(relation);
                ((CS2PivotConversion)this.context).setType((TypedElement)relationCallExp, (Type)this.metaModelManager.getBooleanType(), true);
                this.resolveOperationArgumentTypes(csInvocationExp);
                this.resolveRelationArguments(csInvocationExp, null, relation, relationCallExp);
                return relationCallExp;
            }
            Function function = this.getBestFunction(invocations);
            if (function != null) {
                OperationCallExp operationCallExp = (OperationCallExp)((CS2PivotConversion)this.context).refreshModelElement(OperationCallExp.class, PivotPackage.Literals.OPERATION_CALL_EXP, (ModelElementCS)csInvocationExp);
                ((CS2PivotConversion)this.context).setReferredOperation(operationCallExp, (Operation)function);
                ((CS2PivotConversion)this.context).setType((TypedElement)operationCallExp, function.getType(), function.isRequired());
                this.resolveOperationArgumentTypes(csInvocationExp);
                this.resolveOperationArguments(csInvocationExp, (Operation)function, operationCallExp);
                return operationCallExp;
            }
        }
        return super.resolveBestInvocation(sourceExp, csInvocationExp, invocations);
    }

    @Override
    public Element visitCollectionTemplateCS(@NonNull CollectionTemplateCS csElement) {
        return PivotUtil.getPivot(CollectionTemplateExp.class, (Pivotable)csElement);
    }

    @Override
    public Element visitDefaultValueCS(@NonNull DefaultValueCS csElement) {
        RelationDomainAssignment pivotElement = (RelationDomainAssignment)PivotUtil.getPivot(RelationDomainAssignment.class, (Pivotable)csElement);
        return pivotElement;
    }

    @Override
    public Element visitObjectTemplateCS(@NonNull ObjectTemplateCS csElement) {
        return PivotUtil.getPivot(ObjectTemplateExp.class, (Pivotable)csElement);
    }
}

