/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.manager.PivotIdResolver;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.EnforcementOperation;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.IQVTiEvaluationEnvironment;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiAbstractEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironment;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTiEvaluationVisitorImpl
extends QVTiAbstractEvaluationVisitor {
    public QVTiEvaluationVisitorImpl(@NonNull QVTiEnvironment env, @NonNull IQVTiEvaluationEnvironment evalEnv) {
        super(env, evalEnv);
    }

    @Override
    @NonNull
    public QVTiEvaluationVisitor createNestedEvaluator() {
        QVTiEnvironment qvtEnvironment = this.getEnvironment();
        QVTiEnvironmentFactory factory = qvtEnvironment.getFactory();
        IQVTiEvaluationEnvironment nestedEvalEnv = factory.createEvaluationEnvironment(this.evaluationEnvironment);
        QVTiEvaluationVisitorImpl nestedEvaluationVisitor = new QVTiEvaluationVisitorImpl(qvtEnvironment, nestedEvalEnv);
        nestedEvaluationVisitor.setMonitor(this.getMonitor());
        return nestedEvaluationVisitor;
    }

    private static void doMappingCallRecursion(@NonNull QVTiEvaluationVisitor nv, @NonNull Rule rule, @NonNull List<Variable> rootVariables, @NonNull List<List<Object>> rootBindings, int depth) {
        int nextDepth = depth + 1;
        int maxDepth = rootVariables.size();
        Variable var = rootVariables.get(depth);
        Type guardType = var.getType();
        PivotIdResolver idResolver = nv.getMetaModelManager().getIdResolver();
        for (Object binding : rootBindings.get(depth)) {
            DomainType valueType = idResolver.getDynamicTypeOf(binding);
            if (guardType == null || !valueType.conformsTo((DomainStandardLibrary)nv.getMetaModelManager(), (DomainType)guardType)) continue;
            nv.getEvaluationEnvironment().replace((DomainTypedElement)var, binding);
            if (nextDepth < maxDepth) {
                QVTiEvaluationVisitorImpl.doMappingCallRecursion(nv, rule, rootVariables, rootBindings, nextDepth);
                continue;
            }
            rule.accept((Visitor)nv);
        }
    }

    @Override
    @Nullable
    public Object visitBottomPattern(@NonNull BottomPattern bottomPattern) {
        Object result = true;
        Area area = bottomPattern.getArea();
        if (area instanceof CoreDomain) {
            assert (bottomPattern.getAssignment().isEmpty());
            for (Predicate predicate : bottomPattern.getPredicate()) {
                result = predicate.accept((Visitor)this.undecoratedVisitor);
                if (result != Boolean.TRUE) break;
            }
            for (RealizedVariable rVar : bottomPattern.getRealizedVariable()) {
                rVar.accept((Visitor)this.undecoratedVisitor);
            }
            for (EnforcementOperation enforceOp : bottomPattern.getEnforcementOperation()) {
                enforceOp.accept((Visitor)this.undecoratedVisitor);
            }
            return result;
        }
        assert (area instanceof Mapping);
        assert (bottomPattern.getPredicate().isEmpty());
        assert (bottomPattern.getRealizedVariable().isEmpty());
        assert (bottomPattern.getEnforcementOperation().isEmpty());
        for (Assignment assigment : bottomPattern.getAssignment()) {
            assigment.accept((Visitor)this.undecoratedVisitor);
        }
        return result;
    }

    @Override
    @Nullable
    public Object visitCoreDomain(@NonNull CoreDomain coreDomain) {
        Object result = coreDomain.getGuardPattern().accept((Visitor)this.undecoratedVisitor);
        if (result == Boolean.TRUE) {
            coreDomain.getBottomPattern().accept((Visitor)this.undecoratedVisitor);
        }
        return result;
    }

    @Override
    @Nullable
    public Object visitImperativeModel(@NonNull ImperativeModel imperativeModel) {
        for (Package pkge : imperativeModel.getNestedPackage()) {
            pkge.accept((Visitor)this.undecoratedVisitor);
        }
        return true;
    }

    @Override
    @Nullable
    public Object visitMapping(@NonNull Mapping mapping) {
        Object result;
        GuardPattern gp = mapping.getGuardPattern();
        if (gp != null && (result = gp.accept((Visitor)this.undecoratedVisitor)) != Boolean.TRUE) {
            return null;
        }
        for (Domain domain : mapping.getDomain()) {
            if (!domain.isIsEnforceable()) continue;
            domain.accept((Visitor)this.undecoratedVisitor);
        }
        mapping.getBottomPattern().accept((Visitor)this.undecoratedVisitor);
        for (MappingCall mappingCall : mapping.getMappingCall()) {
            QVTiEvaluationVisitor nv = ((QVTiEvaluationVisitor)this.undecoratedVisitor).createNestedEvaluator();
            try {
                mappingCall.accept((Visitor)nv);
            }
            finally {
                nv.dispose();
            }
        }
        return null;
    }

    @Nullable
    public Object visitPackage(@NonNull Package pkge) {
        return true;
    }

    @Override
    @Nullable
    public Object visitTransformation(@NonNull Transformation transformation) {
        Iterator iterator = transformation.getRule().iterator();
        if (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            QVTiEvaluationVisitor nv = ((QVTiEvaluationVisitor)this.undecoratedVisitor).createNestedEvaluator();
            try {
                HashMap<Variable, List<Object>> mappingBindings = new HashMap<Variable, List<Object>>();
                ArrayList<Variable> rootVariables = new ArrayList<Variable>();
                ArrayList<List<Object>> rootBindings = new ArrayList<List<Object>>();
                for (Domain domain : rule.getDomain()) {
                    CoreDomain coreDomain = (CoreDomain)domain;
                    TypedModel m = coreDomain.getTypedModel();
                    for (Variable var : coreDomain.getGuardPattern().getVariable()) {
                        nv.getEvaluationEnvironment().add((DomainTypedElement)var, null);
                        rootVariables.add(var);
                        Type varType = var.getType();
                        if (varType == null) continue;
                        List<Object> bindingValuesSet = ((QVTiModelManager)this.modelManager).getElementsByType(m, varType);
                        rootBindings.add(bindingValuesSet);
                        mappingBindings.put(var, bindingValuesSet);
                    }
                }
                QVTiEvaluationVisitorImpl.doMappingCallRecursion(nv, rule, rootVariables, rootBindings, 0);
            }
            finally {
                nv.dispose();
            }
        }
        return true;
    }
}

