/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.evaluation.TransformationInstance;
import org.eclipse.qvtd.pivot.qvtbase.evaluation.TypedModelInstance;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationAnalysis;

public class QVTiModelManager
implements ModelManager {
    @NonNull
    protected final QVTiTransformationAnalysis transformationAnalysis;
    @NonNull
    protected final MetamodelManager metamodelManager;
    @NonNull
    private Map<TypedModel, Resource> modelResourceMap = new HashMap<TypedModel, Resource>();
    @NonNull
    private Map<TypedModel, List<EObject>> modelElementsMap = new HashMap<TypedModel, List<EObject>>();
    @NonNull
    private Set<Class> allInstancesClasses;
    @NonNull
    private Map<?, ?>[] unnavigableOpposites;

    public QVTiModelManager(@NonNull QVTiTransformationAnalysis transformationAnalysis) {
        this.transformationAnalysis = transformationAnalysis;
        this.metamodelManager = transformationAnalysis.getMetamodelManager();
        this.allInstancesClasses = transformationAnalysis.getAllInstancesClasses();
        int cacheIndexes = transformationAnalysis.getCacheIndexes();
        this.unnavigableOpposites = new Map[cacheIndexes];
        int i = 0;
        while (i < cacheIndexes) {
            this.unnavigableOpposites[i] = new HashMap();
            ++i;
        }
    }

    public void addModel(@NonNull TypedModel typedModel, @NonNull Resource model) {
        this.modelResourceMap.put(typedModel, model);
    }

    public void addModelElement(@NonNull TypedModel model, @NonNull Object element) {
        List<EObject> elements = this.modelElementsMap.get(model);
        if (elements == null) {
            elements = new ArrayList<EObject>((Collection<EObject>)this.modelResourceMap.get(model).getContents());
            this.modelElementsMap.put(model, elements);
        }
        elements.add((EObject)element);
    }

    public void dispose() {
        this.modelElementsMap.clear();
        this.modelResourceMap.clear();
        this.allInstancesClasses.clear();
        Map<?, ?>[] mapArray = this.unnavigableOpposites;
        int n = this.unnavigableOpposites.length;
        int n2 = 0;
        while (n2 < n) {
            Map<?, ?> unnavigableOpposite = mapArray[n2];
            unnavigableOpposite.clear();
            ++n2;
        }
    }

    @NonNull
    public Set<EObject> get(@NonNull Class type) {
        HashSet<EObject> elements = new HashSet<EObject>();
        Package p = type.getOwningPackage();
        for (TypedModel d : this.modelResourceMap.keySet()) {
            for (Package up : d.getUsedPackage()) {
                if (!up.equals(p)) continue;
                for (Object o : this.getElementsByType(d, (Type)type)) {
                    elements.add((EObject)o);
                }
            }
        }
        return elements;
    }

    @NonNull
    public MetamodelManager getMetamodelManager() {
        return this.metamodelManager;
    }

    public Resource getModel(@NonNull TypedModel typedModel) {
        return this.modelResourceMap.get(typedModel);
    }

    public Collection<Resource> getAllModelResources() {
        return this.modelResourceMap.values();
    }

    public List<Object> getElementsByType(@Nullable TypedModel model, @NonNull Type type) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (this.modelElementsMap.containsKey(model)) {
            for (EObject root : this.modelElementsMap.get(model)) {
                if (root == null) continue;
                if (this.isInstance(type, root)) {
                    elements.add(root);
                }
                TreeIterator contents = root.eAllContents();
                while (contents.hasNext()) {
                    EObject element = (EObject)contents.next();
                    if (element == null || !this.isInstance(type, element)) continue;
                    elements.add(element);
                }
            }
        } else {
            TreeIterator contents = this.modelResourceMap.get(model).getAllContents();
            while (contents.hasNext()) {
                EObject element = (EObject)contents.next();
                if (element == null || !this.isInstance(type, element)) continue;
                elements.add(element);
            }
        }
        return elements;
    }

    public Object getUnnavigableOpposite(@NonNull Integer cacheIndex, @NonNull Object sourceObject) {
        return this.unnavigableOpposites[cacheIndex].get(sourceObject);
    }

    protected boolean isInstance(@NonNull Type requiredType, @NonNull EObject eObject) {
        EClass eClass = eObject.eClass();
        EPackage ePackage = eClass.getEPackage();
        Type objectType = null;
        if (ePackage == PivotPackage.eINSTANCE) {
            String name = (String)ClassUtil.nonNullEMF((Object)eClass.getName());
            objectType = this.metamodelManager.getASClass(name);
        } else {
            try {
                objectType = (Type)this.metamodelManager.getASOf(Type.class, (EObject)eClass);
            }
            catch (ParserException parserException) {
                // empty catch block
            }
        }
        return objectType != null && objectType.conformsTo(this.metamodelManager.getStandardLibrary(), requiredType);
    }

    @NonNull
    public QVTiTransformationAnalysis getTransformationAnalysis() {
        return this.transformationAnalysis;
    }

    public List<EObject> getTypeModelEObjectList(TypedModel model) {
        if (this.modelElementsMap.containsKey(model)) {
            return this.modelElementsMap.get(model);
        }
        return new ArrayList<EObject>();
    }

    public void saveModels() {
        Map saveOptions = XMIUtil.createSaveOptions();
        saveOptions.put("SCHEMA_LOCATION_IMPLEMENTATION", Boolean.TRUE);
        this.saveModels(saveOptions);
    }

    public void saveModels(@Nullable Map<?, ?> savingOptions) {
        TypedModel key;
        Resource model;
        for (Map.Entry<TypedModel, Resource> entry : this.modelResourceMap.entrySet()) {
            model = entry.getValue();
            key = entry.getKey();
            if (!this.modelElementsMap.containsKey(key)) continue;
            for (EObject e : this.modelElementsMap.get(key)) {
                if (e.eContainer() != null) continue;
                model.getContents().add((Object)e);
            }
        }
        for (Map.Entry<TypedModel, Resource> entry : this.modelResourceMap.entrySet()) {
            model = entry.getValue();
            key = entry.getKey();
            if (!this.modelElementsMap.containsKey(key)) continue;
            try {
                model.save(savingOptions);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveMiddleModel(@NonNull URI uri) {
        this.saveMiddleModel(uri, null);
    }

    public void saveMiddleModel(@NonNull URI uri, Map<?, ?> savingOptions) {
    }

    public void setUnnavigableOpposite(@NonNull Integer cacheIndex, @NonNull Object targetObject, Object sourceObject) {
        this.unnavigableOpposites[cacheIndex].put(sourceObject, targetObject);
    }

    public Object getTransformationInstance(@NonNull Transformation transformation) {
        return new QVTiTransformationInstance(this, transformation);
    }

    public Object getTypedModelInstance(@NonNull TypedModel typedModel) {
        return new QVTiTypedModelInstance(this, typedModel);
    }

    public static class QVTiTransformationInstance
    implements TransformationInstance {
        @NonNull
        protected final QVTiModelManager modelManager;
        @NonNull
        protected final Transformation transformation;

        public QVTiTransformationInstance(@NonNull QVTiModelManager modelManager, @NonNull Transformation transformation) {
            this.modelManager = modelManager;
            this.transformation = transformation;
        }

        @NonNull
        public QVTiModelManager getModelManager() {
            return this.modelManager;
        }

        @Nullable
        public String getName() {
            return this.transformation.getName();
        }

        @NonNull
        public Transformation getTransformation() {
            return this.transformation;
        }
    }

    public static class QVTiTypedModelInstance
    implements TypedModelInstance {
        @NonNull
        protected final QVTiModelManager modelManager;
        @NonNull
        protected final TypedModel typedModel;

        public QVTiTypedModelInstance(@NonNull QVTiModelManager modelManager, @NonNull TypedModel typedModel) {
            this.modelManager = modelManager;
            this.typedModel = typedModel;
        }

        @NonNull
        public Set<EObject> getAllObjects() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public String getName() {
            return this.typedModel.getName();
        }

        @NonNull
        public Set<EObject> getObjectsOfKind(@NonNull Class type) {
            IdResolver idResolver = this.modelManager.getMetamodelManager().getEnvironmentFactory().getIdResolver();
            HashSet<EObject> results = new HashSet<EObject>();
            Set<EObject> instances = this.modelManager.get(type);
            for (EObject instance : instances) {
                if (instance == null) continue;
                results.add((EObject)idResolver.ecoreValueOf(null, (Object)instance));
            }
            return results;
        }

        @NonNull
        public Set<EObject> getObjectsOfType(@NonNull Class type) {
            throw new UnsupportedOperationException();
        }

        @NonNull
        public QVTiModelManager getModelManager() {
            return this.modelManager;
        }

        @NonNull
        public Collection<EObject> getRootObjects() {
            throw new UnsupportedOperationException();
        }

        @NonNull
        public TypedModel getTypedModel() {
            return this.typedModel;
        }
    }
}

