/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeDomainUsageAnalysis;

public class QVTiTransformationAnalysis {
    @NonNull
    protected final EnvironmentFactoryInternal environmentFactory;
    @NonNull
    private final QVTimperativeDomainUsageAnalysis domainAnalysis;
    @NonNull
    private final Set<Class> allInstancesClasses = new HashSet<Class>();
    @NonNull
    private final Map<Property, Integer> property2cacheIndex = new HashMap<Property, Integer>();
    @NonNull
    private final Map<Property, Integer> sourceProperty2cacheIndex = new HashMap<Property, Integer>();
    @NonNull
    private final Map<PropertyAssignment, Integer> propertyAssignment2cacheIndex = new HashMap<PropertyAssignment, Integer>();
    @NonNull
    private final Map<OppositePropertyCallExp, Integer> oppositePropertyCallExp2cacheIndex = new HashMap<OppositePropertyCallExp, Integer>();

    @Deprecated
    public QVTiTransformationAnalysis(@NonNull MetamodelManagerInternal metamodelManager) {
        this(metamodelManager.getEnvironmentFactory());
    }

    public QVTiTransformationAnalysis(@NonNull EnvironmentFactoryInternal environmentFactory) {
        this.environmentFactory = environmentFactory;
        this.domainAnalysis = new QVTimperativeDomainUsageAnalysis(environmentFactory);
    }

    @NonNull
    protected Integer allocateCacheIndex(@Nullable OCLExpression sourceExpression, @NonNull Property navigableProperty) {
        Integer cacheIndex = this.property2cacheIndex.get(navigableProperty);
        if (cacheIndex == null) {
            DomainUsage sourceUsage;
            Integer size = this.property2cacheIndex.size();
            this.property2cacheIndex.put(navigableProperty, size);
            if (sourceExpression != null && (sourceUsage = this.domainAnalysis.getUsage((EObject)sourceExpression)) != null && sourceUsage.isCheckable()) {
                this.sourceProperty2cacheIndex.put(navigableProperty, size);
            }
            cacheIndex = size;
        }
        return cacheIndex;
    }

    public void analyzeTransformation(@NonNull Transformation transformation) {
        Class oclElementType = this.environmentFactory.getStandardLibrary().getOclElementType();
        Class modelType = this.environmentFactory.getStandardLibrary().getLibraryType("Model");
        OperationId allInstancesOperationId = oclElementType.getTypeId().getOperationId(0, "allInstances", IdManager.getParametersId((TypeId[])new TypeId[0]));
        OperationId objectsOfKindOperationId = modelType.getTypeId().getOperationId(1, "objectsOfKind", IdManager.getParametersId((TypeId[])new TypeId[]{TypeId.T_1}));
        OperationId objectsOfTypeOperationId = modelType.getTypeId().getOperationId(1, "objectsOfType", IdManager.getParametersId((TypeId[])new TypeId[]{TypeId.T_1}));
        ArrayList<PropertyAssignment> propertyAssignments = new ArrayList<PropertyAssignment>();
        TreeIterator tit = transformation.eAllContents();
        while (tit.hasNext()) {
            OCLExpression argument;
            OperationCallExp operationCallExp;
            Operation referredOperation;
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof OppositePropertyCallExp) {
                OppositePropertyCallExp oppositePropertyCallExp = (OppositePropertyCallExp)eObject;
                Property navigableProperty = oppositePropertyCallExp.getReferredProperty();
                if (navigableProperty == null) continue;
                int cacheIndex = this.allocateCacheIndex(oppositePropertyCallExp.getOwnedSource(), navigableProperty);
                this.oppositePropertyCallExp2cacheIndex.put(oppositePropertyCallExp, cacheIndex);
                continue;
            }
            if (eObject instanceof PropertyAssignment) {
                propertyAssignments.add((PropertyAssignment)eObject);
                continue;
            }
            if (!(eObject instanceof OperationCallExp) || (referredOperation = (operationCallExp = (OperationCallExp)eObject).getReferredOperation()) == null) continue;
            OperationId operationId = referredOperation.getOperationId();
            if (operationId == allInstancesOperationId) {
                OCLExpression source = operationCallExp.getOwnedSource();
                if (source == null) continue;
                Type sourceType = source.getTypeValue();
                if (sourceType == null) {
                    sourceType = source.getType();
                }
                if (!(sourceType instanceof Class)) continue;
                this.allInstancesClasses.add((Class)sourceType);
                continue;
            }
            if (operationId != objectsOfKindOperationId && operationId != objectsOfTypeOperationId || (argument = (OCLExpression)operationCallExp.getOwnedArguments().get(0)) == null) continue;
            Type argumentType = argument.getTypeValue();
            if (argumentType == null) {
                argumentType = argument.getType();
            }
            if (!(argumentType instanceof Class)) continue;
            this.allInstancesClasses.add((Class)argumentType);
        }
        for (PropertyAssignment propertyAssignment : propertyAssignments) {
            Integer cacheIndex;
            Property navigableProperty = propertyAssignment.getTargetProperty();
            if (navigableProperty == null || (cacheIndex = this.property2cacheIndex.get(navigableProperty)) == null) continue;
            this.propertyAssignment2cacheIndex.put(propertyAssignment, cacheIndex);
        }
    }

    @NonNull
    public Set<Class> getAllInstancesClasses() {
        return this.allInstancesClasses;
    }

    @Nullable
    public Integer getCacheIndex(@NonNull OppositePropertyCallExp oppositePropertyCallExp) {
        return this.oppositePropertyCallExp2cacheIndex.get(oppositePropertyCallExp);
    }

    @Nullable
    public Integer getCacheIndex(@NonNull PropertyAssignment propertyAssignment) {
        return this.propertyAssignment2cacheIndex.get(propertyAssignment);
    }

    public int getCacheIndexes() {
        return this.property2cacheIndex.size();
    }

    @NonNull
    public Map<Property, Integer> getCaches() {
        return this.property2cacheIndex;
    }

    @NonNull
    public Map<Class, List<Class>> getInstancesClassAnalysis(@NonNull Iterable<Class> instanceClasses) {
        HashMap<Class, List<Class>> instancesClassAnalysis = new HashMap<Class, List<Class>>();
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        for (Class instanceClass : instanceClasses) {
            CompleteClassInternal completeInstanceClass = metamodelManager.getCompleteClass((Type)instanceClass);
            instancesClassAnalysis.put(completeInstanceClass.getPrimaryClass(), null);
        }
        for (Class instanceClass : instancesClassAnalysis.keySet()) {
            ArrayList<Class> superInstanceClasses = new ArrayList<Class>();
            superInstanceClasses.add(instanceClass);
            CompleteClassInternal completeClass = metamodelManager.getCompleteClass((Type)instanceClass);
            for (CompleteClass superCompleteClass : completeClass.getProperSuperCompleteClasses()) {
                Class superClass = superCompleteClass.getPrimaryClass();
                if (instancesClassAnalysis.containsKey(superClass)) {
                    superInstanceClasses.add(superClass);
                }
                instancesClassAnalysis.put(instanceClass, superInstanceClasses);
            }
        }
        return instancesClassAnalysis;
    }

    @NonNull
    public MetamodelManagerInternal getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    @NonNull
    public Map<Property, Integer> getSourceCaches() {
        return this.sourceProperty2cacheIndex;
    }
}

