/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtbase.utilities;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.ToStringVisitor;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.util.QVTbaseVisitor;

public class QVTbaseToStringVisitor
extends ToStringVisitor
implements QVTbaseVisitor<String> {
    public QVTbaseToStringVisitor(@NonNull StringBuilder s) {
        super(s);
    }

    @Override
    public String visitBaseModel(@NonNull BaseModel object) {
        this.append("base model ");
        return null;
    }

    @Override
    public String visitDomain(@NonNull Domain object) {
        this.appendQualifiedName(object);
        return null;
    }

    @Override
    public String visitFunction(@NonNull Function object) {
        return this.visitOperation(object);
    }

    @Override
    public String visitFunctionParameter(@NonNull FunctionParameter object) {
        return this.visitParameter(object);
    }

    public String visitOperationCallExp(@NonNull OperationCallExp object) {
        Operation oper = object.getReferredOperation();
        if (!(oper instanceof Function)) {
            return super.visitOperationCallExp(object);
        }
        this.appendName((Nameable)oper);
        this.append("(");
        String prefix = "";
        for (OCLExpression argument : object.getOwnedArguments()) {
            this.append(prefix);
            this.safeVisit((Visitable)argument);
            prefix = ", ";
        }
        this.append(")");
        return null;
    }

    @Override
    public String visitPattern(@NonNull Pattern object) {
        this.append("pattern ");
        return null;
    }

    @Override
    public String visitPredicate(@NonNull Predicate object) {
        this.safeVisit((Visitable)object.getConditionExpression());
        return null;
    }

    @Override
    public String visitRule(@NonNull Rule object) {
        this.appendQualifiedName(object);
        return null;
    }

    @Override
    public String visitTransformation(@NonNull Transformation object) {
        this.appendQualifiedName((NamedElement)object);
        return null;
    }

    @Override
    public String visitTypedModel(@NonNull TypedModel object) {
        this.appendName((Nameable)object);
        return null;
    }

    public String visitImport(@NonNull Import object) {
        this.append("import ");
        this.appendName((Nameable)object);
        return null;
    }
}

