/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.launching;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.debug.evaluator.QVTrXtextEvaluator;
import org.eclipse.qvtd.debug.ui.QVTdDebugUIPlugin;
import org.eclipse.qvtd.debug.ui.launching.DirectionalMainTab;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.swt.graphics.Image;

public class QVTrMainTab
extends DirectionalMainTab {
    @Override
    public Image getImage() {
        return QVTdDebugUIPlugin.getDefault().createImage("icons/QVTrModelFile.gif");
    }

    private void gatherOutputModels(@NonNull List<TypedModel> outputModels, @NonNull TypedModel typedModel) {
        if (!outputModels.contains(typedModel)) {
            outputModels.add(typedModel);
            for (TypedModel anotherTypedModel : typedModel.getDependsOn()) {
                if (anotherTypedModel == null) continue;
                this.gatherOutputModels(outputModels, anotherTypedModel);
            }
        }
    }

    @Override
    protected void updateGroups(@NonNull Transformation transformation, @NonNull Map<String, String> inputMap, @NonNull Map<String, String> outputMap) {
        String name;
        HashSet<Object> checkables = new HashSet<Object>();
        HashSet<TypedModel> enforceables = new HashSet<TypedModel>();
        for (Rule rule : transformation.getRule()) {
            if (!(rule instanceof Relation)) continue;
            Relation relation = (Relation)rule;
            for (Domain domain : relation.getDomain()) {
                if (!(domain instanceof RelationDomain)) continue;
                RelationDomain relationDomain = (RelationDomain)domain;
                TypedModel typedModel = relationDomain.getTypedModel();
                if (domain.isIsCheckable()) {
                    checkables.add(typedModel);
                }
                if (!domain.isIsEnforceable()) continue;
                enforceables.add(typedModel);
            }
        }
        HashSet<TypedModel> inputs = new HashSet<TypedModel>();
        HashSet<TypedModel> outputs = new HashSet<TypedModel>();
        String directionName = this.directionCombo.getText();
        ArrayList<TypedModel> outputModels = new ArrayList<TypedModel>();
        for (TypedModel typedModel : transformation.getModelParameter()) {
            if (typedModel == null || !ClassUtil.safeEquals((Object)typedModel.getName(), (Object)directionName)) continue;
            this.gatherOutputModels(outputModels, typedModel);
        }
        for (TypedModel typedModel : outputModels) {
            if (!outputs.add(typedModel)) continue;
            name = typedModel.getName();
            outputMap.put(name, null);
        }
        checkables.addAll(enforceables);
        checkables.removeAll(outputModels);
        for (TypedModel typedModel : checkables) {
            if (!inputs.add(typedModel)) continue;
            name = typedModel.getName();
            inputMap.put(name, null);
        }
    }

    @Override
    @NonNull
    protected Transformation updateTransformation(@NonNull URI txURI) throws IOException {
        QVTiEnvironmentFactory envFactory = this.getEnvironmentFactory();
        QVTrXtextEvaluator xtextEvaluator = new QVTrXtextEvaluator(envFactory, txURI);
        return xtextEvaluator.getTransformation();
    }
}

