/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui.launching;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ocl.examples.codegen.dynamic.OCL2JavaFileObject;
import org.eclipse.ocl.examples.debug.vm.ui.launching.LaunchingUtils;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.BasicProjectManager;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.XMIUtil;
import org.eclipse.qvtd.codegen.qvti.QVTiCodeGenOptions;
import org.eclipse.qvtd.codegen.qvti.java.QVTiCodeGenerator;
import org.eclipse.qvtd.compiler.AbstractCompilerChain;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.debug.launching.QVTiLaunchConstants;
import org.eclipse.qvtd.debug.ui.QVTdDebugUIPlugin;
import org.eclipse.qvtd.debug.ui.launching.AbstractMainTab;
import org.eclipse.qvtd.debug.ui.launching.CompileStepRow;
import org.eclipse.qvtd.debug.ui.launching.ParameterRow;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperative;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public abstract class MainTab
extends AbstractMainTab
implements QVTiLaunchConstants {
    protected Text projectPath;
    protected Button projectBrowseWS;
    protected Text txPath;
    protected Button txBrowseWS;
    protected Button txBrowseFile;
    protected Group oldInputsGroup;
    protected Group newInputsGroup;
    protected Group oldOutputsGroup;
    protected Group newOutputsGroup;
    private Group intermediatesGroup;
    private Group buildGroup;
    private Button autoBuildCheckButton;
    private Button interpretedCheckButton;
    private Button traceEvaluationCheckButton;
    private Button compileButton;
    private Group genmodelGroup;
    private Text genmodelPath;
    private Button genmodelBrowseWS;
    private Button genmodelBrowseFile;
    protected boolean initializing = false;
    private boolean updating = false;
    private boolean txModified = false;
    private Transformation transformation = null;
    private boolean directionModified = false;
    private boolean groupsModified = false;
    private @Nullable CompileJob compileJob = null;

    protected void addListeners() {
        this.projectPath.addModifyListener((ModifyListener)new ProjectModifyListener());
        this.txPath.addModifyListener((ModifyListener)new TransformationModifyListener());
        this.compileButton.addSelectionListener((SelectionListener)new CompileButtonAdapter());
        this.interpretedCheckButton.addSelectionListener((SelectionListener)new InterpretedCheckBoxAdapter());
        this.traceEvaluationCheckButton.addSelectionListener((SelectionListener)new InterpretedCheckBoxAdapter());
    }

    public boolean canSave() {
        String path;
        String name;
        ParameterRow row;
        int i;
        Control[] children;
        URI txURI;
        IProject iProject;
        String projectName;
        block12: {
            assert (!this.initializing);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            projectName = this.getProjectName();
            try {
                iProject = root.getProject(projectName);
                if (iProject != null) break block12;
                this.setErrorMessage("Project '" + projectName + "' does not exist");
                return false;
            }
            catch (Exception e) {
                this.setErrorMessage("Project '" + projectName + "' is invalid : " + e.getMessage());
                return false;
            }
        }
        if (!iProject.isOpen()) {
            this.setErrorMessage("Project '" + projectName + "' is closed");
            return false;
        }
        ResourceSet resourceSet = this.getEnvironmentFactory().getResourceSet();
        URIConverter uriConverter = resourceSet.getURIConverter();
        boolean txExists = uriConverter.exists(txURI = this.getTxURI(), null);
        if (!txExists) {
            this.setErrorMessage("Transformation '" + txURI + "' does not exist");
            return false;
        }
        if (this.newInputsGroup != null) {
            children = this.newInputsGroup.getChildren();
            i = 0;
            while (i < children.length) {
                row = (ParameterRow)children[i];
                name = row.name.getText();
                path = row.path.getText();
                URI inURI = URI.createURI((String)path, (boolean)true).resolve(this.getProjectURI());
                boolean inExists = uriConverter.exists(inURI, null);
                if (!inExists) {
                    this.setErrorMessage("Input '" + name + "': '" + inURI + "' does not exist");
                    return false;
                }
                ++i;
            }
        }
        if (this.newOutputsGroup != null) {
            children = this.newOutputsGroup.getChildren();
            i = 0;
            while (i < children.length) {
                row = (ParameterRow)children[i];
                name = row.name.getText();
                path = row.path.getText();
                URI outURI = URI.createURI((String)path, (boolean)true).resolve(this.getProjectURI());
                boolean outExists = uriConverter.exists(outURI.trimSegments(1), null);
                if (!outExists) {
                    this.setErrorMessage("Output '" + name + "': '" + outURI + "' uses non-existent parent folder");
                    return false;
                }
                ++i;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void cancelCompileJob(boolean force) {
        CompileJob compileJob2;
        if (this.compileButton != null && !this.compileButton.isDisposed()) {
            this.compileButton.setText(force ? "Compile" : "Recompile");
        }
        if ((compileJob2 = this.compileJob) != null) {
            this.compileJob = null;
            if (force) {
                compileJob2.cancel();
                this.resetCompileStates();
            }
        }
    }

    public void compiled(@NonNull String step, @Nullable Object object) {
        CompileStepRow row = this.getCompilerStepRow(step);
        if (row != null) {
            row.compiled(object);
        }
    }

    protected void createBuildGroup(Composite control) {
        this.buildGroup = new Group(control, 0);
        this.buildGroup.setToolTipText("Running the transformation compilation tool chain");
        this.buildGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.buildGroup.setText("Build");
        this.buildGroup.setLayout((Layout)new GridLayout(4, false));
        this.autoBuildCheckButton = new Button((Composite)this.buildGroup, 32);
        this.autoBuildCheckButton.setToolTipText("Whether the intermediates should be auto-built by the builder when relevant models change.");
        this.autoBuildCheckButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.autoBuildCheckButton.setText("Auto-Build");
        this.autoBuildCheckButton.setSelection(false);
        this.autoBuildCheckButton.setEnabled(false);
        this.interpretedCheckButton = new Button((Composite)this.buildGroup, 32);
        this.interpretedCheckButton.setToolTipText("Whether to prepare for interpreted execution bypassing the Java generation compilation step.");
        this.interpretedCheckButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.interpretedCheckButton.setText("Interpreted");
        this.interpretedCheckButton.setSelection(true);
        this.traceEvaluationCheckButton = new Button((Composite)this.buildGroup, 32);
        this.traceEvaluationCheckButton.setToolTipText("Whether to provide a textual evaluation trace to the console.");
        this.traceEvaluationCheckButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.traceEvaluationCheckButton.setText("Console Trace");
        this.traceEvaluationCheckButton.setSelection(true);
        this.compileButton = new Button((Composite)this.buildGroup, 8);
        this.compileButton.setToolTipText("Run the Transformation chain to build all intermedites and final model.");
        this.compileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.compileButton.setText("  Compile  ");
    }

    protected @NonNull CompileJob createCompileJob() {
        URI txURI = this.getTxURI();
        String direction = this.getDirection();
        if (this.isInterpreted()) {
            return new CompileJob(txURI, direction, null, null);
        }
        CompileStepRow compilerStepRow = this.getCompilerStepRow("Java");
        URI javaURI = compilerStepRow != null ? URI.createURI((String)compilerStepRow.name.getText()).resolve(txURI) : null;
        return new CompileJob(txURI, direction, this.getGenmodelPath(), javaURI);
    }

    protected abstract @NonNull CompilerChain createCompilerChain(@NonNull QVTiEnvironmentFactory var1, @NonNull URI var2);

    public void createControl(Composite parent) {
        Composite control = this.createForm(parent);
        this.addListeners();
        this.prepareBrowseProjectsButton(this.projectBrowseWS, this.projectPath);
        LaunchingUtils.prepareBrowseWorkspaceButton((Button)this.txBrowseWS, (Text)this.txPath, (boolean)false);
        LaunchingUtils.prepareBrowseFileSystemButton((Button)this.txBrowseFile, (Text)this.txPath, (boolean)false);
        LaunchingUtils.prepareBrowseWorkspaceButton((Button)this.genmodelBrowseWS, (Text)this.genmodelPath, (boolean)false);
        LaunchingUtils.prepareBrowseFileSystemButton((Button)this.genmodelBrowseFile, (Text)this.genmodelPath, (boolean)false);
        this.updateParametersGroup(this.oldInputsGroup, 0, EMPTY_MAP, null);
        this.updateParametersGroup(this.oldOutputsGroup, 8192, EMPTY_MAP, null);
        this.updateParametersGroup(this.newInputsGroup, 0, EMPTY_MAP, null);
        this.updateParametersGroup(this.newOutputsGroup, 8192, EMPTY_MAP, null);
        this.updateParametersGroup(this.intermediatesGroup, 8192, EMPTY_MAP, this.getIntermediateKeys());
        control.setBounds(0, 0, 300, 300);
        control.layout();
        control.pack();
    }

    protected void createDirectionGroup(Group txGroup) {
    }

    public Composite createForm(Composite parent) {
        Composite control = new Composite(parent, 0);
        this.setControl((Control)control);
        GridLayout controlLayout = new GridLayout(1, false);
        controlLayout.verticalSpacing = 0;
        control.setLayout((Layout)controlLayout);
        control.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Group txGroup = this.createTransformationGroup(control);
        this.createDirectionGroup(txGroup);
        GridLayout oldInputsLayout = controlLayout;
        oldInputsLayout.marginBottom = 0;
        oldInputsLayout.marginHeight = 0;
        oldInputsLayout.marginTop = 0;
        oldInputsLayout.verticalSpacing = 0;
        this.oldInputsGroup = new Group(control, 0);
        this.oldInputsGroup.setToolTipText("The previous input models to be compared to the new input models bound to each input domain");
        GridData layoutData = new GridData(4, 4, true, false, 1, 1);
        this.oldInputsGroup.setLayoutData((Object)layoutData);
        this.oldInputsGroup.setText("Old Inputs");
        this.oldInputsGroup.setLayout((Layout)oldInputsLayout);
        GridLayout newInputsLayout = controlLayout;
        newInputsLayout.marginBottom = 0;
        newInputsLayout.marginHeight = 0;
        newInputsLayout.marginTop = 0;
        newInputsLayout.verticalSpacing = 0;
        this.newInputsGroup = new Group(control, 0);
        this.newInputsGroup.setToolTipText("The models bound to each input domain");
        this.newInputsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.newInputsGroup.setText("Inputs");
        this.newInputsGroup.setLayout((Layout)newInputsLayout);
        GridLayout oldOutputsLayout = controlLayout;
        oldOutputsLayout.marginBottom = 0;
        oldOutputsLayout.marginHeight = 0;
        oldOutputsLayout.marginTop = 0;
        oldOutputsLayout.verticalSpacing = 0;
        this.oldOutputsGroup = new Group(control, 0);
        this.oldOutputsGroup.setToolTipText("The previous output models to be compared to the new output models bound to each output domain");
        this.oldOutputsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.oldOutputsGroup.setText("Old Outputs");
        this.oldOutputsGroup.setLayout((Layout)oldOutputsLayout);
        GridLayout newOutputsLayout = controlLayout;
        newOutputsLayout.marginBottom = 0;
        newOutputsLayout.marginHeight = 0;
        newOutputsLayout.marginTop = 0;
        newOutputsLayout.verticalSpacing = 0;
        this.newOutputsGroup = new Group(control, 0);
        this.newOutputsGroup.setToolTipText("The models bound to each output domain");
        this.newOutputsGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.newOutputsGroup.setText("New Outputs");
        this.newOutputsGroup.setLayout((Layout)newOutputsLayout);
        GridLayout intermediatesLayout = controlLayout;
        intermediatesLayout.marginBottom = 0;
        intermediatesLayout.marginHeight = 0;
        intermediatesLayout.marginTop = 0;
        intermediatesLayout.verticalSpacing = 0;
        this.intermediatesGroup = new Group(control, 0);
        this.intermediatesGroup.setToolTipText("The intermediate models and build files");
        this.intermediatesGroup.setLayout((Layout)intermediatesLayout);
        this.intermediatesGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.intermediatesGroup.setText("Intermediates");
        this.createGenmodelGroup(control);
        this.createBuildGroup(control);
        return control;
    }

    protected void createGenmodelGroup(Composite control) {
        Group txGroup = new Group(control, 0);
        txGroup.setToolTipText("The genmodel for the generated models used by the generated transformation ");
        txGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        txGroup.setText("GenModel");
        txGroup.setLayout((Layout)new GridLayout(3, false));
        this.genmodelPath = new Text((Composite)txGroup, 2048);
        this.genmodelPath.setToolTipText("The genmodel for generated models");
        GridData gd_genmodelPath = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_genmodelPath.minimumWidth = 100;
        this.genmodelPath.setLayoutData((Object)gd_genmodelPath);
        this.genmodelBrowseWS = new Button((Composite)txGroup, 0);
        this.genmodelBrowseWS.setText("Browse Workspace...");
        this.genmodelBrowseFile = new Button((Composite)txGroup, 0);
        this.genmodelBrowseFile.setText("Browse File...");
        this.genmodelGroup = txGroup;
    }

    protected Group createTransformationGroup(Composite control) {
        Group txGroup = new Group(control, 0);
        txGroup.setToolTipText("The default project and transformation selection and its directional configuration ");
        txGroup.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        txGroup.setText("Project / Transformation");
        txGroup.setLayout((Layout)new GridLayout(3, false));
        this.projectPath = new Text((Composite)txGroup, 2048);
        this.projectPath.setToolTipText("The default project");
        GridData gd_projectPath = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_projectPath.minimumWidth = 100;
        this.projectPath.setLayoutData((Object)gd_projectPath);
        this.projectBrowseWS = new Button((Composite)txGroup, 0);
        this.projectBrowseWS.setText("Browse Projects...");
        this.txPath = new Text((Composite)txGroup, 2048);
        this.txPath.setToolTipText("The transformation to execute");
        GridData gd_txPath = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txPath.minimumWidth = 100;
        this.txPath.setLayoutData((Object)gd_txPath);
        this.txBrowseWS = new Button((Composite)txGroup, 0);
        this.txBrowseWS.setText("Browse Workspace...");
        this.txBrowseFile = new Button((Composite)txGroup, 0);
        this.txBrowseFile.setText("Browse File...");
        return txGroup;
    }

    protected @NonNull String deresolve(String key) {
        String rawValue = String.valueOf(key);
        URI rawURI = URI.createURI((String)rawValue);
        String projectName = this.getProjectName();
        if (rawURI.isPlatformResource()) {
            URI normalizedURI = rawURI.deresolve(this.getProjectURI());
            rawValue = String.valueOf(normalizedURI);
        } else if (projectName.length() > 0 && rawValue.startsWith(projectName)) {
            rawValue = rawValue.substring(projectName.length() + 1);
        }
        return rawValue;
    }

    protected @Nullable CompileStepRow getCompilerStepRow(@NonNull String step) {
        @NonNull Group intermediatesGroup2 = this.intermediatesGroup;
        return (CompileStepRow)this.getParameterRow(intermediatesGroup2, step);
    }

    protected @Nullable String getCurrentPath(@NonNull Group group, @NonNull String step) {
        String text;
        ParameterRow row = this.getParameterRow(group, step);
        if (row != null && (text = row.path.getText()) != null) {
            return text;
        }
        return null;
    }

    protected @NonNull String getDefaultIntermediatePath(@NonNull Group group, @NonNull URI txURI, @Nullable String subPath, @NonNull String step) {
        String text = this.getCurrentPath(group, step);
        if (text != null) {
            return text;
        }
        int segmentCount = txURI.segmentCount();
        if (segmentCount > 1) {
            URI prefixURI = txURI.trimSegments(1);
            if (subPath != null) {
                prefixURI = URI.createURI((String)subPath, (boolean)true).resolve(prefixURI.appendSegment(""));
            }
            String name = txURI.trimFileExtension().lastSegment();
            URI deresolveSrcURI = prefixURI.appendSegment(name).appendFileExtension(AbstractCompilerChain.getDefaultExtension((String)step)).deresolve(this.getProjectURI());
            List stepProjectSegments = deresolveSrcURI.segmentsList();
            int stepProjectSegmentCount = stepProjectSegments.size();
            if (prefixURI.isPlatformResource() && stepProjectSegmentCount >= 2) {
                if (step == "Class") {
                    String stepProjectName = prefixURI.segment(1);
                    URI stepProjectURI = URI.createPlatformResourceURI((String)stepProjectName, (boolean)false);
                    return String.valueOf(stepProjectURI.appendSegment("bin").deresolve(this.getProjectURI()));
                }
                if (step == "Java") {
                    String stepProjectName = prefixURI.segment(1);
                    URI stepProjectURI = URI.createPlatformResourceURI((String)stepProjectName, (boolean)false);
                    return String.valueOf(stepProjectURI.appendSegment("src-gen").deresolve(this.getProjectURI()));
                }
            }
            return String.valueOf(deresolveSrcURI);
        }
        return "";
    }

    protected @NonNull String getDefaultPath(@NonNull Group group, @NonNull URI txURI, @Nullable String subPath, @NonNull String name) {
        String text = this.getCurrentPath(group, name);
        if (text != null) {
            return text;
        }
        int segmentCount = txURI.segmentCount();
        if (segmentCount > 1) {
            URI prefixURI = txURI.trimSegments(1);
            if (subPath != null) {
                prefixURI = URI.createURI((String)subPath, (boolean)true).resolve(prefixURI.appendSegment(""));
            }
            return String.valueOf(prefixURI.appendSegment(name).appendFileExtension("xmi").deresolve(this.getProjectURI()));
        }
        return "";
    }

    protected @NonNull String getDirection() {
        return "";
    }

    protected @NonNull QVTiEnvironmentFactory getEnvironmentFactory() {
        OCLInternal ocl2 = this.ocl;
        if (ocl2 == null) {
            this.ocl = ocl2 = OCLInternal.newInstance((EnvironmentFactoryInternal)new QVTiEnvironmentFactory(BasicProjectManager.createDefaultProjectManager(), null));
        }
        return (QVTiEnvironmentFactory)ocl2.getEnvironmentFactory();
    }

    protected @NonNull String getGenmodelPath() {
        return this.genmodelPath.getText();
    }

    public Image getImage() {
        return QVTdDebugUIPlugin.getDefault().createImage("icons/QVTiModelFile.gif");
    }

    protected @NonNull List<@NonNull String> getIntermediateKeys() {
        List<String> asList = Arrays.asList(this.getIntermediateKeysInternal());
        ArrayList<@NonNull E> intermediateKeys = ClassUtil.nullFree(asList);
        if (this.isInterpreted()) {
            intermediateKeys = new ArrayList(intermediateKeys);
            intermediateKeys.remove("Java");
            intermediateKeys.remove("Class");
        }
        return intermediateKeys;
    }

    protected abstract @NonNull String @NonNull [] getIntermediateKeysInternal();

    protected @Nullable ParameterRow getParameterRow(@NonNull Group group, @NonNull String name) {
        Control[] controlArray = group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof ParameterRow) {
                ParameterRow row = (ParameterRow)child;
                if (name.equals(row.name.getText())) {
                    return row;
                }
            }
            ++n2;
        }
        return null;
    }

    protected @NonNull String getProjectName() {
        return this.projectPath.getText().trim();
    }

    protected @NonNull URI getProjectURI() {
        return URI.createPlatformResourceURI((String)(String.valueOf(this.getProjectName()) + "/"), (boolean)true);
    }

    protected @NonNull String getTxName() {
        return this.txPath.getText().trim();
    }

    protected @NonNull URI getTxURI() {
        String txName = this.getTxName();
        return URI.createURI((String)txName, (boolean)true).resolve(this.getProjectURI());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        assert (!this.initializing);
        try {
            try {
                this.initializing = true;
                if (configuration != null) {
                    this.initializeInternal(configuration);
                }
            }
            catch (CoreException coreException) {
                this.initializing = false;
                this.txModified = true;
                this.updateLaunchConfigurationDialog();
            }
        }
        finally {
            this.initializing = false;
            this.txModified = true;
            this.updateLaunchConfigurationDialog();
        }
    }

    protected void initializeInternal(@NonNull ILaunchConfiguration configuration) throws CoreException {
        String genmodelAttribute;
        String projectAttribute = configuration.getAttribute("project", "");
        this.projectPath.setText(String.valueOf(projectAttribute));
        String txAttribute = configuration.getAttribute("tx", "");
        URI projectURI = this.getProjectURI();
        URI uri = URI.createURI((String)txAttribute).resolve(projectURI);
        this.txPath.setText(String.valueOf(uri.deresolve(projectURI)));
        this.interpretedCheckButton.setSelection(configuration.getAttribute("interpreted", true));
        this.traceEvaluationCheckButton.setSelection(configuration.getAttribute("console-trace", false));
        Map oldInputsMap = configuration.getAttribute("old-in", EMPTY_MAP);
        Map newInputsMap = configuration.getAttribute("in", EMPTY_MAP);
        Map oldOutputsMap = configuration.getAttribute("old-out", EMPTY_MAP);
        Map newOutputsMap = configuration.getAttribute("out", EMPTY_MAP);
        Map intermediatesMap = configuration.getAttribute("intermediates", EMPTY_MAP);
        if (oldInputsMap != null) {
            this.updateParametersGroup((Group)ClassUtil.nonNullState((Object)this.oldInputsGroup), 0, oldInputsMap, null);
        }
        if (newInputsMap != null) {
            this.updateParametersGroup((Group)ClassUtil.nonNullState((Object)this.newInputsGroup), 0, newInputsMap, null);
        }
        if (oldOutputsMap != null) {
            this.updateParametersGroup((Group)ClassUtil.nonNullState((Object)this.oldOutputsGroup), 0, oldOutputsMap, null);
        }
        if (newOutputsMap != null) {
            this.updateParametersGroup((Group)ClassUtil.nonNullState((Object)this.newOutputsGroup), 8192, newOutputsMap, null);
        }
        if (intermediatesMap != null) {
            this.updateParametersGroup((Group)ClassUtil.nonNullState((Object)this.intermediatesGroup), 8192, intermediatesMap, this.getIntermediateKeys());
        }
        if ((genmodelAttribute = configuration.getAttribute("genmodel", "")) == null) {
            URI txURI = this.getTxURI();
            String name = txURI.trimFileExtension().lastSegment();
            URI prefixURI = txURI.trimSegments(1);
            URI deresolveSrcURI = prefixURI.appendSegment(name).appendFileExtension("genmodel").deresolve(this.getProjectURI());
            genmodelAttribute = deresolveSrcURI.toString();
        }
        if ((uri = URI.createURI((String)genmodelAttribute)).scheme() == null) {
            uri = URI.createPlatformResourceURI((String)genmodelAttribute, (boolean)true);
        }
        this.genmodelPath.setText(String.valueOf(uri.deresolve(this.getProjectURI())));
    }

    protected boolean isInterpreted() {
        return this.interpretedCheckButton.getSelection();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("project", this.getProjectName());
        configuration.setAttribute("tx", this.getTxURI().toString());
        configuration.setAttribute("auto-build", this.autoBuildCheckButton.getSelection());
        configuration.setAttribute("genmodel", URI.createURI((String)this.genmodelPath.getText(), (boolean)true).resolve(this.getProjectURI()).toString());
        configuration.setAttribute("interpreted", this.interpretedCheckButton.getSelection());
        configuration.setAttribute("console-trace", this.traceEvaluationCheckButton.getSelection());
        this.performApply_Map(configuration, this.oldInputsGroup, "old-in");
        this.performApply_Map(configuration, this.newInputsGroup, "in");
        this.performApply_Map(configuration, this.oldOutputsGroup, "old-out");
        this.performApply_Map(configuration, this.newOutputsGroup, "out");
        this.performApply_Map(configuration, this.intermediatesGroup, "intermediates");
    }

    private void performApply_Map(ILaunchConfigurationWorkingCopy configuration, Group group, @NonNull String mapKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        Control[] controlArray = group.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof ParameterRow) {
                ParameterRow row = (ParameterRow)child;
                URI uri = URI.createURI((String)row.path.getText());
                map.put(row.name.getText(), uri.resolve(this.getProjectURI()).toString());
            }
            ++n2;
        }
        configuration.setAttribute(mapKey, map);
    }

    public void prepareBrowseProjectsButton(@NonNull Button browseWorkspaceButton, final @NonNull Text uriField) {
        final Shell shell = browseWorkspaceButton.getShell();
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LabelProvider labelProvider = new LabelProvider(){

                    public Image getImage(Object element) {
                        return null;
                    }

                    public String getText(Object element) {
                        IProject iProject;
                        if (element instanceof IProject && (iProject = (IProject)element).isOpen()) {
                            return iProject.getName();
                        }
                        return null;
                    }
                };
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider);
                dialog.setTitle("Project Selection");
                dialog.setMessage("Select the default project.");
                dialog.setMultipleSelection(false);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                dialog.setElements((Object[])root.getProjects());
                try {
                    IProject iProject = root.getProject(uriField.getText().trim());
                    if (iProject != null) {
                        dialog.setInitialSelections(new Object[]{iProject});
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dialog.open() == 0) {
                    uriField.setText(((IProject)dialog.getFirstResult()).getName());
                }
            }
        });
    }

    private void requestLayout(@NonNull Control control) {
        this.getShell().layout(new Control[]{control}, 4);
    }

    protected void resetCompileStates() {
        Control[] controlArray = this.intermediatesGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof CompileStepRow) {
                CompileStepRow row = (CompileStepRow)child;
                row.reset();
            }
            ++n2;
        }
    }

    @Override
    protected void setDefaults(@NonNull ILaunchConfigurationWorkingCopy configuration, @NonNull IFile iFile) {
        String projectName = iFile.getProject().getName();
        URI projectURI = URI.createPlatformResourceURI((String)projectName, (boolean)true);
        URI rawTxURI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
        URI resolvedTxURI = rawTxURI.resolve(projectURI);
        configuration.setAttribute("project", projectName);
        configuration.setAttribute("tx", resolvedTxURI.toString());
        configuration.setAttribute("genmodel", resolvedTxURI.trimFileExtension().appendFileExtension("genmodel").toString());
        configuration.setAttribute("auto-build", true);
        configuration.setAttribute("interpreted", true);
        configuration.setAttribute("console-trace", false);
        configuration.setAttribute("old-in", EMPTY_MAP);
        configuration.setAttribute("in", EMPTY_MAP);
        configuration.setAttribute("old-out", EMPTY_MAP);
        configuration.setAttribute("out", EMPTY_MAP);
    }

    protected boolean setDirectionModified() {
        boolean wasDirectionModified = this.directionModified;
        this.directionModified = true;
        return !wasDirectionModified;
    }

    protected void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }

    protected abstract void updateDirection(@NonNull Transformation var1);

    protected void updateGenmodelGroup() {
        GridData genmodelGridData = (GridData)this.genmodelGroup.getLayoutData();
        boolean interpreted = this.isInterpreted();
        if (genmodelGridData.exclude != interpreted) {
            genmodelGridData.exclude = interpreted;
            this.requestLayout((Control)this.genmodelGroup);
            this.genmodelGroup.setVisible(!interpreted);
        }
    }

    protected void updateGroups(@NonNull Transformation transformation, @NonNull Map<@NonNull String, @Nullable String> oldInputsMap, @NonNull Map<@NonNull String, @Nullable String> newInputsMap, @NonNull Map<@NonNull String, @Nullable String> oldOutputsMap, @NonNull Map<@NonNull String, @Nullable String> newOutputsMap, @NonNull Map<@NonNull String, @Nullable String> intermediateMap) {
        for (String key : this.getIntermediateKeys()) {
            intermediateMap.put(key, AbstractCompilerChain.getDefaultExtension((String)key));
        }
    }

    public void updateLaunchConfigurationDialog() {
        if (!this.initializing && !this.updating) {
            this.updating = true;
            try {
                Transformation transformation2;
                if (this.projectPath.isDisposed() || this.txPath.isDisposed()) {
                    return;
                }
                String projectName = this.getProjectName();
                URI txURI = this.getTxURI();
                if (this.txModified) {
                    try {
                        this.transformation = this.updateTransformation(txURI);
                        this.directionModified = true;
                    }
                    catch (Throwable ex) {
                        this.setErrorMessage("Failed to load '" + txURI + "': " + ex.toString());
                        super.updateLaunchConfigurationDialog();
                        this.updating = false;
                        return;
                    }
                    this.txModified = false;
                }
                if ((transformation2 = this.transformation) == null) {
                    return;
                }
                if (this.directionModified) {
                    this.updateDirection(transformation2);
                    this.directionModified = false;
                    this.groupsModified = true;
                }
                if (this.groupsModified) {
                    if (this.txPath.isDisposed()) {
                        return;
                    }
                    HashMap<@NonNull String, @Nullable String> oldInputsMap = new HashMap<String, String>();
                    HashMap<@NonNull String, @Nullable String> newInputsMap = new HashMap<String, String>();
                    HashMap<@NonNull String, @Nullable String> oldOutputsMap = new HashMap<String, String>();
                    HashMap<@NonNull String, @Nullable String> newOutputsMap = new HashMap<String, String>();
                    HashMap<@NonNull String, @Nullable String> intermediateMap = new HashMap<String, String>();
                    this.updateGroups(transformation2, oldInputsMap, newInputsMap, oldOutputsMap, newOutputsMap, intermediateMap);
                    @NonNull Group oldInputsGroup2 = this.oldInputsGroup;
                    @NonNull Group newInputsGroup2 = this.newInputsGroup;
                    @NonNull Group oldOutputsGroup2 = this.oldOutputsGroup;
                    @NonNull Group newOutputsGroup2 = this.newOutputsGroup;
                    @NonNull Group intermediatesGroup2 = this.intermediatesGroup;
                    for (String oldInputName : oldInputsMap.keySet()) {
                        oldInputsMap.put(oldInputName, this.getDefaultPath(oldInputsGroup2, txURI, "in", oldInputName));
                    }
                    for (String newInputName : newInputsMap.keySet()) {
                        newInputsMap.put(newInputName, this.getDefaultPath(newInputsGroup2, txURI, "in", newInputName));
                    }
                    for (String oldOutputName : oldOutputsMap.keySet()) {
                        oldOutputsMap.put(oldOutputName, this.getDefaultPath(oldOutputsGroup2, txURI, "out", oldOutputName));
                    }
                    for (String newOutputName : newOutputsMap.keySet()) {
                        newOutputsMap.put(newOutputName, this.getDefaultPath(newOutputsGroup2, txURI, "out", newOutputName));
                    }
                    for (String intermediateName : intermediateMap.keySet()) {
                        intermediateMap.put(intermediateName, this.getDefaultIntermediatePath(intermediatesGroup2, txURI, "temp", intermediateName));
                    }
                    this.updateParametersGroup(oldInputsGroup2, 0, oldInputsMap, null);
                    this.updateParametersGroup(newInputsGroup2, 0, newInputsMap, null);
                    this.updateParametersGroup(oldOutputsGroup2, 8192, oldOutputsMap, null);
                    this.updateParametersGroup(newOutputsGroup2, 8192, newOutputsMap, null);
                    this.updateParametersGroup(intermediatesGroup2, 8192, intermediateMap, this.getIntermediateKeys());
                    this.groupsModified = false;
                }
                this.updateGenmodelGroup();
            }
            finally {
                super.updateLaunchConfigurationDialog();
                this.updating = false;
            }
        }
    }

    protected void updateParametersGroup(@NonNull Group group, int style, @NonNull Map<String, String> map, @Nullable List<@NonNull String> sortedKeys) {
        Control[] children = group.getChildren();
        int i = 0;
        if (map.isEmpty()) {
            ((GridData)group.getLayoutData()).exclude = true;
            group.setVisible(false);
        } else {
            ((GridData)group.getLayoutData()).exclude = false;
            group.setVisible(true);
            ArrayList<@NonNull String> keys = new ArrayList<String>();
            if (sortedKeys != null) {
                for (String key : sortedKeys) {
                    keys.add(key);
                }
            } else {
                for (String key : map.keySet()) {
                    assert (key != null);
                    keys.add(key);
                }
                Collections.sort(keys);
            }
            int iMax = Math.min(children.length, keys.size());
            while (i < iMax) {
                ParameterRow row = (ParameterRow)children[i];
                String key = (String)keys.get(i);
                if (key != null) {
                    row.name.setText(key);
                    String rawValue = this.deresolve(map.get(key));
                    row.path.setText(rawValue);
                }
                ++i;
            }
            while (i < keys.size()) {
                String parameterPath;
                String key = (String)keys.get(i);
                if (key != null && (parameterPath = map.get(key)) != null) {
                    if (group == this.intermediatesGroup) {
                        new CompileStepRow(this, group, style, key, parameterPath);
                    } else {
                        new ParameterRow(this, group, style, key, parameterPath);
                    }
                }
                ++i;
            }
        }
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this.requestLayout((Control)group);
    }

    protected abstract @NonNull Transformation updateTransformation(@NonNull URI var1) throws IOException;

    protected class CompileButtonAdapter
    extends SelectionAdapter {
        protected CompileButtonAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (MainTab.this.compileJob == null) {
                CompileJob compileJob2 = MainTab.this.createCompileJob();
                if (compileJob2 != null) {
                    MainTab.this.resetCompileStates();
                    if (!MainTab.this.compileButton.isDisposed()) {
                        MainTab.this.compileButton.setText("Abort");
                    }
                    MainTab.this.compileJob = compileJob2;
                    compileJob2.schedule();
                }
            } else {
                MainTab.this.cancelCompileJob(true);
            }
        }
    }

    protected class CompileJob
    extends Job
    implements CompilerChain.Listener {
        protected final @NonNull URI txURI;
        protected final @NonNull String outputName;
        protected final @Nullable String genmodelPath;
        protected final @Nullable URI javaURI;

        public CompileJob(@NonNull URI txURI, @Nullable String outputName, @Nullable String genmodelPath, URI javaURI) {
            super("Compile Transformation");
            this.txURI = txURI;
            this.outputName = outputName;
            this.genmodelPath = genmodelPath;
            this.javaURI = javaURI;
        }

        public void compiled(final @NonNull String step, final @Nullable Object object) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (MainTab.this.compileJob != null) {
                        MainTab.this.compiled(step, object);
                    }
                }
            });
        }

        public @NonNull Class<? extends Transformer> createGeneratedClass(@NonNull QVTimperative qvt, @NonNull Transformation asTransformation, String ... genModelFiles) throws Exception {
            ResourceSet resourceSet = qvt.getResourceSet();
            resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/GenModel", (Object)GenModelPackage.eINSTANCE);
            String[] stringArray = genModelFiles;
            int n = genModelFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String genModelFile = stringArray[n2];
                URI genModelURI = URI.createURI((String)genModelFile).resolve(this.txURI);
                this.loadGenModel(MainTab.this.getEnvironmentFactory(), genModelURI);
                ++n2;
            }
            QVTiCodeGenerator cg = new QVTiCodeGenerator(MainTab.this.getEnvironmentFactory(), asTransformation);
            QVTiCodeGenOptions options = cg.getOptions();
            options.setUseNullAnnotations(true);
            options.setPackagePrefix("cg");
            cg.generateClassFile();
            assert (this.javaURI != null);
            URI normalizedURI = resourceSet.getURIConverter().normalize(this.javaURI);
            String fileString = (String)ClassUtil.nonNullState((Object)normalizedURI.toFileString());
            cg.saveSourceFile(fileString);
            File explicitClassPath = new File("../org.eclipse.qvtd.xtext.qvtcore.tests/bin");
            String qualifiedClassName = cg.getQualifiedName();
            String javaCodeSource = cg.generateClassFile();
            OCL2JavaFileObject.saveClass((String)String.valueOf(explicitClassPath), (String)qualifiedClassName, (String)javaCodeSource);
            Class txClass = OCL2JavaFileObject.loadExplicitClass((File)explicitClassPath, (String)qualifiedClassName);
            if (txClass == null) {
                throw new UnsupportedOperationException();
            }
            return txClass;
        }

        protected void doRun() throws Exception {
            QVTimperative qvt = QVTimperative.newInstance((ProjectManager)BasicProjectManager.CLASS_PATH, null);
            CompilerChain compilerChain2 = MainTab.this.createCompilerChain(qvt.getEnvironmentFactory(), this.txURI);
            compilerChain2.setOption("default", CompilerChain.SAVE_OPTIONS_KEY, (Object)XMIUtil.createSaveOptions());
            compilerChain2.addListener((CompilerChain.Listener)this);
            if (this.genmodelPath == null) {
                compilerChain2.compile(this.outputName);
            } else {
                compilerChain2.build(this.outputName, new String[0]);
            }
        }

        private void loadGenModel(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI genModelURI) {
            ResourceSet resourceSet = environmentFactory.getResourceSet();
            PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
            Resource csGenResource = resourceSet.getResource(genModelURI, true);
            for (EObject eObject : csGenResource.getContents()) {
                if (!(eObject instanceof GenModel)) continue;
                GenModel genModel = (GenModel)eObject;
                genModel.reconcile();
                metamodelManager.addGenModel(genModel);
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.doRun();
            }
            catch (Exception e) {
                return QVTdDebugUIPlugin.newCoreStatusError("Failed to execute compile job", e);
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MainTab.this.cancelCompileJob(false);
                }
            });
            return Status.OK_STATUS;
        }
    }

    protected class InterpretedCheckBoxAdapter
    extends SelectionAdapter {
        protected InterpretedCheckBoxAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            MainTab.this.groupsModified = true;
            MainTab.this.updateLaunchConfigurationDialog();
        }
    }

    protected class ProjectModifyListener
    implements ModifyListener {
        protected ProjectModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (MainTab.this.projectPath.isDisposed()) {
                return;
            }
            String projectName = MainTab.this.projectPath.getText();
            MainTab.this.updateLaunchConfigurationDialog();
        }
    }

    protected class TransformationModeListener
    implements ModifyListener {
        protected TransformationModeListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (MainTab.this.setDirectionModified()) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        }
    }

    protected class TransformationModifyListener
    implements ModifyListener {
        protected TransformationModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (MainTab.this.txPath.isDisposed()) {
                return;
            }
            URI txURI = MainTab.this.getTxURI();
            URI elementsURI = txURI.trimFragment();
            try {
                MainTab.this.updateTransformation(elementsURI);
            }
            catch (Exception ex) {
                MainTab.this.setErrorMessage("Failed to load '" + elementsURI + "': " + ex.toString());
            }
            MainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

