/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractConnectionRole;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ConnectionRole;

public class Connections {
    public static final @NonNull ConnectionRole MANDATORY_EDGE = new MandatoryConnectionRole(false);
    public static final @NonNull ConnectionRole MANDATORY_NODE = new MandatoryConnectionRole(true);
    public static final @NonNull ConnectionRole PASSED = new PassedConnectionRole();
    public static final @NonNull ConnectionRole PREFERRED_EDGE = new PreferredConnectionRole(false);
    public static final @NonNull ConnectionRole PREFERRED_NODE = new PreferredConnectionRole(true);

    private static final class MandatoryConnectionRole
    extends AbstractConnectionRole {
        public MandatoryConnectionRole(boolean isNode) {
            super(isNode);
        }

        @Override
        public @NonNull String getStyle() {
            return "dashed";
        }

        @Override
        public boolean isMandatory() {
            return true;
        }

        @Override
        public boolean isPreferred() {
            return true;
        }

        @Override
        public @NonNull ConnectionRole merge(@NonNull ConnectionRole connectionRole) {
            if (connectionRole.isPassed()) {
                return connectionRole;
            }
            if (connectionRole.isPreferred()) {
                return this;
            }
            return super.merge(connectionRole);
        }

        @Override
        public @NonNull String toString() {
            return "\u00abmandatory\u00bb";
        }
    }

    private static final class PassedConnectionRole
    extends AbstractConnectionRole {
        public PassedConnectionRole() {
            super(true);
        }

        @Override
        public boolean isPassed() {
            return true;
        }

        @Override
        public @NonNull ConnectionRole merge(@NonNull ConnectionRole connectionRole) {
            if (connectionRole.isMandatory()) {
                return this;
            }
            if (connectionRole.isPreferred()) {
                return this;
            }
            return super.merge(connectionRole);
        }

        @Override
        public @NonNull String toString() {
            return "\u00abpassed\u00bb";
        }
    }

    private static final class PreferredConnectionRole
    extends AbstractConnectionRole {
        public PreferredConnectionRole(boolean isNode) {
            super(isNode);
        }

        @Override
        public @NonNull String getStyle() {
            return "dotted";
        }

        @Override
        public boolean isMandatory() {
            return false;
        }

        @Override
        public boolean isPreferred() {
            return true;
        }

        @Override
        public @NonNull ConnectionRole merge(@NonNull ConnectionRole connectionRole) {
            if (connectionRole.isPassed()) {
                return connectionRole;
            }
            if (connectionRole.isMandatory()) {
                return connectionRole;
            }
            return super.merge(connectionRole);
        }

        @Override
        public @NonNull String toString() {
            return "\u00abpreferred\u00bb";
        }
    }
}

