/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Connection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ConnectionRole;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.DatumConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Nodes;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Role;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RootScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Visitor;
import org.eclipse.qvtd.compiler.internal.utilities.SymbolNameBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;

public class CyclicScheduledRegion
extends AbstractScheduledRegion {
    protected final @NonNull ScheduledRegion parentScheduledRegion;
    private @NonNull List<@NonNull Node> headNodes = new ArrayList<Node>();

    public static  @NonNull Role.Phase mergePhase( @NonNull Role.Phase phase1,  @Nullable Role.Phase phase2) {
        if (phase2 == null) {
            return phase1;
        }
        switch (phase1) {
            case CONSTANT: {
                switch (phase2) {
                    case CONSTANT: {
                        return Role.Phase.CONSTANT;
                    }
                    case LOADED: {
                        return Role.Phase.LOADED;
                    }
                    case PREDICATED: {
                        return Role.Phase.PREDICATED;
                    }
                    case REALIZED: {
                        return Role.Phase.REALIZED;
                    }
                }
            }
            case LOADED: {
                switch (phase2) {
                    case CONSTANT: {
                        return Role.Phase.LOADED;
                    }
                    case LOADED: {
                        return Role.Phase.LOADED;
                    }
                    case PREDICATED: {
                        return Role.Phase.PREDICATED;
                    }
                    case REALIZED: {
                        return Role.Phase.REALIZED;
                    }
                }
            }
            case PREDICATED: {
                switch (phase2) {
                    case CONSTANT: {
                        return Role.Phase.PREDICATED;
                    }
                    case LOADED: {
                        return Role.Phase.PREDICATED;
                    }
                    case PREDICATED: {
                        return Role.Phase.PREDICATED;
                    }
                    case REALIZED: {
                        return Role.Phase.REALIZED;
                    }
                }
            }
            case REALIZED: {
                switch (phase2) {
                    case CONSTANT: {
                        return Role.Phase.REALIZED;
                    }
                    case LOADED: {
                        return Role.Phase.REALIZED;
                    }
                    case PREDICATED: {
                        return Role.Phase.REALIZED;
                    }
                    case REALIZED: {
                        return Role.Phase.REALIZED;
                    }
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    public CyclicScheduledRegion(@NonNull ScheduledRegion parentScheduledRegion, @NonNull Iterable<@NonNull Region> regions) {
        super(parentScheduledRegion.getSuperRegion());
        this.parentScheduledRegion = parentScheduledRegion;
        for (Region region : regions) {
            this.addRegion(region);
        }
        this.createHeadNodes();
    }

    @Override
    public <R> @Nullable R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitCyclicScheduledRegion(this);
    }

    @Override
    protected @NonNull SymbolNameBuilder computeSymbolName() {
        ArrayList<@NonNull String> names = new ArrayList<String>();
        for (NodeConnection connection : this.getIncomingPassedConnections()) {
            String name = connection.getClassDatumAnalysis().getCompleteClass().getName();
            assert (name != null);
            names.add(name);
        }
        Collections.sort(names);
        SymbolNameBuilder s = new SymbolNameBuilder();
        s.appendString("r_");
        for (String name : names) {
            s.appendString("_");
            s.appendName(name);
        }
        return s;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createHeadNodes() {
        HashMap<@NonNull ClassDatumAnalysis, @NonNull HashSet<@NonNull NodeConnection>> classDatumAnalysis2connections = new HashMap<ClassDatumAnalysis, HashSet<NodeConnection>>();
        for (Region innerRegion : this.getRegions()) {
            for (NodeConnection connection : innerRegion.getIncomingPassedConnections()) {
                ClassDatumAnalysis classDatumAnalysis = connection.getClassDatumAnalysis();
                HashSet<@NonNull NodeConnection> connections = (HashSet<NodeConnection>)classDatumAnalysis2connections.get(classDatumAnalysis);
                if (connections == null) {
                    connections = new HashSet<NodeConnection>();
                    classDatumAnalysis2connections.put(classDatumAnalysis, connections);
                }
                connections.add(connection);
            }
        }
        for (ClassDatumAnalysis classDatumAnalysis : classDatumAnalysis2connections.keySet()) {
            @NonNull Set oldConnections = (Set)classDatumAnalysis2connections.get(classDatumAnalysis);
            assert (oldConnections != null);
            Node headNode = this.createHeadNode(classDatumAnalysis, oldConnections);
            this.headNodes.add(headNode);
        }
    }

    private @NonNull Node createHeadNode(@NonNull ClassDatumAnalysis classDatumAnalysis, @NonNull Set<@NonNull NodeConnection> oldConnections) {
        HashSet<@NonNull Region> regions = new HashSet<Region>(this.getRegions());
        HashSet<@NonNull Node> externalSourceNodes = new HashSet<Node>();
        HashSet<@NonNull Node> internalSourceNodes = new HashSet<Node>();
        ScheduledRegion commonRegion = null;
        for (NodeConnection oldConnection : oldConnections) {
            if (commonRegion == null) {
                commonRegion = oldConnection.getRegion();
            }
            for (Node sourceNode : oldConnection.getSources()) {
                Region sourceRegion = sourceNode.getRegion();
                if (!regions.contains(sourceRegion)) {
                    externalSourceNodes.add(sourceNode);
                    continue;
                }
                internalSourceNodes.add(sourceNode);
            }
        }
        assert (commonRegion != null);
        Role.Phase nodeRolePhase = null;
        HashMap<@NonNull Node, @NonNull NodeConnection> targetNode2oldConnection = new HashMap<Node, NodeConnection>();
        for (NodeConnection oldConnection : oldConnections) {
            for (Map.Entry<Node, ConnectionRole> entry : oldConnection.getTargets().entrySet()) {
                Region targetRegion;
                @NonNull Node targetNode = entry.getKey();
                @NonNull ConnectionRole connectionRole = entry.getValue();
                if (!connectionRole.isPassed() || !regions.contains(targetRegion = targetNode.getRegion())) continue;
                Role.Phase targetNodeRolePhase = targetNode.getNodeRole().getPhase();
                nodeRolePhase = CyclicScheduledRegion.mergePhase(targetNodeRolePhase, nodeRolePhase);
                targetNode2oldConnection.put(targetNode, oldConnection);
            }
        }
        assert (nodeRolePhase != null);
        String name = "\u00abhead" + (this.headNodes.size() > 0 ? Integer.toString(this.headNodes.size()) : "") + "\u00bb";
        Node headNode = Nodes.INPUT.createNode(this, nodeRolePhase, name, classDatumAnalysis);
        System.out.println("Create: " + headNode);
        NodeConnection newExternalConnection = commonRegion.getNodeConnection(externalSourceNodes, classDatumAnalysis);
        newExternalConnection.addPassedTargetNode(headNode);
        NodeConnection newInternalConnection = this.getNodeConnection(Collections.singletonList(headNode), classDatumAnalysis);
        for (Map.Entry entry : targetNode2oldConnection.entrySet()) {
            @NonNull Node targetNode = (Node)entry.getKey();
            @NonNull NodeConnection oldConnection = (NodeConnection)entry.getValue();
            targetNode.removeIncomingConnection(oldConnection);
            oldConnection.removeTarget(targetNode);
            newInternalConnection.addPassedTargetNode(targetNode);
        }
        for (NodeConnection oldConnection : oldConnections) {
            if (newExternalConnection == oldConnection || !Iterables.isEmpty(oldConnection.getTargetNodes())) continue;
            oldConnection.destroy();
            System.out.println("Destroy: " + oldConnection);
        }
        return headNode;
    }

    @Override
    public @NonNull String getName() {
        ArrayList<@NonNull String> names = new ArrayList<String>();
        for (Region region : this.getRegions()) {
            names.add(region.getName());
        }
        Collections.sort(names);
        StringBuilder s = new StringBuilder();
        for (String name : names) {
            if (s.length() > 0) {
                s.append("\\n");
            }
            s.append(name);
        }
        return s.toString();
    }

    @Override
    public @NonNull String getColor() {
        return "brown";
    }

    @Override
    public @NonNull List<@NonNull Node> getHeadNodes() {
        return this.headNodes;
    }

    @Override
    public @NonNull Iterable<@NonNull DatumConnection> getIncomingConnections() {
        return Sets.newHashSet((Iterable)Iterables.concat(this.getIncomingPassedConnections(), (Iterable)this.getIncomingUsedConnections()));
    }

    public @NonNull List<@NonNull NodeConnection> getIncomingUsedConnections() {
        ArrayList<@NonNull NodeConnection> connections = new ArrayList<NodeConnection>();
        HashSet<@NonNull Region> regions = new HashSet<Region>(this.getRegions());
        for (Region region : regions) {
            for (NodeConnection connection : region.getIncomingUsedConnections()) {
                for (Region sourceRegion : connection.getSourceRegions()) {
                    if (regions.contains(sourceRegion) || connections.contains(connection)) continue;
                    connections.add(connection);
                }
            }
        }
        return connections;
    }

    public @NonNull List<@NonNull DatumConnection> getNextConnections() {
        HashSet<@NonNull NodeConnection> connections = new HashSet<NodeConnection>();
        for (Node headNode : this.headNodes) {
            for (NodeConnection connection : headNode.getOutgoingPassedConnections()) {
                connections.add(connection);
            }
        }
        Iterables.addAll(connections, (Iterable)this.getOutgoingUsedConnections());
        return Lists.newArrayList(connections);
    }

    @Override
    public @NonNull List<@NonNull DatumConnection> getOutgoingConnections() {
        HashSet<@NonNull E> connections = new HashSet();
        Iterables.addAll(connections, this.getOutgoingPassedConnections());
        Iterables.addAll(connections, (Iterable)this.getOutgoingUsedConnections());
        return Lists.newArrayList(connections);
    }

    @Override
    public @NonNull Iterable<@NonNull NodeConnection> getOutgoingPassedConnections() {
        HashSet<@NonNull NodeConnection> connections = new HashSet<NodeConnection>();
        HashSet<@NonNull Region> regions = new HashSet<Region>(this.getRegions());
        for (Region region : regions) {
            for (NodeConnection connection : region.getOutgoingPassedConnections()) {
                for (Map.Entry<Node, ConnectionRole> targetEntry : connection.getTargets().entrySet()) {
                    Node targetNode;
                    Region targetRegion;
                    if (!targetEntry.getValue().isPassed() || regions.contains(targetRegion = (targetNode = targetEntry.getKey()).getRegion())) continue;
                    connections.add(connection);
                }
            }
        }
        return connections;
    }

    public @NonNull List<@NonNull NodeConnection> getOutgoingUsedConnections() {
        ArrayList<@NonNull NodeConnection> connections = new ArrayList<NodeConnection>();
        HashSet<@NonNull Region> regions = new HashSet<Region>(this.getRegions());
        for (Region region : regions) {
            for (NodeConnection connection : region.getOutgoingUsedConnections()) {
                for (Region targetRegion : connection.getTargetRegions()) {
                    if (regions.contains(targetRegion) || connections.contains(connection)) continue;
                    connections.add(connection);
                }
            }
        }
        return connections;
    }

    @Override
    public @NonNull RootScheduledRegion getRootScheduledRegion() {
        return this.parentScheduledRegion.getRootScheduledRegion();
    }

    @Override
    public boolean isCyclicScheduledRegion() {
        return true;
    }

    @Override
    public void toGraph(@NonNull GraphStringBuilder s) {
        s.setLabel(this.getName());
        s.pushCluster();
        for (Region region : this.getRegions()) {
            region.toGraph(s);
        }
        for (Node node : this.getNodes()) {
            s.appendNode((GraphStringBuilder.GraphNode)node);
        }
        for (Edge edge : this.getEdges()) {
            s.appendEdge((GraphStringBuilder.GraphNode)edge.getSource(), (GraphStringBuilder.GraphEdge)edge, (GraphStringBuilder.GraphNode)edge.getTarget());
        }
        for (Connection connection : this.getConnections()) {
            connection.toGraph(s);
        }
        s.popCluster();
    }
}

