/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.VariablesAnalysis;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

class RelationalTransformationToTracePackage {
    protected final @NonNull QVTr2QVTc qvtr2qvtc;

    public RelationalTransformationToTracePackage(@NonNull QVTr2QVTc qvtr2qvtc) {
        this.qvtr2qvtc = qvtr2qvtc;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Package doRelationalTransformationToTracePackage(@NonNull RelationalTransformation rTransformation) {
        Package rPackage = rTransformation.getOwningPackage();
        Package tracePackage = PivotFactory.eINSTANCE.createPackage();
        tracePackage.setName("P" + rTransformation.getName());
        tracePackage.setNsPrefix("P" + rTransformation.getName());
        StringBuilder s = new StringBuilder();
        this.getURI(rPackage, s);
        tracePackage.setURI(String.valueOf(s.toString()) + "/" + rTransformation.getName());
        this.qvtr2qvtc.putTracePackage(rTransformation, tracePackage);
        @NonNull List ownedClasses = ClassUtil.nullFree((List)tracePackage.getOwnedClasses());
        for (Rule rRule : ClassUtil.nullFree((EList)rTransformation.getRule())) {
            if (!(rRule instanceof Relation)) continue;
            ownedClasses.add(this.doRelationToTraceClass((Relation)rRule));
        }
        CompilerUtil.normalizeNameables(ownedClasses);
        return tracePackage;
    }

    private String getURI(Package rPackage, @NonNull StringBuilder s) {
        if (rPackage == null) {
            s.append("http://www.eclipse.org/qvtd-example");
        } else if (rPackage.getURI() != null) {
            s.append(rPackage.getURI());
        } else {
            this.getURI(rPackage.getOwningPackage(), s);
            s.append("/");
            s.append(rPackage.getName());
        }
        return null;
    }

    private @NonNull Class doRelationToTraceClass(@NonNull Relation rRelation) {
        @NonNull Class traceClass = PivotFactory.eINSTANCE.createClass();
        this.qvtr2qvtc.putRelationTrace(rRelation, traceClass);
        traceClass.setName("T" + rRelation.getName());
        for (Variable rVariable : VariablesAnalysis.getMiddleDomainVariables(rRelation)) {
            this.createTraceProperty(null, traceClass, (TypedElement)rVariable, false);
        }
        for (Domain rDomain : ClassUtil.nullFree((EList)rRelation.getDomain())) {
            for (DomainPattern rDomainPattern : ClassUtil.nullFree((EList)((RelationDomain)rDomain).getPattern())) {
                TemplateExp rTemplateExp = (TemplateExp)ClassUtil.nonNullState((Object)rDomainPattern.getTemplateExpression());
                this.doSubTemplateToTraceClassProps(rDomain, rTemplateExp, traceClass);
            }
        }
        CompilerUtil.normalizeNameables(ClassUtil.nullFree((List)traceClass.getOwnedProperties()));
        return traceClass;
    }

    private boolean doSubTemplateToTraceClassProps(@NonNull Domain rDomain, @NonNull TemplateExp te, @NonNull Class rc) {
        boolean isMany = false;
        Variable tv = (Variable)ClassUtil.nonNullState((Object)te.getBindsTo());
        if (te instanceof CollectionTemplateExp) {
            CollectionTemplateExp cte = (CollectionTemplateExp)te;
            Variable collectionVariable = cte.getBindsTo();
            CollectionType collectionType = (CollectionType)collectionVariable.getType();
            Type elementType = (Type)ClassUtil.nonNullState((Object)collectionType.getElementType());
            int argIndex = 0;
            for (OCLExpression m : ClassUtil.nullFree((EList)cte.getMember())) {
                if (m instanceof TemplateExp) {
                    if (this.doSubTemplateToTraceClassProps(rDomain, (TemplateExp)m, rc)) {
                        isMany = true;
                    }
                } else {
                    this.createTraceProperty(rDomain, rc, String.valueOf(collectionVariable.getName()) + "_" + argIndex, elementType, collectionType.isIsNullFree());
                }
                ++argIndex;
            }
            Variable rv = cte.getRest();
            if (rv != null) {
                this.createTraceProperty(rDomain, rc, (TypedElement)rv, isMany);
            }
            this.createTraceProperty(rDomain, rc, (TypedElement)tv, isMany);
        } else if (te instanceof ObjectTemplateExp) {
            ObjectTemplateExp ote = (ObjectTemplateExp)te;
            for (PropertyTemplateItem pt : ClassUtil.nullFree((EList)ote.getPart())) {
                OCLExpression value;
                if (pt.getReferredProperty().isIsMany()) {
                    isMany = true;
                }
                if (!((value = (OCLExpression)ClassUtil.nonNullState((Object)pt.getValue())) instanceof TemplateExp) || !this.doSubTemplateToTraceClassProps(rDomain, (TemplateExp)value, rc)) continue;
                isMany = true;
            }
            this.createTraceProperty(rDomain, rc, (TypedElement)tv, isMany);
        }
        return isMany;
    }

    private void createTraceProperty(@Nullable Domain rDomain, @NonNull Class rc, @NonNull TypedElement tv, boolean isMany) {
        String vn = (String)ClassUtil.nonNullState((Object)tv.getName());
        Type c = (Type)ClassUtil.nonNullState((Object)tv.getType());
        this.qvtr2qvtc.whenTraceProperty(rDomain, rc, vn, c, tv.isIsRequired(), isMany);
    }

    private void createTraceProperty(@Nullable Domain rDomain, @NonNull Class rc, @NonNull String name, @NonNull Type type, boolean isRequired) {
        this.qvtr2qvtc.whenTraceProperty(rDomain, rc, name, type, isRequired, false);
    }
}

