/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.TreeIterable;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreHelper;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

class VariablesAnalysis
extends QVTcoreHelper {
    protected final @NonNull QVTr2QVTc qvtr2qvtc;
    protected final @NonNull CoreDomain cEnforcedDomain;
    protected final @NonNull Mapping cMapping;
    protected final boolean isInvoked;
    protected final @NonNull Transformation cTransformation;
    protected final @NonNull BottomPattern cMiddleBottomPattern;
    protected final @NonNull GuardPattern cMiddleGuardPattern;
    protected final @NonNull RealizedVariable cMiddleRealizedVariable;
    private @NonNull Map<@NonNull String, @NonNull AbstractVariableAnalysis> name2originator = new HashMap<String, AbstractVariableAnalysis>();
    private final @NonNull Map<@NonNull Variable, @NonNull RelationVariableAnalysis> rVariable2analysis = new HashMap<Variable, RelationVariableAnalysis>();
    private final @NonNull Map<@NonNull Variable, @NonNull AbstractVariableAnalysis> cVariable2analysis = new HashMap<Variable, AbstractVariableAnalysis>();

    public static void gatherBoundVariables(@NonNull Map<@NonNull Variable, @Nullable TemplateExp> boundVariables, @NonNull Iterable<@NonNull ? extends Element> asRoots) {
        for (Element element : asRoots) {
            VariablesAnalysis.gatherBoundVariables(boundVariables, element);
        }
    }

    public static void gatherBoundVariables(@NonNull Map<@NonNull Variable, @Nullable TemplateExp> boundVariables, @NonNull Element asRoot) {
        for (EObject eObject : new TreeIterable((EObject)asRoot, true)) {
            Variable rest;
            if (!(eObject instanceof TemplateExp)) continue;
            Variable bindsTo = ((TemplateExp)eObject).getBindsTo();
            if (bindsTo != null) {
                boundVariables.put(bindsTo, (TemplateExp)eObject);
            }
            if (!(eObject instanceof CollectionTemplateExp) || (rest = ((CollectionTemplateExp)eObject).getRest()) == null) continue;
            boundVariables.put(rest, null);
        }
    }

    public static void gatherReferredVariables(@NonNull Set<@NonNull Variable> referredVariables, @NonNull Iterable<@NonNull ? extends Element> asRoots) {
        for (Element element : asRoots) {
            VariablesAnalysis.gatherReferredVariables(referredVariables, element);
        }
    }

    public static void gatherReferredVariables(@NonNull Set<@NonNull Variable> referredVariables, @NonNull Element asRoot) {
        for (EObject eObject : new TreeIterable((EObject)asRoot, true)) {
            Variable rest;
            if (eObject instanceof VariableExp) {
                VariableDeclaration referredVariable = ((VariableExp)eObject).getReferredVariable();
                if (!(referredVariable instanceof Variable)) continue;
                referredVariables.add((Variable)referredVariable);
                continue;
            }
            if (eObject instanceof Variable) {
                referredVariables.add((Variable)eObject);
                continue;
            }
            if (!(eObject instanceof TemplateExp)) continue;
            Variable bindsTo = ((TemplateExp)eObject).getBindsTo();
            if (bindsTo != null) {
                referredVariables.add(bindsTo);
            }
            if (!(eObject instanceof CollectionTemplateExp) || (rest = ((CollectionTemplateExp)eObject).getRest()) == null) continue;
            referredVariables.add(rest);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void gatherReferredVariablesWithDomains(@NonNull Map<@NonNull Variable, @Nullable RelationDomain> referredVariable2domain, @NonNull Element asRoot) {
        for (EObject eObject : new TreeIterable((EObject)asRoot, true)) {
            Variable rest;
            if (eObject instanceof VariableExp) {
                VariableDeclaration referredVariable = ((VariableExp)eObject).getReferredVariable();
                if (!(referredVariable instanceof Variable)) continue;
                EObject eContainer = eObject.eContainer();
                if (eContainer instanceof RelationCallExp) {
                    RelationCallExp relationCallExp = (RelationCallExp)eContainer;
                    int argument = relationCallExp.getArgument().indexOf((Object)eObject);
                    assert (argument >= 0);
                    Relation referredRelation = (Relation)ClassUtil.nonNullState((Object)relationCallExp.getReferredRelation());
                    @NonNull List rootVariables = QVTrelationUtil.getRootVariables((Relation)referredRelation);
                    assert (argument < rootVariables.size());
                    Variable rootVariable = (Variable)rootVariables.get(argument);
                    RelationDomain relationDomain = QVTrelationUtil.getRootVariableDomain((Variable)rootVariable);
                    VariablesAnalysis.gatherReferredVariablesWithDomainsAdd(referredVariable2domain, (Variable)referredVariable, relationDomain);
                    continue;
                }
                VariablesAnalysis.gatherReferredVariablesWithDomainsAdd(referredVariable2domain, (Variable)referredVariable, null);
                continue;
            }
            if (eObject instanceof Variable) {
                VariablesAnalysis.gatherReferredVariablesWithDomainsAdd(referredVariable2domain, (Variable)eObject, null);
                continue;
            }
            if (!(eObject instanceof TemplateExp)) continue;
            Variable bindsTo = ((TemplateExp)eObject).getBindsTo();
            if (bindsTo != null) {
                VariablesAnalysis.gatherReferredVariablesWithDomainsAdd(referredVariable2domain, bindsTo, null);
            }
            if (!(eObject instanceof CollectionTemplateExp) || (rest = ((CollectionTemplateExp)eObject).getRest()) == null) continue;
            VariablesAnalysis.gatherReferredVariablesWithDomainsAdd(referredVariable2domain, rest, null);
        }
    }

    private static void gatherReferredVariablesWithDomainsAdd(@NonNull Map<@NonNull Variable, @Nullable RelationDomain> referredVariable2domain, @NonNull Variable variable, @Nullable RelationDomain relationDomain) {
        if (relationDomain != null) {
            RelationDomain oldDomain = referredVariable2domain.put(variable, relationDomain);
            assert (oldDomain == relationDomain || oldDomain == null);
        } else if (!referredVariable2domain.containsKey(variable)) {
            referredVariable2domain.put(variable, null);
        }
    }

    public static @NonNull Set<@NonNull Variable> getMiddleDomainVariables(@NonNull Relation rRelation) {
        HashSet<@NonNull Variable> rSomeDomainVariables = new HashSet<Variable>();
        HashSet<@NonNull Variable> rMiddleDomainVariables = new HashSet<Variable>();
        for (Domain rDomain : ClassUtil.nullFree((EList)rRelation.getDomain())) {
            HashSet<@NonNull Variable> rThisDomainVariables = new HashSet<Variable>();
            VariablesAnalysis.gatherReferredVariables(rThisDomainVariables, (Element)rDomain);
            for (Variable rVariable : rThisDomainVariables) {
                if (rSomeDomainVariables.add(rVariable)) continue;
                rMiddleDomainVariables.add(rVariable);
            }
        }
        return rMiddleDomainVariables;
    }

    public VariablesAnalysis(@NonNull QVTr2QVTc qvtr2qvtc, @NonNull CoreDomain cEnforcedDomain, @NonNull Type traceClass, boolean isInvoked) {
        super(qvtr2qvtc.getEnvironmentFactory());
        this.qvtr2qvtc = qvtr2qvtc;
        this.cEnforcedDomain = cEnforcedDomain;
        this.cMapping = (Mapping)ClassUtil.nonNullState((Object)QVTcoreUtil.getContainingMapping((EObject)cEnforcedDomain));
        this.isInvoked = isInvoked;
        this.cTransformation = (Transformation)ClassUtil.nonNullState((Object)this.cMapping.getTransformation());
        this.cMiddleBottomPattern = (BottomPattern)ClassUtil.nonNullState((Object)this.cMapping.getBottomPattern());
        this.cMiddleGuardPattern = (GuardPattern)ClassUtil.nonNullState((Object)this.cMapping.getGuardPattern());
        this.cMiddleRealizedVariable = this.addCoreRealizedVariable("trace", traceClass);
    }

    protected void addConditionPredicate(@NonNull CorePattern cCorePattern, @NonNull OCLExpression cLeftExpression, @NonNull OCLExpression cRightExpression) {
        OperationCallExp eTerm = this.createOperationCallExp(cLeftExpression, "=", new OCLExpression[]{cRightExpression});
        this.addPredicate(cCorePattern, (OCLExpression)eTerm);
    }

    public @NonNull Variable addCoreGuardVariable(@NonNull String name, @NonNull Type type) {
        CoreVariableAnalysis analysis = new CoreVariableAnalysis(name, type, null);
        Variable cVariable = analysis.getCoreVariable();
        this.cVariable2analysis.put(cVariable, analysis);
        this.cMiddleGuardPattern.getVariable().add((Object)cVariable);
        return cVariable;
    }

    public @NonNull RealizedVariable addCoreRealizedVariable(@NonNull String name, @NonNull Type type) {
        CoreVariableAnalysis analysis = new CoreVariableAnalysis(name, type);
        RealizedVariable cVariable = analysis.getCoreRealizedVariable();
        this.cVariable2analysis.put((Variable)cVariable, analysis);
        this.cMiddleBottomPattern.getRealizedVariable().add((Object)cVariable);
        return cVariable;
    }

    public @NonNull Variable addCoreVariable(@NonNull String name, @NonNull OCLExpression mMember) {
        CoreVariableAnalysis analysis = new CoreVariableAnalysis(name, (Type)ClassUtil.nonNullState((Object)mMember.getType()), mMember);
        Variable cVariable = analysis.getCoreVariable();
        this.cVariable2analysis.put(cVariable, analysis);
        this.cMiddleGuardPattern.getVariable().add((Object)cVariable);
        return cVariable;
    }

    protected void addPredicate(@NonNull CorePattern cExpectedCorePattern, @NonNull OCLExpression cExpression) {
        assert (this.cMapping == QVTcoreUtil.getContainingMapping((EObject)cExpectedCorePattern));
        QVTr2QVTc.SYNTHESIS.println("  addPredicate " + cExpression);
        HashSet<@NonNull Variable> cReferredVariables = new HashSet<Variable>();
        VariablesAnalysis.gatherReferredVariables(cReferredVariables, (Element)cExpression);
        boolean isGuard = true;
        boolean isMiddle = false;
        GuardPattern cReferredPattern = null;
        for (Variable cReferredVariable : cReferredVariables) {
            AbstractVariableAnalysis analysis = this.cVariable2analysis.get(cReferredVariable);
            if (analysis == null) {
                isGuard = false;
                isMiddle = true;
                break;
            }
            CorePattern corePattern = analysis.getCorePattern();
            if (!(corePattern instanceof GuardPattern)) {
                isGuard = false;
            }
            if (cReferredPattern == null) {
                cReferredPattern = corePattern;
                continue;
            }
            if (cReferredPattern == corePattern) continue;
            isMiddle = true;
        }
        if (isMiddle) {
            cReferredPattern = isGuard ? this.cMiddleGuardPattern : this.cMiddleBottomPattern;
        } else {
            assert (cReferredPattern != null);
            cReferredPattern = isGuard ? cReferredPattern.getArea().getGuardPattern() : cReferredPattern.getArea().getBottomPattern();
        }
        Predicate cPredicate = this.createPredicate(cExpression);
        cReferredPattern.getPredicate().add((Object)cPredicate);
    }

    public void addNavigationAssignment(@NonNull Variable rTargetVariable, @NonNull Property targetProperty, @NonNull OCLExpression cExpression) {
        this.getVariableAnalysis(rTargetVariable).addNavigationAssignment(targetProperty, cExpression);
    }

    public void addTraceNavigationAssignment(@NonNull Property targetProperty, @NonNull OCLExpression cExpression) {
        assert (!targetProperty.isIsMany() || cExpression.getType() instanceof CollectionType);
        VariableExp cSlotVariableExp = this.createVariableExp((Variable)this.cMiddleRealizedVariable);
        NavigationAssignment cAssignment = this.createNavigationAssignment((OCLExpression)cSlotVariableExp, targetProperty, cExpression);
        QVTr2QVTc.SYNTHESIS.println("  addPropertyAssignment " + cAssignment);
        this.assertNewAssignment((List<Assignment>)this.cMiddleBottomPattern.getAssignment(), cAssignment);
        this.cMiddleBottomPattern.getAssignment().add((Object)cAssignment);
    }

    private void assertNewAssignment(@NonNull List<Assignment> oldAssignments, @NonNull NavigationAssignment newAssignment) {
        OCLExpression newSlotExpression = newAssignment.getSlotExpression();
        if (newSlotExpression instanceof VariableExp) {
            VariableDeclaration newVariable = ((VariableExp)newSlotExpression).getReferredVariable();
            Property targetProperty = QVTcoreBaseUtil.getTargetProperty((NavigationAssignment)newAssignment);
            for (Assignment oldAssignment : oldAssignments) {
                OCLExpression oldSlotExpression;
                if (!(oldAssignment instanceof NavigationAssignment) || QVTcoreBaseUtil.getTargetProperty((NavigationAssignment)((NavigationAssignment)oldAssignment)) != targetProperty || !((oldSlotExpression = ((NavigationAssignment)oldAssignment).getSlotExpression()) instanceof VariableExp)) continue;
                VariableDeclaration oldVariable = ((VariableExp)oldSlotExpression).getReferredVariable();
                assert (oldVariable != newVariable) : "Repeated assignment: \"" + oldAssignment + "\", \"" + newAssignment + "\"";
            }
        }
    }

    protected @Nullable RelationVariableAnalysis basicGetVariableAnalysis(@NonNull Variable relationVariable) {
        return this.rVariable2analysis.get(relationVariable);
    }

    public void check() {
        for (RelationVariableAnalysis analysis : this.rVariable2analysis.values()) {
            analysis.check();
        }
    }

    public @NonNull Iterable<@NonNull RelationVariableAnalysis> getAnalyses() {
        return this.rVariable2analysis.values();
    }

    public @NonNull Variable getCoreVariable(@NonNull Variable rVariable) {
        return this.getVariableAnalysis(rVariable).getCoreVariable();
    }

    public @NonNull RealizedVariable getMiddleRealizedVariable() {
        return this.cMiddleRealizedVariable;
    }

    private @Nullable OCLExpression getTemplateExp(@NonNull ObjectTemplateExp objectTemplateExp, @NonNull Parameter keyParameter) {
        Property property;
        String keyParameterName = keyParameter.getName();
        for (PropertyTemplateItem propertyTemplateItem : ClassUtil.nullFree((EList)objectTemplateExp.getPart())) {
            property = propertyTemplateItem.getReferredProperty();
            if (!ClassUtil.safeEquals((Object)property.getName(), (Object)keyParameterName)) continue;
            return propertyTemplateItem.getValue();
        }
        EObject eContainer = objectTemplateExp.eContainer();
        if (eContainer instanceof PropertyTemplateItem) {
            Property oppositeProperty;
            PropertyTemplateItem continingPropertyTemplateItem = (PropertyTemplateItem)eContainer;
            property = continingPropertyTemplateItem.getReferredProperty();
            Property property2 = oppositeProperty = property != null ? property.getOpposite() : null;
            if (oppositeProperty != null && ClassUtil.safeEquals((Object)oppositeProperty.getName(), (Object)keyParameterName)) {
                return continingPropertyTemplateItem.getValue();
            }
        }
        return null;
    }

    public @NonNull String getUniqueVariableName(@NonNull String name, @NonNull AbstractVariableAnalysis originator) {
        AbstractVariableAnalysis oldOriginator = this.name2originator.get(name);
        if (oldOriginator != null) {
            assert (oldOriginator != originator);
            int i = 0;
            while (true) {
                String newName;
                if (!this.name2originator.containsKey(newName = String.valueOf(name) + "_" + i)) {
                    name = newName;
                    break;
                }
                ++i;
            }
        }
        this.name2originator.put(name, originator);
        return name;
    }

    protected @NonNull RelationVariableAnalysis getVariableAnalysis(@NonNull Variable relationVariable) {
        RelationVariableAnalysis analysis = this.rVariable2analysis.get(relationVariable);
        if (analysis == null) {
            assert (QVTbaseUtil.getContainingTransformation((EObject)relationVariable) instanceof RelationalTransformation);
            analysis = new RelationVariableAnalysis(relationVariable);
            this.rVariable2analysis.put(relationVariable, analysis);
        }
        return analysis;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ArrayList<@NonNull String> names = new ArrayList<String>(this.name2originator.keySet());
        Collections.sort(names);
        for (String name : names) {
            if (s.length() > 0) {
                s.append("\n");
            }
            s.append(String.valueOf(name) + " => ");
            AbstractVariableAnalysis originator = this.name2originator.get(name);
            if (originator == this) continue;
            s.append(originator);
        }
        return s.toString();
    }

    protected abstract class AbstractVariableAnalysis {
        protected final @NonNull String name;

        protected AbstractVariableAnalysis(String name) {
            this.name = VariablesAnalysis.this.getUniqueVariableName(name, this);
        }

        public abstract @NonNull CorePattern getCorePattern();
    }

    protected class CoreVariableAnalysis
    extends AbstractVariableAnalysis {
        private @NonNull Variable cVariable;

        private CoreVariableAnalysis(@NonNull String name, @Nullable Type type, OCLExpression initValue) {
            super(name);
            this.cVariable = VariablesAnalysis.this.createVariable(this.name, type, true, initValue);
        }

        private CoreVariableAnalysis(@NonNull String name, Type type) {
            super(name);
            this.cVariable = VariablesAnalysis.this.createRealizedVariable(this.name, type);
        }

        @Override
        public @NonNull CorePattern getCorePattern() {
            return this.cVariable instanceof RealizedVariable ? VariablesAnalysis.this.cMiddleBottomPattern : VariablesAnalysis.this.cMiddleGuardPattern;
        }

        public @NonNull RealizedVariable getCoreRealizedVariable() {
            return (RealizedVariable)this.cVariable;
        }

        public @NonNull Variable getCoreVariable() {
            return this.cVariable;
        }
    }

    protected class RelationVariableAnalysis
    extends AbstractVariableAnalysis {
        protected final @NonNull Variable rVariable;
        private @Nullable Key rKey;
        private @Nullable TemplateExp rTemplateExp;
        private boolean isEnforcedBound;
        private boolean isEnforcedReferred;
        private @Nullable CoreDomain cOtherBound;
        private @Nullable CoreDomain cOtherReferred;
        private @Nullable Area cPredicateArea;
        private boolean isRoot;
        private @Nullable CoreDomain cWhenDomain;
        private @Nullable CoreDomain cWhereDomain;
        private @Nullable Variable cVariable;

        private RelationVariableAnalysis(Variable rVariable) {
            super((String)ClassUtil.nonNullState((Object)rVariable.getName()));
            this.rKey = null;
            this.rTemplateExp = null;
            this.isEnforcedBound = false;
            this.isEnforcedReferred = false;
            this.cOtherBound = null;
            this.cOtherReferred = null;
            this.cPredicateArea = null;
            this.isRoot = false;
            this.cWhenDomain = null;
            this.cWhereDomain = null;
            this.rVariable = rVariable;
        }

        public void addNavigationAssignment(@NonNull Property targetProperty, @NonNull OCLExpression cExpression) {
            Key rKey2 = this.rKey;
            if (this.isKeyed() && rKey2 != null) {
                if (rKey2.getPart().contains((Object)targetProperty)) {
                    return;
                }
                if (rKey2.getOppositePart().contains((Object)targetProperty.getOpposite())) {
                    return;
                }
            }
            Variable cVariable2 = this.getCoreVariable();
            if (!targetProperty.isIsMany() || cExpression.getType() instanceof CollectionType) {
                VariableExp cSlotVariableExp = VariablesAnalysis.this.createVariableExp(cVariable2);
                NavigationAssignment cAssignment = VariablesAnalysis.this.createNavigationAssignment((OCLExpression)cSlotVariableExp, targetProperty, cExpression);
                QVTr2QVTc.SYNTHESIS.println("  addPropertyAssignment " + cAssignment);
                VariablesAnalysis.this.assertNewAssignment((List)VariablesAnalysis.this.cMiddleBottomPattern.getAssignment(), cAssignment);
                VariablesAnalysis.this.cMiddleBottomPattern.getAssignment().add((Object)cAssignment);
                return;
            }
            Property cOppositeProperty = targetProperty.getOpposite();
            if (cOppositeProperty != null && cExpression instanceof VariableExp && (!cOppositeProperty.isIsMany() || cVariable2.getType() instanceof CollectionType)) {
                VariableExp cSlotVariableExp = (VariableExp)cExpression;
                NavigationAssignment cAssignment = VariablesAnalysis.this.createNavigationAssignment((OCLExpression)cSlotVariableExp, cOppositeProperty, (OCLExpression)VariablesAnalysis.this.createVariableExp(cVariable2));
                QVTr2QVTc.SYNTHESIS.println("  addOppositePropertyAssignment " + cAssignment);
                VariablesAnalysis.this.assertNewAssignment((List)VariablesAnalysis.this.cMiddleBottomPattern.getAssignment(), cAssignment);
                VariablesAnalysis.this.cMiddleBottomPattern.getAssignment().add((Object)cAssignment);
                return;
            }
            throw new IllegalStateException("Unsupported collection assign " + cVariable2 + " . " + targetProperty + " := " + cExpression);
        }

        public @Nullable RealizedVariable basicGetCoreRealizedVariable() {
            return (RealizedVariable)this.cVariable;
        }

        public @Nullable Variable basicGetCoreVariable() {
            return this.cVariable;
        }

        public void check() {
            if (this.cVariable == null) {
                System.err.println("No cVariable for " + this);
                return;
            }
            CorePattern cPattern = this.getCorePattern();
            boolean isRealized = this.isRealized();
            assert (this.cVariable != null && this.cVariable.eContainer() == cPattern);
            assert (this.cVariable instanceof RealizedVariable == isRealized);
        }

        @Override
        public @NonNull CorePattern getCorePattern() {
            CoreDomain cArea = null;
            boolean isGuard = false;
            if (this.cWhenDomain != null) {
                isGuard = true;
                cArea = this.cWhenDomain;
            } else if (this.isEnforcedBound) {
                isGuard = VariablesAnalysis.this.isInvoked && this.isRoot;
                cArea = this.rKey != null ? VariablesAnalysis.this.cMapping : VariablesAnalysis.this.cEnforcedDomain;
            } else if (this.cOtherBound != null) {
                isGuard = this.isRoot;
                cArea = this.cOtherBound;
            } else if (this.isEnforcedReferred && this.cOtherReferred != null) {
                isGuard = false;
                cArea = VariablesAnalysis.this.cMapping;
            } else if (this.cOtherReferred != null) {
                isGuard = false;
                cArea = this.cOtherReferred;
            } else if (this.cPredicateArea != null) {
                isGuard = false;
                cArea = this.cPredicateArea;
            }
            assert (cArea != null);
            return (CorePattern)ClassUtil.nonNullState((Object)(isGuard ? cArea.getGuardPattern() : cArea.getBottomPattern()));
        }

        public @NonNull Variable getCoreVariable() {
            Variable cVariable2 = this.cVariable;
            if (cVariable2 == null) {
                cVariable2 = this.synthesize();
            }
            return cVariable2;
        }

        public @NonNull Variable getRelationVariable() {
            return this.rVariable;
        }

        private void initializeKeyedVariable(@NonNull Variable cKeyedVariable) {
            Function function = VariablesAnalysis.this.qvtr2qvtc.getKeyFunction((Key)ClassUtil.nonNull((Object)this.rKey));
            Variable thisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)VariablesAnalysis.this.environmentFactory.getStandardLibrary(), (Transformation)VariablesAnalysis.this.cTransformation);
            ArrayList<@NonNull Object> asArguments = new ArrayList<Object>();
            if (this.rTemplateExp instanceof ObjectTemplateExp) {
                ObjectTemplateExp objectTemplateExp = (ObjectTemplateExp)this.rTemplateExp;
                for (Parameter keyParameter : ClassUtil.nullFree((List)function.getOwnedParameters())) {
                    Variable cVariable;
                    Variable rVariable;
                    OCLExpression parameterExp = VariablesAnalysis.this.getTemplateExp(objectTemplateExp, keyParameter);
                    if (parameterExp instanceof TemplateExp) {
                        rVariable = (Variable)ClassUtil.nonNullState((Object)((TemplateExp)parameterExp).getBindsTo());
                        cVariable = VariablesAnalysis.this.getCoreVariable(rVariable);
                        asArguments.add(VariablesAnalysis.this.createVariableExp(cVariable));
                        continue;
                    }
                    if (parameterExp instanceof VariableExp) {
                        rVariable = (Variable)ClassUtil.nonNullState((Object)((VariableExp)parameterExp).getReferredVariable());
                        cVariable = VariablesAnalysis.this.getCoreVariable(rVariable);
                        asArguments.add(VariablesAnalysis.this.createVariableExp(cVariable));
                        continue;
                    }
                    asArguments.add(VariablesAnalysis.this.createInvalidExpression());
                }
            }
            OperationCallExp asConstructor = VariablesAnalysis.this.createOperationCallExp((OCLExpression)VariablesAnalysis.this.createVariableExp(thisVariable), (Operation)function, asArguments);
            @NonNull VariableAssignment cVariableAssignment = VariablesAnalysis.this.createVariableAssignment(cKeyedVariable, (OCLExpression)asConstructor);
            VariablesAnalysis.this.cMiddleBottomPattern.getAssignment().add((Object)cVariableAssignment);
        }

        private boolean isKeyed() {
            boolean isKeyed = false;
            if (!(this.cWhenDomain != null || VariablesAnalysis.this.isInvoked && this.isRoot || !this.isEnforcedBound)) {
                isKeyed = this.rKey != null;
            }
            return isKeyed;
        }

        private boolean isRealized() {
            boolean isRealized = false;
            if (!(this.cWhenDomain != null || VariablesAnalysis.this.isInvoked && this.isRoot || !this.isEnforcedBound)) {
                isRealized = this.rKey == null;
            }
            return isRealized;
        }

        public void setIsEnforcedBound(@Nullable TemplateExp rTemplateExp, @Nullable Key rKey) {
            assert (!this.isEnforcedBound);
            assert (this.cOtherBound == null);
            assert (this.rKey == null);
            assert (this.rTemplateExp == null);
            this.isEnforcedBound = true;
            this.rTemplateExp = rTemplateExp;
            this.rKey = rKey;
        }

        public void setIsEnforcedReferred() {
            this.isEnforcedReferred = true;
        }

        public void setIsRoot() {
            this.isRoot = true;
        }

        public void setPredicate(@NonNull Area cPredicateArea) {
            this.cPredicateArea = cPredicateArea;
        }

        public void setWhen(@NonNull CoreDomain cWhenDomain) {
            assert (this.cWhenDomain == null || this.cWhenDomain == cWhenDomain);
            this.cWhenDomain = cWhenDomain;
        }

        public void setWhere(@NonNull CoreDomain cWhereDomain) {
            assert (this.cWhereDomain == null || this.cWhereDomain == cWhereDomain);
            this.cWhereDomain = cWhereDomain;
        }

        public void setOtherBound(@NonNull CoreDomain otherDomain) {
            assert (!this.isEnforcedBound);
            assert (this.cOtherBound == null);
            this.cOtherBound = otherDomain;
        }

        public void setOtherReferred(@NonNull CoreDomain cOtherDomain) {
            assert (this.cOtherReferred == null || this.cOtherReferred == cOtherDomain);
            this.cOtherReferred = cOtherDomain;
        }

        public @NonNull Variable synthesize() {
            Variable cVariable2 = this.cVariable;
            if (cVariable2 == null) {
                CorePattern cPattern = this.getCorePattern();
                boolean isKeyed = this.isKeyed();
                boolean isRealized = this.isRealized();
                Type type = (Type)ClassUtil.nonNullState((Object)this.rVariable.getType());
                if (isKeyed) {
                    cVariable2 = VariablesAnalysis.this.createVariable(this.name, type, true, null);
                    this.initializeKeyedVariable(cVariable2);
                    cPattern.getVariable().add((Object)cVariable2);
                } else if (!isRealized) {
                    cVariable2 = VariablesAnalysis.this.createVariable(this.name, type, this.rVariable.isIsRequired(), null);
                    cPattern.getVariable().add((Object)cVariable2);
                } else {
                    RealizedVariable cRealizedVariable = VariablesAnalysis.this.createRealizedVariable(this.name, type);
                    ((BottomPattern)cPattern).getRealizedVariable().add((Object)cRealizedVariable);
                    cVariable2 = cRealizedVariable;
                }
                this.cVariable = cVariable2;
                VariablesAnalysis.this.cVariable2analysis.put(cVariable2, this);
            }
            return cVariable2;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.rVariable.toString());
            if (this.cWhenDomain != null) {
                s.append(" WHEN:" + this.cWhenDomain.getName());
            }
            if (this.cWhereDomain != null) {
                s.append(" WHERE:" + this.cWhereDomain.getName());
            }
            if (VariablesAnalysis.this.isInvoked) {
                s.append(" INVOKED");
            }
            if (this.cPredicateArea != null) {
                s.append(" PREDICATE:" + (this.cPredicateArea instanceof CoreDomain ? ((CoreDomain)this.cPredicateArea).getName() : null));
            }
            if (this.isRoot) {
                s.append(" ROOT");
            }
            if (this.rKey != null) {
                s.append(" KEYED");
            }
            if (this.isEnforcedBound) {
                s.append(" ENFORCED");
            } else if (this.isEnforcedReferred) {
                s.append(" enforced");
            }
            if (this.cOtherBound != null) {
                s.append(" OTHER:" + this.cOtherBound.getName());
            } else if (this.cOtherReferred != null) {
                s.append(" other:" + this.cOtherReferred.getName());
            }
            if (this.rTemplateExp != null) {
                s.append(" " + this.rTemplateExp);
            }
            return s.toString();
        }
    }
}

