/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseHelper;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;

public class TransformationAnalysis
extends QVTbaseHelper
implements Nameable {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull Transformation transformation;
    private final @NonNull Map<@NonNull Rule, @NonNull RuleAnalysis> rule2ruleAnalysis = new HashMap<Rule, RuleAnalysis>();

    public TransformationAnalysis(@NonNull ScheduleManager scheduleManager, @NonNull Transformation transformation) {
        super(scheduleManager.getEnvironmentFactory());
        this.scheduleManager = scheduleManager;
        this.transformation = transformation;
        for (Rule asRule : QVTbaseUtil.getOwnedRules((Transformation)transformation)) {
            RuleAnalysis ruleAnalysis = scheduleManager.createRuleAnalysis(asRule);
            this.rule2ruleAnalysis.put(asRule, ruleAnalysis);
        }
    }

    public void analyze() {
        for (Rule asRule : QVTbaseUtil.getOwnedRules((Transformation)this.transformation)) {
            RuleAnalysis ruleAnalysis = this.getRuleAnalysis(asRule);
            ruleAnalysis.analyze();
        }
    }

    public String getName() {
        return this.transformation.getName();
    }

    public @NonNull Iterable<@NonNull RuleAnalysis> getRuleAnalyses() {
        return this.rule2ruleAnalysis.values();
    }

    public @NonNull RuleAnalysis getRuleAnalysis(@NonNull Rule rule) {
        RuleAnalysis ruleAnalysis = this.rule2ruleAnalysis.get(rule);
        if (ruleAnalysis != null) {
            return ruleAnalysis;
        }
        TransformationAnalysis transformationAnalysis = this.scheduleManager.getTransformationAnalysis(QVTbaseUtil.getContainingTransformation((EObject)rule));
        if (transformationAnalysis != this) {
            return transformationAnalysis.getRuleAnalysis(rule);
        }
        throw new IllegalStateException("No RuleAnalysis for '" + rule + "'");
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @NonNull Transformation getTransformation() {
        return this.transformation;
    }

    public @NonNull String toString() {
        return String.valueOf(this.transformation);
    }
}

