/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.CyclicPartitionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.LoadingPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.NonPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.NonPartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RootPartitionAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseHelper;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;

public class TransformationPartitioner
extends QVTbaseHelper
implements Nameable {
    public static final @NonNull TracingOption CYCLES = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/partition/cycles");
    public static final @NonNull TracingOption DISCRIMINATION = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/partition/discrimination");
    public static final @NonNull TracingOption PREDECESSORS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/partition/predecessors");
    public static final @NonNull TracingOption SUCCESSORS = new TracingOption(CompilerConstants.PLUGIN_ID, "qvts2qvts/partition/successors");
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull AbstractTransformationAnalysis transformationAnalysis;
    protected final @NonNull ProblemHandler problemHandler;
    protected final @NonNull Iterable<@NonNull ? extends Region> activeRegions;
    private final @NonNull List<@NonNull PartitionAnalysis> partitionAnalyses = new ArrayList<PartitionAnalysis>();
    private final @NonNull Map<@NonNull MappingRegion, @NonNull MappingPartitioner> region2mappingPartitioner = new HashMap<MappingRegion, MappingPartitioner>();
    private final @NonNull List<@NonNull MappingPartitioner> mappingPartitioners = new ArrayList<MappingPartitioner>();
    private @Nullable CyclicPartitionsAnalysis cyclicPartitionsAnalysis = null;

    public static @NonNull PartitionedTransformationAnalysis partition(@NonNull AbstractTransformationAnalysis transformationAnalysis, @NonNull ProblemHandler problemHandler, @NonNull Iterable<@NonNull ? extends Region> activeRegions) throws CompilerChainException {
        TransformationPartitioner transformationPartitioner = new TransformationPartitioner(transformationAnalysis, problemHandler, activeRegions);
        return transformationPartitioner.partition();
    }

    public TransformationPartitioner(@NonNull AbstractTransformationAnalysis transformationAnalysis, @NonNull ProblemHandler problemHandler, @NonNull Iterable<@NonNull ? extends Region> activeRegions) {
        super(transformationAnalysis.getScheduleManager().getEnvironmentFactory());
        this.scheduleManager = transformationAnalysis.getScheduleManager();
        this.transformationAnalysis = transformationAnalysis;
        this.problemHandler = problemHandler;
        this.activeRegions = activeRegions;
    }

    public void addProblem(@NonNull CompilerProblem problem) {
        this.problemHandler.addProblem(problem);
    }

    public @NonNull MappingPartitioner getMappingPartitioner(@NonNull MappingRegion region) {
        return (MappingPartitioner)ClassUtil.nonNullState((Object)this.region2mappingPartitioner.get(region));
    }

    public String getName() {
        return this.transformationAnalysis.getName();
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @NonNull PropertyDatum getSuccessPropertyDatum(@NonNull Property successProperty) {
        return this.scheduleManager.getSuccessPropertyDatum(successProperty);
    }

    public @NonNull Transformation getTransformation() {
        return this.transformationAnalysis.getTransformation();
    }

    public @NonNull AbstractTransformationAnalysis getTransformationAnalysis() {
        return this.transformationAnalysis;
    }

    public @NonNull PartitionedTransformationAnalysis partition() throws CompilerChainException {
        PartitionedTransformationAnalysis partitionedTransformationAnalysis = new PartitionedTransformationAnalysis(this);
        for (Region region : this.activeRegions) {
            RegionAnalysis regionAnalysis = this.transformationAnalysis.getRegionAnalysis(region);
            if (region instanceof MappingRegion) {
                MappingRegion mappingRegion = (MappingRegion)region;
                MappingPartitioner mappingPartitioner = new MappingPartitioner(this, regionAnalysis);
                this.region2mappingPartitioner.put(mappingRegion, mappingPartitioner);
                this.mappingPartitioners.add(mappingPartitioner);
                continue;
            }
            if (!(region instanceof LoadingRegion)) continue;
            LoadingPartitionAnalysis loadingPartitionAnalysis = LoadingPartitionAnalysis.createLoadingPartitionAnalysis(partitionedTransformationAnalysis, (LoadingRegion)region);
            this.partitionAnalyses.add(loadingPartitionAnalysis);
            regionAnalysis.setPartitionAnalyses(Collections.singletonList(loadingPartitionAnalysis));
            RootRegion rootRegion = this.transformationAnalysis.getRootRegion();
            rootRegion.setOwnedLoadingRegion((LoadingRegion)region);
        }
        Collections.sort(this.mappingPartitioners, NameUtil.NAMEABLE_COMPARATOR);
        this.transformationAnalysis.prePartition();
        for (MappingPartitioner mappingPartitioner : this.mappingPartitioners) {
            List<Object> regionPartitionAnalyses;
            RegionAnalysis regionAnalysis = mappingPartitioner.getRegionAnalysis();
            if (Iterables.isEmpty(mappingPartitioner.getTraceNodes())) {
                NonPartitionAnalysis nonPartitionAnalysis = new NonPartitionFactory(mappingPartitioner).createPartitionAnalysis(partitionedTransformationAnalysis);
                regionPartitionAnalyses = Collections.singletonList(nonPartitionAnalysis);
            } else {
                regionPartitionAnalyses = Lists.newArrayList(mappingPartitioner.partition(partitionedTransformationAnalysis));
            }
            regionAnalysis.setPartitionAnalyses(regionPartitionAnalyses);
            Iterables.addAll(this.partitionAnalyses, (Iterable)regionPartitionAnalyses);
        }
        Collections.sort(this.partitionAnalyses, NameUtil.NAMEABLE_COMPARATOR);
        return this.postPartition(partitionedTransformationAnalysis);
    }

    public @NonNull PartitionedTransformationAnalysis postPartition(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) throws CompilerChainException {
        partitionedTransformationAnalysis.analyzePartitions(this.partitionAnalyses);
        partitionedTransformationAnalysis.computeTraceClassInheritance();
        this.cyclicPartitionsAnalysis = new CyclicPartitionsAnalysis(this, this.partitionAnalyses);
        RootPartitionAnalysis rootPartitionAnalysis = this.cyclicPartitionsAnalysis.analyze(partitionedTransformationAnalysis);
        partitionedTransformationAnalysis.analyzeFallibilities(rootPartitionAnalysis);
        return partitionedTransformationAnalysis;
    }
}

