/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.exe2016.tests.qvtc;

import java.util.Collection;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.doc.exe2016.tests.AbstractEXE2016CGTests;
import org.eclipse.qvtd.doc.exe2016.tests.DoublyLinkedListGenerator;
import org.eclipse.qvtd.doc.exe2016.tests.PrintAndLog;
import org.eclipse.qvtd.doc.exe2016.tests.qvtc.doublylinkedlist.DoublyLinkedList;
import org.eclipse.qvtd.doc.exe2016.tests.qvtc.doublylinkedlist.DoublylinkedlistPackage;
import org.eclipse.qvtd.doc.exe2016.tests.qvtc.list2list.List2listPackage;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.BasicQVTiExecutor;
import org.eclipse.qvtd.xtext.qvtcore.tests.QVTcCompilerTests;
import org.junit.Test;

public class EXE2016InterpreterTests
extends QVTcCompilerTests {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testQVTcCompiler_Forward2Reverse() throws Exception {
        DoublyLinkedListGenerator doublyLinkedListGenerator = new DoublyLinkedListGenerator();
        PrintAndLog logger = new PrintAndLog("results/" + this.getName());
        logger.printf("%s\n", this.getName());
        QVTcCompilerTests.MyQVT myQVT = this.createQVT("Forward2Reverse", this.getModelsURI("forward2reverse/Forward2Reverse.qvtc"));
        myQVT.loadEcoreFile(this.getModelsURI("forward2reverse/DoublyLinkedList.ecore"), (EPackage)DoublylinkedlistPackage.eINSTANCE);
        myQVT.loadEcoreFile(this.getModelsURI("forward2reverse/List2List.ecore"), (EPackage)List2listPackage.eINSTANCE);
        try {
            int[] tests;
            ImperativeTransformation asTransformation = myQVT.compileTransformation("reverse");
            int[] nArray = tests = PrintAndLog.getTestSizes();
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                int testSize = nArray[n2];
                BasicQVTiExecutor interpretedExecutor = myQVT.createInterpretedExecutor(asTransformation);
                Resource inResource = myQVT.loadInput("forward", this.getModelsURI("families2persons/samples/EmptyList.xmi"));
                assert (inResource != null);
                inResource.getContents().clear();
                inResource.getContents().addAll(doublyLinkedListGenerator.createDoublyLinkedListModel(testSize));
                Resource outResource = myQVT.createModel("reverse", this.getTestURI("List_Interpreted.xmi"));
                assert (outResource != null);
                AbstractEXE2016CGTests.garbageCollect();
                logger.printf("%9d, ", testSize);
                long startTime = System.nanoTime();
                myQVT.executeTransformation();
                @NonNull Collection rootObjects = myQVT.getRootObjects("reverse");
                long endTime = System.nanoTime();
                logger.printf("%9.6f\n", (double)(endTime - startTime) / 1.0E9);
                doublyLinkedListGenerator.checkModel((DoublyLinkedList)rootObjects.iterator().next(), testSize);
                myQVT.getResourceSet().getResources().remove((Object)inResource);
                myQVT.getResourceSet().getResources().remove((Object)outResource);
                inResource = null;
                outResource = null;
                rootObjects = null;
                interpretedExecutor = null;
                ++n2;
            }
        }
        finally {
            myQVT.dispose();
            logger.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testQVTcCompiler_Forward2Reverse_100K() throws Exception {
        DoublyLinkedListGenerator doublyLinkedListGenerator = new DoublyLinkedListGenerator();
        PrintAndLog logger = new PrintAndLog("results/" + this.getName());
        logger.printf("%s\n", this.getName());
        QVTcCompilerTests.MyQVT myQVT = this.createQVT("Forward2Reverse", this.getModelsURI("forward2reverse/Forward2Reverse.qvtc"));
        myQVT.loadEcoreFile(this.getModelsURI("forward2reverse/DoublyLinkedList.ecore"), (EPackage)DoublylinkedlistPackage.eINSTANCE);
        myQVT.loadEcoreFile(this.getModelsURI("forward2reverse/List2List.ecore"), (EPackage)List2listPackage.eINSTANCE);
        try {
            ImperativeTransformation asTransformation = myQVT.compileTransformation("reverse");
            int testSize = 100000;
            BasicQVTiExecutor interpretedExecutor = myQVT.createInterpretedExecutor(asTransformation);
            myQVT.loadInput("forward", this.getModelsURI("families2persons/samples/EmptyList.xmi"));
            Resource inResource = interpretedExecutor.getModel("forward");
            assert (inResource != null);
            inResource.getContents().clear();
            inResource.getContents().addAll(doublyLinkedListGenerator.createDoublyLinkedListModel(testSize));
            myQVT.createModel("middle", this.getTestURI("Forward2Reverse_trace.xmi"));
            myQVT.createModel("reverse", this.getTestURI("List_Interpreted.xmi"));
            AbstractEXE2016CGTests.garbageCollect();
            logger.printf("%9d, ", testSize);
            long startTime = System.nanoTime();
            myQVT.executeTransformation();
            @NonNull Collection rootObjects = myQVT.getRootObjects("reverse");
            long endTime = System.nanoTime();
            logger.printf("%9.6f\n", (double)(endTime - startTime) / 1.0E9);
            doublyLinkedListGenerator.checkModel((DoublyLinkedList)rootObjects.iterator().next(), testSize);
        }
        finally {
            myQVT.dispose();
            logger.dispose();
        }
    }
}

