/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtb2qvts;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ExpressionSynthesizer;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.NameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.RuleAnalysis2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.TransformationAnalysis2TracePackage;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtschedule.CastEdge;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class RuleAnalysis
extends RegionHelper<RuleRegion> {
    protected final @NonNull AbstractTransformationAnalysis transformationAnalysis;
    protected final @NonNull Rule rule;
    protected final @NonNull ExpressionSynthesizer expressionSynthesizer;
    private @Nullable RuleAnalysis2TraceGroup relationAnalysis2traceGroup = null;
    private List<@NonNull Node> dependencyHeadNodes = null;

    protected RuleAnalysis(@NonNull AbstractTransformationAnalysis transformationAnalysis, @NonNull RuleRegion ruleRegion) {
        super(transformationAnalysis.getScheduleManager(), ruleRegion);
        this.rule = QVTscheduleUtil.getReferredRule((RuleRegion)ruleRegion);
        this.transformationAnalysis = transformationAnalysis;
        this.expressionSynthesizer = this.scheduleManager.createExpressionSynthesizer(this);
    }

    public abstract void analyzeMappingRegion();

    public void analyzeSourceModel() {
    }

    public @NonNull Node createDependencyHead(@NonNull ClassDatum classDatum) {
        if (this.dependencyHeadNodes == null) {
            this.dependencyHeadNodes = new ArrayList<Node>();
        }
        Node dependencyHeadNode = this.createDependencyNode("\u00abextra-" + (this.dependencyHeadNodes.size() + 1) + "\u00bb", classDatum);
        dependencyHeadNode.setHead();
        this.dependencyHeadNodes.add(dependencyHeadNode);
        return dependencyHeadNode;
    }

    public void gatherRuleRegions(@NonNull List<@NonNull RuleRegion> ruleRegions) {
        ruleRegions.add((RuleRegion)this.getRegion());
    }

    public @Nullable Node getDependencyHead(@NonNull ClassDatum classDatum) {
        if (this.dependencyHeadNodes != null) {
            for (Node dependencyHeadNode : this.dependencyHeadNodes) {
                if (QVTscheduleUtil.getClassDatum((Node)dependencyHeadNode) != classDatum) continue;
                return dependencyHeadNode;
            }
        }
        return null;
    }

    public @NonNull NameGenerator getNameGenerator() {
        return this.scheduleManager.getNameGenerator();
    }

    public abstract @NonNull Node getReferenceNode(@NonNull VariableDeclaration var1);

    public @NonNull Rule getRule() {
        return this.rule;
    }

    public @NonNull RuleAnalysis2TraceGroup getRuleAnalysis2TraceGroup() {
        RuleAnalysis2TraceGroup relationAnalysis2traceGroup2 = this.relationAnalysis2traceGroup;
        if (relationAnalysis2traceGroup2 == null) {
            this.relationAnalysis2traceGroup = relationAnalysis2traceGroup2 = this.getTransformationAnalysis2TracePackage().getRuleAnalysis2TraceGroup(this.rule);
        }
        return relationAnalysis2traceGroup2;
    }

    public @NonNull AbstractTransformationAnalysis getTransformationAnalysis() {
        return this.transformationAnalysis;
    }

    public @NonNull TransformationAnalysis2TracePackage getTransformationAnalysis2TracePackage() {
        return this.transformationAnalysis.getTransformationAnalysis2TracePackage();
    }

    public @NonNull Node getUnknownNode(@NonNull TypedElement typedElement) {
        assert (!(typedElement instanceof Property));
        Node node = ((RuleRegion)this.region).getNode(typedElement);
        if (node == null) {
            node = this.createUnknownNode((String)ClassUtil.nonNullState((Object)typedElement.getType().toString()), typedElement);
        }
        return node;
    }

    public abstract boolean isPropertyAssignment(@NonNull Node var1, @NonNull Property var2);

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void rewriteCastEdges() {
        for (Edge edge : Lists.newArrayList((Iterable)QVTscheduleUtil.getOwnedEdges((Region)this.region))) {
            if (!(edge instanceof CastEdge)) continue;
            boolean allMatched = false;
            Node sourceNode = QVTscheduleUtil.getSourceNode((Edge)edge);
            if (sourceNode.isMatched()) {
                allMatched = true;
                for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)sourceNode)) {
                    Node targetNode = QVTscheduleUtil.getTargetNode((Edge)outgoingEdge);
                    if (targetNode.isMatched()) continue;
                    allMatched = false;
                    break;
                }
            }
            ClassDatum sourceClassDatum = QVTscheduleUtil.getClassDatum((Node)sourceNode);
            HashSet<@NonNull CompleteClass> allCompleteClasses = new HashSet<CompleteClass>(QVTscheduleUtil.getCompleteClasses((ClassDatum)sourceClassDatum));
            for (Edge outgoingEdge : QVTscheduleUtil.getOutgoingEdges((Node)sourceNode)) {
                if (outgoingEdge instanceof CastEdge) {
                    Node targetNode = QVTscheduleUtil.getTargetNode((Edge)outgoingEdge);
                    ClassDatum targetClassDatum = QVTscheduleUtil.getClassDatum((Node)targetNode);
                    @NonNull List targetCompleteClasses = QVTscheduleUtil.getCompleteClasses((ClassDatum)targetClassDatum);
                    allCompleteClasses.addAll(targetCompleteClasses);
                    continue;
                }
                if (allMatched) continue;
                allCompleteClasses = null;
                break;
            }
            if (allCompleteClasses != null) {
                this.rewriteCastEdgeAsMergedMultiCompleteClass(sourceNode, allCompleteClasses);
            } else {
                assert (!edge.isMatched());
                this.expressionSynthesizer.rewriteCastEdgeAsOclAsType((CastEdge)edge);
            }
            assert (edge.eContainer() == null);
            assert (edge.getSourceNode() == null);
            assert (edge.getTargetNode() == null);
        }
    }

    protected void rewriteCastEdgeAsMergedMultiCompleteClass(@NonNull Node sourceNode, @NonNull Set<@NonNull CompleteClass> allCompleteClasses) {
        ArrayList<@NonNull CompleteClass> sortedCompleteClasses = new ArrayList<CompleteClass>(allCompleteClasses);
        Collections.sort(sortedCompleteClasses, DeepestFirstCompleteClassInheritanceComparator.INSTANCE);
        ArrayList<@NonNull CompleteClass> newCompleteClasses = new ArrayList<CompleteClass>();
        for (CompleteClass sortedCompleteClass : sortedCompleteClasses) {
            boolean isRequired = true;
            for (CompleteClass newCompleteClass : newCompleteClasses) {
                if (!newCompleteClass.conformsTo(sortedCompleteClass)) continue;
                isRequired = false;
                break;
            }
            if (!isRequired) continue;
            newCompleteClasses.add(sortedCompleteClass);
        }
        ClassDatum sourceClassDatum = QVTscheduleUtil.getClassDatum((Node)sourceNode);
        TypedModel typedModel = QVTscheduleUtil.getReferredTypedModel((ClassDatum)sourceClassDatum);
        ClassDatum mergedClassDatum = this.scheduleManager.getClassDatum(typedModel, newCompleteClasses);
        sourceNode.setClassDatum(mergedClassDatum);
        for (Edge sourceOutgoingEdge : Lists.newArrayList((Iterable)QVTscheduleUtil.getOutgoingEdges((Node)sourceNode))) {
            CompilerUtil.migrateCastEdgeTargetContents((CastEdge)sourceOutgoingEdge, sourceNode);
        }
    }

    public @NonNull String toString() {
        return this.getName();
    }

    protected static final class DeepestFirstCompleteClassInheritanceComparator
    implements Comparator<CompleteClass> {
        public static final @NonNull DeepestFirstCompleteClassInheritanceComparator INSTANCE = new DeepestFirstCompleteClassInheritanceComparator();

        protected DeepestFirstCompleteClassInheritanceComparator() {
        }

        @Override
        public int compare(@NonNull CompleteClass o1, @NonNull CompleteClass o2) {
            int d2;
            int d1 = o1.getCompleteInheritance().getDepth();
            if (d1 != (d2 = o2.getCompleteInheritance().getDepth())) {
                return d2 - d1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    }
}

