/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.AbstractGroup;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.Boundary;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SimpleGroup;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.Split;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SplitterAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SplitterUtil;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class CompoundGroup
extends AbstractGroup {
    protected final @NonNull List<@NonNull SimpleGroup> internalSimpleGroups;
    protected final @NonNull List<@NonNull Node> headNodes;
    private final @NonNull Map<@NonNull SimpleGroup, @NonNull Map<@NonNull SimpleGroup, @NonNull List<@NonNull Boundary>>> sourceGroup2targetGroup2boundaries = new HashMap<SimpleGroup, Map<SimpleGroup, List<Boundary>>>();
    private final @NonNull List<@NonNull Boundary> orderedBoundaries = new ArrayList<Boundary>();

    public CompoundGroup(@NonNull SplitterAnalysis splitter, @NonNull Iterable<@NonNull SimpleGroup> simpleGroups) {
        super(splitter, SplitterUtil.computeHeadNodes(simpleGroups));
        this.internalSimpleGroups = Lists.newArrayList(simpleGroups);
        this.headNodes = SplitterUtil.computeHeadNodes(simpleGroups);
        assert (this.internalSimpleGroups.size() > 1);
        Collections.sort(this.internalSimpleGroups, NameUtil.NAMEABLE_COMPARATOR);
    }

    private void addBoundary(@NonNull SimpleGroup sourceGroup, @NonNull Edge edge, @NonNull SimpleGroup targetGroup) {
        List<Boundary> boundaries;
        Boundary boundary = new Boundary(sourceGroup, edge, targetGroup);
        Map<@NonNull SimpleGroup, @NonNull List<@NonNull Boundary>> targetGroup2boundaries = this.sourceGroup2targetGroup2boundaries.get(sourceGroup);
        if (targetGroup2boundaries == null) {
            targetGroup2boundaries = new HashMap<SimpleGroup, List<Boundary>>();
            this.sourceGroup2targetGroup2boundaries.put(sourceGroup, targetGroup2boundaries);
        }
        if ((boundaries = targetGroup2boundaries.get(targetGroup)) == null) {
            boundaries = new ArrayList<Boundary>();
            targetGroup2boundaries.put(targetGroup, boundaries);
        }
        boolean wasAdded = boundaries.add(boundary);
        assert (wasAdded);
    }

    @Override
    public void buildSplit(@NonNull Split split, @Nullable SimpleGroup sourceSimpleGroup, @Nullable Edge edge) {
        SimpleGroup entryGroup = this.getEntryGroup();
        split.addStage(sourceSimpleGroup, edge, entryGroup);
        for (Boundary boundary : this.orderedBoundaries) {
            split.addStage(boundary.getSourceGroup(), boundary.getEdge(), boundary.getTargetGroup());
        }
        this.buildSplit(split, entryGroup);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Iterable<@NonNull SimpleGroup> computeExternalBoundaries(@NonNull Iterable<@NonNull SimpleGroup> externalSimpleGroups) {
        Set<@NonNull Node> externalReachableNodes = SplitterUtil.computeNavigableNodes(SplitterUtil.computeHeadNodes(externalSimpleGroups));
        Set<@NonNull Node> externalComputableNodes = SplitterUtil.computeComputableTargetNodes(externalReachableNodes);
        ArrayList<@NonNull SimpleGroup> externalInternalSimpleGroups = new ArrayList<SimpleGroup>();
        for (SimpleGroup internalSimpleGroup : this.internalSimpleGroups) {
            Iterable<@NonNull Node> internalReachableNodes = internalSimpleGroup.getReachableNodes();
            @NonNull HashSet overlapNodes = Sets.newHashSet(internalReachableNodes);
            overlapNodes.retainAll(externalComputableNodes);
            if (overlapNodes.isEmpty()) continue;
            externalInternalSimpleGroups.add(internalSimpleGroup);
        }
        return externalInternalSimpleGroups;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void computeInternalBoundaries() {
        int iMax = this.internalSimpleGroups.size();
        int iThis = 0;
        while (iThis < iMax) {
            SimpleGroup thisGroup = this.internalSimpleGroups.get(iThis);
            @NonNull HashSet theseReachableNodes = Sets.newHashSet(thisGroup.getReachableNodes());
            int iThat = iThis + 1;
            while (iThat < iMax) {
                SimpleGroup thatGroup = this.internalSimpleGroups.get(iThat);
                Iterable<@NonNull Node> thoseReachableNodes = thatGroup.getReachableNodes();
                @NonNull HashSet overlapNodes = Sets.newHashSet(thoseReachableNodes);
                overlapNodes.retainAll(theseReachableNodes);
                if (!overlapNodes.isEmpty()) {
                    @NonNull HashSet theseNonOverlapNodes = Sets.newHashSet((Iterable)theseReachableNodes);
                    @NonNull HashSet thoseNonOverlapNodes = Sets.newHashSet(thoseReachableNodes);
                    theseNonOverlapNodes.removeAll(overlapNodes);
                    thoseNonOverlapNodes.removeAll(overlapNodes);
                    this.createBoundaries(thisGroup, thoseNonOverlapNodes);
                    this.createBoundaries(thatGroup, theseNonOverlapNodes);
                }
                ++iThat;
            }
            ++iThis;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void computeMutualOrdering(@NonNull Iterable<@NonNull SimpleGroup> externalSimpleGroups) {
        this.computeInternalBoundaries();
        ArrayList<@NonNull SimpleGroup> scheduledSimpleGroups = new ArrayList<SimpleGroup>();
        if (!Iterables.isEmpty(externalSimpleGroups)) {
            for (SimpleGroup externalInternalSimpleGroup : this.computeExternalBoundaries(externalSimpleGroups)) {
                scheduledSimpleGroups.add(externalInternalSimpleGroup);
            }
        }
        Collections.sort(scheduledSimpleGroups, NameUtil.NAMEABLE_COMPARATOR);
        @NonNull ArrayList unscheduledSimpleGroups = Lists.newArrayList(this.internalSimpleGroups);
        unscheduledSimpleGroups.removeAll(scheduledSimpleGroups);
        while (unscheduledSimpleGroups.size() > 0) {
            Set<@NonNull Boundary> activeBoundaries = this.selectActiveBoundariesHeuristic(scheduledSimpleGroups, unscheduledSimpleGroups);
            Boundary bestBoundary = this.selectBestBoundaryHeuristic(activeBoundaries, scheduledSimpleGroups);
            SimpleGroup sourceGroup = bestBoundary.getSourceGroup();
            SimpleGroup targetGroup = bestBoundary.getTargetGroup();
            assert (scheduledSimpleGroups.isEmpty() || scheduledSimpleGroups.contains(sourceGroup));
            assert (scheduledSimpleGroups.isEmpty() || !unscheduledSimpleGroups.contains(sourceGroup));
            assert (!scheduledSimpleGroups.contains(targetGroup));
            assert (unscheduledSimpleGroups.contains(targetGroup));
            assert (!this.orderedBoundaries.contains(bestBoundary));
            this.orderedBoundaries.add(bestBoundary);
            if (unscheduledSimpleGroups.remove(sourceGroup)) {
                scheduledSimpleGroups.add(sourceGroup);
            }
            unscheduledSimpleGroups.remove(targetGroup);
            scheduledSimpleGroups.add(targetGroup);
        }
    }

    protected void createBoundaries(@NonNull SimpleGroup sourceGroup, @NonNull Iterable<@NonNull Node> nonOverlapNodes) {
        for (Node nonOverlapNode : nonOverlapNodes) {
            for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)nonOverlapNode)) {
                Node targetNode;
                Property property;
                Property opposite;
                if (!edge.isNavigation()) continue;
                NavigationEdge navigationEdge = (NavigationEdge)edge;
                assert (edge.getEdgeSource() == nonOverlapNode);
                if (edge.isRealized() || !edge.isMatched() || (opposite = (property = QVTscheduleUtil.getReferredProperty((NavigationEdge)navigationEdge)).getOpposite()) == null || !opposite.isIsMany() || Iterables.contains(nonOverlapNodes, (Object)(targetNode = edge.getEdgeTarget()))) continue;
                Iterable<@NonNull SimpleGroup> targetGroups = this.splitter.getReachableSimpleGroups(targetNode);
                assert (targetGroups != null);
                for (SimpleGroup targetGroup : targetGroups) {
                    if (targetGroup == sourceGroup || !this.internalSimpleGroups.contains(targetGroup)) continue;
                    this.addBoundary(sourceGroup, edge, targetGroup);
                }
            }
        }
    }

    public @NonNull SimpleGroup getEntryGroup() {
        assert (!this.orderedBoundaries.isEmpty());
        return this.orderedBoundaries.get(0).getSourceGroup();
    }

    @Override
    public @NonNull Iterable<@NonNull Node> getHeadNodes() {
        return this.headNodes;
    }

    @Override
    public @NonNull Iterable<@NonNull SimpleGroup> getInternalSimpleGroups() {
        return this.internalSimpleGroups;
    }

    private @NonNull Set<@NonNull Boundary> selectActiveBoundariesHeuristic(@NonNull Iterable<@NonNull SimpleGroup> scheduledSimpleGroups, @NonNull Iterable<@NonNull SimpleGroup> unscheduledSimpleGroups) {
        assert (!this.sourceGroup2targetGroup2boundaries.isEmpty());
        HashSet<@NonNull Boundary> activeBoundaries = new HashSet<Boundary>();
        for (SimpleGroup scheduledSimpleGroup : scheduledSimpleGroups) {
            Map<@NonNull SimpleGroup, @NonNull List<@NonNull Boundary>> targetGroup2boundaries = this.sourceGroup2targetGroup2boundaries.get(scheduledSimpleGroup);
            if (targetGroup2boundaries == null) continue;
            for (SimpleGroup simpleGroup : targetGroup2boundaries.keySet()) {
                if (!Iterables.contains(unscheduledSimpleGroups, (Object)simpleGroup)) continue;
                List<@NonNull Boundary> boundaries = targetGroup2boundaries.get(simpleGroup);
                assert (boundaries != null);
                activeBoundaries.addAll(boundaries);
            }
        }
        if (activeBoundaries.isEmpty()) {
            for (SimpleGroup sourceGroup : this.sourceGroup2targetGroup2boundaries.keySet()) {
                Node headNode = sourceGroup.getHeadNode();
                if (!headNode.isLoaded()) continue;
                Map<@NonNull SimpleGroup, @NonNull List<@NonNull Boundary>> map = this.sourceGroup2targetGroup2boundaries.get(sourceGroup);
                assert (map != null);
                for (List<Boundary> boundaries : map.values()) {
                    activeBoundaries.addAll(boundaries);
                }
            }
        }
        if (activeBoundaries.isEmpty()) {
            HashSet<@NonNull E> allBoundariesSet = new HashSet();
            for (Map<SimpleGroup, List<Boundary>> targetGroup2boundaries : this.sourceGroup2targetGroup2boundaries.values()) {
                for (List list : targetGroup2boundaries.values()) {
                    allBoundariesSet.addAll(list);
                }
            }
            ArrayList<@NonNull E> allBoundariesList = new ArrayList(allBoundariesSet);
            Collections.sort(allBoundariesList, NameUtil.NAMEABLE_COMPARATOR);
            activeBoundaries.add((Boundary)allBoundariesList.get(0));
        }
        return activeBoundaries;
    }

    private @NonNull Boundary selectBestBoundaryHeuristic(@NonNull Set<@NonNull Boundary> activeBoundaries, @NonNull Iterable<@NonNull SimpleGroup> scheduledSimpleGroups) {
        assert (!activeBoundaries.isEmpty());
        ArrayList<@NonNull Boundary> goodBoundaries = new ArrayList<Boundary>();
        for (Boundary boundary : activeBoundaries) {
            Edge edge = boundary.getEdge();
            if (!edge.isConstant() && !edge.isLoaded()) continue;
            goodBoundaries.add(boundary);
        }
        goodBoundaries.isEmpty();
        if (goodBoundaries.isEmpty()) {
            goodBoundaries.addAll(activeBoundaries);
        }
        Collections.sort(goodBoundaries, NameUtil.NAMEABLE_COMPARATOR);
        return (Boundary)goodBoundaries.get(0);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void toString(@NonNull StringBuilder s, int depth) {
        CompilerUtil.indent(s, depth);
        s.append("compound-group: ");
        s.append(this.name);
        if (this.orderedBoundaries.isEmpty()) {
            @NonNull ArrayList sortedSimpleGroups = Lists.newArrayList(this.internalSimpleGroups);
            Collections.sort(sortedSimpleGroups, NameUtil.NAMEABLE_COMPARATOR);
            for (SimpleGroup simpleGroup : sortedSimpleGroups) {
                s.append("\n");
                simpleGroup.toString(s, depth + 1);
            }
        } else {
            for (Boundary boundary : this.orderedBoundaries) {
                s.append("\n");
                CompilerUtil.indent(s, depth + 1);
                s.append("boundary: ");
                s.append(boundary.getName());
                s.append("\n");
                CompilerUtil.indent(s, depth + 2);
                s.append(boundary.getEdge().getEdgeTarget());
            }
        }
        super.toString(s, depth);
    }
}

