/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.launching;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.resource.BasicProjectManager;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.compiler.QVTcCompilerChain;
import org.eclipse.qvtd.debug.QVTiDebugPlugin;
import org.eclipse.qvtd.debug.core.QVTiDebugCore;
import org.eclipse.qvtd.debug.evaluator.BasicQVTcExecutor;
import org.eclipse.qvtd.debug.launching.QVTcLaunchConstants;
import org.eclipse.qvtd.debug.launching.QVTiLaunchConfigurationDelegate;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperative;

public class QVTcLaunchConfigurationDelegate
extends QVTiLaunchConfigurationDelegate
implements QVTcLaunchConstants {
    public static final @NonNull String @NonNull [] compileStepKeys = new String[]{"QVTc", "QVTu", "QVTm", "QVTs", "QVTi"};
    public static final @NonNull String @NonNull [] generateStepKeys = new String[]{"Java", "Class"};

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        String projectName = configuration.getAttribute("project", "");
        if (projectName == null) {
            QVTiDebugPlugin.throwCoreExceptionError("No default project", null);
            return false;
        }
        String txName = configuration.getAttribute("tx", null);
        if (txName == null) {
            QVTiDebugPlugin.throwCoreExceptionError("No transformation to compile", null);
            return false;
        }
        URI txURI = URI.createURI((String)txName);
        String outputName = configuration.getAttribute("direction", null);
        if (outputName == null) {
            QVTiDebugPlugin.throwCoreExceptionError("No output direction for '" + txURI + "'", null);
            return false;
        }
        boolean interpreted = configuration.getAttribute("interpreted", true);
        boolean dotGraphs = configuration.getAttribute("dot-graphs", true);
        boolean yedGraphs = configuration.getAttribute("yed-graphs", true);
        QVTimperative qvt = QVTimperative.newInstance((ProjectManager)BasicProjectManager.CLASS_PATH, null);
        QVTiEnvironmentFactory environmentFactory = qvt.getEnvironmentFactory();
        DefaultCompilerOptions compilerOptions = this.createCompilerOptions();
        Map intermediatesMap = configuration.getAttribute("intermediates", EMPTY_MAP);
        assert (intermediatesMap != null);
        compilerOptions.setURIsFromStrings(compileStepKeys, intermediatesMap);
        compilerOptions.setDebugGraphs(dotGraphs, yedGraphs);
        if (!interpreted) {
            try {
                URI genModelURI = URI.createURI((String)configuration.getAttribute("genmodel", ""), (boolean)true);
                URI javaURI = URI.createURI((String)((String)intermediatesMap.get("Java")), (boolean)true);
                URI classURI = URI.createURI((String)((String)intermediatesMap.get("Class")), (boolean)true);
                compilerOptions.setQVTcGenerateOptions(projectName, txURI, genModelURI, javaURI, classURI);
            }
            catch (Exception e) {
                QVTiDebugPlugin.throwCoreExceptionError("Failed to configure transformation '" + txURI + "'", e);
                return false;
            }
        }
        QVTcCompilerChain compilerChain = new QVTcCompilerChain(environmentFactory, txURI, txURI, (CompilerOptions)compilerOptions);
        try {
            if (interpreted) {
                compilerChain.compile(outputName);
            } else {
                compilerChain.build(outputName, new String[0]);
            }
        }
        catch (Exception e) {
            QVTiDebugPlugin.throwCoreExceptionError("Failed to compile transformation '" + txURI + "'", e);
            return false;
        }
        return super.buildForLaunch(configuration, mode, monitor);
    }

    @Override
    protected @NonNull QVTiExecutor createExecutor(@NonNull QVTiEnvironmentFactory envFactory, @NonNull ImperativeTransformation transformation) {
        return new BasicQVTcExecutor(envFactory, transformation);
    }

    @Override
    protected @NonNull QVTiDebugCore getDebugCore() {
        return QVTiDebugCore.INSTANCE;
    }

    @Override
    protected @NonNull URI getTransformationURI(ILaunchConfiguration configuration) throws CoreException {
        Map intermediatesMap = configuration.getAttribute("intermediates", EMPTY_MAP);
        String qvtiName = (String)intermediatesMap.get("QVTi");
        return URI.createURI((String)qvtiName, (boolean)true);
    }
}

