/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtcore.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibTables;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.ocl.pivot.validation.ComposedEValidator;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.compiler.internal.usage.DirectedDomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.usage.DomainUsageAnalysis;
import org.eclipse.qvtd.compiler.internal.usage.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;

public abstract class AbstractDomainUsageTests
extends LoadTestCase {
    private static ComposedEValidator makeSureRequiredBundleIsLoaded = null;

    protected @NonNull Map<Object, Object> getSaveOptions() {
        return DefaultCompilerOptions.defaultSavingOptions;
    }

    protected @NonNull Transformation loadTransformation(@NonNull MyQVT myQVT, @NonNull URI transformURI) throws Exception {
        OCLstdlibTables.LIBRARY.getClass();
        myQVT.getEnvironmentFactory().configureLoadFirstStrategy();
        String inputName = transformURI.lastSegment();
        String cstName = String.valueOf(inputName) + ".xmi";
        String pivotName = String.valueOf(inputName) + "as";
        URI cstURI = this.getTestURI(cstName);
        URI pivotURI = this.getTestURI(pivotName);
        BaseCSResource xtextResource = (BaseCSResource)myQVT.getResourceSet().getResource(transformURI, true);
        assert (xtextResource != null);
        AbstractDomainUsageTests.assertNoResourceErrors((String)"Load failed", (Resource)xtextResource);
        ASResource asResource = xtextResource.getASResource();
        AbstractDomainUsageTests.assertNoValidationErrors((String)"Validation errors", (EObject)((EObject)xtextResource.getContents().get(0)));
        this.saveAsXMI((Resource)xtextResource, cstURI);
        asResource.setURI(pivotURI);
        asResource.save(this.getSaveOptions());
        for (EObject eObject : new TreeIterable((Resource)asResource)) {
            if (!(eObject instanceof Transformation)) continue;
            return (Transformation)eObject;
        }
        AbstractDomainUsageTests.fail((String)("Failed to load " + transformURI));
        throw new IllegalStateException();
    }

    protected static class MyQVT
    extends OCLInternal {
        public MyQVT(@NonNull EnvironmentFactoryInternal environmentFactory) {
            super(environmentFactory);
        }

        public void checkAnalysis(@NonNull Transformation asTransformation, @NonNull RootDomainUsageAnalysis domainAnalysis, boolean showAnalysis) {
            Map analysis = domainAnalysis.analyzeTransformation();
            DirectedDomainUsageAnalysis directedDomainUsageAnalysis = domainAnalysis.createDirectedDomainUsageAnalysis();
            directedDomainUsageAnalysis.analyzeTransformation(null);
            HashMap<@NonNull DomainUsage, @NonNull List<@NonNull Element>> usage2elements = new HashMap<DomainUsage, List<Element>>();
            ArrayList<@NonNull Operation> operations = new ArrayList<Operation>();
            TreeIterator tit = asTransformation.eAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                assert (eObject != null);
                if (eObject instanceof Comment) continue;
                DomainUsage usage = (DomainUsage)analysis.get(eObject);
                assert (usage != null) : "No usage for " + eObject.eClass().getName() + " " + eObject;
                assert (usage.isConstant()) : "Variable usage for " + eObject;
                ArrayList<@NonNull Element> list = (ArrayList<Element>)usage2elements.get(usage);
                if (list == null) {
                    list = new ArrayList<Element>();
                    usage2elements.put(usage, list);
                }
                list.add((Element)eObject);
                if (!(eObject instanceof Operation)) continue;
                operations.add((Operation)eObject);
                tit.prune();
            }
            for (Operation operation : operations) {
                DomainUsageAnalysis operationAnalysis = domainAnalysis.getAnalysis(operation);
                TreeIterator tit2 = operation.eAllContents();
                while (tit2.hasNext()) {
                    EObject eObject = (EObject)tit2.next();
                    if (eObject instanceof Comment || !(eObject instanceof Element)) continue;
                    DomainUsage usage = operationAnalysis.getUsage((Element)eObject);
                    assert (usage != null) : "No nested usage for " + eObject.eClass().getName() + " " + eObject;
                    ArrayList<@NonNull Element> list = (ArrayList<Element>)usage2elements.get(usage);
                    if (list == null) {
                        list = new ArrayList<Element>();
                        usage2elements.put(usage, list);
                    }
                    list.add((Element)eObject);
                }
            }
            if (showAnalysis) {
                this.printAnalysis(usage2elements);
            }
        }

        public void printAnalysis(@NonNull Map<@NonNull DomainUsage, @NonNull List<@NonNull Element>> usage2elements) {
            ArrayList<@NonNull DomainUsage> sortedUsages = new ArrayList<DomainUsage>(usage2elements.keySet());
            Collections.sort(sortedUsages);
            for (DomainUsage usage : sortedUsages) {
                System.out.println(usage);
                ArrayList<@NonNull String> lines = new ArrayList<String>();
                List<@NonNull Element> elements = usage2elements.get(usage);
                if (elements != null) {
                    for (Element element : elements) {
                        lines.add(String.valueOf(element.eClass().getName()) + " " + element);
                    }
                }
                Collections.sort(lines);
                for (String line : lines) {
                    System.out.println("\t" + line);
                }
            }
        }
    }
}

