/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.EntryPoint;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.SetStatement;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.EntryPointAnalysis;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;

public class EntryPointsAnalysis {
    protected final @NonNull EnvironmentFactoryInternal environmentFactory;
    protected final @NonNull ImperativeTransformation transformation;
    private final @NonNull Set<@NonNull CompleteClass> allInstancesCompleteClasses = new HashSet<CompleteClass>();
    private final @NonNull Map<@NonNull Property, @NonNull Integer> property2cacheIndex = new HashMap<Property, Integer>();
    private final @NonNull Map<@NonNull SetStatement, @NonNull Integer> setStatement2cacheIndex = new HashMap<SetStatement, Integer>();
    private final @NonNull Map<@NonNull EntryPoint, @NonNull EntryPointAnalysis> entryPoint2entryPointAnalysis = new HashMap<EntryPoint, EntryPointAnalysis>();
    private final @NonNull Map<@NonNull Mapping, @NonNull EntryPointAnalysis> mapping2entryPointAnalysis = new HashMap<Mapping, EntryPointAnalysis>();

    public EntryPointsAnalysis(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull ImperativeTransformation transformation) {
        this.environmentFactory = environmentFactory;
        this.transformation = transformation;
    }

    protected @NonNull Integer allocateCacheIndex(@Nullable OCLExpression sourceExpression, @NonNull Property navigableProperty) {
        Integer cacheIndex = this.property2cacheIndex.get(navigableProperty);
        if (cacheIndex == null) {
            Integer size = this.property2cacheIndex.size();
            this.property2cacheIndex.put(navigableProperty, size);
            cacheIndex = size;
        }
        return cacheIndex;
    }

    protected void analyzeStatements(@NonNull Iterable<@NonNull SetStatement> setStatements) {
        for (SetStatement propertyAssignment : setStatements) {
            Integer cacheIndex;
            Property navigableProperty = propertyAssignment.getTargetProperty();
            if (navigableProperty == null || (cacheIndex = this.property2cacheIndex.get(navigableProperty)) == null) continue;
            this.setStatement2cacheIndex.put(propertyAssignment, cacheIndex);
        }
    }

    public void analyzeTransformation() {
        for (EntryPoint iEntryPoint : QVTimperativeUtil.computeEntryPoints(this.transformation)) {
            EntryPointAnalysis entryPointAnalysis = new EntryPointAnalysis(this, iEntryPoint);
            this.entryPoint2entryPointAnalysis.put(iEntryPoint, entryPointAnalysis);
            for (Mapping mapping : QVTimperativeUtil.computeMappingClosure(iEntryPoint)) {
                entryPointAnalysis.addMapping(mapping);
                this.mapping2entryPointAnalysis.put(mapping, entryPointAnalysis);
            }
        }
        assert (!this.entryPoint2entryPointAnalysis.isEmpty());
        for (EntryPointAnalysis entryPointAnalysis : this.entryPoint2entryPointAnalysis.values()) {
            entryPointAnalysis.analyze();
        }
    }

    public void addAllInstancesClass(@NonNull TypedElement asExpression) {
        Type asType;
        Type type = asType = asExpression instanceof OCLExpression ? ((OCLExpression)asExpression).getTypeValue() : null;
        if (asType == null) {
            asType = asExpression.getType();
        }
        if (asType instanceof Class) {
            assert (!(asType instanceof PrimitiveType));
            assert (!(asType instanceof CollectionType));
            CompleteClassInternal completeClass = this.environmentFactory.getCompleteModel().getCompleteClass(asType);
            this.allInstancesCompleteClasses.add((CompleteClass)completeClass);
        }
    }

    public @NonNull Set<@NonNull CompleteClass> getAllInstancesCompleteClasses() {
        return this.allInstancesCompleteClasses;
    }

    public @Nullable Integer getCacheIndex(@NonNull SetStatement setStatement) {
        return this.setStatement2cacheIndex.get(setStatement);
    }

    public int getCacheIndexes() {
        return this.property2cacheIndex.size();
    }

    public @NonNull Map<@NonNull Property, @NonNull Integer> getCaches() {
        return this.property2cacheIndex;
    }

    public @NonNull EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    public @NonNull Iterable<@NonNull EntryPointAnalysis> getEntryPointAnalyses() {
        return this.entryPoint2entryPointAnalysis.values();
    }

    public @NonNull EntryPointAnalysis getEntryPointAnalysis(@NonNull EntryPoint entryPoint) {
        return (EntryPointAnalysis)ClassUtil.nonNullState((Object)this.entryPoint2entryPointAnalysis.get(entryPoint));
    }

    public @NonNull Map<@NonNull CompleteClass, @Nullable List<@NonNull CompleteClass>> getInstancesCompleteClassAnalysis(@NonNull Iterable<@NonNull CompleteClass> instanceCompleteClasses) {
        HashMap<@NonNull CompleteClass, @Nullable List<@NonNull CompleteClass>> instancesClassAnalysis = new HashMap<CompleteClass, List<CompleteClass>>();
        for (CompleteClass instanceCompleteClass : instanceCompleteClasses) {
            instancesClassAnalysis.put(instanceCompleteClass, null);
        }
        for (CompleteClass instanceCompleteClass : instancesClassAnalysis.keySet()) {
            ArrayList<@NonNull CompleteClass> superInstanceCompleteClasses = new ArrayList<CompleteClass>();
            superInstanceCompleteClasses.add(instanceCompleteClass);
            for (CompleteClass superCompleteClass : instanceCompleteClass.getProperSuperCompleteClasses()) {
                if (instancesClassAnalysis.containsKey(superCompleteClass)) {
                    superInstanceCompleteClasses.add(superCompleteClass);
                }
                instancesClassAnalysis.put(instanceCompleteClass, superInstanceCompleteClasses);
            }
        }
        return instancesClassAnalysis;
    }

    public @NonNull MetamodelManagerInternal getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    public @NonNull PropertyId @NonNull [] getPropertyIndex2propertyId() {
        @NonNull PropertyId @NonNull [] propertyIndex2propertyId = new PropertyId[this.property2cacheIndex.size()];
        for (Property property : this.property2cacheIndex.keySet()) {
            Integer index = this.property2cacheIndex.get(property);
            assert (index != null);
            propertyIndex2propertyId[index.intValue()] = property.getPropertyId();
        }
        return propertyIndex2propertyId;
    }

    public @NonNull ImperativeTransformation getTransformation() {
        return this.transformation;
    }

    public String toString() {
        return this.entryPoint2entryPointAnalysis.keySet().toString();
    }
}

