/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.manager.PivotIdResolver;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiAbstractEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiModelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTiEvaluationVisitorImpl
extends QVTiAbstractEvaluationVisitor {
    public QVTiEvaluationVisitorImpl(@NonNull Environment env, @NonNull EvaluationEnvironment evalEnv, @NonNull QVTiModelManager modelManager) {
        super(env, evalEnv, modelManager);
    }

    @Override
    @NonNull
    public QVTiEvaluationVisitor createNestedEvaluator() {
        EnvironmentFactory factory = this.environment.getFactory();
        EvaluationEnvironment nestedEvalEnv = factory.createEvaluationEnvironment(this.evaluationEnvironment);
        QVTiEvaluationVisitorImpl ne = new QVTiEvaluationVisitorImpl(this.environment, nestedEvalEnv, this.getModelManager());
        return ne;
    }

    private void doMappingCallRecursion(@NonNull Rule rule, @NonNull List<Variable> rootVariables, @NonNull List<List<Object>> rootBindings, int depth) {
        int nextDepth = depth + 1;
        int maxDepth = rootVariables.size();
        Variable var = rootVariables.get(depth);
        Type guardType = var.getType();
        PivotIdResolver idResolver = this.metaModelManager.getIdResolver();
        for (Object binding : rootBindings.get(depth)) {
            DomainType valueType = idResolver.getDynamicTypeOf(binding);
            if (guardType == null || !valueType.conformsTo((DomainStandardLibrary)this.metaModelManager, (DomainType)guardType)) continue;
            this.evaluationEnvironment.replace((DomainTypedElement)var, binding);
            if (nextDepth < maxDepth) {
                this.doMappingCallRecursion(rule, rootVariables, rootBindings, nextDepth);
                continue;
            }
            rule.accept((Visitor)this.getUndecoratedVisitor());
        }
    }

    @Override
    @Nullable
    public Object visitImperativeModel(@NonNull ImperativeModel imperativeModel) {
        for (Package pkge : imperativeModel.getNestedPackage()) {
            pkge.accept((Visitor)this.getUndecoratedVisitor());
        }
        return true;
    }

    @Override
    @Nullable
    public Object visitMapping(@NonNull Mapping object) {
        return this.visiting((Visitable)object);
    }

    @Nullable
    public Object visitPackage(@NonNull Package pkge) {
        return true;
    }

    @Override
    @Nullable
    public Object visitTransformation(@NonNull Transformation transformation) {
        Iterator iterator = transformation.getRule().iterator();
        if (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            HashMap<Variable, List<Object>> mappingBindings = new HashMap<Variable, List<Object>>();
            ArrayList<Variable> rootVariables = new ArrayList<Variable>();
            ArrayList<List<Object>> rootBindings = new ArrayList<List<Object>>();
            for (Domain domain : rule.getDomain()) {
                CoreDomain coreDomain = (CoreDomain)domain;
                TypedModel m = coreDomain.getTypedModel();
                for (Variable var : coreDomain.getGuardPattern().getVariable()) {
                    this.evaluationEnvironment.add((DomainTypedElement)var, null);
                    rootVariables.add(var);
                    Type varType = var.getType();
                    if (varType == null) continue;
                    List<Object> bindingValuesSet = ((QVTiModelManager)this.modelManager).getElementsByType(m, varType);
                    rootBindings.add(bindingValuesSet);
                    mappingBindings.put(var, bindingValuesSet);
                }
            }
            this.doMappingCallRecursion(rule, rootVariables, rootBindings, 0);
        }
        return true;
    }
}

