/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtcorebase.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Detail;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.AbstractDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsageAnalysis;

public class RootDomainUsageAnalysis
extends AbstractDomainUsageAnalysis {
    @NonNull
    private static final Integer NONE_USAGE_BIT_MASK = 0;
    @NonNull
    private static final Integer PRIMITIVE_USAGE_BIT_MASK = 1;
    @NonNull
    protected final Map<String, Integer> name2bit = new HashMap<String, Integer>();
    @NonNull
    protected final List<TypedModel> bit2typedModel = new ArrayList<TypedModel>();
    @NonNull
    private final Map<Integer, DomainUsageConstant> constantUsages = new HashMap<Integer, DomainUsageConstant>();
    @NonNull
    private final Map<Integer, DomainUsageConstant> validUsages = new HashMap<Integer, DomainUsageConstant>();
    private DomainUsageConstant middleUsage = null;
    private DomainUsageConstant checkableUsage = null;
    private DomainUsageConstant enforceableUsage = null;
    @NonNull
    protected final Map<Class, DomainUsageConstant> class2usage = new HashMap<Class, DomainUsageConstant>();
    @NonNull
    protected final Map<Property, DomainUsage> property2containingClassUsage = new HashMap<Property, DomainUsage>();
    @NonNull
    protected final Map<Property, DomainUsage> property2referredTypeUsage = new HashMap<Property, DomainUsage>();
    @NonNull
    protected final Map<Operation, DomainUsageAnalysis.Internal> operation2analysis = new HashMap<Operation, DomainUsageAnalysis.Internal>();

    protected RootDomainUsageAnalysis(@NonNull EnvironmentFactoryInternal environmentFactory) {
        super(environmentFactory);
        TypedModel primitiveTypeModel = QVTbaseFactory.eINSTANCE.createTypedModel();
        primitiveTypeModel.setName("$primitive$");
        this.add(primitiveTypeModel);
        this.validUsages.put(NONE_USAGE_BIT_MASK, this.getConstantUsage(NONE_USAGE_BIT_MASK));
        this.validUsages.put(PRIMITIVE_USAGE_BIT_MASK, this.getConstantUsage(PRIMITIVE_USAGE_BIT_MASK));
    }

    protected int add(@NonNull TypedModel typedModel) {
        int nextBit = this.bit2typedModel.size();
        this.bit2typedModel.add(typedModel);
        this.name2bit.put(typedModel.getName(), nextBit);
        return nextBit;
    }

    @NonNull
    public DomainUsageAnalysis analyzeOperation(@NonNull Operation object) {
        DomainUsageAnalysis.Internal analysis = this.operation2analysis.get(object);
        if (analysis == null) {
            analysis = this.createNestedAnalysis();
            this.operation2analysis.put(object, analysis);
            DomainUsage usage = analysis.visit((Element)object);
            this.setUsage((Element)object, usage);
        }
        return analysis;
    }

    @NonNull
    public Map<Element, DomainUsage> analyzeTransformation(@NonNull Transformation transformation) {
        int checkableMask = 0;
        int enforceableMask = 0;
        CompleteModelInternal completeModel = ((EnvironmentFactoryInternal)this.context).getCompleteModel();
        for (TypedModel typedModel : transformation.getModelParameter()) {
            int nextBit = this.add(typedModel);
            int bitMask = 1 << nextBit;
            DomainUsageConstant typedModelUsage = this.getConstantUsage(bitMask);
            this.validUsages.put(bitMask, typedModelUsage);
            boolean isCheckable = false;
            boolean isEnforceable = false;
            for (Rule rule : transformation.getRule()) {
                for (Domain domain : rule.getDomain()) {
                    if (domain.getTypedModel() != typedModel) continue;
                    if (domain.isIsCheckable()) {
                        isCheckable = true;
                    }
                    if (!domain.isIsEnforceable()) continue;
                    isEnforceable = true;
                }
            }
            if (isCheckable) {
                checkableMask |= bitMask;
            }
            if (isEnforceable) {
                enforceableMask |= bitMask;
            }
            this.setUsage((Element)typedModel, typedModelUsage);
            Variable ownedContext = typedModel.getOwnedContext();
            if (ownedContext != null) {
                this.setUsage((Element)ownedContext, typedModelUsage);
            }
            HashSet<CompleteClass> completeClasses = new HashSet<CompleteClass>();
            for (Package asPackage : QVTbaseUtil.getAllUsedPackages((TypedModel)typedModel)) {
                for (Class asClass : asPackage.getOwnedClasses()) {
                    if (asClass == null) continue;
                    for (CompleteClass completeClass : completeModel.getCompleteClass((Type)asClass).getSuperCompleteClasses()) {
                        completeClasses.add(completeClass);
                    }
                }
            }
            for (CompleteClass completeClass : completeClasses) {
                for (Class asClass : completeClass.getPartialClasses()) {
                    DomainUsageConstant oldUsage = this.class2usage.get(asClass);
                    DomainUsageConstant newUsage = oldUsage != null ? typedModelUsage.union(oldUsage) : typedModelUsage;
                    this.class2usage.put(asClass, newUsage);
                }
            }
        }
        for (Class asClass : this.class2usage.keySet()) {
            DomainUsage newUsage = this.class2usage.get(asClass);
            for (Property property : asClass.getOwnedProperties()) {
                this.property2containingClassUsage.put(property, newUsage);
                DomainUsage referredTypeUsage = null;
                for (Element annotation : property.getOwnedAnnotations()) {
                    Annotation annotation2;
                    if (!(annotation instanceof Annotation) || !"http://www.eclipse.org/qvt#Domains".equals((annotation2 = (Annotation)annotation).getName())) continue;
                    for (Detail detail : annotation2.getOwnedDetails()) {
                        if (!"referredDomain".equals(detail.getName())) continue;
                        int mask = 0;
                        for (String value : detail.getValues()) {
                            Integer bit = this.name2bit.get(value.trim());
                            if (bit == null) continue;
                            mask |= 1 << bit;
                        }
                        referredTypeUsage = this.getValidUsage(mask);
                    }
                }
                if (referredTypeUsage == null) {
                    referredTypeUsage = this.visit((Element)property.getType());
                }
                this.property2referredTypeUsage.put(property, referredTypeUsage);
            }
        }
        this.class2usage.put(((EnvironmentFactoryInternal)this.context).getStandardLibrary().getOclTypeType(), this.getAnyUsage());
        this.checkableUsage = this.getConstantUsage(this.getAnyMask() & checkableMask);
        this.enforceableUsage = this.getConstantUsage(this.getAnyMask() & enforceableMask);
        this.middleUsage = this.getConstantUsage(this.getAnyMask() & ~checkableMask & ~enforceableMask);
        Variable ownedContext = transformation.getOwnedContext();
        if (ownedContext != null) {
            this.setUsage((Element)ownedContext, this.getAnyUsage());
        }
        this.visit((Element)transformation);
        return this.element2usage;
    }

    @NonNull
    protected Nested createNestedAnalysis() {
        return new Nested();
    }

    @NonNull
    public DomainUsage createVariableUsage(int intersectionMask) {
        return new DomainUsageVariable(intersectionMask);
    }

    @NonNull
    public DomainUsageAnalysis getAnalysis(@NonNull Operation operation) {
        DomainUsageAnalysis analysis = this.operation2analysis.get(operation);
        if (analysis == null) {
            analysis = this.analyzeOperation(operation);
        }
        return analysis;
    }

    protected int getAnyMask() {
        return (1 << this.bit2typedModel.size()) - 1;
    }

    @NonNull
    public DomainUsageConstant getAnyUsage() {
        return this.getConstantUsage(this.getAnyMask());
    }

    @NonNull
    public DomainUsage getCheckableUsage() {
        return (DomainUsage)ClassUtil.nonNullState((Object)this.checkableUsage);
    }

    @NonNull
    public DomainUsageConstant getConstantUsage(int bitMask) {
        DomainUsageConstant usage = this.constantUsages.get(bitMask);
        if (usage == null) {
            usage = new DomainUsageConstant(bitMask);
            this.constantUsages.put(bitMask, usage);
        }
        return usage;
    }

    @NonNull
    public DomainUsage getEnforceableUsage() {
        return (DomainUsage)ClassUtil.nonNullState((Object)this.enforceableUsage);
    }

    @NonNull
    public DomainUsage getMiddleUsage() {
        return (DomainUsage)ClassUtil.nonNullState((Object)this.middleUsage);
    }

    @NonNull
    public DomainUsage getNoneUsage() {
        return this.constantUsages.get(NONE_USAGE_BIT_MASK);
    }

    @NonNull
    public DomainUsage getPrimitiveUsage() {
        return this.constantUsages.get(PRIMITIVE_USAGE_BIT_MASK);
    }

    @Override
    @NonNull
    protected RootDomainUsageAnalysis getRootAnalysis() {
        return this;
    }

    @NonNull
    public TypedModel getTypedModel(int i) {
        return this.bit2typedModel.get(i);
    }

    @Nullable
    public DomainUsageConstant getValidUsage(int bitMask) {
        return this.validUsages.get(bitMask);
    }

    protected abstract class AbstractDomainUsage
    implements DomainUsage.Internal {
        protected final int bitMask;

        protected AbstractDomainUsage(int bitMask) {
            this.bitMask = bitMask;
        }

        @Override
        public int compareTo(DomainUsage.Internal o) {
            return this.getMask() - o.getMask();
        }

        @Override
        public int getMask() {
            return this.bitMask;
        }

        @Override
        @Nullable
        public TypedModel getTypedModel() throws IllegalStateException {
            int residue = this.bitMask;
            int i = 0;
            while (residue != 0) {
                int bit = 1 << i;
                if ((residue & bit) != 0) {
                    if ((residue &= ~bit) == 0) {
                        return RootDomainUsageAnalysis.this.getTypedModel(i);
                    }
                    throw new IllegalStateException("Amiguous TypedModel: " + this);
                }
                ++i;
            }
            return null;
        }

        @Override
        @NonNull
        public Iterable<TypedModel> getTypedModels() {
            ArrayList<TypedModel> typedModels = new ArrayList<TypedModel>();
            int residue = this.bitMask;
            int i = 0;
            while (residue != 0) {
                int bit = 1 << i;
                if ((residue & bit) != 0) {
                    residue &= ~bit;
                    typedModels.add(RootDomainUsageAnalysis.this.getTypedModel(i));
                }
                ++i;
            }
            return typedModels;
        }

        @Override
        public boolean isCheckable() {
            return (this.bitMask & ((RootDomainUsageAnalysis)RootDomainUsageAnalysis.this).checkableUsage.bitMask) != 0;
        }

        @Override
        public boolean isEnforceable() {
            return (this.bitMask & ((RootDomainUsageAnalysis)RootDomainUsageAnalysis.this).enforceableUsage.bitMask) != 0;
        }

        @Override
        public boolean isMiddle() {
            return (this.bitMask & ((RootDomainUsageAnalysis)RootDomainUsageAnalysis.this).middleUsage.bitMask) != 0;
        }

        protected String toString(@NonNull String prefix) {
            StringBuilder s = new StringBuilder();
            s.append(prefix);
            boolean first = true;
            int i = 0;
            while (i < RootDomainUsageAnalysis.this.bit2typedModel.size()) {
                int iMask = 1 << i;
                if ((this.bitMask & iMask) != 0) {
                    if (!first) {
                        s.append("|");
                    }
                    s.append(RootDomainUsageAnalysis.this.bit2typedModel.get(i).getName());
                    first = false;
                }
                ++i;
            }
            if (first) {
                s.append("$none$");
            }
            return s.toString();
        }
    }

    protected class DomainUsageConstant
    extends AbstractDomainUsage {
        protected DomainUsageConstant(int bitMask) {
            super(bitMask);
        }

        @Override
        public void addUsedBy(@NonNull Element element) {
        }

        @Override
        @NonNull
        public DomainUsage cloneVariable() {
            return this;
        }

        @Override
        @Nullable
        public Iterable<Element> getElements() {
            return null;
        }

        @Override
        public boolean isConstant() {
            return true;
        }

        public String toString() {
            return this.toString("Constant ");
        }

        @NonNull
        public DomainUsageConstant union(@NonNull DomainUsageConstant usage) {
            return RootDomainUsageAnalysis.this.getConstantUsage(this.bitMask | usage.bitMask);
        }
    }

    protected class DomainUsageVariable
    extends AbstractDomainUsage {
        @NonNull
        protected final List<Element> usedBy;

        protected DomainUsageVariable(int bitMask) {
            super(bitMask);
            this.usedBy = new ArrayList<Element>();
            assert (bitMask != 0);
        }

        @Override
        public void addUsedBy(@NonNull Element element) {
            this.usedBy.add(element);
        }

        @Override
        @NonNull
        public DomainUsage cloneVariable() {
            return new DomainUsageVariable(this.bitMask);
        }

        @Override
        @Nullable
        public Iterable<Element> getElements() {
            return this.usedBy;
        }

        @Override
        public boolean isConstant() {
            return false;
        }

        public String toString() {
            return this.toString("Variable ");
        }
    }

    protected class Nested
    extends AbstractDomainUsageAnalysis {
        protected Nested() {
            super(RootDomainUsageAnalysis.this.getEnvironmentFactory());
        }

        @Override
        @NonNull
        protected RootDomainUsageAnalysis getRootAnalysis() {
            return RootDomainUsageAnalysis.this;
        }
    }
}

