/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvtp;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.internal.common.AbstractQVTc2QVTc;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.CoreModel;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.QVTcoreFactory;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.Assignment;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.OppositePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.QVTcoreBaseFactory;
import org.eclipse.qvtd.pivot.qvtcorebase.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcorebase.utilities.QVTcoreBaseUtil;

public class QVTm2QVTp
extends AbstractQVTc2QVTc {
    public static final @NonNull TracingOption PARTITIONING = new TracingOption(CompilerConstants.PLUGIN_ID, "qvtm2qvtp/partitioning");
    protected final @NonNull RootDomainUsageAnalysis domainAnalysis;
    private final @NonNull Map<@NonNull Transformation, @NonNull Set<@NonNull TypedModel>> transformation2enforceableTypedModels = new HashMap<Transformation, Set<TypedModel>>();

    private static @NonNull Set<@NonNull Variable> computeDirectlyReferencedVariables(@NonNull List<@NonNull NavigationAssignment> navigationAssignments) {
        HashSet<@NonNull Variable> usedVariables = new HashSet<Variable>();
        for (NavigationAssignment navigationAssignment : navigationAssignments) {
            QVTm2QVTp.computeDirectlyReferencedVariables(navigationAssignment, usedVariables);
        }
        return usedVariables;
    }

    private static void computeDirectlyReferencedVariables(@NonNull NavigationAssignment navigationAssignment, @NonNull Set<@NonNull Variable> usedVariables) {
        TreeIterator tit = navigationAssignment.eAllContents();
        while (tit.hasNext()) {
            VariableDeclaration referredVariable;
            EObject eObject = (EObject)tit.next();
            if (!(eObject instanceof VariableExp) || !((referredVariable = ((VariableExp)eObject).getReferredVariable()) instanceof Variable) || referredVariable.eContainer() instanceof Transformation) continue;
            usedVariables.add((Variable)referredVariable);
        }
    }

    private static @NonNull Iterable<@NonNull Variable> computeIndirectlyDefinedVariables(@NonNull Iterable<@NonNull Variable> byVariables, @NonNull List<@NonNull NavigationAssignment> navigationAssignments) {
        ArrayList<@NonNull Variable> variablesList = new ArrayList<Variable>();
        Iterables.addAll(variablesList, byVariables);
        int i = 0;
        while (i < variablesList.size()) {
            Variable usedVariable = (Variable)variablesList.get(i);
            for (NavigationAssignment navigationAssignment : navigationAssignments) {
                Variable rightVariable = QVTm2QVTp.getVariable(navigationAssignment.getValue());
                Variable leftVariable = QVTm2QVTp.getVariable(navigationAssignment.getSlotExpression());
                if (leftVariable != usedVariable || rightVariable == null || variablesList.contains(rightVariable)) continue;
                variablesList.add(rightVariable);
            }
            ++i;
        }
        return variablesList;
    }

    private static @NonNull List<@NonNull Variable> computeIndirectlyReferencedVariables(@NonNull Iterable<@NonNull Variable> byVariables, @NonNull List<@NonNull NavigationAssignment> navigationAssignments) {
        ArrayList<@NonNull Variable> variablesList = new ArrayList<Variable>();
        Iterables.addAll(variablesList, byVariables);
        int i = 0;
        while (i < variablesList.size()) {
            Variable usedVariable = (Variable)variablesList.get(i);
            for (NavigationAssignment navigationAssignment : navigationAssignments) {
                Variable rightVariable = QVTm2QVTp.getVariable(navigationAssignment.getValue());
                Variable leftVariable = QVTm2QVTp.getVariable(navigationAssignment.getSlotExpression());
                if (rightVariable != usedVariable || leftVariable == null || variablesList.contains(leftVariable)) continue;
                variablesList.add(leftVariable);
            }
            ++i;
        }
        return variablesList;
    }

    private static @Nullable Variable getVariable(@Nullable OCLExpression anExpression) {
        if (!(anExpression instanceof VariableExp)) {
            return null;
        }
        VariableDeclaration referredVariable = ((VariableExp)anExpression).getReferredVariable();
        if (!(referredVariable instanceof Variable)) {
            return null;
        }
        return (Variable)referredVariable;
    }

    public QVTm2QVTp(@NonNull EnvironmentFactory environmentFactory) {
        super(environmentFactory);
        this.domainAnalysis = new QVTcoreDomainUsageAnalysis(environmentFactory);
    }

    protected @NonNull AbstractPartCreateVisitor createCreateVisitor() {
        return new SimpleCreateVisitor(this);
    }

    protected @NonNull UpdateVisitor createUpdateVisitor() {
        return new UpdateVisitor(this);
    }

    private @NonNull RootDomainUsageAnalysis getDomainUsageAnalysis() {
        return this.domainAnalysis;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean isEnforceableTransformationWide(@NonNull Domain domain) {
        Transformation transformation = QVTbaseUtil.getContainingTransformation((EObject)domain);
        assert (transformation != null);
        @NonNull Set enforceableTypedModels = this.transformation2enforceableTypedModels.get(transformation);
        if (enforceableTypedModels == null) {
            enforceableTypedModels = QVTbaseUtil.getEnforceableTypedModels((Transformation)transformation);
            this.transformation2enforceableTypedModels.put(transformation, enforceableTypedModels);
        }
        TypedModel typedModel = domain.getTypedModel();
        return enforceableTypedModels.contains(typedModel);
    }

    protected static abstract class AbstractPart
    implements Part {
        protected final @NonNull Partitioning partitioning;

        protected AbstractPart(@NonNull Partitioning partitioning) {
            this.partitioning = partitioning;
            partitioning.addPart(this);
        }

        @Override
        public int compareTo(@NonNull Part o) {
            return this.getName().compareTo(o.getName());
        }

        public @NonNull String toString() {
            return this.getName();
        }
    }

    protected static abstract class AbstractPartCreateVisitor
    extends AbstractQVTc2QVTc.AbstractCreateVisitor<QVTm2QVTp> {
        private final @NonNull Map<@NonNull Type, @NonNull List<@NonNull Partitioning>> secondaryHeadType2partitionings = new HashMap<Type, List<Partitioning>>();

        protected AbstractPartCreateVisitor(@NonNull QVTm2QVTp context) {
            super(context);
        }

        private void addSecondaryHead(@NonNull RealizedVariable secondaryHead, @NonNull Partitioning partitioning) {
            Type secondaryType = secondaryHead.getType();
            assert (secondaryType != null);
            List<@NonNull Partitioning> partitionings = this.secondaryHeadType2partitionings.get(secondaryType);
            if (partitionings == null) {
                partitionings = new ArrayList<Partitioning>();
                this.secondaryHeadType2partitionings.put(secondaryType, partitionings);
            }
            assert (!partitionings.contains(partitioning));
            partitionings.add(partitioning);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private void discriminate(@NonNull List<@NonNull Partitioning> partitionings) throws IOException {
            HashMap<@NonNull Partitioning, @NonNull Map<@NonNull Property, @Nullable OCLExpression>> partitioning2property2value = new HashMap<Partitioning, Map<Property, OCLExpression>>();
            HashSet<@NonNull Property> commonProperties = null;
            for (Partitioning partitioning : partitionings) {
                Map<@NonNull Property, @Nullable OCLExpression> rootPaths = partitioning.getRootPaths();
                if (rootPaths == null) continue;
                partitioning2property2value.put(partitioning, rootPaths);
                if (commonProperties == null) {
                    commonProperties = new HashSet<Property>(rootPaths.keySet());
                    continue;
                }
                commonProperties.retainAll(rootPaths.keySet());
            }
            assert (commonProperties != null);
            if (commonProperties.isEmpty()) {
                throw new IOException("No common properties to disambiguate ");
            }
            CompleteModel completeModel = ((QVTm2QVTp)this.context).getEnvironmentFactory().getCompleteModel();
            ArrayList<@NonNull E> sortedProperties = new ArrayList(commonProperties);
            Collections.sort(sortedProperties, NameUtil.NAMEABLE_COMPARATOR);
            for (Property property : sortedProperties) {
                boolean isDiscriminant = true;
                ArrayList<@Nullable CompleteClass> valueCompleteClasses = new ArrayList<CompleteClass>();
                for (Partitioning partitioning : partitionings) {
                    @NonNull @Nullable Map property2value = (Map)partitioning2property2value.get(partitioning);
                    assert (property2value != null);
                    Type type = null;
                    @Nullable OCLExpression value = (OCLExpression)property2value.get(property);
                    if (value instanceof VariableExp) {
                        VariableDeclaration referredVariable = ((VariableExp)value).getReferredVariable();
                        assert (referredVariable != null);
                        type = referredVariable.getType();
                    } else if (value != null && !(value instanceof NullLiteralExp)) {
                        type = value.getType();
                    }
                    CompleteClass thisCompleteClass = type != null ? completeModel.getCompleteClass(type) : null;
                    for (CompleteClass thatCompleteClass : valueCompleteClasses) {
                        if (this.isDiscriminant(thisCompleteClass, thatCompleteClass)) continue;
                        isDiscriminant = false;
                        break;
                    }
                    valueCompleteClasses.add(thisCompleteClass);
                    if (!isDiscriminant) break;
                }
                PARTITIONING.println(((Object)valueCompleteClasses).toString());
                if (!isDiscriminant) continue;
                for (Partitioning partitioning : partitionings) {
                    partitioning.setDiscriminant(property);
                }
                return;
            }
            throw new IOException("Unable to disambiguate ");
        }

        @Override
        protected void doRules(@NonNull Transformation tIn, @NonNull Transformation tOut) {
            ArrayList<@NonNull Partitioning> allPartitionings = new ArrayList<Partitioning>();
            for (Rule inRule : ClassUtil.nullFree((EList)tIn.getRule())) {
                Mapping mIn = (Mapping)inRule;
                Partitioning partitioning = new Partitioning(this, mIn);
                boolean doDebug = PARTITIONING.isActive();
                StringBuilder s = doDebug ? new StringBuilder() : null;
                try {
                    partitioning.analyze(s);
                    RealizedVariable secondaryHead = partitioning.getSecondaryHead();
                    if (secondaryHead != null) {
                        this.addSecondaryHead(secondaryHead, partitioning);
                    }
                }
                finally {
                    if (s != null) {
                        PARTITIONING.println(s.toString());
                    }
                }
                allPartitionings.add(partitioning);
            }
            try {
                for (List<Partitioning> ambiguousPartitionings : this.secondaryHeadType2partitionings.values()) {
                    if (ambiguousPartitionings.size() <= 1) continue;
                    this.discriminate(ambiguousPartitionings);
                }
            }
            catch (IOException e) {
                throw new WrappedException((Exception)e);
            }
            EList outRules = tOut.getRule();
            for (Partitioning partitioning : allPartitionings) {
                outRules.addAll(partitioning.synthesize());
            }
        }

        public @NonNull QVTm2QVTp getContext() {
            return (QVTm2QVTp)this.context;
        }

        private boolean isDiscriminant(@Nullable CompleteClass thisCompleteClass, @Nullable CompleteClass thatCompleteClass) {
            if (thisCompleteClass == thatCompleteClass) {
                return false;
            }
            if (thisCompleteClass == null || thatCompleteClass == null) {
                return true;
            }
            if (thisCompleteClass.conformsTo(thatCompleteClass)) {
                return false;
            }
            return !thatCompleteClass.conformsTo(thisCompleteClass);
        }

        @Override
        public @NonNull BottomPattern visitBottomPattern(@NonNull BottomPattern bIn) {
            BottomPattern bOut = QVTcoreBaseFactory.eINSTANCE.createBottomPattern();
            ((QVTm2QVTp)this.context).addTrace((Element)bIn, (Element)bOut);
            return bOut;
        }

        @Override
        public @NonNull CoreDomain visitCoreDomain(@NonNull CoreDomain dIn) {
            boolean isEnforceable = ((QVTm2QVTp)this.context).isEnforceableTransformationWide((Domain)dIn);
            assert (dIn.isIsEnforceable() == isEnforceable);
            return super.visitCoreDomain(dIn);
        }

        @Override
        public @NonNull CoreModel visitCoreModel(@NonNull CoreModel mIn) {
            @NonNull CoreModel mOut = super.visitCoreModel(mIn);
            mOut.setExternalURI(mIn.getExternalURI().replace(".qvtm.qvtc", ".qvtp.qvtc"));
            return mOut;
        }

        @Override
        public @NonNull GuardPattern visitGuardPattern(@NonNull GuardPattern gIn) {
            GuardPattern gOut = QVTcoreBaseFactory.eINSTANCE.createGuardPattern();
            ((QVTm2QVTp)this.context).addTrace((Element)gIn, (Element)gOut);
            return gOut;
        }

        public abstract @NonNull Mapping visitMapping(@NonNull Mapping var1);

        @Override
        public @NonNull Transformation visitTransformation(@NonNull Transformation tIn) {
            ((QVTm2QVTp)this.context).getDomainUsageAnalysis().analyzeTransformation(tIn);
            return super.visitTransformation(tIn);
        }

        @Override
        public @NonNull TypedModel visitTypedModel(@NonNull TypedModel tmIn) {
            @NonNull TypedModel tmOut = super.visitTypedModel(tmIn);
            String name = tmIn.getName();
            if (name == null) {
                name = "middle";
                tmOut.setName(name);
            }
            return tmOut;
        }
    }

    protected static abstract class AbstractPrimaryCreateVisitor
    extends AbstractPartCreateVisitor {
        public AbstractPrimaryCreateVisitor(@NonNull QVTm2QVTp context) {
            super(context);
        }

        protected void createAllPredicatesOrAssignments(@NonNull Iterable<Assignment> aIns, @NonNull List<Predicate> pOuts, @NonNull List<Assignment> aOuts) {
            for (Assignment aIn : aIns) {
                Assignment eOut = this.create(aIn);
                if (eOut instanceof Predicate) {
                    pOuts.add((Predicate)eOut);
                    continue;
                }
                if (eOut instanceof Assignment) {
                    aOuts.add(eOut);
                    continue;
                }
                assert (eOut == null);
            }
        }

        protected void createAllVariables(@NonNull Iterable<? extends Variable> vIns, @NonNull List<Variable> gvOuts, @NonNull List<Variable> bvOuts) {
            for (Variable variable : vIns) {
                Variable vOut = this.create(variable);
                assert (vOut != null);
                if (variable.getOwnedInit() != null) {
                    bvOuts.add(vOut);
                    continue;
                }
                gvOuts.add(vOut);
            }
        }

        @Override
        public @NonNull Mapping visitMapping(@NonNull Mapping mIn) {
            @NonNull Mapping mOut = QVTcoreFactory.eINSTANCE.createMapping();
            ((QVTm2QVTp)this.context).pushScope((NamedElement)mOut);
            ((QVTm2QVTp)this.context).addTrace((Element)mIn, (Element)mOut);
            mOut.setName(mIn.getName());
            mOut.setGuardPattern(this.create(mIn.getGuardPattern()));
            mOut.setBottomPattern(this.create(mIn.getBottomPattern()));
            this.createAll(mIn.getOwnedComments(), mOut.getOwnedComments());
            CoreDomain dOut = QVTcoreBaseFactory.eINSTANCE.createCoreDomain();
            ((QVTm2QVTp)this.context).addTrace((Element)mIn, (Element)dOut);
            dOut.setGuardPattern(this.create(mIn.getGuardPattern()));
            dOut.setBottomPattern(this.create(mIn.getBottomPattern()));
            dOut.setIsCheckable(false);
            dOut.setIsEnforceable(true);
            GuardPattern gIn = mIn.getGuardPattern();
            this.createAll(gIn.getPredicate(), mOut.getGuardPattern().getPredicate());
            this.createAll(gIn.getVariable(), dOut.getGuardPattern().getVariable());
            BottomPattern bIn = mIn.getBottomPattern();
            this.createAllPredicatesOrAssignments((Iterable<Assignment>)bIn.getAssignment(), (List<Predicate>)mOut.getGuardPattern().getPredicate(), (List<Assignment>)mOut.getBottomPattern().getAssignment());
            this.createAll(bIn.getPredicate(), mOut.getBottomPattern().getPredicate());
            this.createAll(bIn.getRealizedVariable(), dOut.getBottomPattern().getRealizedVariable());
            this.createAllVariables((Iterable<? extends Variable>)bIn.getVariable(), (List<Variable>)mOut.getGuardPattern().getVariable(), (List<Variable>)mOut.getBottomPattern().getVariable());
            mOut.getDomain().add((Object)dOut);
            for (Domain d : ClassUtil.nullFree((EList)mIn.getDomain())) {
                CoreDomain dIn = (CoreDomain)d;
                CoreDomain dOut2 = this.create(dIn);
                assert (dOut2 != null);
                boolean isEnforceable = ((QVTm2QVTp)this.context).isEnforceableTransformationWide(d);
                assert (d.isIsEnforceable() == isEnforceable);
                GuardPattern gIn2 = dIn.getGuardPattern();
                this.createAll(gIn2.getPredicate(), mOut.getGuardPattern().getPredicate());
                this.createAll(gIn2.getVariable(), dOut2.getGuardPattern().getVariable());
                BottomPattern bIn2 = dIn.getBottomPattern();
                this.createAllPredicatesOrAssignments((Iterable<Assignment>)bIn2.getAssignment(), (List<Predicate>)mOut.getGuardPattern().getPredicate(), (List<Assignment>)mOut.getBottomPattern().getAssignment());
                this.createAll(bIn2.getPredicate(), mOut.getGuardPattern().getPredicate());
                this.createAll(bIn2.getRealizedVariable(), dOut2.getBottomPattern().getRealizedVariable());
                this.createAllVariables((Iterable<? extends Variable>)bIn2.getVariable(), (List<Variable>)dOut2.getGuardPattern().getVariable(), (List<Variable>)dOut2.getBottomPattern().getVariable());
                mOut.getDomain().add((Object)dOut2);
            }
            ((QVTm2QVTp)this.context).popScope();
            return mOut;
        }
    }

    protected static abstract class AssignablePart
    extends AbstractPart {
        private @Nullable OCLExpression value = null;

        protected AssignablePart(@NonNull Partitioning partitioning) {
            super(partitioning);
        }

        @Override
        public @Nullable Set<@NonNull Part> analyzeRequiredParts() {
            OCLExpression value2 = this.value;
            if (value2 == null) {
                return null;
            }
            return this.partitioning.analyzeRequiredParts((Element)value2);
        }

        public @Nullable OCLExpression getValue() {
            return this.value;
        }

        public @Nullable VariablePart getVariablePartInitializer() {
            OCLExpression value2 = this.value;
            if (value2 == null) {
                return null;
            }
            return this.partitioning.basicGetVariablePart(value2);
        }

        public void setValue(@NonNull OCLExpression value) {
            if (this.value != null) {
                System.err.println("Duplicate assignment to " + this + " '" + this.value + "'/ '" + value + "'");
            }
            this.value = value;
        }

        @Override
        public @NonNull String toString() {
            if (this.value == null) {
                return super.toString();
            }
            return String.valueOf(super.toString()) + " := " + this.value;
        }
    }

    protected static class ComplexPart
    extends PropertyAssignablePart {
        protected final @NonNull NavigationAssignment navigationAssignment;

        public ComplexPart(@NonNull Partitioning partitioning, @NonNull NavigationAssignment navigationAssignment) {
            super(partitioning);
            this.navigationAssignment = navigationAssignment;
        }

        @Override
        public @NonNull String getName() {
            return this.navigationAssignment.getSlotExpression() + "." + QVTcoreBaseUtil.getTargetProperty((NavigationAssignment)this.navigationAssignment).getName();
        }

        @Override
        public @NonNull NavigationAssignment getNavigationAssignment() {
            return this.navigationAssignment;
        }
    }

    protected static interface Part
    extends Nameable,
    Comparable<Part> {
        public @Nullable Set<@NonNull Part> analyzeRequiredParts();

        public @NonNull String getName();
    }

    protected static class Partitioning {
        protected final @NonNull AbstractPartCreateVisitor createVisitor;
        protected final @NonNull Mapping mapping;
        private final @NonNull Map<@NonNull Variable, @NonNull VariablePart> variable2part = new HashMap<Variable, VariablePart>();
        private @Nullable List<@NonNull VariablePart> allBottomVariables = null;
        private @Nullable List<@NonNull VariablePart> allGuardVariables = null;
        private @Nullable List<@NonNull PredicatePart> allPredicates = null;
        private final @NonNull List<@NonNull AssignablePart> allPropertyAssignments = new ArrayList<AssignablePart>();
        private final @NonNull List<@NonNull VariablePart> allRealizedVariables = new ArrayList<VariablePart>();
        private @Nullable Map<@NonNull Property, @NonNull PropertyPart> allPropertyParts = null;
        private @Nullable List<@NonNull NavigationAssignment> primaryAssignments = null;
        private @Nullable RealizedVariable secondaryHead = null;
        private final @NonNull Map<@NonNull Part, @Nullable Set<@NonNull Part>> part2requiredParts = new HashMap<Part, Set<Part>>();
        private final @NonNull List<@NonNull Part> allParts = new ArrayList<Part>();
        private final @NonNull Set<@NonNull Part> partitionedParts = new HashSet<Part>();
        private final @NonNull Set<@NonNull Part> remainingParts = new HashSet<Part>();
        private @Nullable Map<@NonNull List<@NonNull Part>, @NonNull List<@NonNull Part>> requiredParts2requiringParts = null;
        private @Nullable Property discriminant = null;

        public Partitioning(@NonNull AbstractPartCreateVisitor createVisitor, @NonNull Mapping mapping) {
            this.createVisitor = createVisitor;
            this.mapping = mapping;
        }

        private void addAssignments(@NonNull BottomPattern bottomPattern) {
            for (Assignment assignment : ClassUtil.nullFree((EList)bottomPattern.getAssignment())) {
                AssignablePart assignablePart = assignment instanceof VariableAssignment ? this.addVariableAssignment((VariableAssignment)assignment) : this.addNavigationAssignment((NavigationAssignment)assignment);
                OCLExpression value = assignment.getValue();
                assert (value != null);
                assert (assignablePart.getValue() == value);
            }
        }

        private void addBottomVariables(@NonNull BottomPattern bottomPattern) {
            List<@NonNull VariablePart> allBottomVariables2 = this.allBottomVariables;
            for (Variable variable : ClassUtil.nullFree((EList)bottomPattern.getVariable())) {
                VariablePart variablePart = new VariablePart(this, variable);
                if (allBottomVariables2 == null) {
                    this.allBottomVariables = allBottomVariables2 = new ArrayList<VariablePart>();
                }
                allBottomVariables2.add(variablePart);
                VariablePart oldVariablePart = this.variable2part.put(variable, variablePart);
                assert (oldVariablePart == null);
            }
        }

        private void addGuardVariables(@NonNull GuardPattern guardPattern) {
            List<@NonNull VariablePart> allGuardVariables2 = this.allGuardVariables;
            for (Variable variable : ClassUtil.nullFree((EList)guardPattern.getVariable())) {
                VariablePart variablePart = new VariablePart(this, variable);
                if (allGuardVariables2 == null) {
                    this.allGuardVariables = allGuardVariables2 = new ArrayList<VariablePart>();
                }
                allGuardVariables2.add(variablePart);
                VariablePart oldVariablePart = this.variable2part.put(variable, variablePart);
                assert (oldVariablePart == null);
            }
        }

        private @NonNull AssignablePart addNavigationAssignment(@NonNull NavigationAssignment navigationAssignment) {
            OCLExpression slotExpression = navigationAssignment.getSlotExpression();
            assert (slotExpression != null);
            VariablePart variablePart = this.basicGetVariablePart(slotExpression);
            PropertyAssignablePart assignablePart = variablePart != null ? variablePart.getPropertyPart(navigationAssignment) : new ComplexPart(this, navigationAssignment);
            this.allPropertyAssignments.add(assignablePart);
            return assignablePart;
        }

        private void addPart(@NonNull Part part) {
            assert (!this.part2requiredParts.containsKey(part));
            this.part2requiredParts.put(part, null);
            this.allParts.add(part);
        }

        private void addPredicates(@NonNull CorePattern corePattern) {
            List<@NonNull PredicatePart> allPredicates2 = this.allPredicates;
            for (Predicate predicate : ClassUtil.nullFree((EList)corePattern.getPredicate())) {
                PredicatePart predicatePart = new PredicatePart(this, predicate);
                if (allPredicates2 == null) {
                    this.allPredicates = allPredicates2 = new ArrayList<PredicatePart>();
                }
                allPredicates2.add(predicatePart);
            }
        }

        private @NonNull PropertyPart addPropertyPart(@NonNull Property property) {
            PropertyPart propertyPart;
            Map<@NonNull Property, @NonNull PropertyPart> allPropertyParts2 = this.allPropertyParts;
            if (allPropertyParts2 == null) {
                this.allPropertyParts = allPropertyParts2 = new HashMap<Property, PropertyPart>();
            }
            if ((propertyPart = allPropertyParts2.get(property)) == null) {
                propertyPart = new PropertyPart(this, property);
                allPropertyParts2.put(property, propertyPart);
            }
            return propertyPart;
        }

        private void addRealizedVariables(@NonNull BottomPattern bottomPattern) {
            for (RealizedVariable variable : ClassUtil.nullFree((EList)bottomPattern.getRealizedVariable())) {
                VariablePart variablePart = new VariablePart(this, (Variable)variable);
                this.allRealizedVariables.add(variablePart);
                VariablePart oldVariablePart = this.variable2part.put((Variable)variable, variablePart);
                assert (oldVariablePart == null);
            }
        }

        private @NonNull VariablePart addVariableAssignment(@NonNull VariableAssignment variableAssignment) {
            Variable targetVariable = variableAssignment.getTargetVariable();
            assert (targetVariable != null);
            VariablePart variablePart = this.variable2part.get(targetVariable);
            assert (variablePart != null);
            OCLExpression value = variableAssignment.getValue();
            assert (value != null);
            variablePart.setValue(value);
            return variablePart;
        }

        public void analyze(@Nullable StringBuilder s) {
            for (Domain domain : ClassUtil.nullFree((EList)this.mapping.getDomain())) {
                this.analyzeArea((Area)((CoreDomain)domain));
            }
            this.analyzeArea((Area)this.mapping);
            Collections.sort(this.allPropertyAssignments);
            Collections.sort(this.allRealizedVariables);
            int i = 0;
            while (i < this.allParts.size()) {
                Part part = this.allParts.get(i);
                this.part2requiredParts.put(part, part.analyzeRequiredParts());
                this.remainingParts.add(part);
                ++i;
            }
            this.requiredParts2requiringParts = this.partition(s);
            Map<@NonNull List<@NonNull Part>, @NonNull List<@NonNull Part>> requiredParts2requiringParts = this.requiredParts2requiringParts;
            if (requiredParts2requiringParts != null && requiredParts2requiringParts.size() > 0) {
                this.primaryAssignments = this.synthesizeComputePrimaryAssignments(requiredParts2requiringParts);
                List<@NonNull NavigationAssignment> primaryAssignments2 = this.primaryAssignments;
                this.secondaryHead = this.synthesizeComputeSecondaryHead(this.allRealizedVariables, primaryAssignments2);
                if (this.secondaryHead == null) {
                    this.secondaryHead = this.synthesizeComputeSecondaryHead(this.allRealizedVariables, primaryAssignments2);
                }
            }
        }

        private void analyzeArea(@NonNull Area area) {
            GuardPattern guardPattern = area.getGuardPattern();
            assert (guardPattern != null);
            this.addGuardVariables(guardPattern);
            this.addPredicates((CorePattern)guardPattern);
            BottomPattern bottomPattern = area.getBottomPattern();
            assert (bottomPattern != null);
            this.addBottomVariables(bottomPattern);
            this.addPredicates((CorePattern)bottomPattern);
            this.addRealizedVariables(bottomPattern);
            this.addAssignments(bottomPattern);
        }

        private @Nullable Part analyzeRequiredPart(@NonNull Element eObject) {
            if (eObject instanceof VariableExp) {
                VariableDeclaration referredVariable = ((VariableExp)eObject).getReferredVariable();
                VariablePart variablePart = this.variable2part.get(referredVariable);
                if (variablePart != null) {
                    return variablePart;
                }
            } else if (eObject instanceof NavigationCallExp) {
                VariablePropertyPart propertyPart;
                VariablePart variablePart;
                NavigationCallExp navigationCallExp = (NavigationCallExp)eObject;
                OCLExpression source = navigationCallExp.getOwnedSource();
                assert (source != null);
                DomainUsage usage = this.createVisitor.getContext().domainAnalysis.getUsage((Element)source);
                if (usage.isInput()) {
                    return null;
                }
                Property property = PivotUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
                assert (property != null);
                if (source instanceof VariableExp && (variablePart = this.basicGetVariablePart(source)) != null && (propertyPart = variablePart.basicGetPropertyPart(property)) != null) {
                    return propertyPart;
                }
                return this.addPropertyPart(property);
            }
            return null;
        }

        protected @Nullable Set<@NonNull Part> analyzeRequiredParts(@NonNull Element element) {
            HashSet<@NonNull Part> requiredParts = null;
            Part requiredPart = this.analyzeRequiredPart(element);
            if (requiredPart != null) {
                requiredParts = new HashSet<Part>();
                requiredParts.add(requiredPart);
            }
            TreeIterator tit = element.eAllContents();
            while (tit.hasNext()) {
                EObject eObject = (EObject)tit.next();
                if (!(eObject instanceof Element) || (requiredPart = this.analyzeRequiredPart((Element)eObject)) == null) continue;
                if (requiredParts == null) {
                    requiredParts = new HashSet();
                }
                requiredParts.add(requiredPart);
            }
            return requiredParts;
        }

        private @Nullable VariablePart basicGetVariablePart(@NonNull OCLExpression oclExpression) {
            if (!(oclExpression instanceof VariableExp)) {
                return null;
            }
            VariableDeclaration referredVariable = ((VariableExp)oclExpression).getReferredVariable();
            assert (referredVariable != null);
            return this.variable2part.get(referredVariable);
        }

        public @Nullable Map<@NonNull Property, @Nullable OCLExpression> getRootPaths() {
            HashMap<@NonNull Property, @Nullable OCLExpression> property2value = null;
            List<@NonNull NavigationAssignment> primaryAssignments2 = this.primaryAssignments;
            RealizedVariable secondaryHead2 = this.secondaryHead;
            if (secondaryHead2 != null && primaryAssignments2 != null) {
                property2value = new HashMap<Property, OCLExpression>();
                for (NavigationAssignment navigationAssignment : primaryAssignments2) {
                    Variable leftVariable = QVTm2QVTp.getVariable(navigationAssignment.getSlotExpression());
                    if (leftVariable != secondaryHead2) continue;
                    Property targetProperty = QVTcoreBaseUtil.getTargetProperty((NavigationAssignment)navigationAssignment);
                    assert (targetProperty != null);
                    property2value.put(targetProperty, navigationAssignment.getValue());
                }
            }
            return property2value;
        }

        public @Nullable RealizedVariable getSecondaryHead() {
            return this.secondaryHead;
        }

        public @Nullable Map<@NonNull List<@NonNull Part>, @NonNull List<@NonNull Part>> partition(@Nullable StringBuilder s) {
            Collections.sort(this.allParts);
            if (s != null) {
                s.append(this.mapping + "\n");
                this.showAllParts(s);
            }
            this.partitionGuardVariables(s);
            this.partitionBottomVariables(s);
            this.partitionPredicates(s);
            Set<@NonNull VariablePropertyPart> simpleRealizedPropertyParts = this.partitionSimpleRealizedVariables(s);
            Map<@NonNull Part, @NonNull List<@NonNull Part>> requiredPart2requiringParts = this.partitionRealizedPropertyParts(simpleRealizedPropertyParts);
            if (requiredPart2requiringParts != null) {
                if (s != null) {
                    s.append("  partitioned parts:\n");
                    s.append("   ");
                    for (Part partitionedPart : this.partitionedParts) {
                        s.append(" " + partitionedPart.getName());
                    }
                    s.append("\n");
                    this.showRequiredPart2requiringParts(s, requiredPart2requiringParts);
                }
                Map<@NonNull List<@NonNull Part>, @NonNull List<@NonNull Part>> requiredParts2requiringParts = this.partitionRecurseCommits(requiredPart2requiringParts);
                if (s != null) {
                    this.showRequiredParts2requiringParts(s, requiredParts2requiringParts);
                }
                return requiredParts2requiringParts;
            }
            return null;
        }

        private void partitionBottomVariables(@Nullable StringBuilder s) {
            List<@NonNull VariablePart> allBottomVariables2 = this.allBottomVariables;
            if (allBottomVariables2 != null) {
                Collections.sort(allBottomVariables2);
                if (s != null) {
                    s.append("  bottom variables:");
                }
                for (VariablePart part : allBottomVariables2) {
                    if (s != null) {
                        s.append(" " + part.getName());
                    }
                    this.partitionPart(part);
                }
                if (s != null) {
                    s.append("\n");
                }
            }
        }

        private void partitionGuardVariables(@Nullable StringBuilder s) {
            List<@NonNull VariablePart> allGuardVariables2 = this.allGuardVariables;
            if (allGuardVariables2 != null) {
                Collections.sort(allGuardVariables2);
                if (s != null) {
                    s.append("  guard variables:");
                }
                for (VariablePart part : allGuardVariables2) {
                    if (s != null) {
                        s.append(" " + part.getName());
                    }
                    this.partitionPart(part);
                }
                if (s != null) {
                    s.append("\n");
                }
            }
        }

        private void partitionPart(@NonNull Part part) {
            this.partitionedParts.add(part);
            this.remainingParts.remove(part);
        }

        private void partitionPredicates(@Nullable StringBuilder s) {
            List<@NonNull PredicatePart> allPredicates2 = this.allPredicates;
            if (allPredicates2 == null) {
                return;
            }
            Collections.sort(allPredicates2);
            HashSet<@NonNull Part> predicateDependencies = null;
            for (PredicatePart predicatePart : allPredicates2) {
                Set<@NonNull Part> parts = this.part2requiredParts.get(predicatePart);
                if (parts == null) continue;
                for (Part part : parts) {
                    if (this.partitionedParts.contains(part)) continue;
                    if (predicateDependencies == null) {
                        predicateDependencies = new HashSet<Part>();
                    }
                    predicateDependencies.add(part);
                }
            }
            if (predicateDependencies != null) {
                if (s != null) {
                    s.append("  predicate dependencies:");
                }
                ArrayList<@NonNull E> predicateDependenciesList = new ArrayList(predicateDependencies);
                Collections.sort(predicateDependenciesList);
                for (Part part : predicateDependenciesList) {
                    if (s != null) {
                        s.append(" " + part.getName());
                    }
                    this.partitionPart(part);
                }
                if (s != null) {
                    s.append("\n");
                }
            }
            if (s != null) {
                s.append("  predicates:\n");
            }
            for (PredicatePart part : allPredicates2) {
                if (s != null) {
                    s.append("    " + part.getName() + "\n");
                }
                this.partitionPart(part);
            }
        }

        private @Nullable Map<@NonNull Part, @NonNull List<@NonNull Part>> partitionRealizedPropertyParts(@Nullable Set<@NonNull VariablePropertyPart> realizedPropertyParts) {
            Set<@NonNull Part> checkParts = this.part2requiredParts.keySet();
            assert (this.partitionedParts.size() + this.remainingParts.size() == this.allParts.size());
            assert (checkParts.equals(new HashSet<Part>(this.allParts)));
            assert (checkParts.containsAll(this.partitionedParts));
            assert (checkParts.containsAll(this.remainingParts));
            HashMap<@NonNull Part, @NonNull List<@NonNull Part>> requiredPart2requiringParts = new HashMap<Part, List<Part>>();
            for (Part remainingPart : this.remainingParts) {
                Set<@NonNull Part> requiredParts = this.part2requiredParts.get(remainingPart);
                if (requiredParts == null) continue;
                for (Part requiredPart : requiredParts) {
                    if (this.partitionedParts.contains(requiredPart)) continue;
                    ArrayList<@NonNull Part> requiringParts = (ArrayList<Part>)requiredPart2requiringParts.get(requiredPart);
                    if (requiringParts == null) {
                        requiringParts = new ArrayList<Part>();
                        requiredPart2requiringParts.put(requiredPart, requiringParts);
                    }
                    assert (!requiringParts.contains(remainingPart));
                    requiringParts.add(remainingPart);
                }
            }
            return requiredPart2requiringParts;
        }

        private @NonNull Map<@NonNull List<@NonNull Part>, @NonNull List<@NonNull Part>> partitionRecurseCommits(@NonNull Map<@NonNull Part, @NonNull List<@NonNull Part>> requiredPart2requiringParts) {
            List<Part> requiringParts;
            ArrayList<@NonNull Part> requiredPartsRequiredOnlyOnce = null;
            for (Part requiredPart : requiredPart2requiringParts.keySet()) {
                List<@NonNull Part> requiringParts2 = requiredPart2requiringParts.get(requiredPart);
                assert (requiringParts2 != null);
                if (requiringParts2.size() != 1 || requiredPart2requiringParts.get(requiringParts2.get(0)) == null) continue;
                if (requiredPartsRequiredOnlyOnce == null) {
                    requiredPartsRequiredOnlyOnce = new ArrayList<Part>();
                }
                requiredPartsRequiredOnlyOnce.add(requiredPart);
            }
            @NonNull HashMap<@NonNull List<@NonNull Part>, @NonNull List<@NonNull Part>> requiredParts2requiringParts = new HashMap<List<Part>, List<Part>>();
            if (requiredPartsRequiredOnlyOnce != null) {
                for (Part requiredPart : requiredPartsRequiredOnlyOnce) {
                    requiringParts = requiredPart2requiringParts.remove(requiredPart);
                    assert (requiringParts != null && requiringParts.size() == 1);
                    Part requiringPart = requiringParts.get(0);
                    List<@NonNull Part> requiringRequiringParts = requiredPart2requiringParts.remove(requiringPart);
                    if (requiringRequiringParts == null) continue;
                    ArrayList<@NonNull Part> mergedRequiredParts = new ArrayList<Part>();
                    mergedRequiredParts.add(requiredPart);
                    mergedRequiredParts.add(requiringPart);
                    ArrayList<@NonNull Part> mergedRequiringParts = new ArrayList<Part>(requiringRequiringParts);
                    mergedRequiringParts.add(requiringPart);
                    requiredParts2requiringParts.put(mergedRequiredParts, mergedRequiringParts);
                }
            }
            for (Part requiredPart : requiredPart2requiringParts.keySet()) {
                requiringParts = requiredPart2requiringParts.get(requiredPart);
                assert (requiringParts != null);
                requiredParts2requiringParts.put(Collections.singletonList(requiredPart), requiringParts);
            }
            return requiredParts2requiringParts;
        }

        private @Nullable Set<@NonNull VariablePropertyPart> partitionSimpleRealizedVariables(@Nullable StringBuilder s) {
            HashSet<@NonNull VariablePropertyPart> realizedPropertyParts = null;
            if (s != null) {
                s.append("  realized variables:");
            }
            for (VariablePart variablePart : this.allRealizedVariables) {
                if (s != null) {
                    s.append(" " + variablePart.getName());
                }
                this.partitionPart(variablePart);
                Iterable<@NonNull VariablePropertyPart> propertyParts = variablePart.getPropertyParts();
                if (propertyParts == null) continue;
                for (VariablePropertyPart propertyPart : propertyParts) {
                    VariablePart variablePart2 = propertyPart.getVariablePartInitializer();
                    if (variablePart2 == null) continue;
                    if (realizedPropertyParts == null) {
                        realizedPropertyParts = new HashSet<VariablePropertyPart>();
                    }
                    realizedPropertyParts.add(propertyPart);
                }
            }
            if (s != null) {
                s.append("\n");
            }
            if (realizedPropertyParts != null) {
                if (s != null) {
                    s.append("  realized variable initializers:");
                }
                for (VariablePropertyPart variablePropertyPart : realizedPropertyParts) {
                    if (s != null) {
                        s.append(" " + variablePropertyPart.getName());
                    }
                    this.partitionPart(variablePropertyPart);
                }
                if (s != null) {
                    s.append("\n");
                }
            }
            return realizedPropertyParts;
        }

        public void setDiscriminant(@NonNull Property property) {
            assert (this.discriminant == null);
            this.discriminant = property;
        }

        private void showAllParts(@NonNull StringBuilder s) {
            for (Part part : this.allParts) {
                Set<Part> parts;
                if (s != null) {
                    s.append("    " + part + " : {");
                }
                if ((parts = this.part2requiredParts.get(part)) != null) {
                    ArrayList<@NonNull Part> sortedDependentParts = new ArrayList<Part>(parts);
                    Collections.sort(sortedDependentParts);
                    for (Part dependentPart : sortedDependentParts) {
                        if (s != null) {
                            s.append(" " + dependentPart.getName());
                        }
                        assert (this.part2requiredParts.containsKey(dependentPart));
                    }
                }
                if (s == null) continue;
                s.append(" }\n");
            }
        }

        private void showRequiredPart2requiringParts(@NonNull StringBuilder s, @NonNull Map<@NonNull Part, @NonNull List<@NonNull Part>> requiredPart2requiringParts) {
            s.append("  required part => requiring parts:\n");
            for (Part requiredPart : requiredPart2requiringParts.keySet()) {
                s.append("    ");
                s.append(requiredPart.getName());
                s.append(" => {");
                List<@NonNull Part> requiringParts = requiredPart2requiringParts.get(requiredPart);
                assert (requiringParts != null);
                Collections.sort(requiringParts);
                for (Part requiringPart : requiringParts) {
                    s.append(" " + requiringPart.getName());
                }
                s.append(" }\n");
            }
        }

        private void showRequiredParts2requiringParts(@NonNull StringBuilder s, @NonNull Map<@NonNull List<@NonNull Part>, @NonNull List<@NonNull Part>> requiredParts2requiringParts) {
            s.append("  required part => requiring parts:\n");
            for (List<Part> requiredParts : requiredParts2requiringParts.keySet()) {
                s.append("    {");
                for (Part requiredPart : requiredParts) {
                    s.append(" " + requiredPart.getName());
                }
                s.append(" } => {");
                List<@NonNull Part> requiringParts = requiredParts2requiringParts.get(requiredParts);
                assert (requiringParts != null);
                Collections.sort(requiringParts);
                for (Part requiringPart : requiringParts) {
                    s.append(" " + requiringPart.getName());
                }
                s.append(" }\n");
            }
        }

        public @NonNull List<@NonNull Mapping> synthesize() {
            String name = this.mapping.getName();
            Map<@NonNull List<@NonNull Part>, @NonNull List<@NonNull Part>> requiredParts2requiringParts2 = this.requiredParts2requiringParts;
            if (requiredParts2requiringParts2 == null || requiredParts2requiringParts2.size() <= 0) {
                Mapping mOut = this.createVisitor.create(this.mapping);
                assert (mOut != null);
                return Collections.singletonList(mOut);
            }
            ArrayList<@NonNull Mapping> mOuts = new ArrayList<Mapping>();
            List<@NonNull NavigationAssignment> primaryAssignments2 = this.primaryAssignments;
            RealizedVariable secondaryHead2 = this.secondaryHead;
            assert (primaryAssignments2 != null);
            final Map<@NonNull List<@NonNull Part>, @NonNull String> dependentParts2mappingName = this.synthesizeComputeMappingNames(requiredParts2requiringParts2);
            QVTm2QVTp context = this.createVisitor.getContext();
            AbstractPartCreateVisitor refinedCreateVisitor = new PrimaryPartCreateVisitor(context, primaryAssignments2);
            Mapping mOut = refinedCreateVisitor.create(this.mapping);
            assert (mOut != null);
            mOuts.add(mOut);
            NavigationAssignment discriminantAssignment = null;
            if (this.discriminant != null) {
                for (NavigationAssignment primaryAssignment : primaryAssignments2) {
                    Variable variable;
                    if (QVTcoreBaseUtil.getTargetProperty((NavigationAssignment)primaryAssignment) != this.discriminant || (variable = QVTm2QVTp.getVariable(primaryAssignment.getSlotExpression())) != secondaryHead2) continue;
                    discriminantAssignment = primaryAssignment;
                    break;
                }
            }
            ArrayList<@NonNull List<@NonNull Part>> requiredPartsList = new ArrayList<List<Part>>(requiredParts2requiringParts2.keySet());
            Collections.sort(requiredPartsList, new Comparator<List<Part>>(){

                @Override
                public int compare(@NonNull List<@NonNull Part> o1, @NonNull List<@NonNull Part> o2) {
                    String n1 = (String)dependentParts2mappingName.get(o1);
                    String n2 = (String)dependentParts2mappingName.get(o2);
                    return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
                }
            });
            HashSet<@NonNull Part> resolvedRequiringParts = new HashSet<Part>();
            for (List list : requiredPartsList) {
                List<@NonNull Part> requiringParts = requiredParts2requiringParts2.get(list);
                assert (requiringParts != null);
                requiringParts = new ArrayList<Part>(requiringParts);
                requiringParts.removeAll(resolvedRequiringParts);
                if (requiringParts.size() <= 0) continue;
                List<@NonNull NavigationAssignment> secondaryAssignments = this.synthesizeComputeSecondaryAssignments(requiringParts);
                String mappingName = dependentParts2mappingName.get(list);
                assert (mappingName != null);
                assert (secondaryHead2 != null);
                refinedCreateVisitor = new SecondaryPartCreateVisitor(context, mappingName, secondaryHead2, primaryAssignments2, discriminantAssignment != null ? Collections.singletonList(discriminantAssignment) : Collections.emptyList(), secondaryAssignments);
                mOut = refinedCreateVisitor.create(this.mapping);
                assert (mOut != null);
                mOuts.add(mOut);
                resolvedRequiringParts.addAll(requiringParts);
            }
            return mOuts;
        }

        private @Nullable RealizedVariable synthesizeComputeSecondaryHead(@NonNull List<@NonNull VariablePart> allRealizedVariables, @NonNull List<@NonNull NavigationAssignment> primaryAssignments) {
            Iterable definedVariables;
            int realizedVariableCount;
            DomainUsage usage;
            RealizedVariable realizedVariable;
            RealizedVariable bestRealizedVariable = null;
            int bestRealizedVariableCount = 0;
            for (VariablePart realizedVariablePart : allRealizedVariables) {
                realizedVariable = (RealizedVariable)realizedVariablePart.getVariable();
                usage = this.createVisitor.getContext().getDomainUsageAnalysis().getUsage((Element)realizedVariable);
                if (!usage.isMiddle()) continue;
                realizedVariableCount = 0;
                definedVariables = QVTm2QVTp.computeIndirectlyDefinedVariables(Collections.singletonList(realizedVariable), primaryAssignments);
                for (Variable definedVariable : definedVariables) {
                    if (!(definedVariable instanceof RealizedVariable)) continue;
                    ++realizedVariableCount;
                }
                if (bestRealizedVariable != null && realizedVariableCount < bestRealizedVariableCount) continue;
                bestRealizedVariable = realizedVariable;
                bestRealizedVariableCount = realizedVariableCount;
            }
            if (bestRealizedVariable == null) {
                for (VariablePart realizedVariablePart : allRealizedVariables) {
                    realizedVariable = (RealizedVariable)realizedVariablePart.getVariable();
                    usage = this.createVisitor.getContext().getDomainUsageAnalysis().getUsage((Element)realizedVariable);
                    if (!usage.isOutput()) continue;
                    realizedVariableCount = 0;
                    definedVariables = QVTm2QVTp.computeIndirectlyDefinedVariables(Collections.singletonList(realizedVariable), primaryAssignments);
                    for (Variable definedVariable : definedVariables) {
                        if (!(definedVariable instanceof RealizedVariable)) continue;
                        ++realizedVariableCount;
                    }
                    if (bestRealizedVariable != null && realizedVariableCount < bestRealizedVariableCount) continue;
                    bestRealizedVariable = realizedVariable;
                    bestRealizedVariableCount = realizedVariableCount;
                }
            }
            return bestRealizedVariable;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private @NonNull Map<@NonNull List<@NonNull Part>, @NonNull String> synthesizeComputeMappingNames(@NonNull Map<@NonNull List<@NonNull Part>, @NonNull List<@NonNull Part>> dependentParts2commitParts) {
            HashMap<@NonNull List<@NonNull Part>, @NonNull String> dependentParts2mappingNames = new HashMap<List<Part>, String>();
            int i = 0;
            HashMap<@NonNull String, @NonNull List<@NonNull Part>> key2dependentParts = new HashMap<String, List<Part>>();
            for (List<Part> dependentParts : dependentParts2commitParts.keySet()) {
                StringBuilder s = new StringBuilder();
                for (Part dependentPart : dependentParts) {
                    s.append("_");
                    s.append(dependentPart.getName());
                }
                key2dependentParts.put(s.toString(), dependentParts);
            }
            ArrayList<@NonNull K> sortedKeys = new ArrayList(key2dependentParts.keySet());
            Collections.sort(sortedKeys);
            for (String key : sortedKeys) {
                @NonNull List dependentParts = (List)key2dependentParts.get(key);
                assert (dependentParts != null);
                String name = String.valueOf(this.mapping.getName()) + i++;
                dependentParts2mappingNames.put(dependentParts, name);
            }
            return dependentParts2mappingNames;
        }

        private @NonNull List<@NonNull NavigationAssignment> synthesizeComputePrimaryAssignments(@NonNull Map<@NonNull List<@NonNull Part>, @NonNull List<@NonNull Part>> requiredParts2requiringParts) {
            ArrayList<@NonNull NavigationAssignment> primaryAssignments = new ArrayList<NavigationAssignment>();
            for (AssignablePart assignablePart : this.allPropertyAssignments) {
                NavigationAssignment navigationAssignment;
                if (!(assignablePart instanceof PropertyAssignablePart) || (navigationAssignment = ((PropertyAssignablePart)assignablePart).getNavigationAssignment()) == null) continue;
                primaryAssignments.add(navigationAssignment);
            }
            for (List list : requiredParts2requiringParts.values()) {
                for (Part requiringPart : list) {
                    NavigationAssignment navigationAssignment;
                    if (!(requiringPart instanceof PropertyAssignablePart) || (navigationAssignment = ((PropertyAssignablePart)requiringPart).getNavigationAssignment()) == null) continue;
                    primaryAssignments.remove(navigationAssignment);
                }
            }
            return primaryAssignments;
        }

        private @NonNull List<@NonNull NavigationAssignment> synthesizeComputeSecondaryAssignments(@NonNull List<@NonNull Part> commitParts) {
            ArrayList<@NonNull NavigationAssignment> secondaryAssignments = new ArrayList<NavigationAssignment>();
            for (Part secondaryCommit : commitParts) {
                NavigationAssignment propertyAssignment;
                if (!(secondaryCommit instanceof PropertyAssignablePart) || (propertyAssignment = ((PropertyAssignablePart)secondaryCommit).getNavigationAssignment()) == null) continue;
                secondaryAssignments.add(propertyAssignment);
            }
            return secondaryAssignments;
        }

        public String toString() {
            return this.mapping.toString();
        }
    }

    protected static class PredicatePart
    extends AbstractPart {
        private final @NonNull Predicate predicate;

        public PredicatePart(@NonNull Partitioning partitioning, @NonNull Predicate predicate) {
            super(partitioning);
            this.predicate = predicate;
        }

        @Override
        public @Nullable Set<@NonNull Part> analyzeRequiredParts() {
            return this.partitioning.analyzeRequiredParts((Element)this.predicate);
        }

        @Override
        public @NonNull String getName() {
            return String.valueOf(this.predicate);
        }
    }

    protected static class PrimaryPartCreateVisitor
    extends AbstractPrimaryCreateVisitor {
        protected final @NonNull List<@NonNull NavigationAssignment> primaryAssignments;

        public PrimaryPartCreateVisitor(@NonNull QVTm2QVTp context, @NonNull List<@NonNull NavigationAssignment> primaryAssignments) {
            super(context);
            this.primaryAssignments = primaryAssignments;
        }

        @Override
        public @Nullable Element visitOppositePropertyAssignment(@NonNull OppositePropertyAssignment paIn) {
            if (this.primaryAssignments.contains(paIn)) {
                return super.visitOppositePropertyAssignment(paIn);
            }
            return null;
        }

        @Override
        public @Nullable Element visitPropertyAssignment(@NonNull PropertyAssignment paIn) {
            if (this.primaryAssignments.contains(paIn)) {
                return super.visitPropertyAssignment(paIn);
            }
            return null;
        }
    }

    protected static abstract class PropertyAssignablePart
    extends AssignablePart {
        public PropertyAssignablePart(@NonNull Partitioning partitioning) {
            super(partitioning);
        }

        public abstract @Nullable NavigationAssignment getNavigationAssignment();
    }

    protected static class PropertyPart
    extends AbstractPart {
        private final @NonNull Property property;

        public PropertyPart(@NonNull Partitioning partitioning, @NonNull Property property) {
            super(partitioning);
            this.property = property;
        }

        @Override
        public @Nullable Set<@NonNull Part> analyzeRequiredParts() {
            return null;
        }

        @Override
        public @NonNull String getName() {
            return String.valueOf(this.property.getOwningClass().getName()) + "::" + this.property.getName();
        }

        public @NonNull Property getProperty() {
            return this.property;
        }
    }

    protected static class SecondaryPartCreateVisitor
    extends AbstractPartCreateVisitor {
        protected final @NonNull String mappingName;
        protected final @NonNull List<@NonNull NavigationAssignment> primaryAssignments;
        protected final @NonNull List<@NonNull NavigationAssignment> secondaryAssignments;
        protected final @NonNull Set<@NonNull Variable> guardVariables;
        protected final @NonNull Set<@NonNull Variable> bottomVariables;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public SecondaryPartCreateVisitor(@NonNull QVTm2QVTp context, @NonNull String mappingName, @NonNull RealizedVariable secondaryHead, @NonNull List<@NonNull NavigationAssignment> primaryAssignments, @NonNull List<@NonNull NavigationAssignment> discriminantAssignments, @NonNull List<@NonNull NavigationAssignment> secondaryAssignments) {
            super(context);
            this.mappingName = mappingName;
            this.primaryAssignments = primaryAssignments;
            this.secondaryAssignments = secondaryAssignments;
            assert (primaryAssignments.containsAll(discriminantAssignments));
            assert (Sets.intersection((Set)Sets.newHashSet(primaryAssignments), (Set)Sets.newHashSet(secondaryAssignments)).isEmpty());
            @NonNull Set primaryVariables = QVTm2QVTp.computeDirectlyReferencedVariables(primaryAssignments);
            @NonNull Set discriminantVariables = QVTm2QVTp.computeDirectlyReferencedVariables(discriminantAssignments);
            @NonNull Set secondaryVariables = QVTm2QVTp.computeDirectlyReferencedVariables(secondaryAssignments);
            discriminantVariables.add(secondaryHead);
            @NonNull List indirectlyReferencedVariables = QVTm2QVTp.computeIndirectlyReferencedVariables(secondaryVariables, primaryAssignments);
            assert (indirectlyReferencedVariables.containsAll(secondaryVariables));
            assert (primaryVariables.containsAll(discriminantVariables));
            this.guardVariables = new HashSet<Variable>(primaryVariables);
            this.guardVariables.retainAll(indirectlyReferencedVariables);
            this.guardVariables.addAll(discriminantVariables);
            this.bottomVariables = new HashSet<Variable>(secondaryVariables);
            this.bottomVariables.removeAll(this.guardVariables);
        }

        protected <T extends Element> @NonNull T create2(@NonNull T source) {
            @Nullable Element target = (Element)source.accept((Visitor)this);
            assert (target != null);
            return (T)target;
        }

        @Override
        public @NonNull Mapping visitMapping(@NonNull Mapping mIn) {
            Variable vOut;
            CoreDomain dOut;
            HashMap<@Nullable TypedModel, @NonNull CoreDomain> tmIn2dOut = new HashMap<TypedModel, CoreDomain>();
            @NonNull Mapping mOut = QVTcoreFactory.eINSTANCE.createMapping();
            ((QVTm2QVTp)this.context).pushScope((NamedElement)mOut);
            ((QVTm2QVTp)this.context).addTrace((Element)mIn, (Element)mOut);
            mOut.setName(this.mappingName);
            mOut.setGuardPattern(this.create(mIn.getGuardPattern()));
            mOut.setBottomPattern(this.create(mIn.getBottomPattern()));
            this.createAll(mIn.getOwnedComments(), mOut.getOwnedComments());
            CoreDomain coreDomain = QVTcoreBaseFactory.eINSTANCE.createCoreDomain();
            ((QVTm2QVTp)this.context).addTrace((Element)mIn, (Element)coreDomain);
            GuardPattern gOut = this.create(mIn.getGuardPattern());
            BottomPattern bOut = this.create(mIn.getBottomPattern());
            assert (gOut != null && bOut != null);
            coreDomain.setGuardPattern(gOut);
            coreDomain.setBottomPattern(bOut);
            coreDomain.setIsCheckable(false);
            coreDomain.setIsEnforceable(true);
            mOut.getDomain().add((Object)coreDomain);
            tmIn2dOut.put(null, coreDomain);
            for (Domain domain : ClassUtil.nullFree((EList)mIn.getDomain())) {
                CoreDomain dIn = (CoreDomain)domain;
                CoreDomain dOut3 = this.create(dIn);
                assert (dOut3 != null);
                boolean isEnforceable = ((QVTm2QVTp)this.context).isEnforceableTransformationWide(domain);
                assert (domain.isIsEnforceable() == isEnforceable);
                mOut.getDomain().add((Object)dOut3);
                tmIn2dOut.put(dIn.getTypedModel(), dOut3);
            }
            for (Variable variable : this.guardVariables) {
                dOut = (CoreDomain)tmIn2dOut.get(this.getTypedModel(variable));
                assert (dOut != null);
                vOut = this.create(variable);
                dOut.getGuardPattern().getVariable().add((Object)vOut);
            }
            for (Variable variable : this.bottomVariables) {
                dOut = (CoreDomain)tmIn2dOut.get(this.getTypedModel(variable));
                assert (dOut != null);
                vOut = this.create(variable);
                dOut.getBottomPattern().getVariable().add((Object)vOut);
            }
            for (Assignment assignment : this.primaryAssignments) {
                if (!(assignment instanceof NavigationAssignment)) continue;
                HashSet<@NonNull E> usedVariables = new HashSet();
                NavigationAssignment paIn = (NavigationAssignment)assignment;
                if (!(paIn.getValue() instanceof VariableExp)) continue;
                QVTm2QVTp.computeDirectlyReferencedVariables(paIn, usedVariables);
                if (!this.guardVariables.containsAll(usedVariables)) continue;
                @NonNull Predicate pOut = QVTbaseFactory.eINSTANCE.createPredicate();
                ((QVTm2QVTp)this.context).addTrace((Element)assignment, (Element)pOut);
                this.createAll(assignment.getOwnedComments(), pOut.getOwnedComments());
                mOut.getGuardPattern().getPredicate().add((Object)pOut);
            }
            for (NavigationAssignment navigationAssignment : this.secondaryAssignments) {
                mOut.getBottomPattern().getAssignment().add((Object)((Assignment)this.create2(navigationAssignment)));
            }
            ((QVTm2QVTp)this.context).popScope();
            return mOut;
        }

        private @Nullable TypedModel getTypedModel(@NonNull Variable vIn) {
            CoreDomain dIn = (CoreDomain)QVTcoreBaseUtil.getContainingDomain((EObject)vIn);
            return dIn != null ? dIn.getTypedModel() : null;
        }

        @Override
        public @Nullable Element visitPredicate(@NonNull Predicate pIn) {
            return null;
        }

        @Override
        public @NonNull Variable visitRealizedVariable(@NonNull RealizedVariable rvIn) {
            return super.visitVariable((Variable)rvIn);
        }
    }

    protected static class SimpleCreateVisitor
    extends AbstractPrimaryCreateVisitor {
        public SimpleCreateVisitor(@NonNull QVTm2QVTp context) {
            super(context);
        }
    }

    protected static class UpdateVisitor
    extends AbstractQVTc2QVTc.AbstractUpdateVisitor<QVTm2QVTp> {
        public UpdateVisitor(@NonNull QVTm2QVTp context) {
            super(context);
        }

        @Override
        public @Nullable Object visitCoreModel(@NonNull CoreModel mOut) {
            return super.visitCoreModel(mOut);
        }
    }

    protected static class VariablePart
    extends AssignablePart {
        protected final @NonNull Variable variable;
        private @Nullable Map<@NonNull Property, @NonNull VariablePropertyPart> property2part = null;

        public VariablePart(@NonNull Partitioning partitioning, @NonNull Variable variable) {
            super(partitioning);
            this.variable = variable;
            OCLExpression ownedInit = variable.getOwnedInit();
            if (ownedInit != null) {
                this.setValue(ownedInit);
            }
        }

        public @Nullable VariablePropertyPart basicGetPropertyPart(@NonNull Property property) {
            Map<@NonNull Property, @NonNull VariablePropertyPart> property2part2 = this.property2part;
            if (property2part2 == null) {
                return null;
            }
            return property2part2.get(property);
        }

        @Override
        public @NonNull String getName() {
            return String.valueOf(this.variable.getName());
        }

        public @NonNull VariablePropertyPart getPropertyPart(@NonNull Property property) {
            VariablePropertyPart propertyPart;
            Map<@NonNull Property, @NonNull VariablePropertyPart> property2part2 = this.property2part;
            if (property2part2 == null) {
                this.property2part = property2part2 = new HashMap<Property, VariablePropertyPart>();
            }
            if ((propertyPart = property2part2.get(property)) == null) {
                propertyPart = new VariablePropertyPart(this.partitioning, this, property);
                property2part2.put(property, propertyPart);
            }
            return propertyPart;
        }

        public @NonNull VariablePropertyPart getPropertyPart(@NonNull NavigationAssignment navigationAssignment) {
            Property property = QVTcoreBaseUtil.getTargetProperty((NavigationAssignment)navigationAssignment);
            assert (property != null);
            VariablePropertyPart part = this.getPropertyPart(property);
            part.setNavigationAssignment(navigationAssignment);
            return part;
        }

        public @Nullable Iterable<@NonNull VariablePropertyPart> getPropertyParts() {
            return this.property2part != null ? this.property2part.values() : null;
        }

        public @NonNull Variable getVariable() {
            return this.variable;
        }
    }

    protected static class VariablePropertyPart
    extends PropertyAssignablePart {
        protected final @NonNull VariablePart variablePart;
        private final @NonNull Property property;
        private @Nullable NavigationAssignment navigationAssignment = null;

        public VariablePropertyPart(@NonNull Partitioning partitioning, @NonNull VariablePart variablePart, @NonNull Property property) {
            super(partitioning);
            this.variablePart = variablePart;
            this.property = property;
        }

        @Override
        public @Nullable Set<@NonNull Part> analyzeRequiredParts() {
            Set<@NonNull Part> requiredParts = super.analyzeRequiredParts();
            if (requiredParts == null) {
                requiredParts = new HashSet<Part>();
            }
            requiredParts.add(this.variablePart);
            return requiredParts;
        }

        @Override
        public @NonNull String getName() {
            return String.valueOf(this.variablePart.getName()) + "." + this.property.getName();
        }

        @Override
        public @Nullable NavigationAssignment getNavigationAssignment() {
            return this.navigationAssignment;
        }

        public void setNavigationAssignment(@NonNull NavigationAssignment navigationAssignment) {
            assert (this.navigationAssignment == null) : "Duplicate NavigationAssignment";
            this.navigationAssignment = navigationAssignment;
            OCLExpression value = navigationAssignment.getValue();
            assert (value != null);
            this.setValue(value);
        }
    }
}

