/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.DatumConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.EdgeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Edges;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.MergeableRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NavigationEdge;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Nodes;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region2Depth;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RootCompositionRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RootScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Scheduler;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SchedulerConstants;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleMappingRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SimpleNode;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SuperRegion;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.compiler.internal.utilities.SymbolNameBuilder;
import org.eclipse.qvtd.compiler.internal.utilities.ToDOT;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;
import org.eclipse.qvtd.pivot.schedule.AbstractAction;

public abstract class AbstractRegion
implements Region,
ToDOT.ToDOTable {
    public static final @NonNull List<@NonNull MergeableRegion> EMPTY_MERGEABLE_REGIONS = Collections.emptyList();
    protected final @NonNull SuperRegion superRegion;
    private @Nullable ScheduledRegion invokingRegion = null;
    private final @NonNull List<@NonNull Edge> edges = new ArrayList<Edge>();
    private final @NonNull List<@NonNull Node> nodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Integer> indexes = new ArrayList<Integer>();
    private final @NonNull List<@NonNull Region> callableParents = new ArrayList<Region>();
    private final @NonNull List<@NonNull Region> callableChildren = new ArrayList<Region>();
    private @Nullable Map<@NonNull TypedModel, @NonNull Set<@NonNull NavigationEdge>> typedModel2checkedEdges = null;
    private @Nullable Map<@NonNull TypedModel, @NonNull Set<@NonNull NavigationEdge>> typedModel2enforcedEdges = null;
    private @Nullable String symbolName = null;
    private final @NonNull ToDOT toDot = new ToDOT(this){};
    private @NonNull List<@NonNull NodeConnection> rootConnections = new ArrayList<NodeConnection>();
    private @NonNull List<@NonNull NodeConnection> intermediateConnections = new ArrayList<NodeConnection>();
    private boolean isCyclic = false;

    protected AbstractRegion(@NonNull SuperRegion superRegion) {
        this.superRegion = superRegion;
        superRegion.addRegion(this);
    }

    @Override
    public void addCallToChild(@NonNull Region region) {
        this.callableChildren.add(region);
        ((AbstractRegion)region).callableParents.add(this);
    }

    @Override
    public void addEdge(@NonNull Edge edge) {
        assert (!this.edges.contains(edge));
        for (Edge oldEdge : this.edges) {
            oldEdge.getEdgeRole();
            edge.getEdgeRole();
        }
        this.edges.add(edge);
    }

    private void addCheckedEdge(@NonNull NavigationEdge predicatedEdge) {
        assert (predicatedEdge.isPredicated());
        assert (predicatedEdge.getRegion() == this);
        Map<@NonNull TypedModel, @NonNull Set<@NonNull NavigationEdge>> typedModel2checkedEdges2 = this.typedModel2checkedEdges;
        assert (typedModel2checkedEdges2 != null);
        TypedModel typedModel = predicatedEdge.getSource().getClassDatumAnalysis().getTypedModel();
        Set<@NonNull NavigationEdge> checkedEdges = typedModel2checkedEdges2.get(typedModel);
        if (checkedEdges == null) {
            checkedEdges = new HashSet<NavigationEdge>();
            typedModel2checkedEdges2.put(typedModel, checkedEdges);
        }
        checkedEdges.add(predicatedEdge);
        QVTs2QVTiVisitor.POLLED_PROPERTIES.println("    checked " + predicatedEdge.getProperty() + " at " + this.getIndexRangeText() + " in " + typedModel + " for " + this);
    }

    @Override
    public void addEnforcedEdge(@NonNull NavigationEdge realizedEdge) {
        assert (realizedEdge.isRealized());
        assert (realizedEdge.getRegion() == this);
        Map<@NonNull TypedModel, @NonNull Set<@NonNull NavigationEdge>> typedModel2enforcedEdges2 = this.typedModel2enforcedEdges;
        assert (typedModel2enforcedEdges2 != null);
        TypedModel typedModel = realizedEdge.getSource().getClassDatumAnalysis().getTypedModel();
        Set<@NonNull NavigationEdge> enforcedEdges = typedModel2enforcedEdges2.get(typedModel);
        if (enforcedEdges == null) {
            enforcedEdges = new HashSet<NavigationEdge>();
            typedModel2enforcedEdges2.put(typedModel, enforcedEdges);
        }
        enforcedEdges.add(realizedEdge);
        QVTs2QVTiVisitor.POLLED_PROPERTIES.println("    enforced " + realizedEdge.getProperty() + " at " + this.getIndexRangeText() + " in " + realizedEdge.getSource().getClassDatumAnalysis().getTypedModel() + " for " + this);
    }

    @Override
    public boolean addIndex(int index) {
        int i = 0;
        while (i < this.indexes.size()) {
            Integer anIndex = this.indexes.get(i);
            if (index == anIndex) {
                return false;
            }
            if (index < anIndex) {
                this.indexes.add(i, index);
                return true;
            }
            ++i;
        }
        this.indexes.add(index);
        return true;
    }

    @Override
    public void addIntermediateConnection(@NonNull NodeConnection connection) {
        assert (!this.intermediateConnections.contains(connection));
        this.intermediateConnections.add(connection);
    }

    @Override
    public void addRootConnection(@NonNull NodeConnection connection) {
        assert (!this.rootConnections.contains(connection));
        this.rootConnections.add(connection);
    }

    @Override
    public void addNode(@NonNull Node node) {
        assert (!this.nodes.contains(node));
        this.nodes.add(node);
    }

    public void appendNode(@NonNull GraphStringBuilder s, @NonNull String nodeName) {
        String style;
        String name = String.valueOf(this.getSymbolName()) + "\\n " + this.getName();
        String indexText = this.getIndexText();
        if (indexText != null) {
            name = String.valueOf(name) + "\\n " + indexText;
        }
        s.setLabel(name);
        String shape = this.getShape();
        if (shape != null) {
            s.setShape(shape);
        }
        if ((style = this.getStyle()) != null) {
            s.setStyle(style);
        }
        s.setColor(this.getColor());
        s.appendAttributedNode(nodeName);
    }

    protected @Nullable String basicGetSymbolName() {
        return this.symbolName;
    }

    @Override
    public void buildPredicatedNavigationEdgesIndex(@NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigationEdge>>> typedModel2property2predicatedEdges) {
        for (NavigationEdge predicatedEdge : this.getPredicatedNavigationEdges()) {
            List<NavigationEdge> predicatedEdges;
            if (predicatedEdge.isCast()) continue;
            Property property = predicatedEdge.getProperty();
            Node predicatedNode = predicatedEdge.getSource();
            TypedModel typedModel = predicatedNode.getClassDatumAnalysis().getTypedModel();
            Map<@NonNull Property, @NonNull List<@NonNull NavigationEdge>> property2predicatedEdges = typedModel2property2predicatedEdges.get(typedModel);
            if (property2predicatedEdges == null) {
                property2predicatedEdges = new HashMap<Property, List<NavigationEdge>>();
                typedModel2property2predicatedEdges.put(typedModel, property2predicatedEdges);
            }
            if ((predicatedEdges = property2predicatedEdges.get(property)) == null) {
                predicatedEdges = new ArrayList<NavigationEdge>();
                property2predicatedEdges.put(property, predicatedEdges);
            }
            predicatedEdges.add(predicatedEdge);
            QVTs2QVTiVisitor.POLLED_PROPERTIES.println("  " + typedModel + " predicated for " + property);
        }
        this.typedModel2checkedEdges = new HashMap<TypedModel, Set<NavigationEdge>>();
    }

    @Override
    public void buildRealizedNavigationEdgesIndex(@NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigationEdge>>> typedModel2property2realizedEdges) {
        for (NavigationEdge realizedEdge : this.getRealizedNavigationEdges()) {
            List<NavigationEdge> realizedEdges;
            Property property = realizedEdge.getProperty();
            Node realizedNode = realizedEdge.getSource();
            TypedModel typedModel = realizedNode.getClassDatumAnalysis().getTypedModel();
            Map<@NonNull Property, @NonNull List<@NonNull NavigationEdge>> property2realizedEdges = typedModel2property2realizedEdges.get(typedModel);
            if (property2realizedEdges == null) {
                property2realizedEdges = new HashMap<Property, List<NavigationEdge>>();
                typedModel2property2realizedEdges.put(typedModel, property2realizedEdges);
            }
            if ((realizedEdges = property2realizedEdges.get(property)) == null) {
                realizedEdges = new ArrayList<NavigationEdge>();
                property2realizedEdges.put(property, realizedEdges);
            }
            realizedEdges.add(realizedEdge);
            QVTs2QVTiVisitor.POLLED_PROPERTIES.println("  " + typedModel + " realized for " + property);
        }
        this.typedModel2enforcedEdges = new HashMap<TypedModel, Set<NavigationEdge>>();
    }

    protected boolean canCreatePath(@NonNull Node startNode, @NonNull List<@NonNull NavigationEdge> protoPath) {
        Node sourceNode = startNode;
        for (NavigationEdge protoEdge : protoPath) {
            NavigationEdge edge = sourceNode.getNavigationEdge(protoEdge.getProperty());
            if (edge == null) continue;
            Node protoTarget = protoEdge.getTarget();
            Node target = edge.getTarget();
            if (target.isNull() != protoTarget.isNull()) {
                return false;
            }
            sourceNode = target;
        }
        return true;
    }

    @Override
    public @Nullable Map<@NonNull Node, @NonNull Node> canMerge(@NonNull Region secondaryRegion, @NonNull Region2Depth region2depths, boolean isLateMerge) {
        HashMap<Node, Node> secondaryNode2primaryNode = null;
        Map<@NonNull CompleteClass, @NonNull List<@NonNull Node>> completeClass2node = this.getCompleteClass2Node();
        List<@NonNull Node> secondaryHeadNodes = secondaryRegion.getHeadNodes();
        assert (secondaryHeadNodes.size() == 1);
        Node secondaryHeadNode = secondaryHeadNodes.get(0);
        CompleteClass completeClass = secondaryHeadNode.getCompleteClass();
        List<@NonNull Node> primaryNodes = completeClass2node.get(completeClass);
        if (primaryNodes != null) {
            Node primaryHeadNode = this.selectMergedHeadNode(secondaryHeadNode, primaryNodes);
            if (primaryHeadNode == null) {
                return null;
            }
            secondaryNode2primaryNode = new HashMap<Node, Node>();
            if ("if".equals(secondaryHeadNode.getName())) {
                secondaryHeadNode.getName();
            }
            secondaryNode2primaryNode.put(secondaryHeadNode, primaryHeadNode);
        }
        if (secondaryNode2primaryNode == null) {
            return null;
        }
        if (!this.canMergeInternal(secondaryRegion, secondaryNode2primaryNode, region2depths, isLateMerge)) {
            return null;
        }
        Iterable<@NonNull Node> primaryTrueNodes = this.getTrueNodes();
        Iterable<@NonNull Node> secondaryTrueNodes = secondaryRegion.getTrueNodes();
        if (Iterables.size(primaryTrueNodes) != Iterables.size(secondaryTrueNodes)) {
            return null;
        }
        for (Node primaryTrueNode : primaryTrueNodes) {
            boolean gotIt = false;
            for (Node secondaryTrueNode : secondaryTrueNodes) {
                assert (secondaryTrueNode != null);
                HashMap<@NonNull Node, @NonNull Node> primary2secondary = new HashMap<Node, Node>();
                if (!this.isEquivalent(primaryTrueNode, secondaryTrueNode, primary2secondary)) continue;
                gotIt = true;
                for (Node primaryNode : primary2secondary.keySet()) {
                    Node equivalentNode = (Node)primary2secondary.get(primaryNode);
                    assert (equivalentNode != null);
                    if ("if".equals(equivalentNode.getName())) {
                        equivalentNode.getName();
                    }
                    secondaryNode2primaryNode.put(equivalentNode, primaryNode);
                }
            }
            if (gotIt) continue;
            return null;
        }
        return secondaryNode2primaryNode;
    }

    private boolean canMergeInternal(@NonNull Region secondaryRegion, @NonNull Map<@NonNull Node, @NonNull Node> secondaryNode2primaryNode, @NonNull Region2Depth region2depths, boolean isLateMerge) {
        HashSet<@NonNull Node> secondaryNodes = new HashSet<Node>(secondaryNode2primaryNode.keySet());
        ArrayList<@NonNull Node> secondaryNodesList = new ArrayList<Node>(secondaryNodes);
        int i = 0;
        while (i < secondaryNodesList.size()) {
            Node primaryTargetNode;
            Node secondaryTargetNode;
            @NonNull Node secondarySourceNode = (Node)secondaryNodesList.get(i);
            Node primarySourceNode = secondaryNode2primaryNode.get(secondarySourceNode);
            if (primarySourceNode == null && secondarySourceNode.isPredicated()) {
                return false;
            }
            for (NavigationEdge navigationEdge : secondarySourceNode.getNavigationEdges()) {
                Node primaryTargetNode2;
                secondaryTargetNode = navigationEdge.getTarget();
                primaryTargetNode = null;
                if (primarySourceNode != null) {
                    Edge primaryEdge = primarySourceNode.getNavigationEdge(navigationEdge.getProperty());
                    if (primaryEdge != null) {
                        primaryTargetNode = primaryEdge.getTarget();
                        if (primaryTargetNode.getCompleteClass() != secondaryTargetNode.getCompleteClass()) {
                            return false;
                        }
                        if (primaryTargetNode.isNull() != secondaryTargetNode.isNull()) {
                            return false;
                        }
                    } else if (navigationEdge.isPredicated()) {
                        if (!isLateMerge) {
                            return false;
                        }
                        Iterator<Node> iterator = secondaryTargetNode.getUsedBindingSources().iterator();
                        if (iterator.hasNext()) {
                            Node secondaryOriginNode = iterator.next();
                            return false;
                        }
                    }
                }
                if (primaryTargetNode != null && (primaryTargetNode2 = secondaryNode2primaryNode.get(secondaryTargetNode)) == null) {
                    if ("if".equals(secondaryTargetNode.getName())) {
                        secondaryTargetNode.getName();
                    }
                    secondaryNode2primaryNode.put(secondaryTargetNode, primaryTargetNode);
                }
                assert (secondaryTargetNode != null);
                if (!secondaryNodes.add(secondaryTargetNode)) continue;
                secondaryNodesList.add(secondaryTargetNode);
            }
            if (!isLateMerge && primarySourceNode != null) {
                for (Edge edge : secondarySourceNode.getComputationEdges()) {
                    secondaryTargetNode = edge.getTarget();
                    primaryTargetNode = null;
                    for (Edge primaryEdge : primarySourceNode.getComputationEdges()) {
                        if (!ClassUtil.safeEquals((Object)primaryEdge.getName(), (Object)edge.getName()) || !this.isEquivalent(secondaryTargetNode, primaryTargetNode = primaryEdge.getTarget(), secondaryNode2primaryNode)) continue;
                        secondaryNodesList.add(secondaryTargetNode);
                    }
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public void checkIncomingConnections() {
    }

    @Override
    public void computeCheckedOrEnforcedEdges(@NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigationEdge>>> typedModel2property2predicatedEdges, @NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigationEdge>>> typedModel2property2realizedEdges) {
        boolean doDebug = QVTs2QVTiVisitor.POLLED_PROPERTIES.isActive();
        if (doDebug) {
            QVTs2QVTiVisitor.POLLED_PROPERTIES.println("analyzing " + this + " (" + this.getIndexRangeText() + ")");
        }
        for (NavigationEdge predicatedEdge : this.getPredicatedNavigationEdges()) {
            EdgeConnection edgeConnection;
            if (predicatedEdge.isCast()) continue;
            Property property = predicatedEdge.getProperty();
            if (doDebug) {
                QVTs2QVTiVisitor.POLLED_PROPERTIES.println("  analyzing " + predicatedEdge.getSource().getName() + "::" + property.getName() + " : " + predicatedEdge.getSource().getCompleteClass());
            }
            if ((edgeConnection = predicatedEdge.getIncomingConnection()) != null) {
                Region usedRegion;
                boolean isChecked = false;
                for (NavigationEdge usedEdge : edgeConnection.getSources()) {
                    usedRegion = usedEdge.getRegion();
                    usedRegion.addEnforcedEdge(usedEdge);
                    if (usedRegion.getFinalExecutionIndex() < this.getInvocationIndex()) continue;
                    this.addCheckedEdge(predicatedEdge);
                    isChecked = true;
                }
                if (isChecked) {
                    for (NavigationEdge usedEdge : edgeConnection.getSources()) {
                        usedRegion = usedEdge.getRegion();
                        usedRegion.addEnforcedEdge(usedEdge);
                    }
                }
            }
            Node laterNode = predicatedEdge.getSource();
            Node predicatedSourceNode = predicatedEdge.getSource();
            Node predicatedTargetNode = predicatedEdge.getTarget();
            NodeConnection usedConnection = predicatedTargetNode.getIncomingUsedConnection();
            if (usedConnection == null) continue;
            for (Node usedSourceNode : usedConnection.getSources()) {
                CompleteClass realizedTargetType;
                CompleteClass realizedSourceType;
                Node realizedTargetNode;
                Node realizedSourceNode;
                Region usedRegion = usedSourceNode.getRegion();
                if (usedRegion.getFinalExecutionIndex() < this.getInvocationIndex()) continue;
                CompleteClass predicatedSourceType = predicatedSourceNode.getCompleteClass();
                CompleteClass predicatedTargetType = predicatedTargetNode.getCompleteClass();
                ClassDatumAnalysis classDatumAnalysis = laterNode.getClassDatumAnalysis();
                TypedModel typedModel = classDatumAnalysis.getTypedModel();
                Map<@NonNull Property, @NonNull List<@NonNull NavigationEdge>> property2realizedEdges = typedModel2property2realizedEdges.get(typedModel);
                assert (property2realizedEdges != null);
                Property oclContainerProperty = this.getSchedulerConstants().getOclContainerProperty();
                if (property == oclContainerProperty) {
                    for (Property candidateProperty : property2realizedEdges.keySet()) {
                        if (!candidateProperty.isIsComposite()) continue;
                        List<@NonNull NavigationEdge> realizedEdges = property2realizedEdges.get(candidateProperty);
                        assert (realizedEdges != null);
                        for (NavigationEdge realizedEdge : realizedEdges) {
                            Region earlierRegion = realizedEdge.getRegion();
                            realizedSourceNode = realizedEdge.getSource();
                            realizedTargetNode = realizedEdge.getTarget();
                            realizedSourceType = realizedSourceNode.getCompleteClass();
                            realizedTargetType = realizedTargetNode.getCompleteClass();
                            if (realizedSourceType.conformsTo(predicatedSourceType) && realizedTargetType.conformsTo(predicatedTargetType)) assert (this.getFinalExecutionIndex() >= earlierRegion.getInvocationIndex());
                            assert (this.getFinalExecutionIndex() >= earlierRegion.getInvocationIndex());
                            this.addCheckedEdge(predicatedEdge);
                            earlierRegion.addEnforcedEdge(realizedEdge);
                        }
                    }
                    continue;
                }
                assert (property2realizedEdges != null) : "No realized typed model for " + typedModel;
                List<@NonNull NavigationEdge> realizedEdges = property2realizedEdges.get(property);
                if (realizedEdges == null) {
                    System.err.println("No realized edges for " + property + " in " + typedModel);
                    continue;
                }
                for (NavigationEdge realizedEdge : realizedEdges) {
                    String enforceIsHazardFreeBecause;
                    String checkIsHazardFreeBecause;
                    Region earlierRegion = realizedEdge.getRegion();
                    realizedSourceNode = realizedEdge.getSource();
                    realizedTargetNode = realizedEdge.getTarget();
                    realizedSourceType = realizedSourceNode.getCompleteClass();
                    realizedTargetType = realizedTargetNode.getCompleteClass();
                    if (!realizedSourceType.conformsTo(predicatedSourceType) || !realizedTargetType.conformsTo(predicatedTargetType)) {
                        checkIsHazardFreeBecause = "incompatible";
                        enforceIsHazardFreeBecause = "incompatible";
                    } else if (this == earlierRegion) {
                        checkIsHazardFreeBecause = null;
                        enforceIsHazardFreeBecause = null;
                    } else if (earlierRegion.getFinalExecutionIndex() < this.getInvocationIndex()) {
                        checkIsHazardFreeBecause = "later";
                        enforceIsHazardFreeBecause = null;
                    } else {
                        checkIsHazardFreeBecause = null;
                        enforceIsHazardFreeBecause = null;
                    }
                    if (checkIsHazardFreeBecause == null) {
                        this.addCheckedEdge(predicatedEdge);
                    } else if (doDebug) {
                        QVTs2QVTiVisitor.POLLED_PROPERTIES.println("    ignored check for " + this + "::" + laterNode.getName() + "(" + this.getIndexRangeText() + ")" + " " + checkIsHazardFreeBecause + " (" + earlierRegion.getIndexRangeText() + ")" + earlierRegion + "::" + realizedEdge.getSource().getName());
                    }
                    if (enforceIsHazardFreeBecause == null) {
                        earlierRegion.addEnforcedEdge(realizedEdge);
                        continue;
                    }
                    if (!doDebug) continue;
                    QVTs2QVTiVisitor.POLLED_PROPERTIES.println("    ignored enforce " + this + "::" + laterNode.getName() + "(" + this.getIndexRangeText() + ")" + " " + enforceIsHazardFreeBecause + " (" + earlierRegion.getIndexRangeText() + ")" + earlierRegion + "::" + realizedEdge.getSource().getName());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull SymbolNameBuilder computeSymbolName() {
        void var2_9;
        void var2_7;
        ArrayList<String> names = new ArrayList<String>();
        for (Region region : this.getAllMappingRegions()) {
            names.add(region.getName());
        }
        Collections.sort(names);
        Object var2_4 = null;
        @NonNull Object bestToOneSubRegion = null;
        Node bestNamingNode = null;
        for (Node node : this.getRealizedNodes()) {
            Iterator<@NonNull E> toOneSubRegion = this.computeToOneSubRegion(new HashSet<Node>(), node);
            if (bestToOneSubRegion == null || toOneSubRegion.size() > bestToOneSubRegion.size()) {
                bestToOneSubRegion = toOneSubRegion;
                bestNamingNode = node;
                continue;
            }
            if (bestNamingNode == null || toOneSubRegion.size() != bestToOneSubRegion.size() || ClassUtil.safeCompareTo((Comparable)((Object)bestNamingNode.getCompleteClass().getName()), (Comparable)((Object)node.getCompleteClass().getName())) <= 0) continue;
            bestToOneSubRegion = toOneSubRegion;
            bestNamingNode = node;
        }
        if (bestNamingNode != null) {
            SymbolNameBuilder symbolNameBuilder = new SymbolNameBuilder();
            symbolNameBuilder.appendString("m_");
            symbolNameBuilder.appendName(bestNamingNode.getCompleteClass().getName());
            ArrayList<@NonNull String> headNames = new ArrayList<String>();
            for (Node headNode : this.getHeadNodes()) {
                String name = headNode.getCompleteClass().getName();
                if (name == null) continue;
                headNames.add(name);
            }
            for (String headName : headNames) {
                symbolNameBuilder.appendString("_");
                symbolNameBuilder.appendString(headName);
            }
        } else {
            Iterator<Node> iterator = this.getHeadNodes().iterator();
            if (iterator.hasNext()) {
                @NonNull Node headNode = iterator.next();
                SymbolNameBuilder symbolNameBuilder = new SymbolNameBuilder();
                symbolNameBuilder.appendString("m_");
                symbolNameBuilder.appendName(headNode.getCompleteClass().getName());
                ArrayList<String> edgeNames = new ArrayList<String>();
                for (NavigationEdge edge : headNode.getNavigationEdges()) {
                    String propertyName = edge.getProperty().getName();
                    edgeNames.add(edge.getTarget().isNull() ? String.valueOf(propertyName) + "0" : propertyName);
                }
                Collections.sort(edgeNames);
                for (String edgeName : edgeNames) {
                    symbolNameBuilder.appendString("_");
                    symbolNameBuilder.appendName(edgeName);
                }
            }
        }
        if (var2_7 == null) {
            SymbolNameBuilder symbolNameBuilder = new SymbolNameBuilder();
            symbolNameBuilder.appendString("m_");
        }
        return var2_9;
    }

    private @NonNull Set<@NonNull Node> computeToOneSubRegion(@NonNull Set<@NonNull Node> toOneSubRegion, @NonNull Node atNode) {
        if (toOneSubRegion.add(atNode)) {
            for (NavigationEdge edge : atNode.getNavigationEdges()) {
                assert (edge.getSource() == atNode);
                Property source2target = edge.getProperty();
                if (source2target.isIsMany() || source2target.isIsImplicit()) continue;
                this.computeToOneSubRegion(toOneSubRegion, edge.getTarget());
            }
        }
        return toOneSubRegion;
    }

    private void createEdgeConnection(@NonNull NavigationEdge predicatedEdge) {
        assert (predicatedEdge.isNavigation());
        assert (predicatedEdge.getIncomingConnection() == null);
        if (predicatedEdge.isCast()) {
            return;
        }
        Property predicatedProperty = predicatedEdge.getProperty();
        if (predicatedProperty.isIsImplicit()) {
            return;
        }
        ScheduledRegion invokingRegion2 = this.invokingRegion;
        assert (invokingRegion2 != null);
        RootScheduledRegion rootScheduledRegion = invokingRegion2.getRootScheduledRegion();
        NavigationEdge castEdge = RegionUtil.getCastTarget(predicatedEdge);
        Node castTarget = RegionUtil.getCastTarget(castEdge.getTarget());
        ClassDatumAnalysis classDatumAnalysis = castTarget.getClassDatumAnalysis();
        if (classDatumAnalysis.getCompleteClass().getPrimaryClass() instanceof DataType) {
            Iterable<@NonNull NavigationEdge> realizedEdges = rootScheduledRegion.getRealizedEdges(predicatedEdge, classDatumAnalysis);
            if (realizedEdges != null) {
                ArrayList<@NonNull Node> sourceNodes = new ArrayList<Node>();
                for (NavigationEdge realizedEdge : realizedEdges) {
                    if (!RegionUtil.isConformantSource(realizedEdge, predicatedEdge) || !RegionUtil.isConformantTarget(realizedEdge, predicatedEdge)) continue;
                    sourceNodes.add(realizedEdge.getTarget());
                }
                NodeConnection nodeConnection = invokingRegion2.getAttributeConnection(sourceNodes, predicatedEdge.getSource().getCompleteClass(), predicatedProperty, classDatumAnalysis);
                nodeConnection.addUsedTargetNode(castTarget, false);
                if (Scheduler.CONNECTION_CREATION.isActive()) {
                    Scheduler.CONNECTION_CREATION.println("  Attribute NodeConnection to " + castTarget);
                }
            }
        } else {
            Iterable<@NonNull Node> sourceNodes = rootScheduledRegion.getIntroducingOrProducingNodes(classDatumAnalysis);
            Iterable<@NonNull NavigationEdge> realizedEdges = rootScheduledRegion.getRealizedEdges(predicatedEdge, classDatumAnalysis);
            if (realizedEdges != null) {
                HashSet<@NonNull Region> edgeSourceRegions = new HashSet<Region>();
                HashSet<@NonNull Region> nodeSourceRegions = new HashSet<Region>();
                for (NavigationEdge realizedEdge : realizedEdges) {
                    edgeSourceRegions.add(realizedEdge.getRegion());
                }
                if (sourceNodes != null) {
                    for (Node sourceNode : sourceNodes) {
                        nodeSourceRegions.add(sourceNode.getRegion());
                    }
                }
                if (!nodeSourceRegions.containsAll(edgeSourceRegions)) {
                    EdgeConnection edgeConnection;
                    HashSet<Region> conformantEdgeSourceRegions = null;
                    ArrayList<NavigationEdge> thoseEdges = null;
                    for (NavigationEdge realizedEdge : realizedEdges) {
                        if (!RegionUtil.isConformantSource(realizedEdge, predicatedEdge) || !RegionUtil.isConformantTarget(realizedEdge, predicatedEdge)) continue;
                        if (thoseEdges == null) {
                            thoseEdges = new ArrayList<NavigationEdge>();
                            conformantEdgeSourceRegions = new HashSet<Region>();
                        }
                        if (thoseEdges.contains(realizedEdge)) continue;
                        thoseEdges.add(realizedEdge);
                        assert (conformantEdgeSourceRegions != null);
                        conformantEdgeSourceRegions.add(realizedEdge.getRegion());
                    }
                    if (thoseEdges != null && !nodeSourceRegions.containsAll(conformantEdgeSourceRegions) && !Iterables.contains((edgeConnection = invokingRegion2.getEdgeConnection(thoseEdges, predicatedProperty)).getTargetEdges(), (Object)castEdge)) {
                        edgeConnection.addUsedTargetEdge(castEdge, false);
                        if (Scheduler.CONNECTION_CREATION.isActive()) {
                            Scheduler.CONNECTION_CREATION.println("  EdgeConnection to " + castEdge);
                        }
                    }
                }
            }
            if (!(sourceNodes == null || castTarget.isLoaded() || castTarget.isConstant() || castTarget.isHead() || castTarget.isOperation() || castTarget.isTrue() || castTarget.getIncomingConnection() != null)) {
                NodeConnection predicatedConnection = invokingRegion2.getNodeConnection(sourceNodes, classDatumAnalysis);
                predicatedConnection.addUsedTargetNode(castTarget, false);
                if (Scheduler.CONNECTION_CREATION.isActive()) {
                    Scheduler.CONNECTION_CREATION.println("  NodeConnection from " + castTarget);
                }
            }
        }
    }

    private @Nullable NodeConnection createHeadConnection(@NonNull Node headNode) {
        ScheduledRegion invokingRegion2 = this.invokingRegion;
        assert (invokingRegion2 != null);
        RootScheduledRegion rootScheduledRegion = invokingRegion2.getRootScheduledRegion();
        ClassDatumAnalysis classDatumAnalysis = headNode.getClassDatumAnalysis();
        ArrayList<Node> headSources = null;
        Iterable<@NonNull Node> sourceNodes = rootScheduledRegion.getIntroducingOrProducingNodes(headNode);
        if (sourceNodes != null) {
            for (Node sourceNode : sourceNodes) {
                HashMap<Node, Node> called2calling;
                Region sourceRegion = sourceNode.getRegion();
                if (sourceRegion == this || !this.isCompatiblePattern(headNode, sourceNode, called2calling = new HashMap<Node, Node>())) continue;
                if (headSources == null) {
                    headSources = new ArrayList<Node>();
                }
                headSources.add(sourceNode);
            }
        }
        if (headSources == null) {
            return null;
        }
        NodeConnection headConnection = invokingRegion2.getNodeConnection(headSources, classDatumAnalysis);
        if (headNode.getNodeRole().isExtraGuardVariable()) {
            headConnection.addUsedTargetNode(headNode, false);
        } else {
            headConnection.addPassedTargetNode(headNode);
        }
        if (Scheduler.CONNECTION_CREATION.isActive()) {
            Scheduler.CONNECTION_CREATION.println("  Head NodeConnection to " + headNode);
            for (Node sourceNode : headSources) {
                Scheduler.CONNECTION_CREATION.println("    from " + sourceNode);
            }
        }
        return headConnection;
    }

    private @Nullable Iterable<@NonNull NodeConnection> createHeadConnections() {
        ArrayList<@NonNull NodeConnection> headConnections = null;
        for (Node headNode : this.getHeadNodes()) {
            if (headNode.isInternal()) continue;
            NodeConnection headConnection = this.createHeadConnection(headNode);
            if (headConnection == null) {
                if (headNode.getNodeRole().isExtraGuardVariable()) continue;
                System.err.println("createHeadConnections abandoned for " + headNode + " of " + this);
                return null;
            }
            if (headConnections == null) {
                headConnections = new ArrayList<NodeConnection>();
            }
            headConnections.add(headConnection);
        }
        return headConnections;
    }

    @Override
    public void createIncomingConnections() {
        if (Scheduler.CONNECTION_CREATION.isActive()) {
            Scheduler.CONNECTION_CREATION.println("connecting " + this);
        }
        assert (!(this instanceof RootCompositionRegion));
        Iterable<@NonNull NodeConnection> headConnections = this.createHeadConnections();
        if (headConnections != null) {
            for (NavigationEdge predicatedEdge : this.getPredicatedNavigationEdges()) {
                this.createEdgeConnection(predicatedEdge);
            }
        }
    }

    protected @Nullable Map<@NonNull Node, @NonNull Node> expandRecursion(@NonNull Node nextNode, @NonNull Node prevNode, @NonNull Map<@NonNull Node, @NonNull Node> bindings) {
        Node oldPrevNode = bindings.put(nextNode, prevNode);
        if (oldPrevNode != null) {
            assert (oldPrevNode == prevNode);
            return bindings;
        }
        for (NavigationEdge navigationEdge : prevNode.getNavigationEdges()) {
            Node nextTarget = nextNode.getNavigationTarget(navigationEdge.getProperty());
            if (nextTarget == null) {
                return null;
            }
            Node prevTarget = navigationEdge.getTarget();
            if (this.expandRecursion(nextTarget, prevTarget, bindings) != null) continue;
            return null;
        }
        return bindings;
    }

    @Override
    public @NonNull Iterable<@NonNull SimpleMappingRegion> getAllMappingRegions() {
        return SchedulerConstants.EMPTY_MAPPING_REGION_SET;
    }

    @Override
    public @NonNull Iterable<@NonNull Node> getAncestorsOf(@NonNull Node node) {
        ArrayList<@NonNull Node> ancestors = new ArrayList<Node>();
        HashSet<@NonNull Node> ancestorSet = new HashSet<Node>();
        node.getAllAncestors(ancestorSet);
        for (Node ancestor : ancestorSet) {
            if (ancestor.getRegion() != this) continue;
            ancestors.add(ancestor);
        }
        return ancestors;
    }

    public @NonNull SimpleNode getAssignedAttributeNode(@NonNull SimpleNode parentNode, @NonNull Property property) {
        assert (parentNode.isClassNode());
        assert (property.getType() instanceof DataType);
        SimpleNode node = parentNode.getNavigationTarget(property);
        if (node == null) {
            node = Nodes.REALIZED_ATTRIBUTE.createSimpleNode(parentNode.getRegion(), parentNode, property);
        }
        return node;
    }

    @Override
    public final @NonNull Iterable<@NonNull Node> getAssignedNodes() {
        return Iterables.filter(this.nodes, (Predicate)IsAssignedNodePredicate.INSTANCE);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public final @NonNull Iterable<@NonNull NavigationEdge> getAssignmentEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.edges, (Predicate)IsAssignmentEdgePredicate.INSTANCE);
        return filter;
    }

    protected @Nullable List<@NonNull NavigationEdge> getBestPath(@Nullable List<@NonNull NavigationEdge> bestPath, @Nullable List<@NonNull NavigationEdge> candidatePath) {
        if (bestPath == null) {
            return candidatePath;
        }
        if (candidatePath == null) {
            return bestPath;
        }
        int bestCost = this.getCost(bestPath);
        int candidateCost = this.getCost(candidatePath);
        if (candidateCost < bestCost) {
            return candidatePath;
        }
        return bestPath;
    }

    private @NonNull NavigationEdge getBestEdge(@Nullable NavigationEdge bestEdge, @NonNull NavigationEdge candidateEdge) {
        if (bestEdge == null) {
            return candidateEdge;
        }
        if (bestEdge.getProperty().isIsImplicit() && !candidateEdge.getProperty().isIsImplicit()) {
            return candidateEdge;
        }
        return bestEdge;
    }

    @Override
    public @NonNull Iterable<@NonNull Region> getCallableChildren() {
        return this.callableChildren;
    }

    @Override
    public @NonNull Iterable<@NonNull Region> getCallableParents() {
        return this.callableParents;
    }

    public @NonNull List<@NonNull Region> getCalledRegions() {
        ArrayList<@NonNull Region> childRegions = new ArrayList<Region>();
        for (NodeConnection childConnection : this.getOutgoingPassedConnections()) {
            for (Node childNode : childConnection.getTargetNodes()) {
                Region childRegion = childNode.getRegion();
                if (childRegions.contains(childRegion)) continue;
                childRegions.add(childRegion);
            }
        }
        return childRegions;
    }

    public @NonNull List<@NonNull Region> getCallingRegions() {
        ArrayList<@NonNull Region> callingRegions = new ArrayList<Region>();
        for (NodeConnection callingConnection : this.getIncomingPassedConnections()) {
            for (Node callingNode : callingConnection.getSources()) {
                Region callingRegion = callingNode.getRegion();
                if (callingRegions.contains(callingRegion)) continue;
                callingRegions.add(callingRegion);
            }
        }
        return callingRegions;
    }

    public @Nullable Set<@NonNull NavigationEdge> getCheckedEdges(@NonNull TypedModel typedModel) {
        assert (this.typedModel2checkedEdges != null);
        return this.typedModel2checkedEdges.get(typedModel);
    }

    @Override
    public @NonNull ClassDatumAnalysis getClassDatumAnalysis(@NonNull TypedElement typedElement) {
        return this.getSchedulerConstants().getClassDatumAnalysis(typedElement);
    }

    @Override
    public @NonNull String getColor() {
        return "blue";
    }

    private @NonNull Map<@NonNull CompleteClass, @NonNull List<@NonNull Node>> getCompleteClass2Node() {
        HashMap<@NonNull CompleteClass, @NonNull List<@NonNull Node>> completeClass2node = new HashMap<CompleteClass, List<Node>>();
        for (Node node : this.getNodes()) {
            CompleteClass completeClass = node.getCompleteClass();
            ArrayList<@NonNull Node> mergedNodes = (ArrayList<Node>)completeClass2node.get(completeClass);
            if (mergedNodes == null) {
                mergedNodes = new ArrayList<Node>();
                completeClass2node.put(completeClass, mergedNodes);
            }
            if (mergedNodes.contains(node)) continue;
            mergedNodes.add(node);
        }
        return completeClass2node;
    }

    @Override
    public final @NonNull Iterable<@NonNull Node> getComposedNodes() {
        return Iterables.filter(this.nodes, (Predicate)IsComposedNodePredicate.INSTANCE);
    }

    public final @NonNull Iterable<@NonNull Node> getComputedNodes() {
        return Iterables.filter(this.nodes, (Predicate)IsComputedPredicate.INSTANCE);
    }

    private int getCost(@NonNull List<@NonNull NavigationEdge> path) {
        int cost = 0;
        for (NavigationEdge edge : path) {
            if (!edge.getProperty().isIsImplicit()) continue;
            ++cost;
        }
        return cost;
    }

    @Override
    public @NonNull Collection<@NonNull Edge> getEdges() {
        return this.edges;
    }

    public @Nullable Set<@NonNull NavigationEdge> getEnforcedEdges(@NonNull TypedModel typedModel) {
        assert (this.typedModel2enforcedEdges != null);
        return this.typedModel2enforcedEdges.get(typedModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull Edge> getExpressionEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.edges, (Predicate)IsExpressionEdgePredicate.INSTANCE);
        return filter;
    }

    @Override
    public int getFinalExecutionIndex() {
        assert (this.indexes.size() > 0);
        return this.indexes.get(this.indexes.size() - 1);
    }

    @Override
    public final @NonNull Iterable<@NonNull Node> getGuardNodes() {
        return Iterables.filter(this.nodes, (Predicate)IsGuardNodePredicate.INSTANCE);
    }

    @Override
    public final @NonNull Iterable<@NonNull Node> getGuardVariableNodes() {
        return Iterables.filter(this.nodes, (Predicate)IsGuardVariableNodePredicate.INSTANCE);
    }

    @Override
    public @NonNull Iterable<@NonNull DatumConnection> getIncomingConnections() {
        DatumConnection connection;
        ArrayList<@NonNull DatumConnection> connections = new ArrayList<DatumConnection>();
        for (Node headNode : this.getHeadNodes()) {
            connection = headNode.getIncomingPassedConnection();
            if (connection == null || connections.contains(connection)) continue;
            connections.add(connection);
        }
        for (Node node : this.getPredicatedNodes()) {
            connection = node.getIncomingUsedConnection();
            if (connection == null || connections.contains(connection)) continue;
            connections.add(connection);
        }
        for (NavigationEdge edge : this.getPredicatedNavigationEdges()) {
            connection = edge.getIncomingConnection();
            if (connection == null || connections.contains(connection)) continue;
            connections.add(connection);
        }
        return connections;
    }

    @Override
    public @NonNull Iterable<@NonNull NodeConnection> getIncomingPassedConnections() {
        ArrayList<@NonNull NodeConnection> connections = new ArrayList<NodeConnection>();
        for (Node headNode : this.getHeadNodes()) {
            NodeConnection connection = headNode.getIncomingPassedConnection();
            if (connection == null) continue;
            connections.add(connection);
        }
        return connections;
    }

    @Override
    public @NonNull Iterable<@NonNull NodeConnection> getIncomingUsedConnections() {
        ArrayList<@NonNull NodeConnection> connections = new ArrayList<NodeConnection>();
        for (Node node : this.getPredicatedNodes()) {
            NodeConnection connection = node.getIncomingUsedConnection();
            if (connection == null) continue;
            connections.add(connection);
        }
        return connections;
    }

    @Override
    public @NonNull String getIndexRangeText() {
        return String.valueOf(this.getInvocationIndex()) + ".." + this.getFinalExecutionIndex();
    }

    public @Nullable String getIndexText() {
        StringBuilder s = null;
        for (Integer index : this.indexes) {
            if (s == null) {
                s = new StringBuilder();
            } else {
                s.append(",");
            }
            s.append(index.toString());
        }
        return s != null ? s.toString() : null;
    }

    @Override
    public @NonNull List<@NonNull Integer> getIndexes() {
        return this.indexes;
    }

    @Override
    public @NonNull List<@NonNull NodeConnection> getIntermediateConnections() {
        return this.intermediateConnections;
    }

    @Override
    public int getInvocationIndex() {
        assert (this.indexes.size() > 0);
        return this.indexes.get(0);
    }

    @Override
    public @Nullable ScheduledRegion getInvokingRegion() {
        return this.invokingRegion;
    }

    @Override
    public @NonNull List<@NonNull DatumConnection> getLoopingConnections() {
        ArrayList<@NonNull DatumConnection> loopingConnections = new ArrayList<DatumConnection>();
        for (DatumConnection connection : this.getOutgoingConnections()) {
            for (Region sourceRegion : connection.getSourceRegions()) {
                if (this != sourceRegion) continue;
                for (Region targetRegion : connection.getTargetRegions()) {
                    if (this != targetRegion || loopingConnections.contains(connection)) continue;
                    loopingConnections.add(connection);
                }
            }
        }
        return loopingConnections;
    }

    public @NonNull SimpleMappingRegion getMappingRegion(@NonNull AbstractAction action) {
        return this.superRegion.getMappingRegion(action);
    }

    @Override
    public final @NonNull Iterable<@NonNull Node> getMatchableNodes() {
        return Iterables.filter(this.nodes, (Predicate)IsMatchableNodePredicate.INSTANCE);
    }

    @Override
    public @NonNull Iterable<@NonNull MergeableRegion> getMergeableRegions() {
        return EMPTY_MERGEABLE_REGIONS;
    }

    @Override
    public @NonNull String getName() {
        ArrayList<@NonNull String> names = new ArrayList<String>();
        for (Region region : this.getAllMappingRegions()) {
            names.add(region.getName());
        }
        Collections.sort(names);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        for (String name : names) {
            stringBuilder.append("\n");
            stringBuilder.append(name);
        }
        return stringBuilder.toString();
    }

    @Override
    public final @NonNull Iterable<@NonNull Node> getNavigableNodes() {
        return Iterables.filter(this.nodes, (Predicate)IsNavigableNodePredicate.INSTANCE);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull NavigationEdge> getNavigationEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.edges, NavigationEdge.class);
        return filter;
    }

    @Override
    public @NonNull Collection<@NonNull Node> getNodes() {
        return this.nodes;
    }

    @Override
    public @NonNull Iterable<@NonNull DatumConnection> getNextConnections() {
        return this.getOutgoingConnections();
    }

    public @NonNull List<@NonNull DatumConnection> getOutgoingConnections() {
        ArrayList<@NonNull DatumConnection> connections = new ArrayList<DatumConnection>();
        for (Node node : this.getNodes()) {
            for (NodeConnection nodeConnection : node.getOutgoingPassedConnections()) {
                connections.add(nodeConnection);
            }
            for (NodeConnection nodeConnection : node.getOutgoingUsedBindingEdges()) {
                connections.add(nodeConnection);
            }
        }
        for (NavigationEdge edge : this.getNavigationEdges()) {
            for (EdgeConnection edgeConnection : edge.getOutgoingConnections()) {
                connections.add(edgeConnection);
            }
        }
        return connections;
    }

    @Override
    public @NonNull Iterable<@NonNull NodeConnection> getOutgoingPassedConnections() {
        ArrayList<@NonNull NodeConnection> connections = new ArrayList<NodeConnection>();
        for (Node node : this.getNodes()) {
            for (NodeConnection connection : node.getOutgoingPassedConnections()) {
                connections.add(connection);
            }
        }
        return connections;
    }

    @Override
    public @NonNull Iterable<@NonNull NodeConnection> getOutgoingUsedConnections() {
        ArrayList<@NonNull NodeConnection> connections = new ArrayList<NodeConnection>();
        for (Node node : this.getNodes()) {
            for (NodeConnection connection : node.getOutgoingUsedBindingEdges()) {
                connections.add(connection);
            }
        }
        return connections;
    }

    protected @Nullable List<@NonNull NavigationEdge> getPath(@NonNull Node sourceNode, @NonNull Node targetNode, @NonNull Set<@NonNull Edge> usedEdges) {
        assert (sourceNode.getRegion() == targetNode.getRegion());
        NavigationEdge bestEdge = null;
        List<NavigationEdge> bestPath = null;
        for (NavigationEdge edge : sourceNode.getNavigationEdges()) {
            if (usedEdges.contains(edge) || edge.getProperty().isIsMany() || edge.isRealized()) continue;
            if (edge.getTarget() == targetNode) {
                bestEdge = this.getBestEdge(bestEdge, edge);
                continue;
            }
            HashSet<@NonNull Edge> moreUsedEdges = new HashSet<Edge>(usedEdges);
            moreUsedEdges.add(edge);
            List<@NonNull NavigationEdge> tailPath = this.getPath(edge.getTarget(), targetNode, moreUsedEdges);
            if (tailPath != null) {
                tailPath = new ArrayList<NavigationEdge>(tailPath);
                tailPath.add(0, edge);
            }
            bestPath = this.getBestPath(bestPath, tailPath);
        }
        if (bestEdge == null) {
            return bestPath;
        }
        if (bestPath == null) {
            return Collections.singletonList(bestEdge);
        }
        return this.getBestPath(Collections.singletonList(bestEdge), bestPath);
    }

    public @NonNull SimpleNode getPredicatedAttributeNode(@NonNull SimpleNode parentNode, @NonNull NavigationCallExp navigationCallExp) {
        assert (parentNode.isClassNode());
        Property referredProperty = PivotUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
        assert (referredProperty != null);
        SimpleNode node = parentNode.getNavigationTarget(referredProperty);
        if (node == null) {
            node = Nodes.ATTRIBUTE.createSimpleNode(parentNode.getRegion(), parentNode, navigationCallExp);
        }
        return node;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public final @NonNull Iterable<NavigationEdge> getPredicateEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.edges, (Predicate)IsPredicatedEdgePredicate.INSTANCE);
        return filter;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull NavigationEdge> getPredicatedNavigationEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.edges, (Predicate)IsPredicatedNavigationEdgePredicate.INSTANCE);
        return filter;
    }

    @Override
    public final @NonNull Iterable<@NonNull Node> getPredicatedNodes() {
        return Iterables.filter(this.nodes, (Predicate)IsPredicatedNodePredicate.INSTANCE);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull Edge> getRealizedEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.edges, (Predicate)IsRealizedEdgePredicate.INSTANCE);
        return filter;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull NavigationEdge> getRealizedNavigationEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.edges, (Predicate)IsRealizedNavigationEdgePredicate.INSTANCE);
        return filter;
    }

    @Override
    public final @NonNull Iterable<@NonNull Node> getRealizedNodes() {
        return Iterables.filter(this.nodes, (Predicate)IsRealizedNodePredicate.INSTANCE);
    }

    @Override
    public final @NonNull Iterable<@NonNull Node> getRealizedVariableNodes() {
        return Iterables.filter(this.nodes, (Predicate)IsRealizedVariableNodePredicate.INSTANCE);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public final @NonNull Iterable<@NonNull Edge> getRecursionEdges() {
        @NonNull @NonNull Iterable filter = Iterables.filter(this.edges, (Predicate)IsRecursionEdgePredicate.INSTANCE);
        return filter;
    }

    @Override
    public @NonNull List<@NonNull NodeConnection> getRootConnections() {
        return this.rootConnections;
    }

    @Override
    public @NonNull SchedulerConstants getSchedulerConstants() {
        return this.superRegion.getSchedulerConstants();
    }

    @Override
    public @Nullable String getShape() {
        return null;
    }

    @Override
    public @Nullable String getStyle() {
        return null;
    }

    @Override
    public @NonNull SuperRegion getSuperRegion() {
        return this.superRegion;
    }

    @Override
    public final @NonNull String getSymbolName() {
        String symbolName2 = this.symbolName;
        if (symbolName2 == null) {
            this.symbolName = symbolName2 = this.getSchedulerConstants().reserveSymbolName(this.computeSymbolName(), this);
        }
        return symbolName2;
    }

    @Override
    public final @NonNull Iterable<@NonNull Node> getTrueNodes() {
        return Iterables.filter(this.nodes, (Predicate)IsTrueNodePredicate.INSTANCE);
    }

    @Override
    public @NonNull List<@NonNull NodeConnection> getUsedConnections() {
        ArrayList<@NonNull NodeConnection> usedConnections = new ArrayList<NodeConnection>();
        for (Node node : this.getPredicatedNodes()) {
            NodeConnection connection = node.getIncomingUsedConnection();
            if (connection == null) continue;
            usedConnections.add(connection);
        }
        return usedConnections;
    }

    private boolean isCompatiblePattern(@NonNull Node calledNode, @NonNull Node callingNode, @NonNull Map<@NonNull Node, @NonNull Node> called2calling) {
        Node oldPrevNode = called2calling.put(calledNode, callingNode);
        if (oldPrevNode != null) {
            return oldPrevNode == callingNode;
        }
        for (NavigationEdge calledEdge : calledNode.getNavigationEdges()) {
            NavigationEdge nextCallingEdge;
            Node nextCalledNode = calledEdge.getTarget();
            if (nextCalledNode.isRealized() || nextCalledNode.isAttributeNode() || (nextCallingEdge = callingNode.getNavigationEdge(calledEdge.getProperty())) == null) continue;
            Node nextCallingNode = nextCallingEdge.getTarget();
            if (nextCallingNode.isNull() != nextCalledNode.isNull()) {
                return false;
            }
            if (this.isCompatiblePattern(nextCalledNode, nextCallingNode, called2calling)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isChildCompositionRegion() {
        return false;
    }

    @Override
    public boolean isCyclicScheduledRegion() {
        return false;
    }

    private boolean isEquivalent(@NonNull Node primaryNode, @NonNull Node secondaryNode, @NonNull Map<@NonNull Node, @NonNull Node> primary2secondary) {
        Node node = primary2secondary.get(primaryNode);
        if (node != null) {
            return node == secondaryNode;
        }
        if (primaryNode.getNodeRole() != secondaryNode.getNodeRole()) {
            return false;
        }
        if (!ClassUtil.safeEquals((Object)primaryNode.getName(), (Object)secondaryNode.getName())) {
            return false;
        }
        HashMap<@NonNull Node, @NonNull Node> nestedPrimary2secondary = new HashMap<Node, Node>(primary2secondary);
        nestedPrimary2secondary.put(primaryNode, secondaryNode);
        for (Edge primaryEdge : primaryNode.getArgumentEdges()) {
            boolean gotIt = false;
            for (Edge secondaryEdge : secondaryNode.getArgumentEdges()) {
                if (!ClassUtil.safeEquals((Object)primaryEdge.getName(), (Object)secondaryEdge.getName())) continue;
                if (!this.isEquivalent(primaryEdge.getSource(), secondaryEdge.getSource(), nestedPrimary2secondary)) {
                    return false;
                }
                gotIt = true;
                break;
            }
            if (gotIt) continue;
            return false;
        }
        primary2secondary.putAll(nestedPrimary2secondary);
        return true;
    }

    @Override
    public boolean isLateMergeable(@NonNull Region consumerRegion, @NonNull Region2Depth region2depths) {
        return true;
    }

    @Override
    public boolean isOperationRegion() {
        return false;
    }

    @Override
    public boolean isRootCompositionRegion() {
        return false;
    }

    @Override
    public void refineBindings(@NonNull Region bindingRegion) {
        this.refineHeadBindings(bindingRegion);
    }

    protected void refineHeadBindings(@NonNull Region bindingRegion) {
    }

    @Override
    public void removeEdge(@NonNull Edge edge) {
        boolean wasRemoved = this.edges.remove(edge);
        assert (wasRemoved);
    }

    @Override
    public void removeNode(@NonNull Node node) {
        boolean wasRemoved = this.nodes.remove(node);
        assert (wasRemoved);
    }

    public void resolveRecursion() {
        Map<@NonNull CompleteClass, @NonNull List<@NonNull Node>> completeClass2node = this.getCompleteClass2Node();
        List<@NonNull Node> headNodes = this.getHeadNodes();
        if (headNodes.size() == 1) {
            Node headNode = headNodes.get(0);
            List<@NonNull Node> nodeList = completeClass2node.get(headNode.getCompleteClass());
            assert (nodeList != null);
            if (nodeList.size() > 1) {
                for (Node node : nodeList) {
                    Map<Node, Node> bindings;
                    if (node == headNode || (bindings = this.expandRecursion(headNode, node, new HashMap<Node, Node>())) == null) continue;
                    for (Map.Entry<Node, Node> entry : bindings.entrySet()) {
                        @NonNull Node prevNode = entry.getKey();
                        @NonNull Node nextNode = entry.getValue();
                        (prevNode.isHead() ? Edges.PRIMARY_RECURSION : Edges.SECONDARY_RECURSION).createEdge(this, prevNode, nextNode);
                    }
                    return;
                }
            }
        }
    }

    protected @NonNull Node selectBestHeadNode(@NonNull List<@NonNull Node> headNodes) {
        int size = headNodes.size();
        assert (size >= 1);
        if (size == 1) {
            return headNodes.get(0);
        }
        Node bestHeadNode = null;
        int bestNonImplicits = -1;
        ArrayList<@NonNull Node> sortedHeadNodes = new ArrayList<Node>(headNodes);
        Collections.sort(sortedHeadNodes, NameUtil.NAMEABLE_COMPARATOR);
        for (Node thisHeadNode : sortedHeadNodes) {
            int nonImplicits = 0;
            block1: for (Node thatHeadNode : sortedHeadNodes) {
                for (NavigationEdge edge : thisHeadNode.getNavigationEdges()) {
                    Property property;
                    if (edge.getTarget() != thatHeadNode || (property = edge.getProperty()).isIsImplicit()) continue;
                    ++nonImplicits;
                    continue block1;
                }
            }
            if (nonImplicits <= bestNonImplicits) continue;
            bestHeadNode = thisHeadNode;
            bestNonImplicits = nonImplicits;
        }
        assert (bestHeadNode != null);
        return bestHeadNode;
    }

    private @Nullable Node selectMergedHeadNode(@NonNull Node headNode, @NonNull List<@NonNull Node> mergedNodes) {
        if (mergedNodes.size() == 1) {
            Node mergedNode = this.selectBestHeadNode(mergedNodes);
            if (mergedNode.isIterator()) {
                return null;
            }
            return mergedNode;
        }
        if (mergedNodes.size() == 0) {
            return null;
        }
        Iterable<NavigationEdge> predicateEdges = headNode.getPredicateEdges();
        for (Node mergedNode : mergedNodes) {
            boolean ok;
            boolean bl = ok = !mergedNode.isIterator();
            if (ok) {
                for (NavigationEdge predicateEdge : predicateEdges) {
                    Property property = predicateEdge.getProperty();
                    Node navigation = mergedNode.getNavigationTarget(property);
                    if (navigation != null) continue;
                    ok = false;
                    break;
                }
            }
            if (!ok) continue;
            return mergedNode;
        }
        return null;
    }

    @Override
    public void setInvokingRegion(@NonNull ScheduledRegion invokingRegion) {
        this.invokingRegion = invokingRegion;
    }

    @Override
    public void setIsCyclic() {
        this.isCyclic = true;
    }

    @Override
    public void toCallGraph(@NonNull GraphStringBuilder s) {
        s.appendNode((GraphStringBuilder.GraphNode)this);
        for (final Region region : this.getCallableChildren()) {
            GraphStringBuilder.GraphEdge graphEdge = new GraphStringBuilder.GraphEdge(){

                public void appendEdgeAttributes(@NonNull GraphStringBuilder s, // Could not load outer class - annotation placement on inner may be incorrect
                @NonNull GraphStringBuilder.GraphNode source, // Could not load outer class - annotation placement on inner may be incorrect
                @NonNull GraphStringBuilder.GraphNode target) {
                    s.appendAttributedEdge(source, (GraphStringBuilder.GraphEdge)this, target);
                }

                public // Could not load outer class - annotation placement on inner may be incorrect
                @NonNull GraphStringBuilder.GraphNode getSource() {
                    return AbstractRegion.this;
                }

                public // Could not load outer class - annotation placement on inner may be incorrect
                @NonNull GraphStringBuilder.GraphNode getTarget() {
                    return region;
                }
            };
            s.appendEdge(graphEdge.getSource(), graphEdge, graphEdge.getTarget());
        }
        for (final NodeConnection connection : this.getRootConnections()) {
            GraphStringBuilder.GraphEdge graphEdge1 = new GraphStringBuilder.GraphEdge(){

                public void appendEdgeAttributes(@NonNull GraphStringBuilder s, // Could not load outer class - annotation placement on inner may be incorrect
                @NonNull GraphStringBuilder.GraphNode source, // Could not load outer class - annotation placement on inner may be incorrect
                @NonNull GraphStringBuilder.GraphNode target) {
                    s.appendAttributedEdge(source, (GraphStringBuilder.GraphEdge)this, target);
                }

                public // Could not load outer class - annotation placement on inner may be incorrect
                @NonNull GraphStringBuilder.GraphNode getSource() {
                    return AbstractRegion.this;
                }

                public // Could not load outer class - annotation placement on inner may be incorrect
                @NonNull GraphStringBuilder.GraphNode getTarget() {
                    return (AbstractConnection)((Object)connection);
                }
            };
            s.appendEdge(graphEdge1.getSource(), graphEdge1, graphEdge1.getTarget());
            for (final Node targetNode : connection.getTargetNodes()) {
                GraphStringBuilder.GraphEdge graphEdge = new GraphStringBuilder.GraphEdge(){

                    public void appendEdgeAttributes(@NonNull GraphStringBuilder s, // Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull GraphStringBuilder.GraphNode source, // Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull GraphStringBuilder.GraphNode target) {
                        s.appendAttributedEdge(source, (GraphStringBuilder.GraphEdge)this, target);
                    }

                    public // Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull GraphStringBuilder.GraphNode getSource() {
                        return (AbstractConnection)((Object)connection);
                    }

                    public // Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull GraphStringBuilder.GraphNode getTarget() {
                        return targetNode.getRegion();
                    }
                };
                s.appendEdge(graphEdge.getSource(), graphEdge, graphEdge.getTarget());
            }
        }
    }

    @Override
    public void toGraph(@NonNull GraphStringBuilder s) {
        s.setLabel(this.getName());
        s.pushCluster();
        for (Node node : this.getNodes()) {
            node.toGraph(s);
        }
        for (Edge edge : this.getEdges()) {
            edge.toGraph(s);
        }
        s.popCluster();
    }

    @Override
    public void toRegionGraph(@NonNull GraphStringBuilder s) {
        s.appendNode((GraphStringBuilder.GraphNode)this);
        for (Edge edge : this.getRecursionEdges()) {
            s.appendEdge((GraphStringBuilder.GraphNode)edge.getSource().getRegion(), (GraphStringBuilder.GraphEdge)edge, (GraphStringBuilder.GraphNode)edge.getTarget().getRegion());
        }
    }

    public @NonNull String toString() {
        return this.symbolName != null ? this.symbolName : this.getName();
    }

    protected void writeDebugGraphs(@NonNull String context) {
        SchedulerConstants scheduler = this.getSchedulerConstants();
        scheduler.writeDOTfile(this, "-" + context);
        scheduler.writeGraphMLfile(this, "-" + context);
    }

    public static class EarliestRegionComparator
    implements Comparator<Region> {
        public static final @NonNull EarliestRegionComparator INSTANCE = new EarliestRegionComparator();

        public static @NonNull List<@NonNull Region> sort(@NonNull Iterable<@NonNull Region> regions) {
            ArrayList<@NonNull Region> sortedRegions = new ArrayList<Region>();
            Iterables.addAll(sortedRegions, regions);
            Collections.sort(sortedRegions, INSTANCE);
            return sortedRegions;
        }

        @Override
        public int compare(@NonNull Region o1, @NonNull Region o2) {
            int i1 = o1.getInvocationIndex();
            int i2 = o2.getInvocationIndex();
            return i1 - i2;
        }
    }

    public static final class EdgeSourceFunction
    implements Function<Edge, Node> {
        public static final @NonNull EdgeSourceFunction INSTANCE = new EdgeSourceFunction();

        public @NonNull Node apply(@NonNull Edge edge) {
            return edge.getSource();
        }
    }

    public static final class EdgeTargetFunction
    implements Function<Edge, Node> {
        public static final @NonNull EdgeTargetFunction INSTANCE = new EdgeTargetFunction();

        public @NonNull Node apply(@NonNull Edge edge) {
            return edge.getTarget();
        }
    }

    public static final class IsAssignedNodePredicate
    implements Predicate<Node> {
        public static final @NonNull IsAssignedNodePredicate INSTANCE = new IsAssignedNodePredicate();

        public boolean apply(@NonNull Node node) {
            return node.isRealized();
        }
    }

    public static final class IsAssignmentEdgePredicate
    implements Predicate<Edge> {
        public static final @NonNull IsAssignmentEdgePredicate INSTANCE = new IsAssignmentEdgePredicate();

        public boolean apply(@NonNull Edge edge) {
            return edge.isRealized();
        }
    }

    public static final class IsCallableRegionPredicate
    implements Predicate<Region> {
        public static final @NonNull IsCallableRegionPredicate INSTANCE = new IsCallableRegionPredicate();

        public boolean apply(@NonNull Region region) {
            return !region.isOperationRegion();
        }
    }

    public static final class IsCastEdgePredicate
    implements Predicate<Edge> {
        public static final @NonNull IsCastEdgePredicate INSTANCE = new IsCastEdgePredicate();

        public boolean apply(@NonNull Edge edge) {
            return edge.isCast();
        }
    }

    public static final class IsComposedNodePredicate
    implements Predicate<Node> {
        public static final @NonNull IsComposedNodePredicate INSTANCE = new IsComposedNodePredicate();

        public boolean apply(@NonNull Node node) {
            return node.isComposed();
        }
    }

    public static final class IsComputationEdgePredicate
    implements Predicate<Edge> {
        public static final @NonNull IsComputationEdgePredicate INSTANCE = new IsComputationEdgePredicate();

        public boolean apply(@NonNull Edge edge) {
            return edge.isComputation();
        }
    }

    public static final class IsComputedPredicate
    implements Predicate<Node> {
        public static final @NonNull IsComputedPredicate INSTANCE = new IsComputedPredicate();

        public boolean apply(@NonNull Node node) {
            return node.isRealized();
        }
    }

    public static final class IsExpressionEdgePredicate
    implements Predicate<Edge> {
        public static final @NonNull IsExpressionEdgePredicate INSTANCE = new IsExpressionEdgePredicate();

        public boolean apply(@NonNull Edge edge) {
            return edge.isArgument();
        }
    }

    public static final class IsGuardNodePredicate
    implements Predicate<Node> {
        public static final @NonNull IsGuardNodePredicate INSTANCE = new IsGuardNodePredicate();

        public boolean apply(@NonNull Node node) {
            return node.isGuard();
        }
    }

    public static final class IsGuardVariableNodePredicate
    implements Predicate<Node> {
        public static final @NonNull IsGuardVariableNodePredicate INSTANCE = new IsGuardVariableNodePredicate();

        public boolean apply(@NonNull Node node) {
            return node.isGuardVariable();
        }
    }

    public static final class IsMatchableNodePredicate
    implements Predicate<Node> {
        public static final @NonNull IsMatchableNodePredicate INSTANCE = new IsMatchableNodePredicate();

        public boolean apply(@NonNull Node node) {
            return node.isMatchable();
        }
    }

    public static final class IsMergeableEdgePredicate
    implements Predicate<Edge> {
        public static final @NonNull IsMergeableEdgePredicate INSTANCE = new IsMergeableEdgePredicate();

        public boolean apply(@NonNull Edge edge) {
            return edge.isMergeable();
        }
    }

    public static final class IsNavigableNodePredicate
    implements Predicate<Node> {
        public static final @NonNull IsNavigableNodePredicate INSTANCE = new IsNavigableNodePredicate();

        public boolean apply(@NonNull Node node) {
            return node.isNavigable();
        }
    }

    public static final class IsNavigationEdgePredicate
    implements Predicate<Edge> {
        public static final @NonNull IsNavigationEdgePredicate INSTANCE = new IsNavigationEdgePredicate();

        public boolean apply(@NonNull Edge edge) {
            return edge.isNavigation();
        }
    }

    public static final class IsPredicatedEdgePredicate
    implements Predicate<Edge> {
        public static final @NonNull IsPredicatedEdgePredicate INSTANCE = new IsPredicatedEdgePredicate();

        public boolean apply(@NonNull Edge edge) {
            return edge.isPredicated();
        }
    }

    public static final class IsPredicatedNavigationEdgePredicate
    implements Predicate<Edge> {
        public static final @NonNull IsPredicatedNavigationEdgePredicate INSTANCE = new IsPredicatedNavigationEdgePredicate();

        public boolean apply(@NonNull Edge edge) {
            return edge.isPredicated() && edge.isNavigation();
        }
    }

    public static final class IsPredicatedNodePredicate
    implements Predicate<Node> {
        public static final @NonNull IsPredicatedNodePredicate INSTANCE = new IsPredicatedNodePredicate();

        public boolean apply(@NonNull Node node) {
            return node.isPredicated();
        }
    }

    public static final class IsRealizedEdgePredicate
    implements Predicate<Edge> {
        public static final @NonNull IsRealizedEdgePredicate INSTANCE = new IsRealizedEdgePredicate();

        public boolean apply(@NonNull Edge edge) {
            return edge.isRealized();
        }
    }

    public static final class IsRealizedNavigationEdgePredicate
    implements Predicate<Edge> {
        public static final @NonNull IsRealizedNavigationEdgePredicate INSTANCE = new IsRealizedNavigationEdgePredicate();

        public boolean apply(@NonNull Edge edge) {
            return edge.isRealized() && edge.isNavigation();
        }
    }

    public static final class IsRealizedNodePredicate
    implements Predicate<Node> {
        public static final @NonNull IsRealizedNodePredicate INSTANCE = new IsRealizedNodePredicate();

        public boolean apply(@NonNull Node node) {
            return node.isRealized();
        }
    }

    public static final class IsRealizedVariableNodePredicate
    implements Predicate<Node> {
        public static final @NonNull IsRealizedVariableNodePredicate INSTANCE = new IsRealizedVariableNodePredicate();

        public boolean apply(@NonNull Node node) {
            return node.isRealizedVariable();
        }
    }

    public static final class IsRecursionEdgePredicate
    implements Predicate<Edge> {
        public static final @NonNull IsRecursionEdgePredicate INSTANCE = new IsRecursionEdgePredicate();

        public boolean apply(@NonNull Edge edge) {
            return edge.isRecursion();
        }
    }

    public static final class IsTrueNodePredicate
    implements Predicate<Node> {
        public static final @NonNull IsTrueNodePredicate INSTANCE = new IsTrueNodePredicate();

        public boolean apply(@NonNull Node node) {
            return node.isTrue();
        }
    }
}

