/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtp2qvts;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.AbstractConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ConnectionRole;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Connections;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Scheduler;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SchedulerConstants;
import org.eclipse.qvtd.compiler.internal.utilities.SymbolNameBuilder;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.GraphStringBuilder;

public class BasicNodeConnection
extends AbstractConnection<Node>
implements NodeConnection {
    protected final @NonNull ClassDatumAnalysis classDatumAnalysis;
    private Region commonRegion = null;
    private List<@NonNull Region> intermediateRegions = null;

    public BasicNodeConnection(@NonNull ScheduledRegion region, @NonNull Set<@NonNull Node> sourceNodes, @NonNull SymbolNameBuilder symbolNameBuilder, @NonNull ClassDatumAnalysis classDatumAnalysis) {
        super(region, sourceNodes, symbolNameBuilder);
        this.classDatumAnalysis = classDatumAnalysis;
        region.addNodeConnection(this);
        for (Node sourceNode : sourceNodes) {
            sourceNode.addOutgoingConnection(this);
        }
    }

    @Override
    public void addPassedTargetNode(@NonNull Node targetNode) {
        this.mergeRole(Connections.PASSED);
        assert (!this.targetEnd2role.containsKey(targetNode));
        this.targetEnd2role.put(targetNode, Connections.PASSED);
        targetNode.addIncomingConnection(this);
    }

    @Override
    public void addUsedTargetNode(@NonNull Node targetNode, boolean mustBeLater) {
        ConnectionRole newConnectionRole = mustBeLater ? Connections.MANDATORY_NODE : Connections.PREFERRED_NODE;
        ConnectionRole oldConnectionRole = (ConnectionRole)this.targetEnd2role.get(targetNode);
        if (oldConnectionRole != null && oldConnectionRole != newConnectionRole) {
            newConnectionRole = newConnectionRole.merge(oldConnectionRole);
        }
        this.mergeRole(newConnectionRole);
        this.targetEnd2role.put(targetNode, newConnectionRole);
        targetNode.addIncomingConnection(this);
    }

    @Override
    public @Nullable Node basicGetSource(@NonNull Region sourceRegion) {
        Node sourceNode = null;
        for (Node node : this.sourceEnds) {
            if (node.getRegion() != sourceRegion) continue;
            assert (sourceNode == null);
            sourceNode = node;
        }
        return sourceNode;
    }

    @Override
    public void destroy() {
        for (Node sourceNode : this.sourceEnds) {
            sourceNode.removeOutgoingConnection(this);
        }
        for (Node targetNode : this.targetEnd2role.keySet()) {
            targetNode.removeIncomingConnection(this);
        }
        super.destroy();
    }

    @Override
    public @NonNull ClassDatumAnalysis getClassDatumAnalysis() {
        return this.classDatumAnalysis;
    }

    @Override
    public @Nullable Region getCommonRegion() {
        return this.commonRegion;
    }

    @Override
    public @NonNull List<@NonNull Region> getIntermediateRegions() {
        return this.intermediateRegions != null ? this.intermediateRegions : SchedulerConstants.EMPTY_REGION_LIST;
    }

    @Override
    public @NonNull Iterable<@NonNull Node> getSourceNodes() {
        return this.sourceEnds;
    }

    @Override
    public @NonNull Type getSourcesType(@NonNull IdResolver idResolver) {
        Class commonType = null;
        for (Node node : this.getSources()) {
            Class nodeType = node.getCompleteClass().getPrimaryClass();
            CompleteEnvironment environment = idResolver.getEnvironment();
            if (!(nodeType instanceof CollectionType)) {
                CollectionType collectionType = nodeType = this.isOrdered() ? environment.getOrderedSetType((Type)nodeType, true, null, null) : environment.getSetType((Type)nodeType, true, null, null);
            }
            if (commonType == null) {
                commonType = nodeType;
                continue;
            }
            if (nodeType == commonType) continue;
            commonType = commonType.getCommonType(idResolver, (Type)nodeType);
        }
        assert (commonType != null);
        return commonType;
    }

    @Override
    public @NonNull Iterable<@NonNull Node> getTargetNodes() {
        return this.targetEnd2role.keySet();
    }

    @Override
    public @NonNull Map<@NonNull Node, @NonNull ConnectionRole> getTargets() {
        return this.targetEnd2role;
    }

    @Override
    public boolean isMandatory() {
        return this.getConnectionRole().isMandatory();
    }

    public boolean isNode2Node() {
        return this.sourceEnds.size() == 1 && this.targetEnd2role.size() == 1;
    }

    private boolean isOrdered() {
        boolean isOrdered = false;
        for (Node sourceNode1 : this.getSources()) {
            Region sourceRegion = sourceNode1.getRegion();
            for (NodeConnection passedConnection : sourceRegion.getIncomingPassedConnections()) {
                for (Node sourceNode2 : passedConnection.getSources()) {
                    Class sourceType2 = sourceNode2.getClassDatumAnalysis().getCompleteClass().getPrimaryClass();
                    if (!(sourceType2 instanceof CollectionType) || !((CollectionType)sourceType2).isOrdered()) continue;
                    return true;
                }
            }
        }
        return isOrdered;
    }

    @Override
    public boolean isPassed() {
        return this.getConnectionRole().isPassed();
    }

    @Override
    public boolean isPassed(@NonNull Region targetRegion) {
        if (Iterables.contains(targetRegion.getIncomingPassedConnections(), (Object)this)) {
            return true;
        }
        for (Node targetNode : this.targetEnd2role.keySet()) {
            if (targetNode.getRegion() != targetRegion) continue;
            ConnectionRole role = (ConnectionRole)this.targetEnd2role.get(targetNode);
            assert (role != null);
            if (!role.isPassed()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUsed() {
        return this.getConnectionRole().isPreferred();
    }

    @Override
    public boolean isUsed(@NonNull Node targetNode) {
        ConnectionRole targetConnectionRole = (ConnectionRole)this.targetEnd2role.get(targetNode);
        assert (targetConnectionRole != null);
        return targetConnectionRole.isPreferred();
    }

    @Override
    public void removeSource(@NonNull Node sourceNode) {
        boolean wasRemoved = this.sourceEnds.remove(sourceNode);
        assert (wasRemoved);
    }

    @Override
    public void removeTarget(@NonNull Node targetNode) {
        ConnectionRole oldRole = (ConnectionRole)this.targetEnd2role.remove(targetNode);
        assert (oldRole != null);
    }

    @Override
    public void setCommonRegion(@NonNull Region commonRegion, @NonNull List<@NonNull Region> intermediateRegions) {
        assert (this.commonRegion == null);
        assert (this.intermediateRegions == null);
        this.commonRegion = commonRegion;
        this.intermediateRegions = intermediateRegions;
        commonRegion.addRootConnection(this);
        for (Region intermediateRegion : intermediateRegions) {
            intermediateRegion.addIntermediateConnection(this);
        }
        if (Scheduler.CONNECTION_ROUTING.isActive()) {
            StringBuilder s = new StringBuilder();
            s.append(String.valueOf(this.getSymbolName()) + " common: " + commonRegion + " intermediate:");
            for (Region intermediateRegion : intermediateRegions) {
                s.append(" " + intermediateRegion);
            }
            Scheduler.CONNECTION_ROUTING.println(s.toString());
        }
    }

    @Override
    public void toCallGraph(@NonNull GraphStringBuilder s) {
        if (this.isNode2Node()) {
            s.appendNode((GraphStringBuilder.GraphNode)this);
        } else {
            s.appendNode((GraphStringBuilder.GraphNode)this);
        }
    }

    @Override
    public void toGraph(@NonNull GraphStringBuilder s) {
        if (this.isNode2Node()) {
            Node sourceNode = (Node)this.sourceEnds.iterator().next();
            Node targetNode = (Node)this.targetEnd2role.keySet().iterator().next();
            s.appendEdge((GraphStringBuilder.GraphNode)sourceNode, (GraphStringBuilder.GraphEdge)this, (GraphStringBuilder.GraphNode)targetNode);
        } else {
            s.appendNode((GraphStringBuilder.GraphNode)this);
            for (Node source : this.getSources()) {
                s.appendEdge((GraphStringBuilder.GraphNode)source, (GraphStringBuilder.GraphEdge)this, (GraphStringBuilder.GraphNode)this);
            }
            for (Node target : this.getTargetNodes()) {
                ConnectionRole role = (ConnectionRole)this.targetEnd2role.get(target);
                assert (role != null);
                s.appendEdge((GraphStringBuilder.GraphNode)this, (GraphStringBuilder.GraphEdge)role, (GraphStringBuilder.GraphNode)target);
            }
        }
    }
}

