/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtcorebase.utilities;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.TreeIterable;
import org.eclipse.qvtd.pivot.qvtcorebase.AbstractMapping;
import org.eclipse.qvtd.pivot.qvtcorebase.Area;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.CorePattern;
import org.eclipse.qvtd.pivot.qvtcorebase.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.OppositePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;

public class QVTcoreBaseUtil
extends QVTbaseUtil {
    public static @NonNull Area getArea(@NonNull AbstractMapping mapping, @NonNull TypedModel typedModel) {
        for (Domain domain : mapping.getDomain()) {
            if (domain.getTypedModel() != typedModel) continue;
            return (CoreDomain)domain;
        }
        return mapping;
    }

    public static @Nullable Area getContainingArea(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof Area) {
                return (Area)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable CorePattern getContainingPattern(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof CorePattern) {
                return (CorePattern)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static @Nullable CoreDomain getDomain(@NonNull AbstractMapping rule, @NonNull TypedModel typedModel) {
        return (CoreDomain)QVTcoreBaseUtil.getDomain((Rule)rule, (TypedModel)typedModel);
    }

    public static @NonNull Property getTargetProperty(@NonNull NavigationAssignment asNavigationAssignment) {
        if (asNavigationAssignment instanceof PropertyAssignment) {
            return (Property)ClassUtil.nonNullState((Object)((PropertyAssignment)asNavigationAssignment).getTargetProperty());
        }
        if (asNavigationAssignment instanceof OppositePropertyAssignment) {
            Property referredProperty = (Property)ClassUtil.nonNullState((Object)((OppositePropertyAssignment)asNavigationAssignment).getTargetProperty());
            return (Property)ClassUtil.nonNullState((Object)referredProperty.getOpposite());
        }
        throw new UnsupportedOperationException("Unsupported " + asNavigationAssignment.eClass().getName());
    }

    public static @Nullable TypedModel getTypedModel(@Nullable Area area) {
        if (area instanceof CoreDomain) {
            return ((CoreDomain)area).getTypedModel();
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void sortPatternVariables(@NonNull List<@NonNull Variable> variables) {
        if (variables.size() > 1) {
            HashMap<@NonNull Variable, @Nullable List<@NonNull VariableDeclaration>> def2refs = new HashMap<Variable, List<VariableDeclaration>>();
            for (Variable variable : variables) {
                def2refs.put(variable, null);
            }
            for (Variable variable : variables) {
                ArrayList<VariableDeclaration> refs = null;
                OCLExpression initExpression = variable.getOwnedInit();
                if (initExpression == null) continue;
                for (EObject eObject : new TreeIterable((EObject)initExpression, true)) {
                    if (!(eObject instanceof VariableExp)) continue;
                    VariableDeclaration referredVariable = ((VariableExp)eObject).getReferredVariable();
                    assert (referredVariable != null);
                    if (!def2refs.containsKey(referredVariable)) continue;
                    if (refs == null) {
                        refs = new ArrayList<VariableDeclaration>();
                        def2refs.put(variable, refs);
                    }
                    if (refs.contains(referredVariable)) continue;
                    refs.add(referredVariable);
                }
            }
            boolean changed = true;
            while (changed) {
                changed = false;
                for (Variable variable : def2refs.keySet()) {
                    @NonNull List refs = (List)def2refs.get(variable);
                    if (refs == null) continue;
                    int i = 0;
                    while (i < refs.size()) {
                        VariableDeclaration ref = (VariableDeclaration)refs.get(i);
                        @NonNull List refRefs = (List)def2refs.get(ref);
                        if (refRefs != null) {
                            for (VariableDeclaration refRef : refRefs) {
                                if (refs.contains(refRef)) continue;
                                refs.add(refRef);
                                changed = true;
                            }
                        }
                        ++i;
                    }
                }
            }
            ClassUtil.sort(variables, (Comparator)new PatternVariableComparator(def2refs));
        }
    }

    protected static class PatternVariableComparator
    implements Comparator<Variable> {
        private final @NonNull Map<@NonNull Variable, @Nullable List<@NonNull VariableDeclaration>> def2refs;

        protected PatternVariableComparator(@NonNull Map<@NonNull Variable, @Nullable List<@NonNull VariableDeclaration>> def2refs) {
            this.def2refs = def2refs;
        }

        @Override
        public int compare(@NonNull Variable o1, @NonNull Variable o2) {
            int s2;
            List<@NonNull VariableDeclaration> l1 = this.def2refs.get(o1);
            List<@NonNull VariableDeclaration> l2 = this.def2refs.get(o2);
            int s1 = l1 != null ? l1.size() : 0;
            int n = s2 = l2 != null ? l2.size() : 0;
            if (s1 != s2) {
                return s1 - s2;
            }
            String n1 = o1.getName();
            String n2 = o2.getName();
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }
}

