/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtc2qvtu;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;

public class QVTuConfiguration {
    private final @NonNull Mode mode;
    private final @NonNull List<@NonNull TypedModel> inputTypedModels;
    private final @NonNull List<@NonNull TypedModel> intermediateTypedModels;
    private final @NonNull List<@NonNull TypedModel> outputTypedModels;

    public QVTuConfiguration(@NonNull Mode mode, @NonNull List<@NonNull TypedModel> inputTypedModels, @NonNull List<@NonNull TypedModel> intermediateTypedModels, @NonNull List<@NonNull TypedModel> outputTypedModels) {
        this.mode = mode;
        this.inputTypedModels = inputTypedModels;
        this.intermediateTypedModels = intermediateTypedModels;
        this.outputTypedModels = outputTypedModels;
    }

    public boolean isCheckMode() {
        return this.mode == Mode.CHECK;
    }

    public boolean isEnforceMode() {
        return this.mode == Mode.ENFORCE;
    }

    public boolean isInput(@NonNull TypedModel typedModel) {
        return this.inputTypedModels.contains(typedModel);
    }

    public boolean isIntermediate(@NonNull TypedModel typedModel) {
        return this.intermediateTypedModels.contains(typedModel);
    }

    public boolean isOutput(@NonNull TypedModel typedModel) {
        return this.outputTypedModels.contains(typedModel);
    }

    public static enum Mode {
        CHECK,
        ENFORCE;

    }
}

