/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.IteratorVariable;
import org.eclipse.ocl.pivot.LetVariable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.AbstractVariableAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.VariablesAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcore.Area;
import org.eclipse.qvtd.pivot.qvtcore.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.CorePattern;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;
import org.eclipse.qvtd.pivot.qvtcore.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

public class RelationVariableAnalysis
extends AbstractVariableAnalysis {
    protected final @NonNull Variable rVariable;
    private @Nullable TypedModel rEnforcedTypedModel = null;
    private @Nullable Key rKey = null;
    private @Nullable TemplateExp rTemplateExp = null;
    private boolean isEnforcedBound = false;
    private boolean isEnforcedReferred = false;
    private @Nullable CoreDomain cOtherBound = null;
    private @Nullable CoreDomain cOtherReferred = null;
    private boolean isRoot = false;
    private @Nullable CoreDomain cWhenDomain = null;
    private @Nullable CoreDomain cWhereDomain = null;
    private @Nullable Area cPredicateArea = null;
    private @Nullable Strategy strategy = null;
    private @Nullable Variable cVariable;

    public RelationVariableAnalysis(@NonNull VariablesAnalysis variablesAnalysis, @NonNull Variable rVariable) {
        super(variablesAnalysis, (String)ClassUtil.nonNullState((Object)rVariable.getName()));
        assert (!"this".equals(rVariable.getName()));
        this.rVariable = rVariable;
        assert (!(rVariable instanceof IteratorVariable));
        assert (!(rVariable instanceof LetVariable));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void addNavigationAssignment(@NonNull Property targetProperty, @NonNull OCLExpression cExpression, @Nullable Boolean isPartial) throws CompilerChainException {
        boolean isKeyed;
        Key rKey2 = this.rKey;
        boolean bl = isKeyed = this.getStrategy() == Strategy.KEYED;
        if (isKeyed && rKey2 != null) {
            if (rKey2.getPart().contains((Object)targetProperty)) {
                return;
            }
            if (rKey2.getOppositePart().contains((Object)targetProperty.getOpposite())) {
                return;
            }
        }
        Variable cVariable2 = this.getCoreVariable();
        @NonNull List cMiddleBottomAssignments = QVTcoreUtil.Internal.getOwnedAssignmentsList((BottomPattern)this.variablesAnalysis.getMiddleBottomPattern());
        if (isPartial == null) {
            isPartial = targetProperty.isIsMany() && !(cExpression.getType() instanceof CollectionType);
        }
        VariableExp cSlotVariableExp = this.variablesAnalysis.createVariableExp((VariableDeclaration)cVariable2);
        NavigationAssignment cAssignment = this.variablesAnalysis.createNavigationAssignment((OCLExpression)cSlotVariableExp, targetProperty, cExpression, isPartial);
        QVTr2QVTc.SYNTHESIS.println("  addPropertyAssignment " + cAssignment);
        this.variablesAnalysis.assertNewAssignment(cMiddleBottomAssignments, cAssignment);
        cMiddleBottomAssignments.add(cAssignment);
    }

    public @Nullable RealizedVariable basicGetCoreRealizedVariable() {
        return (RealizedVariable)this.cVariable;
    }

    public @Nullable Variable basicGetCoreVariable() {
        return this.cVariable;
    }

    @Override
    public void check() {
        boolean isRealized;
        if (this.cVariable == null) {
            System.err.println("No cVariable for " + this);
            return;
        }
        CorePattern cPattern = this.getCorePattern();
        boolean bl = isRealized = this.getStrategy() == Strategy.REALIZED_BOTTOM;
        assert (this.cVariable != null && (this.cVariable.eContainer() == cPattern || this.cVariable instanceof IteratorVariable || this.cVariable instanceof LetVariable));
        assert (this.cVariable instanceof RealizedVariable == (isRealized && !(this.cVariable.getType() instanceof DataType)));
    }

    private @NonNull Strategy computeStrategy() {
        if (!(this.cWhenDomain != null || this.variablesAnalysis.isInvoked() && this.isRoot || !this.isEnforcedBound || this.rKey == null)) {
            assert (this.rEnforcedTypedModel != null);
            assert (this.rKey != null);
            assert (this.isEnforcedBound);
            assert (this.cOtherBound == null);
            assert (this.cOtherReferred == null);
            return Strategy.KEYED;
        }
        if (!(this.cWhenDomain != null || this.variablesAnalysis.isWhered() && this.isRoot || !this.isEnforcedBound || this.rKey != null)) {
            assert (this.rEnforcedTypedModel != null);
            assert (this.rKey == null);
            assert (this.rTemplateExp != null);
            assert (this.isEnforcedBound);
            assert (this.cOtherBound == null);
            assert (this.cOtherReferred == null);
            return Strategy.REALIZED_BOTTOM;
        }
        if (this.rEnforcedTypedModel != null) {
            assert (this.rEnforcedTypedModel != null);
            assert (this.isEnforcedBound);
            assert (this.cOtherBound == null);
            return Strategy.ENFORCED_GUARD;
        }
        if (this.cWhenDomain != null || this.isEnforcedBound && this.variablesAnalysis.isInvoked() && this.isRoot || !this.isEnforcedBound && this.cOtherBound != null && this.isRoot || !this.isEnforcedBound && this.cOtherBound == null && (!this.isEnforcedReferred || this.cOtherReferred == null) && this.cOtherReferred == null && this.cPredicateArea == null && this.isEnforcedReferred && this.cOtherReferred == null) {
            assert (this.rEnforcedTypedModel == null);
            assert (!this.isEnforcedBound);
            assert (this.cOtherBound != null || this.cOtherReferred != null || this.cWhenDomain != null || this.cWhereDomain != null);
            return Strategy.OTHER_GUARD;
        }
        if (this.cOtherBound != null) {
            assert (this.rEnforcedTypedModel == null);
            assert (this.rKey == null);
            assert (!this.isEnforcedBound);
            assert (this.cOtherBound != null);
            assert (!this.isRoot);
            return Strategy.OTHER_BOTTOM;
        }
        if (this.isEnforcedReferred && this.cOtherReferred != null) {
            assert (this.rEnforcedTypedModel == null);
            assert (this.rKey == null);
            assert (this.rTemplateExp == null);
            assert (!this.isEnforcedBound);
            assert (this.isEnforcedReferred);
            assert (this.cOtherBound == null);
            assert (this.cOtherReferred != null);
            assert (!this.isRoot);
            return Strategy.SHARED_BOTTOM;
        }
        assert (this.rEnforcedTypedModel == null);
        assert (this.rKey == null);
        assert (!this.isEnforcedBound);
        assert (!this.isEnforcedReferred);
        assert (this.cOtherBound != null || this.cOtherReferred != null || this.cWhenDomain != null || this.cWhereDomain != null);
        assert (!this.isRoot);
        return Strategy.OTHER_BOTTOM;
    }

    @Override
    public @NonNull CorePattern getCorePattern() {
        switch (this.getStrategy()) {
            case ENFORCED_GUARD: {
                return QVTcoreUtil.getGuardPattern((Area)this.variablesAnalysis.cEnforcedDomain);
            }
            case KEYED: {
                return QVTcoreUtil.getBottomPattern((Area)this.variablesAnalysis.cEnforcedDomain);
            }
            case OTHER_BOTTOM: {
                return QVTcoreUtil.getBottomPattern((Area)this.getOtherDomain());
            }
            case OTHER_GUARD: {
                return QVTcoreUtil.getGuardPattern((Area)this.getOtherDomain());
            }
            case REALIZED_BOTTOM: {
                return QVTcoreUtil.getBottomPattern((Area)this.variablesAnalysis.cEnforcedDomain);
            }
            case SHARED_BOTTOM: {
                return this.variablesAnalysis.cMiddleBottomPattern;
            }
        }
        throw new IllegalStateException("A " + (Object)((Object)this.strategy) + " variable has no CoreDomain");
    }

    @Override
    public @NonNull Variable getCoreVariable() throws CompilerChainException {
        Variable cVariable2 = this.cVariable;
        if (cVariable2 == null) {
            cVariable2 = this.synthesize();
        }
        return cVariable2;
    }

    private @NonNull CoreDomain getOtherDomain() throws IllegalStateException {
        if (this.cOtherBound != null) {
            return this.cOtherBound;
        }
        if (this.cOtherReferred != null) {
            return this.cOtherReferred;
        }
        if (this.cWhenDomain != null) {
            return this.cWhenDomain;
        }
        if (this.cWhereDomain != null) {
            return this.cWhereDomain;
        }
        throw new IllegalStateException("Failed to determine other pattern for " + this);
    }

    @Override
    public @NonNull Variable getRelationVariable() {
        return this.rVariable;
    }

    protected @NonNull Strategy getStrategy() {
        Strategy strategy2 = this.strategy;
        if (strategy2 == null) {
            this.strategy = strategy2 = this.computeStrategy();
        }
        return strategy2;
    }

    @Override
    public boolean hasWhenDomain() {
        return this.cWhenDomain != null;
    }

    private void initializeKeyedVariable(@NonNull Variable cKeyedVariable) throws CompilerChainException {
        TypedModel rEnforcedTypedModel2 = (TypedModel)ClassUtil.nonNull((Object)this.rEnforcedTypedModel);
        Key rKey2 = (Key)ClassUtil.nonNull((Object)this.rKey);
        Function function = this.variablesAnalysis.qvtr2qvtc.getKeyFunction(rEnforcedTypedModel2, rKey2);
        ArrayList<@NonNull VariableExp> asArguments = new ArrayList<VariableExp>();
        if (this.rTemplateExp instanceof ObjectTemplateExp) {
            ObjectTemplateExp objectTemplateExp = (ObjectTemplateExp)this.rTemplateExp;
            for (Parameter keyParameter : ClassUtil.nullFree((List)function.getOwnedParameters())) {
                Variable cVariable;
                Variable rVariable;
                OCLExpression parameterExp = this.variablesAnalysis.getTemplateExp(objectTemplateExp, keyParameter);
                if (parameterExp instanceof TemplateExp) {
                    rVariable = (Variable)ClassUtil.nonNullState((Object)((TemplateExp)parameterExp).getBindsTo());
                    cVariable = this.variablesAnalysis.getCoreVariable(rVariable);
                    asArguments.add(this.variablesAnalysis.createVariableExp((VariableDeclaration)cVariable));
                    continue;
                }
                if (parameterExp instanceof VariableExp) {
                    rVariable = (Variable)ClassUtil.nonNullState((Object)((VariableExp)parameterExp).getReferredVariable());
                    cVariable = this.variablesAnalysis.getCoreVariable(rVariable);
                    asArguments.add(this.variablesAnalysis.createVariableExp((VariableDeclaration)cVariable));
                    continue;
                }
                throw new CompilerChainException("Missing ''{1}'' value for ''{0}'' key.", rKey2.getIdentifies().getName(), keyParameter.getName());
            }
        }
        Variable cThisVariable = this.variablesAnalysis.getCoreThisVariable();
        OperationCallExp asConstructor = this.variablesAnalysis.createOperationCallExp((OCLExpression)this.variablesAnalysis.createVariableExp((VariableDeclaration)cThisVariable), (Operation)function, asArguments);
        @NonNull VariableAssignment cVariableAssignment = this.variablesAnalysis.createVariableAssignment(cKeyedVariable, (OCLExpression)asConstructor);
        this.variablesAnalysis.getMiddleBottomPattern().getAssignment().add((Object)cVariableAssignment);
    }

    @Override
    public void setIsEnforcedBound(@Nullable TemplateExp rTemplateExp, @NonNull TypedModel rEnforcedTypedModel, @Nullable Key rKey) {
        assert (this.strategy == null);
        assert (!this.isEnforcedBound);
        assert (this.cOtherBound == null);
        assert (this.rEnforcedTypedModel == null);
        assert (this.rKey == null);
        assert (this.rTemplateExp == null);
        this.isEnforcedBound = true;
        this.rTemplateExp = rTemplateExp;
        this.rEnforcedTypedModel = rEnforcedTypedModel;
        this.rKey = rKey;
    }

    @Override
    public void setIsEnforcedReferred() {
        assert (this.strategy == null);
        this.isEnforcedReferred = true;
    }

    @Override
    public void setIsRoot() {
        assert (this.strategy == null);
        this.isRoot = true;
    }

    @Override
    public void setOtherBound(@NonNull CoreDomain otherDomain) {
        assert (this.strategy == null);
        assert (!this.isEnforcedBound);
        assert (this.cOtherBound == null);
        this.cOtherBound = otherDomain;
    }

    @Override
    public void setOtherReferred(@NonNull CoreDomain cOtherDomain) {
        assert (this.strategy == null);
        assert (this.cOtherReferred == null || this.cOtherReferred == cOtherDomain);
        this.cOtherReferred = cOtherDomain;
    }

    @Override
    public void setPredicate(@NonNull Area cPredicateArea) {
        assert (this.strategy == null);
        this.cPredicateArea = cPredicateArea;
    }

    @Override
    public void setWhen(@NonNull CoreDomain cWhenDomain) {
        assert (this.strategy == null);
        assert (this.cWhenDomain == null || this.cWhenDomain == cWhenDomain);
        this.cWhenDomain = cWhenDomain;
    }

    @Override
    public void setWhere(@NonNull CoreDomain cWhereDomain) {
        assert (this.strategy == null);
        assert (this.cWhereDomain == null || this.cWhereDomain == cWhereDomain);
        this.cWhereDomain = cWhereDomain;
    }

    protected @NonNull Variable synthesize() throws CompilerChainException {
        Variable cVariable2 = this.cVariable;
        if (cVariable2 == null) {
            Strategy strategy2 = this.getStrategy();
            Type type = QVTrelationUtil.getType((TypedElement)this.rVariable);
            switch (strategy2) {
                case ENFORCED_GUARD: {
                    cVariable2 = this.variablesAnalysis.createGuardVariable(this.name, type, this.rVariable.isIsRequired(), null);
                    this.variablesAnalysis.cEnforcedDomain.getGuardPattern().getVariable().add((Object)cVariable2);
                    break;
                }
                case KEYED: {
                    cVariable2 = this.variablesAnalysis.createBottomVariable(this.name, type, true, null);
                    this.initializeKeyedVariable(cVariable2);
                    this.variablesAnalysis.cEnforcedDomain.getBottomPattern().getVariable().add((Object)cVariable2);
                    break;
                }
                case OTHER_BOTTOM: {
                    cVariable2 = this.variablesAnalysis.createBottomVariable(this.name, type, this.rVariable.isIsRequired(), null);
                    this.getOtherDomain().getBottomPattern().getVariable().add((Object)cVariable2);
                    break;
                }
                case OTHER_GUARD: {
                    cVariable2 = this.variablesAnalysis.createGuardVariable(this.name, type, this.rVariable.isIsRequired(), null);
                    this.getOtherDomain().getGuardPattern().getVariable().add((Object)cVariable2);
                    break;
                }
                case REALIZED_BOTTOM: {
                    if (type instanceof CollectionType) {
                        cVariable2 = this.variablesAnalysis.createBottomVariable(this.name, type, this.rVariable.isIsRequired(), null);
                        this.variablesAnalysis.cEnforcedDomain.getBottomPattern().getVariable().add((Object)cVariable2);
                        break;
                    }
                    RealizedVariable cRealizedVariable = this.variablesAnalysis.createRealizedVariable(this.name, type);
                    this.variablesAnalysis.cEnforcedDomain.getBottomPattern().getRealizedVariable().add((Object)cRealizedVariable);
                    cVariable2 = cRealizedVariable;
                    break;
                }
                case SHARED_BOTTOM: {
                    cVariable2 = this.variablesAnalysis.createBottomVariable(this.name, type, this.rVariable.isIsRequired(), null);
                    this.variablesAnalysis.cMiddleBottomPattern.getVariable().add((Object)cVariable2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Failed to identify strategy for variable " + this);
                }
            }
            this.cVariable = cVariable2;
            this.variablesAnalysis.addVariableAnalysis(this);
        }
        return cVariable2;
    }

    @Override
    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.rVariable.toString());
        if (this.cWhenDomain != null) {
            s.append(" WHEN:" + this.cWhenDomain.getName());
        }
        if (this.cWhereDomain != null) {
            s.append(" WHERE:" + this.cWhereDomain.getName());
        }
        if (this.variablesAnalysis.isWhened()) {
            s.append(" WHENED");
        }
        if (this.variablesAnalysis.isWhered()) {
            s.append(" WHERED");
        }
        if (this.cPredicateArea != null) {
            s.append(" PREDICATE:" + (this.cPredicateArea instanceof CoreDomain ? ((CoreDomain)this.cPredicateArea).getName() : null));
        }
        if (this.isRoot) {
            s.append(" ROOT");
        }
        if (this.rKey != null) {
            s.append(" KEYED");
        }
        if (this.isEnforcedBound) {
            s.append(" ENFORCED");
        } else if (this.isEnforcedReferred) {
            s.append(" enforced");
        }
        if (this.cOtherBound != null) {
            s.append(" OTHER:" + this.cOtherBound.getName());
        } else if (this.cOtherReferred != null) {
            s.append(" other:" + this.cOtherReferred.getName());
        }
        if (this.rTemplateExp != null) {
            s.append(" " + this.rTemplateExp);
        }
        return s.toString();
    }

    static enum Strategy {
        ENFORCED_GUARD,
        KEYED,
        OTHER_BOTTOM,
        OTHER_GUARD,
        REALIZED_BOTTOM,
        SHARED_BOTTOM;

    }
}

