/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ContentsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RootMappingAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ClassDatumAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ScheduleIndexer;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.merger.LateConsumerMerger;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.Partitioner;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.StandardLibraryHelper;
import org.eclipse.qvtd.pivot.qvtcore.analysis.DomainUsage;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.ConnectionEnd;
import org.eclipse.qvtd.pivot.qvtschedule.DatumConnection;
import org.eclipse.qvtd.pivot.qvtschedule.EdgeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.LoadingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NodeConnection;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;
import org.eclipse.qvtd.pivot.qvtschedule.impl.LoadingRegionImpl;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleConstants;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameBuilder;

public class QVTs2QVTs
extends QVTimperativeHelper {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ProblemHandler problemHandler;
    protected final @NonNull String rootName;
    private final @NonNull LoadingRegion loadingRegion;
    private ContentsAnalysis contentsAnalysis;
    private final @NonNull RootMappingAnalysis rootAnalysis;
    protected final @NonNull CompleteModel completeModel;
    private final @NonNull Map<@NonNull Region, RegionAnalysis> region2regionAnalysis = new HashMap<Region, RegionAnalysis>();
    private final @NonNull Map<@NonNull Model, @NonNull DomainUsage> inputModels = new HashMap<Model, DomainUsage>();
    private final @NonNull StandardLibraryHelper standardLibraryHelper;
    public final @NonNull Map<@NonNull ClassDatum, @NonNull Map<@NonNull Set<@NonNull Node>, @NonNull NodeConnection>> classDatum2nodes2nodeConnections = new HashMap<ClassDatum, Map<Set<Node>, NodeConnection>>();
    public final @NonNull Map<@NonNull Set<@NonNull NavigableEdge>, @NonNull EdgeConnection> edges2edgeConnection = new HashMap<Set<NavigableEdge>, EdgeConnection>();

    public QVTs2QVTs(@NonNull ProblemHandler problemHandler, @NonNull ScheduleManager qvtm2qvts, @NonNull String rootName) {
        super(qvtm2qvts.getEnvironmentFactory());
        this.scheduleManager = qvtm2qvts;
        this.standardLibraryHelper = new StandardLibraryHelper(this.standardLibrary);
        this.problemHandler = problemHandler;
        this.rootName = rootName;
        this.loadingRegion = this.createLoadingRegion();
        this.rootAnalysis = new RootMappingAnalysis(this.loadingRegion);
        this.completeModel = this.environmentFactory.getCompleteModel();
    }

    private void computeInputModels(@NonNull ScheduledRegion rootScheduledRegion) {
        for (ClassDatumAnalysis classDatumAnalysis : this.scheduleManager.getClassDatumAnalyses()) {
            Model model;
            Class type;
            Package asPackage;
            DomainUsage domainUsage = classDatumAnalysis.getDomainUsage();
            if (!domainUsage.isInput() || domainUsage.isOutput() || (asPackage = PivotUtil.getContainingPackage((EObject)(type = classDatumAnalysis.getClassDatum().getCompleteClass().getPrimaryClass()))) == null || "http://www.eclipse.org/ocl/2015/Orphanage".equals(asPackage.getURI()) || (model = PivotUtil.getContainingModel((EObject)type)) == null) continue;
            this.inputModels.put(model, domainUsage);
        }
    }

    private @NonNull NodeConnection createNodeConnection(@NonNull ScheduledRegion scheduledRegion, @NonNull Set<@NonNull Node> sourceSet, @NonNull ClassDatum classDatum, @NonNull SymbolNameBuilder s) {
        NodeConnection connection = QVTscheduleFactory.eINSTANCE.createNodeConnection();
        connection.setOwningScheduledRegion(scheduledRegion);
        connection.getSourceEnds().addAll(sourceSet);
        connection.setName(this.scheduleManager.getScheduleModel().reserveSymbolName(s, (Object)connection));
        connection.setClassDatum(classDatum);
        for (Node sourceNode : sourceSet) {
            sourceNode.addOutgoingConnection(connection);
        }
        return connection;
    }

    private @NonNull LoadingRegion createRootContainmentRegion(@NonNull ScheduledRegion rootScheduledRegion) {
        this.loadingRegion.setOwningScheduledRegion(rootScheduledRegion);
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            this.scheduleManager.writeDebugGraphs((Region)this.loadingRegion, null);
        }
        return this.loadingRegion;
    }

    private void createConnections(@NonNull ScheduledRegion rootScheduledRegion) {
        ArrayList<@NonNull E> sortedCallableRegions = new ArrayList();
        Iterables.addAll(sortedCallableRegions, (Iterable)rootScheduledRegion.getCallableRegions());
        Collections.sort(sortedCallableRegions, NameUtil.NAMEABLE_COMPARATOR);
        for (Region region : sortedCallableRegions) {
            this.createIncomingConnections(region);
        }
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            this.scheduleManager.writeDebugGraphs(rootScheduledRegion, "4-bindings", true, true, false);
        }
    }

    private void createEdgeConnection(@NonNull Region region, @NonNull NavigableEdge predicatedEdge) {
        block23: {
            ClassDatumAnalysis classDatumAnalysis;
            Node castTarget;
            NavigableEdge castEdge;
            ScheduledRegion invokingRegion2;
            Property predicatedProperty;
            block22: {
                assert (predicatedEdge.isNavigation());
                assert (predicatedEdge.getIncomingConnection() == null);
                if (predicatedEdge.isCast()) {
                    return;
                }
                predicatedProperty = predicatedEdge.getProperty();
                if (predicatedProperty.isIsImplicit()) {
                    return;
                }
                invokingRegion2 = region.getOwningScheduledRegion();
                assert (invokingRegion2 != null);
                castEdge = QVTscheduleUtil.getCastTarget((NavigableEdge)predicatedEdge);
                castTarget = QVTscheduleUtil.getCastTarget((Node)castEdge.getEdgeTarget());
                classDatumAnalysis = RegionUtil.getClassDatumAnalysis(castTarget);
                if (!(classDatumAnalysis.getClassDatum().getCompleteClass().getPrimaryClass() instanceof DataType)) break block22;
                Iterable<@NonNull NavigableEdge> realizedEdges = this.getNewEdges(predicatedEdge, classDatumAnalysis);
                if (realizedEdges == null) break block23;
                ArrayList<@NonNull Node> sourceNodes = new ArrayList<Node>();
                for (NavigableEdge realizedEdge : realizedEdges) {
                    if (!RegionUtil.isElementallyConformantSource(realizedEdge, predicatedEdge) || !QVTscheduleUtil.isConformantTarget((NavigableEdge)realizedEdge, (NavigableEdge)predicatedEdge)) continue;
                    sourceNodes.add(realizedEdge.getEdgeTarget());
                }
                NodeConnection nodeConnection = this.getAttributeConnection(invokingRegion2, sourceNodes, predicatedEdge.getEdgeSource().getCompleteClass(), predicatedProperty, classDatumAnalysis.getClassDatum());
                nodeConnection.addUsedTargetNode(castTarget, false);
                if (!QVTscheduleConstants.CONNECTION_CREATION.isActive()) break block23;
                QVTscheduleConstants.CONNECTION_CREATION.println("  Attribute NodeConnection \"" + nodeConnection + "\" to " + castTarget);
                break block23;
            }
            Iterable<@NonNull Node> sourceNodes = this.getNewNodes(classDatumAnalysis);
            Iterable<@NonNull NavigableEdge> realizedEdges = this.getNewEdges(predicatedEdge, classDatumAnalysis);
            if (realizedEdges != null) {
                HashSet<@NonNull Region> edgeSourceRegions = new HashSet<Region>();
                HashSet<@NonNull Region> nodeSourceRegions = new HashSet<Region>();
                for (NavigableEdge realizedEdge : realizedEdges) {
                    edgeSourceRegions.add(QVTscheduleUtil.getOwningRegion((ConnectionEnd)realizedEdge));
                }
                if (sourceNodes != null) {
                    for (Node sourceNode : sourceNodes) {
                        nodeSourceRegions.add(QVTscheduleUtil.getOwningRegion((Node)sourceNode));
                    }
                }
                if (!nodeSourceRegions.containsAll(edgeSourceRegions)) {
                    HashSet<Region> conformantEdgeSourceRegions = null;
                    ArrayList<NavigableEdge> thoseEdges = null;
                    for (NavigableEdge realizedEdge : realizedEdges) {
                        if (!RegionUtil.isElementallyConformantSource(realizedEdge, predicatedEdge) || !QVTscheduleUtil.isConformantTarget((NavigableEdge)realizedEdge, (NavigableEdge)predicatedEdge)) continue;
                        if (thoseEdges == null) {
                            thoseEdges = new ArrayList<NavigableEdge>();
                            conformantEdgeSourceRegions = new HashSet<Region>();
                        }
                        if (thoseEdges.contains(realizedEdge)) continue;
                        thoseEdges.add(realizedEdge);
                        assert (conformantEdgeSourceRegions != null);
                        conformantEdgeSourceRegions.add(QVTscheduleUtil.getOwningRegion((ConnectionEnd)realizedEdge));
                    }
                    if (thoseEdges != null && !nodeSourceRegions.containsAll(conformantEdgeSourceRegions)) {
                        EdgeConnection edgeConnection = this.getEdgeConnection(invokingRegion2, thoseEdges, predicatedProperty);
                        if (QVTscheduleConstants.CONNECTION_CREATION.isActive()) {
                            QVTscheduleConstants.CONNECTION_CREATION.println("  EdgeConnection \"" + edgeConnection + "\" to " + predicatedEdge);
                        }
                        if (!Iterables.contains((Iterable)edgeConnection.getTargetEdges(), (Object)castEdge)) {
                            edgeConnection.addUsedTargetEdge(castEdge, false);
                            if (QVTscheduleConstants.CONNECTION_CREATION.isActive()) {
                                for (NavigableEdge thatEdge : thoseEdges) {
                                    QVTscheduleConstants.CONNECTION_CREATION.println("    from " + thatEdge.getOwningRegion() + "  : " + thatEdge);
                                }
                            }
                        }
                    }
                }
            }
            if (!(sourceNodes == null || castTarget.isLoaded() || castTarget.isConstant() || castTarget.isHead() || castTarget.isOperation() || castTarget.isTrue() || castTarget.getIncomingConnection() != null)) {
                NodeConnection predicatedConnection = this.getNodeConnection(invokingRegion2, sourceNodes, classDatumAnalysis.getClassDatum(), classDatumAnalysis.getDomainUsage());
                predicatedConnection.addUsedTargetNode(castTarget, false);
                if (QVTscheduleConstants.CONNECTION_CREATION.isActive()) {
                    QVTscheduleConstants.CONNECTION_CREATION.println("  NodeConnection \"" + predicatedConnection + "\" to " + castTarget);
                    for (Node sourceNode : sourceNodes) {
                        QVTscheduleConstants.CONNECTION_CREATION.println("    from " + sourceNode.getOwningRegion() + " : " + sourceNode);
                    }
                }
            }
        }
    }

    private @NonNull EdgeConnection createEdgeConnection(@NonNull ScheduledRegion scheduledRegion, @NonNull Set<@NonNull NavigableEdge> sourceSet, @NonNull Property property, @NonNull SymbolNameBuilder s) {
        assert (!property.isIsImplicit());
        EdgeConnection connection = QVTscheduleFactory.eINSTANCE.createEdgeConnection();
        connection.setOwningScheduledRegion(scheduledRegion);
        connection.setName(this.scheduleManager.getScheduleModel().reserveSymbolName(s, (Object)connection));
        connection.getSourceEnds().addAll(sourceSet);
        connection.setReferredProperty(property);
        for (NavigableEdge sourceEdge : sourceSet) {
            sourceEdge.addOutgoingConnection(connection);
        }
        return connection;
    }

    private @Nullable NodeConnection createHeadConnection(@NonNull Region region, @NonNull Node headNode) {
        ScheduledRegion invokingRegion2 = RegionUtil.getOwningScheduledRegion((Region)region);
        ClassDatumAnalysis classDatumAnalysis = RegionUtil.getClassDatumAnalysis(headNode);
        ArrayList<Node> headSources = null;
        Iterable<@NonNull Node> sourceNodes = this.getIntroducingOrNewNodes(headNode);
        if (sourceNodes != null) {
            for (Node sourceNode : sourceNodes) {
                HashMap<Node, Node> called2calling;
                if (!this.isCompatiblePattern(region, headNode, sourceNode, called2calling = new HashMap<Node, Node>())) continue;
                if (headSources == null) {
                    headSources = new ArrayList<Node>();
                }
                headSources.add(sourceNode);
            }
        }
        if (headSources == null) {
            return null;
        }
        NodeConnection headConnection = this.getNodeConnection(invokingRegion2, headSources, classDatumAnalysis.getClassDatum(), classDatumAnalysis.getDomainUsage());
        if (headNode.isDependency()) {
            headConnection.addUsedTargetNode(headNode, false);
        } else {
            headConnection.addPassedTargetNode(headNode);
        }
        if (QVTscheduleConstants.CONNECTION_CREATION.isActive()) {
            QVTscheduleConstants.CONNECTION_CREATION.println(String.valueOf(headNode.isDependency() ? "  Extra NodeConnection " : "  Head NodeConnection \"") + headConnection + "\" to " + headNode);
            for (Node sourceNode : headSources) {
                QVTscheduleConstants.CONNECTION_CREATION.println("    from " + sourceNode.getOwningRegion() + " : " + sourceNode);
            }
        }
        return headConnection;
    }

    private @Nullable Iterable<@NonNull NodeConnection> createHeadConnections(@NonNull Region region) {
        ArrayList<@NonNull NodeConnection> headConnections = null;
        for (Node headNode : QVTscheduleUtil.getHeadNodes((Region)region)) {
            if (headNode.isTrue()) continue;
            if (headNode.isDependency()) {
                this.createHeadConnection(region, headNode);
                continue;
            }
            NodeConnection headConnection = this.createHeadConnection(region, headNode);
            if (headConnection == null) {
                this.scheduleManager.addRegionError(region, "createHeadConnections abandoned for " + headNode, new Object[0]);
                this.scheduleManager.addRegionError(region, "createHeadConnections abandoned for " + headNode, new Object[0]);
                headConnection = this.createHeadConnection(region, headNode);
                return null;
            }
            if (headConnections == null) {
                headConnections = new ArrayList<NodeConnection>();
            }
            headConnections.add(headConnection);
        }
        return headConnections;
    }

    public void createIncomingConnections(@NonNull Region region) {
        if (QVTscheduleConstants.CONNECTION_CREATION.isActive()) {
            QVTscheduleConstants.CONNECTION_CREATION.println("connecting " + region);
        }
        assert (!(this instanceof LoadingRegion));
        Iterable<@NonNull NodeConnection> headConnections = this.createHeadConnections(region);
        if (headConnections != null) {
            for (NavigableEdge predicatedEdge : region.getPredicatedNavigationEdges()) {
                if (predicatedEdge.isCast()) continue;
                this.createEdgeConnection(region, predicatedEdge);
            }
        }
    }

    protected @NonNull LoadingRegion createLoadingRegion() {
        LoadingRegion loadingRegion = QVTscheduleFactory.eINSTANCE.createLoadingRegion();
        SymbolNameBuilder s = new SymbolNameBuilder();
        s.appendString("__root__");
        loadingRegion.setSymbolName(this.scheduleManager.getScheduleModel().reserveSymbolName(s, (Object)loadingRegion));
        return loadingRegion;
    }

    private void createLocalSchedule(@NonNull ScheduledRegion scheduledRegion) {
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            this.scheduleManager.writeDebugGraphs(scheduledRegion, "5-cycled", true, true, false);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void createLocalSchedule2(@NonNull ScheduledRegion scheduledRegion, @NonNull List<@NonNull Region> orderedRegions) {
        boolean noLateConsumerMerge;
        HashMap<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2predicatedEdges = new HashMap<TypedModel, Map<Property, List<NavigableEdge>>>();
        HashMap<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2realizedEdges = new HashMap<TypedModel, Map<Property, List<NavigableEdge>>>();
        for (Region region : orderedRegions) {
            QVTscheduleConstants.POLLED_PROPERTIES.println("building indexes for " + region + " " + region.getIndexRangeText());
            RegionAnalysis regionAnalysis = RegionAnalysis.get(region);
            regionAnalysis.buildNavigationEdgesIndex(typedModel2property2predicatedEdges, typedModel2property2realizedEdges);
        }
        for (Region region : orderedRegions) {
            int earliestIndex = (Integer)region.getIndexes().get(0);
            ArrayList<DatumConnection> redundantConnections = null;
            for (DatumConnection usedConnection : region.getIncomingConnections()) {
                if (usedConnection.isPassed(region)) continue;
                boolean isRedundant = true;
                for (Region sourceRegion : usedConnection.getSourceRegions()) {
                    @NonNull List indexes = sourceRegion.getIndexes();
                    int lastIndex = (Integer)indexes.get(indexes.size() - 1);
                    if (lastIndex < earliestIndex) continue;
                    isRedundant = false;
                    break;
                }
                if (!isRedundant) continue;
                if (redundantConnections == null) {
                    redundantConnections = new ArrayList<DatumConnection>();
                }
                redundantConnections.add(usedConnection);
            }
            if (redundantConnections == null) continue;
            for (DatumConnection redundantConnection : redundantConnections) {
                redundantConnection.removeTargetRegion(region);
            }
        }
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            this.scheduleManager.writeDebugGraphs(scheduledRegion, "7-pruned", true, true, false);
        }
        if (!(noLateConsumerMerge = this.scheduleManager.isNoLateConsumerMerge())) {
            this.lateMerge(scheduledRegion, orderedRegions, typedModel2property2predicatedEdges, typedModel2property2realizedEdges);
        }
        for (Region region : orderedRegions) {
            this.getRegionAnalysis(region).computeCheckedOrEnforcedEdges(typedModel2property2predicatedEdges, typedModel2property2realizedEdges);
        }
    }

    public @NonNull ScheduledRegion createRootRegion(@NonNull Iterable<@NonNull ? extends Region> allRegions) {
        ScheduledRegion rootRegion = null;
        for (Region region : Lists.newArrayList(allRegions)) {
            if (region.getOwningScheduledRegion() != null) continue;
            if (rootRegion == null) {
                rootRegion = QVTscheduleFactory.eINSTANCE.createScheduledRegion();
                rootRegion.setOwningScheduleModel(this.scheduleManager.getScheduleModel());
                rootRegion.setName(this.rootName);
            }
            region.setOwningScheduledRegion(rootRegion);
        }
        assert (rootRegion != null);
        return rootRegion;
    }

    public void createSchedule1(@NonNull ScheduledRegion rootScheduledRegion) {
        this.computeInputModels(rootScheduledRegion);
        if (QVTm2QVTs.DUMP_INPUT_MODEL_TO_DOMAIN_USAGE.isActive()) {
            QVTm2QVTs.DUMP_INPUT_MODEL_TO_DOMAIN_USAGE.println(this.dumpInputModels().reduce("", QVTscheduleUtil.stringJoin((String)"\n\t")));
        }
        for (Region region : RegionUtil.getOwnedRegions((ScheduledRegion)rootScheduledRegion)) {
            this.contentsAnalysis.addRegion(region);
        }
        if (QVTm2QVTs.DUMP_CLASS_TO_REALIZED_NODES.isActive()) {
            QVTm2QVTs.DUMP_CLASS_TO_REALIZED_NODES.println(this.contentsAnalysis.dumpClass2newNode().reduce("", QVTscheduleUtil.stringJoin((String)"\n\t")));
        }
        if (QVTm2QVTs.DUMP_CLASS_TO_CONSUMING_NODES.isActive()) {
            QVTm2QVTs.DUMP_CLASS_TO_CONSUMING_NODES.println(this.contentsAnalysis.dumpClass2oldNode().reduce("", QVTscheduleUtil.stringJoin((String)"\n\t")));
        }
        this.createRootContainmentRegion(rootScheduledRegion);
        this.createConnections(rootScheduledRegion);
    }

    protected void createSchedule2(@NonNull ScheduledRegion rootScheduledRegion) {
        ArrayList<@NonNull ScheduledRegion> allScheduledRegions = new ArrayList<ScheduledRegion>();
        allScheduledRegions.add(rootScheduledRegion);
        for (ScheduledRegion scheduledRegion : allScheduledRegions) {
            this.createLocalSchedule(scheduledRegion);
        }
        ScheduleIndexer scheduleIndexer = new ScheduleIndexer(rootScheduledRegion);
        scheduleIndexer.schedule(rootScheduledRegion);
        for (ScheduledRegion scheduledRegion : allScheduledRegions) {
            this.createLocalSchedule2(scheduledRegion, scheduleIndexer.getOrdering());
        }
    }

    private Stream<String> dumpInputModels() {
        Stream<String> entries = this.inputModels.keySet().stream().map(k -> String.valueOf(String.valueOf(k)) + " : " + String.valueOf(this.inputModels.get(k)));
        return entries.sorted();
    }

    public @NonNull NodeConnection getAttributeConnection(@NonNull ScheduledRegion scheduledRegion, @NonNull Iterable<@NonNull Node> sourceNodes, @NonNull CompleteClass owningClass, @NonNull Property property, @NonNull ClassDatum classDatum) {
        HashSet sourceSet;
        NodeConnection connection;
        Map<@NonNull Set<@NonNull Node>, @NonNull NodeConnection> nodes2connection = this.classDatum2nodes2nodeConnections.get(classDatum);
        if (nodes2connection == null) {
            nodes2connection = new HashMap<Set<Node>, NodeConnection>();
            this.classDatum2nodes2nodeConnections.put(classDatum, nodes2connection);
        }
        if ((connection = nodes2connection.get(sourceSet = Sets.newHashSet(sourceNodes))) == null) {
            SymbolNameBuilder s = new SymbolNameBuilder();
            s.appendString("ja_");
            s.appendName(owningClass.getName());
            s.appendString("_");
            s.appendName(property.getName());
            connection = this.createNodeConnection(scheduledRegion, sourceSet, classDatum, s);
            nodes2connection.put(sourceSet, connection);
        }
        return connection;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull EdgeConnection getEdgeConnection(@NonNull ScheduledRegion scheduledRegion, @NonNull Iterable<@NonNull NavigableEdge> sourceEdges, @NonNull Property property) {
        @NonNull HashSet sourceSet = Sets.newHashSet(sourceEdges);
        EdgeConnection connection = this.edges2edgeConnection.get(sourceSet);
        if (connection == null) {
            SymbolNameBuilder s = new SymbolNameBuilder();
            s.appendString("je_");
            s.appendName(property.getOwningClass().getName());
            s.appendString("_");
            s.appendName(property.getName());
            connection = this.createEdgeConnection(scheduledRegion, sourceSet, property, s);
            this.edges2edgeConnection.put(sourceSet, connection);
        }
        return connection;
    }

    public @Nullable Iterable<@NonNull Node> getIntroducingOrNewNodes(@NonNull Node headNode) {
        ClassDatumAnalysis classDatumAnalysis = RegionUtil.getClassDatumAnalysis(headNode);
        if (!classDatumAnalysis.getDomainUsage().isInput()) {
            return this.contentsAnalysis.getNewNodes(classDatumAnalysis);
        }
        ArrayList<@NonNull Node> nodes = new ArrayList<Node>();
        nodes.add(this.rootAnalysis.getIntroducerNode(headNode));
        for (TypedModel dependsOn : QVTbaseUtil.getDependsOns((TypedModel)RegionUtil.getTypedModel(classDatumAnalysis))) {
            ClassDatumAnalysis classDatumAnalysis2 = this.scheduleManager.getClassDatumAnalysis(headNode.getCompleteClass().getPrimaryClass(), dependsOn);
            Iterable<@NonNull Node> newNodes = this.contentsAnalysis.getNewNodes(classDatumAnalysis2);
            if (newNodes == null) continue;
            for (Node newNode : newNodes) {
                if (nodes.contains(newNode)) continue;
                nodes.add(newNode);
            }
        }
        return nodes;
    }

    public @Nullable Iterable<@NonNull NavigableEdge> getNewEdges(@NonNull NavigableEdge edge, @NonNull ClassDatumAnalysis requiredClassDatumAnalysis) {
        return this.contentsAnalysis.getNewEdges(edge, requiredClassDatumAnalysis);
    }

    public @Nullable Iterable<@NonNull Node> getNewNodes(@NonNull ClassDatumAnalysis classDatumAnalysis) {
        return this.contentsAnalysis.getNewNodes(classDatumAnalysis);
    }

    private @NonNull NodeConnection getNodeConnection(@NonNull ScheduledRegion scheduledRegion, @NonNull Iterable<@NonNull Node> sourceNodes, @NonNull ClassDatum classDatum, @NonNull DomainUsage domainUsage) {
        HashSet sourceSet;
        NodeConnection connection;
        Map<@NonNull Set<@NonNull Node>, @NonNull NodeConnection> nodes2connection = this.classDatum2nodes2nodeConnections.get(classDatum);
        if (nodes2connection == null) {
            nodes2connection = new HashMap<Set<Node>, NodeConnection>();
            this.classDatum2nodes2nodeConnections.put(classDatum, nodes2connection);
        }
        if ((connection = nodes2connection.get(sourceSet = Sets.newHashSet(sourceNodes))) == null) {
            SymbolNameBuilder s = new SymbolNameBuilder();
            s.appendString("j");
            s.appendString(domainUsage.isInput() ? "i" : (domainUsage.isOutput() ? "o" : "m"));
            s.appendString("_");
            s.appendName(classDatum.getCompleteClass().getName());
            connection = this.createNodeConnection(scheduledRegion, sourceSet, classDatum, s);
            nodes2connection.put(sourceSet, connection);
        }
        return connection;
    }

    public @NonNull RegionAnalysis getRegionAnalysis(@NonNull Region region) {
        RegionAnalysis regionAnalysis = this.region2regionAnalysis.get(region);
        if (regionAnalysis == null) {
            regionAnalysis = RegionAnalysis.get(region);
            this.region2regionAnalysis.put(region, regionAnalysis);
        }
        return regionAnalysis;
    }

    public @NonNull StandardLibraryHelper getStandardLibraryHelper() {
        return this.standardLibraryHelper;
    }

    private boolean isCompatiblePattern(@NonNull Region region, @NonNull Node calledNode, @NonNull Node callingNode, @NonNull Map<@NonNull Node, @NonNull Node> called2calling) {
        Node oldPrevNode = called2calling.put(calledNode, callingNode);
        if (oldPrevNode != null) {
            return oldPrevNode == callingNode;
        }
        for (NavigableEdge calledEdge : calledNode.getNavigationEdges()) {
            NavigableEdge nextCallingEdge;
            Node nextCalledNode = calledEdge.getEdgeTarget();
            if (nextCalledNode.isRealized() || nextCalledNode.isDataType() || (nextCallingEdge = callingNode.getNavigationEdge(QVTscheduleUtil.getProperty((NavigableEdge)calledEdge))) == null) continue;
            Node nextCallingNode = nextCallingEdge.getEdgeTarget();
            if (nextCallingNode.isExplicitNull() != nextCalledNode.isExplicitNull()) {
                return false;
            }
            if (this.isCompatiblePattern(region, nextCalledNode, nextCallingNode, called2calling)) continue;
            return false;
        }
        return true;
    }

    private void lateMerge(@NonNull ScheduledRegion scheduledRegion, @NonNull List<@NonNull Region> orderedRegions, @NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2predicatedEdges, @NonNull Map<@NonNull TypedModel, @NonNull Map<@NonNull Property, @NonNull List<@NonNull NavigableEdge>>> typedModel2property2realizedEdges) {
        Map<@NonNull Region, @NonNull List<@NonNull Region>> newRegion2oldRegions = LateConsumerMerger.merge(scheduledRegion);
        for (Map.Entry<Region, List<Region>> entry : newRegion2oldRegions.entrySet()) {
            Region newRegion = entry.getKey();
            List<@NonNull Region> oldRegions = entry.getValue();
            assert (oldRegions.size() >= 2);
            int orderedRegionIndex = orderedRegions.indexOf(oldRegions.get(0));
            for (Region oldRegion : oldRegions) {
                orderedRegions.remove(oldRegion);
                oldRegion.setOwningScheduledRegion(null);
            }
            orderedRegions.add(orderedRegionIndex, newRegion);
            QVTscheduleConstants.POLLED_PROPERTIES.println("building indexes for " + newRegion + " " + newRegion.getIndexRangeText());
            RegionAnalysis regionAnalysis = RegionAnalysis.get(newRegion);
            regionAnalysis.buildNavigationEdgesIndex(typedModel2property2predicatedEdges, typedModel2property2realizedEdges);
        }
    }

    protected void splitRegions() {
    }

    public @NonNull ScheduledRegion transform(@NonNull ScheduleManager scheduleManager, @NonNull Iterable<@NonNull ? extends Region> activeRegions) throws CompilerChainException {
        this.contentsAnalysis = new ContentsAnalysis(scheduleManager);
        ((LoadingRegionImpl)this.loadingRegion).setFixmeScheduleModel(scheduleManager.getScheduleModel());
        Iterable<@NonNull MappingRegion> partitionedRegions = Partitioner.partition(this.problemHandler, activeRegions);
        if (!Iterables.isEmpty(partitionedRegions)) {
            activeRegions = partitionedRegions;
        }
        ScheduledRegion rootRegion = this.createRootRegion(activeRegions);
        this.createSchedule1(rootRegion);
        this.createSchedule2(rootRegion);
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            scheduleManager.writeDebugGraphs(rootRegion, "9-final", true, true, true);
        }
        return rootRegion;
    }
}

