/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionUtil;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.splitter.SimpleGroup;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;

class SplitterUtil {
    SplitterUtil() {
    }

    public static @NonNull Set<@NonNull Node> computeComputableTargetNodes(@NonNull Iterable<@NonNull Node> seedNodes) {
        HashSet<@NonNull Node> computableTargetNodes = new HashSet<Node>();
        HashSet<@NonNull Node> unresolvedOperationNodes = new HashSet<Node>();
        for (Node node : seedNodes) {
            SplitterUtil.computeComputableTargetNodes(computableTargetNodes, node, unresolvedOperationNodes);
        }
        while (!unresolvedOperationNodes.isEmpty()) {
            boolean resolvedOne = false;
            for (Node unresolvedNode : new ArrayList<Node>(unresolvedOperationNodes)) {
                boolean allReachable = true;
                for (Edge edge : RegionUtil.getIncomingEdges((Node)unresolvedNode)) {
                    if (!edge.isExpression() || computableTargetNodes.contains(edge.getEdgeSource())) continue;
                    allReachable = false;
                }
                if (!allReachable) continue;
                resolvedOne = true;
                unresolvedOperationNodes.remove(unresolvedNode);
                SplitterUtil.computeComputableTargetNodes(computableTargetNodes, unresolvedNode, unresolvedOperationNodes);
            }
            if (!resolvedOne) break;
        }
        return Collections.unmodifiableSet(computableTargetNodes);
    }

    private static void computeComputableTargetNodes(@NonNull Set<@NonNull Node> computableTargetNodes, @NonNull Node sourceNode, @NonNull Set<@NonNull Node> unresolvedOperationNodes) {
        if (computableTargetNodes.add(sourceNode)) {
            for (Edge edge : RegionUtil.getOutgoingEdges((Node)sourceNode)) {
                if (!edge.isComputation() && (!edge.isNavigation() || edge.isMatched())) continue;
                Node targetNode = edge.getEdgeTarget();
                if (targetNode.isRealized() && targetNode.isOperation()) {
                    unresolvedOperationNodes.add(targetNode);
                    continue;
                }
                SplitterUtil.computeComputableTargetNodes(computableTargetNodes, targetNode, unresolvedOperationNodes);
            }
            for (Edge edge : RegionUtil.getIncomingEdges((Node)sourceNode)) {
                Node node;
                if (!edge.isComputation() || !(node = edge.getEdgeSource()).isConstant()) continue;
                SplitterUtil.computeComputableTargetNodes(computableTargetNodes, node, unresolvedOperationNodes);
            }
        }
    }

    public static @NonNull List<@NonNull Node> computeHeadNodes(@NonNull Iterable<@NonNull SimpleGroup> simpleGroups) {
        HashSet<@NonNull Node> headNodeSet = new HashSet<Node>();
        for (SimpleGroup simpleGroup : simpleGroups) {
            headNodeSet.add(simpleGroup.getHeadNode());
        }
        ArrayList<@NonNull Node> headNodeList = new ArrayList<Node>(headNodeSet);
        Collections.sort(headNodeList, NameUtil.NAMEABLE_COMPARATOR);
        return headNodeList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull String computeMultiHeadNodeName(Iterable<@NonNull Node> headNodes) {
        StringBuilder s = new StringBuilder();
        @NonNull ArrayList sortedHeadNodes = Lists.newArrayList(headNodes);
        Collections.sort(sortedHeadNodes, NameUtil.NAMEABLE_COMPARATOR);
        for (Node headNode : sortedHeadNodes) {
            if (s.length() <= 0) {
                s.append("\"");
            } else {
                s.append(",");
            }
            s.append(headNode.getName());
        }
        s.append("\"");
        return s.toString();
    }

    public static @NonNull Set<@NonNull Node> computeNavigableNodes(@NonNull Iterable<@NonNull Node> headNodes) {
        HashSet<@NonNull Node> reachableNodes = new HashSet<Node>();
        for (Node headNode : headNodes) {
            SplitterUtil.computeNavigableNodes(reachableNodes, headNode);
        }
        return reachableNodes;
    }

    private static @NonNull Set<@NonNull Node> computeNavigableNodes(@NonNull Set<@NonNull Node> reachableNodes, @NonNull Node sourceNode) {
        if (reachableNodes.add(sourceNode)) {
            for (NavigableEdge edge : sourceNode.getNavigationEdges()) {
                assert (edge.getEdgeSource() == sourceNode);
                if (edge.isRealized() || !edge.isMatched()) continue;
                Node targetNode = edge.getEdgeTarget();
                SplitterUtil.computeNavigableNodes(reachableNodes, targetNode);
            }
        }
        return reachableNodes;
    }

    public static boolean isBidirectional(@NonNull Edge edge) {
        if (!edge.isNavigation()) {
            return false;
        }
        Node sourceNode = edge.getEdgeSource();
        Node targetNode = edge.getEdgeTarget();
        for (Edge edge2 : RegionUtil.getOutgoingEdges((Node)targetNode)) {
            if (!edge2.isNavigation() || edge2.getEdgeTarget() != sourceNode) continue;
            return true;
        }
        return false;
    }
}

