/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LiteralExp;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.FinalAnalysis;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ContainmentAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.OperationDependencyPaths;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.OperationDependencyStep;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.StandardLibraryHelper;
import org.eclipse.qvtd.pivot.qvtcore.CorePattern;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.OppositePropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcore.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcore.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcore.util.AbstractExtendingQVTcoreVisitor;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;

public class OperationDependencyAnalysis {
    public static final @NonNull TracingOption ATTEMPT = new TracingOption(CompilerConstants.PLUGIN_ID, "dependency/attempt");
    public static final @NonNull TracingOption CALL = new TracingOption(CompilerConstants.PLUGIN_ID, "dependency/call");
    public static final @NonNull TracingOption CREATE = new TracingOption(CompilerConstants.PLUGIN_ID, "dependency/create");
    public static final @NonNull TracingOption HYPOTHECATING = new TracingOption(CompilerConstants.PLUGIN_ID, "dependency/hypothecating");
    public static final @NonNull TracingOption PENDING = new TracingOption(CompilerConstants.PLUGIN_ID, "dependency/pending");
    public static final @NonNull TracingOption REFINING = new TracingOption(CompilerConstants.PLUGIN_ID, "dependency/refining");
    public static final @NonNull TracingOption RESULT = new TracingOption(CompilerConstants.PLUGIN_ID, "dependency/result");
    public static final @NonNull TracingOption START = new TracingOption(CompilerConstants.PLUGIN_ID, "dependency/start");
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory;
    private final @NonNull MetamodelManager metamodelManager;
    private final @NonNull CompleteModel completeModel;
    protected final @NonNull StandardLibraryHelper standardLibraryHelper;
    protected final @NonNull RootDomainUsageAnalysis domainUsageAnalysis;
    private final @NonNull Map<@NonNull List<@Nullable Object>, @NonNull BasicDependencyPaths> content2path = new HashMap<List<Object>, BasicDependencyPaths>();
    private final @NonNull BasicDependencyPaths emptyDependencyPaths = this.createDependencyPaths(null, null);
    private final @NonNull Map<@NonNull OperationId, @NonNull Map<@NonNull List<@NonNull BasicDependencyPaths>, @NonNull OperationAnalysis>> operation2paths2analysis = new HashMap<OperationId, Map<List<BasicDependencyPaths>, OperationAnalysis>>();
    private final @NonNull Map<DomainUsage, @NonNull DependencyStepFactory> usage2factory = new HashMap<DomainUsage, DependencyStepFactory>();
    private final @NonNull ContainmentAnalysis containmentAnalysis;
    private final @NonNull FinalAnalysis finalAnalysis;
    protected final @NonNull CompleteClass oclVoidCompleteClass;
    protected final @NonNull CompleteClass oclInvalidCompleteClass;
    private final @NonNull Deque<@NonNull AbstractOperationAnalysis> pending = new LinkedList<AbstractOperationAnalysis>();
    private final @NonNull Set<@NonNull OperationAnalysis> refining = new HashSet<OperationAnalysis>();

    public OperationDependencyAnalysis(@NonNull ContainmentAnalysis containmentAnalysis, @NonNull RootDomainUsageAnalysis domainUsageAnalysis) {
        this.environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)containmentAnalysis.getEnvironmentFactory();
        this.metamodelManager = this.environmentFactory.getMetamodelManager();
        StandardLibraryInternal standardLibrary = this.environmentFactory.getStandardLibrary();
        this.standardLibraryHelper = new StandardLibraryHelper((StandardLibrary)standardLibrary);
        this.domainUsageAnalysis = domainUsageAnalysis;
        this.containmentAnalysis = containmentAnalysis;
        this.finalAnalysis = ((PivotMetamodelManager)this.metamodelManager).getFinalAnalysis();
        this.completeModel = this.environmentFactory.getCompleteModel();
        this.oclVoidCompleteClass = this.completeModel.getCompleteClass((Type)standardLibrary.getOclVoidType());
        this.oclInvalidCompleteClass = this.completeModel.getCompleteClass((Type)standardLibrary.getOclInvalidType());
    }

    protected void addPendingAnalysis(@NonNull AbstractOperationAnalysis operationAnalysis) {
        PENDING.println(operationAnalysis.toString());
        assert (operationAnalysis.basicGetResult() == null);
        this.refining.remove(operationAnalysis);
        if (!this.pending.contains(operationAnalysis)) {
            this.pending.add(operationAnalysis);
        }
    }

    protected void addRefiningAnalysis(@NonNull OperationAnalysis operationAnalysis) {
        REFINING.println(operationAnalysis.toString());
        assert (!this.pending.contains(operationAnalysis));
        assert (operationAnalysis.basicGetResult() == null);
        this.refining.add(operationAnalysis);
    }

    public @NonNull OperationDependencyPaths analyze(@NonNull OperationCallExp operationCallExp) {
        RootOperationAnalysis rootAnalysis = new RootOperationAnalysis(this, operationCallExp);
        return this.analyze(rootAnalysis.visitor, (Element)rootAnalysis.operationCallExp);
    }

    /*
     * Unable to fully structure code
     */
    private @NonNull OperationDependencyPaths analyze(@NonNull DependencyAnalyzerVisitor visitor, @NonNull Element element) {
        result = visitor.analyze((Visitable)element);
        ** GOTO lbl12
        {
            this.checkAll();
            analysis = this.pending.remove();
            analysis.analyze(true);
            do {
                if (this.pending.size() > 0) continue block0;
                if (this.refining.size() <= 0) continue;
                this.checkAll();
                analysis = this.removeRefining();
                analysis.analyze(false);
lbl12:
                // 3 sources

            } while (this.pending.size() > 0 || this.refining.size() > 0);
        }
        result2 = visitor.analyze((Visitable)element);
        return (OperationDependencyPaths)ClassUtil.nonNullState((Object)result2);
    }

    public @NonNull OperationDependencyPaths analyzeOperation(@NonNull OperationCallExp operationCallExp) {
        RootOperationAnalysis rootAnalysis = new RootOperationAnalysis(this, operationCallExp);
        this.analyze(rootAnalysis.visitor, (Element)operationCallExp);
        return rootAnalysis.visitor.analyzeOperation(operationCallExp);
    }

    private void checkAll() {
        for (Map<List<BasicDependencyPaths>, OperationAnalysis> paths2analysis : this.operation2paths2analysis.values()) {
            for (List<BasicDependencyPaths> paths : paths2analysis.keySet()) {
                for (OperationDependencyPaths operationDependencyPaths : paths) {
                    assert (Iterables.isEmpty(operationDependencyPaths.getHiddenPaths()));
                    for (List<OperationDependencyStep> steps : operationDependencyPaths.getReturnPaths()) {
                        for (OperationDependencyStep step : steps) {
                            assert (step instanceof ClassDependencyStep);
                        }
                    }
                }
            }
            for (OperationAnalysis operationAnalysis : paths2analysis.values()) {
                operationAnalysis.check();
            }
        }
    }

    protected @NonNull ClassDependencyStep createClassDependencyStep(@NonNull Type type, @NonNull Element element) {
        while (type instanceof CollectionType) {
            type = (Type)ClassUtil.nonNullState((Object)((Class)((CollectionType)type).getElementType()));
        }
        DomainUsage usage1 = this.domainUsageAnalysis.basicGetUsage((Element)type);
        DomainUsage usage = usage1 != null ? usage1 : this.getUsage(element);
        DependencyStepFactory factory = this.getDependencyStepFactory(usage);
        return factory.createClassDependencyStep((Class)type, element);
    }

    protected @NonNull DependencyAnalyzerVisitor createDependencyAnalyzerVisitor(@NonNull AbstractOperationAnalysis operationAnalysis, boolean exactResult) {
        return new DependencyAnalyzerVisitor(operationAnalysis, exactResult);
    }

    public @NonNull BasicDependencyPaths createDependencyPaths(@NonNull TypedElement typedElement) {
        Class type = (Class)ClassUtil.nonNullState((Object)((Class)typedElement.getType()));
        return this.createDependencyPaths(this.createClassDependencyStep((Type)type, (Element)typedElement));
    }

    protected @NonNull BasicDependencyPaths createDependencyPaths(@NonNull OperationDependencyStep returnStep) {
        HashSet<@NonNull List<@NonNull OperationDependencyStep>> returnPaths = new HashSet<List<OperationDependencyStep>>();
        returnPaths.add(Collections.singletonList(returnStep));
        return this.createDependencyPaths(returnPaths, null);
    }

    protected @NonNull BasicDependencyPaths createDependencyPaths(@Nullable Set<@NonNull List<@NonNull OperationDependencyStep>> returnPaths, @Nullable Set<@NonNull List<@NonNull OperationDependencyStep>> hiddenPaths) {
        ArrayList<@Nullable Set<List<OperationDependencyStep>>> content = new ArrayList<Set<List<OperationDependencyStep>>>();
        content.add(returnPaths);
        content.add(hiddenPaths);
        BasicDependencyPaths path = this.content2path.get(content);
        if (path == null) {
            path = new BasicDependencyPaths(this, returnPaths, hiddenPaths);
            this.content2path.put(content, path);
        }
        return path;
    }

    public @NonNull BasicDependencyPaths createParameterDependencyPaths(@NonNull VariableDeclaration parameter) {
        return this.createDependencyPaths(this.createParameterDependencyStep(parameter));
    }

    protected @NonNull ParameterDependencyStep createParameterDependencyStep(@NonNull VariableDeclaration parameter) {
        Type type = parameter.getType();
        while (type instanceof CollectionType) {
            type = (Type)ClassUtil.nonNullState((Object)((CollectionType)type).getElementType());
        }
        assert (type != null);
        DomainUsage usage1 = this.domainUsageAnalysis.basicGetUsage((Element)type);
        DomainUsage usage = usage1 != null ? usage1 : this.getUsage((Element)parameter);
        DependencyStepFactory factory = this.getDependencyStepFactory(usage);
        return factory.createParameterDependencyStep((Class)type, parameter);
    }

    protected @NonNull NavigationDependencyStep createPropertyDependencyStep(@NonNull NavigationCallExp navigationCallExp) {
        DomainUsage usage = this.getUsage((Element)navigationCallExp);
        DependencyStepFactory factory = this.getDependencyStepFactory(usage);
        return factory.createPropertyDependencyStep(navigationCallExp);
    }

    protected @NonNull NavigationDependencyStep createPropertyDependencyStep(@NonNull Property containmentProperty, @NonNull OperationCallExp oclContainerCallExp) {
        DomainUsage usage = this.getUsage((Element)containmentProperty);
        DependencyStepFactory factory = this.getDependencyStepFactory(usage);
        return factory.createPropertyDependencyStep(containmentProperty, oclContainerCallExp);
    }

    public void dump() {
        ArrayList<@NonNull OperationId> operationIds = new ArrayList<OperationId>(this.operation2paths2analysis.keySet());
        Collections.sort(operationIds, new Comparator<OperationId>(){

            @Override
            public int compare(@NonNull OperationId o1, @NonNull OperationId o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (OperationId operationId : operationIds) {
            System.out.println(operationId);
            Map<@NonNull List<@NonNull BasicDependencyPaths>, @NonNull OperationAnalysis> map = this.operation2paths2analysis.get(operationId);
            assert (map != null);
            for (List<BasicDependencyPaths> paths : map.keySet()) {
                for (BasicDependencyPaths path : paths) {
                    System.out.println("\t" + path);
                }
                System.out.println("\t=>" + map.get(paths));
            }
        }
    }

    protected @NonNull DependencyStepFactory getDependencyStepFactory(@NonNull DomainUsage usage) {
        DependencyStepFactory factory = this.usage2factory.get(usage);
        if (factory == null) {
            factory = new DependencyStepFactory(usage);
            this.usage2factory.put(usage, factory);
        }
        return factory;
    }

    private @NonNull Set<@NonNull AbstractOperationAnalysis> getInvokers(@NonNull AbstractOperationAnalysis analysis, @NonNull Set<@NonNull AbstractOperationAnalysis> invokers) {
        if (invokers.add(analysis) && analysis.invokingFutureAnalyses != null) {
            for (AbstractOperationAnalysis invokingAnalysis : analysis.invokingFutureAnalyses) {
                this.getInvokers(invokingAnalysis, invokers);
            }
        }
        return invokers;
    }

    public @NonNull StandardLibrary getStandardLibrary() {
        return this.standardLibraryHelper.getStandardLibrary();
    }

    protected @NonNull DomainUsage getUsage(@NonNull Element element) {
        DomainUsage usage = this.domainUsageAnalysis.getUsage(element);
        assert (usage != null);
        return usage;
    }

    protected void removeRefiningAnalysis(@NonNull OperationAnalysis operationAnalysis) {
        this.refining.remove(operationAnalysis);
    }

    private @NonNull OperationAnalysis removeRefining() {
        final @NonNull HashMap<@NonNull OperationAnalysis, @NonNull Set<@NonNull AbstractOperationAnalysis>> analysis2invokers = new HashMap<OperationAnalysis, Set<AbstractOperationAnalysis>>();
        HashMap<@NonNull String, @NonNull OperationAnalysis> key2analysis = new HashMap<String, OperationAnalysis>();
        for (OperationAnalysis analysis : this.refining) {
            key2analysis.put(analysis.toString(), analysis);
            analysis2invokers.put(analysis, this.getInvokers(analysis, new HashSet<AbstractOperationAnalysis>()));
            analysis.check();
        }
        ArrayList<@NonNull OperationAnalysis> sortedBlockedAnalyses = new ArrayList<OperationAnalysis>(this.refining);
        Collections.sort(sortedBlockedAnalyses, new Comparator<AbstractOperationAnalysis>(){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Override
            public int compare(@NonNull AbstractOperationAnalysis o1, @NonNull AbstractOperationAnalysis o2) {
                int i2;
                @NonNull Set s1 = (Set)analysis2invokers.get(o1);
                @NonNull Set s2 = (Set)analysis2invokers.get(o2);
                if (!($assertionsDisabled || s1 != null && s2 != null)) {
                    throw new AssertionError();
                }
                int i1 = s1.size();
                int diff = i1 - (i2 = s2.size());
                if (diff != 0) {
                    return diff;
                }
                return ClassUtil.safeCompareTo((Comparable)((Object)o1.toString()), (Comparable)((Object)o2.toString()));
            }
        });
        OperationAnalysis mostBlocked = null;
        mostBlocked = (OperationAnalysis)sortedBlockedAnalyses.get(sortedBlockedAnalyses.size() - 1);
        assert (mostBlocked != null);
        this.refining.remove(mostBlocked);
        HYPOTHECATING.println(mostBlocked.toString());
        return mostBlocked;
    }

    public static abstract class AbstractOperationAnalysis {
        protected final @NonNull OperationDependencyAnalysis operationDependencyAnalysis;
        protected @Nullable Collection<@NonNull OperationAnalysis> invokedFutureAnalyses = null;
        protected @Nullable Set<@NonNull AbstractOperationAnalysis> invokingFutureAnalyses = null;
        protected BasicDependencyPaths result = null;

        protected AbstractOperationAnalysis(@NonNull OperationDependencyAnalysis operationDependencyAnalysis) {
            this.operationDependencyAnalysis = operationDependencyAnalysis;
        }

        protected void addInvokedFutureAnalysis(@NonNull OperationAnalysis invokedAnalysis) {
            Collection<@NonNull OperationAnalysis> invokedFutureAnalyses2 = this.invokedFutureAnalyses;
            if (invokedFutureAnalyses2 == null) {
                this.invokedFutureAnalyses = invokedFutureAnalyses2 = new HashSet<OperationAnalysis>();
            }
            invokedFutureAnalyses2.add(invokedAnalysis);
        }

        protected void addInvokingFutureAnalysis(@NonNull AbstractOperationAnalysis invokingAnalysis) {
            Set<@NonNull AbstractOperationAnalysis> invokingFutureAnalyses2 = this.invokingFutureAnalyses;
            if (invokingFutureAnalyses2 == null) {
                this.invokingFutureAnalyses = invokingFutureAnalyses2 = new HashSet<AbstractOperationAnalysis>();
            }
            invokingFutureAnalyses2.add(invokingAnalysis);
        }

        public abstract void analyze(boolean var1);

        public @Nullable BasicDependencyPaths basicGetResult() {
            return this.result;
        }

        public void check() {
            Collection<@NonNull OperationAnalysis> invokedFutureAnalyses2 = this.invokedFutureAnalyses;
            Set<@NonNull AbstractOperationAnalysis> invokingFutureAnalyses2 = this.invokingFutureAnalyses;
            if (this.result != null) {
                assert (invokedFutureAnalyses2 == null || invokedFutureAnalyses2.isEmpty()) : "Analysis with result should not invoke futures:" + this;
                assert (invokingFutureAnalyses2 == null || invokingFutureAnalyses2.isEmpty()) : "Analysis with result should not be invoked as a future: " + this;
                assert (!this.operationDependencyAnalysis.pending.contains(this)) : "Analysis with result should not be pending: " + this;
                assert (!this.operationDependencyAnalysis.refining.contains(this)) : "Analysis with result should not be refining: " + this;
            } else if (this.operationDependencyAnalysis.refining.contains(this)) {
                assert (!this.operationDependencyAnalysis.pending.contains(this)) : "Analysis with refining result should not be pending: " + this;
            } else {
                assert (this.operationDependencyAnalysis.pending.contains(this)) : "Analysis with pending result should be pending: " + this;
                assert (!this.operationDependencyAnalysis.refining.contains(this)) : "Analysis with pending result should not be refining: " + this;
            }
        }

        protected void removeInvokedAnalysis(@NonNull OperationAnalysis operationAnalysis) {
            assert (this.invokedFutureAnalyses != null);
            boolean wasRemoved = this.invokedFutureAnalyses.remove(operationAnalysis);
            assert (wasRemoved);
        }

        protected void removeInvokingAnalysis(@NonNull AbstractOperationAnalysis operationAnalysis) {
            assert (this.invokingFutureAnalyses != null);
            boolean wasRemoved = this.invokingFutureAnalyses.remove(operationAnalysis);
            assert (wasRemoved);
        }

        protected void resetInvokedFutureAnalyses() {
            Collection<@NonNull OperationAnalysis> invokedFutureAnalyses2 = this.invokedFutureAnalyses;
            if (invokedFutureAnalyses2 != null) {
                for (OperationAnalysis invokedFutureAnalysis : invokedFutureAnalyses2) {
                    invokedFutureAnalysis.removeInvokingAnalysis(this);
                }
                invokedFutureAnalyses2.clear();
            }
        }
    }

    protected static class BasicDependencyPaths
    implements OperationDependencyPaths {
        protected final @NonNull OperationDependencyAnalysis operationDependencyAnalysis;
        private final @NonNull Set<@NonNull List<@NonNull OperationDependencyStep>> returnPaths;
        private final @NonNull Set<@NonNull List<@NonNull OperationDependencyStep>> hiddenPaths;

        protected BasicDependencyPaths(@NonNull OperationDependencyAnalysis operationDependencyAnalysis, @Nullable Set<@NonNull List<@NonNull OperationDependencyStep>> returnPaths, @Nullable Set<@NonNull List<@NonNull OperationDependencyStep>> hiddenPaths) {
            Set immutableHiddenPaths;
            Set immutableReturnPaths;
            this.operationDependencyAnalysis = operationDependencyAnalysis;
            if (returnPaths != null) {
                immutableReturnPaths = new HashSet(returnPaths.size());
                for (List<OperationDependencyStep> returnPath : returnPaths) {
                    immutableReturnPaths.add(Collections.unmodifiableList(returnPath));
                }
            } else {
                immutableReturnPaths = Collections.emptySet();
            }
            this.returnPaths = Collections.unmodifiableSet(immutableReturnPaths);
            if (hiddenPaths != null) {
                immutableHiddenPaths = new HashSet(hiddenPaths.size());
                for (List<OperationDependencyStep> hiddenPath : hiddenPaths) {
                    immutableHiddenPaths.add(Collections.unmodifiableList(hiddenPath));
                }
            } else {
                immutableHiddenPaths = Collections.emptySet();
            }
            this.hiddenPaths = Collections.unmodifiableSet(immutableHiddenPaths);
        }

        public @NonNull BasicDependencyPaths addHidden(@NonNull BasicDependencyPaths secondPath) {
            Set<@NonNull List<@NonNull OperationDependencyStep>> newHiddenPaths = this.hiddenPaths;
            Set<@NonNull List<@NonNull OperationDependencyStep>> secondPathHiddenPaths = secondPath.basicGetHiddenPaths();
            newHiddenPaths = new HashSet<List<OperationDependencyStep>>(newHiddenPaths);
            newHiddenPaths.addAll(secondPathHiddenPaths);
            Set<@NonNull List<@NonNull OperationDependencyStep>> secondPathReturnPaths = secondPath.basicGetReturnPaths();
            newHiddenPaths = new HashSet<List<OperationDependencyStep>>(newHiddenPaths);
            newHiddenPaths.addAll(secondPathReturnPaths);
            return this.operationDependencyAnalysis.createDependencyPaths(this.returnPaths, newHiddenPaths);
        }

        public @NonNull BasicDependencyPaths addReturn(@NonNull BasicDependencyPaths secondPath) {
            Set<@NonNull List<@NonNull OperationDependencyStep>> secondPathReturnPaths = secondPath.basicGetReturnPaths();
            HashSet<@NonNull List<@NonNull OperationDependencyStep>> newReturnPaths = new HashSet<List<OperationDependencyStep>>(this.returnPaths);
            newReturnPaths.addAll(secondPathReturnPaths);
            Set<@NonNull List<@NonNull OperationDependencyStep>> secondPathHiddenPaths = secondPath.basicGetHiddenPaths();
            HashSet<@NonNull List<@NonNull OperationDependencyStep>> newHiddenPaths = new HashSet<List<OperationDependencyStep>>(this.hiddenPaths);
            newHiddenPaths.addAll(secondPathHiddenPaths);
            return this.operationDependencyAnalysis.createDependencyPaths(newReturnPaths, newHiddenPaths);
        }

        public @NonNull BasicDependencyPaths append(@NonNull NavigationDependencyStep propertyDependencyStep) {
            Set<@NonNull List<@NonNull OperationDependencyStep>> oldReturnPaths = this.returnPaths;
            if (BasicDependencyPaths.isRedundant(oldReturnPaths, propertyDependencyStep.getProperty())) {
                return this;
            }
            StandardLibrary standardLibrary = this.operationDependencyAnalysis.getStandardLibrary();
            HashSet<@NonNull List<@NonNull OperationDependencyStep>> newReturnPaths = new HashSet<List<OperationDependencyStep>>();
            for (List<OperationDependencyStep> oldReturnPath : oldReturnPaths) {
                List<OperationDependencyStep> newReturnPath = null;
                int size = oldReturnPath.size();
                assert (size > 0);
                if (size > 0 && oldReturnPath.get(size - 1) == propertyDependencyStep) {
                    newReturnPath = oldReturnPath;
                } else {
                    Class endClass = oldReturnPath.get(size - 1).getElementalType();
                    Class sourceClass = propertyDependencyStep.getProperty().getOwningClass();
                    assert (sourceClass != null);
                    if (endClass.conformsTo(standardLibrary, (Type)sourceClass)) {
                        newReturnPath = new ArrayList<OperationDependencyStep>(oldReturnPath);
                        newReturnPath.add(propertyDependencyStep);
                    } else if (sourceClass.conformsTo(standardLibrary, (Type)endClass)) {
                        if (oldReturnPath.size() == 1) {
                            ClassDependencyStep newClassDependencyStep = this.operationDependencyAnalysis.createClassDependencyStep((Type)sourceClass, oldReturnPath.get(0).getElement());
                            newReturnPath = new ArrayList<OperationDependencyStep>();
                            newReturnPath.add(newClassDependencyStep);
                        } else {
                            newReturnPath = new ArrayList<OperationDependencyStep>(oldReturnPath);
                        }
                        newReturnPath.add(propertyDependencyStep);
                    } else {
                        newReturnPath = oldReturnPath;
                    }
                }
                newReturnPaths.add(newReturnPath);
            }
            return this.operationDependencyAnalysis.createDependencyPaths(newReturnPaths, this.hiddenPaths);
        }

        public @NonNull Set<@NonNull List<@NonNull OperationDependencyStep>> basicGetHiddenPaths() {
            return this.hiddenPaths;
        }

        public @NonNull Set<@NonNull List<@NonNull OperationDependencyStep>> basicGetReturnPaths() {
            return this.returnPaths;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public @NonNull Iterable<@NonNull List<@NonNull OperationDependencyStep>> getHiddenPaths() {
            HashMap<@NonNull String, @NonNull List<@NonNull OperationDependencyStep>> map = new HashMap<String, List<OperationDependencyStep>>();
            for (List<OperationDependencyStep> list : this.hiddenPaths) {
                map.put(String.valueOf(list), list);
            }
            ArrayList<@NonNull K> sortedKeys = new ArrayList(map.keySet());
            Collections.sort(sortedKeys);
            ArrayList<@NonNull List<@NonNull OperationDependencyStep>> sortedList = new ArrayList<List<OperationDependencyStep>>();
            for (String key : sortedKeys) {
                @NonNull List steps = (List)map.get(key);
                assert (steps != null);
                sortedList.add(steps);
            }
            return sortedList;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public @NonNull Iterable<@NonNull List<@NonNull OperationDependencyStep>> getReturnPaths() {
            HashMap<@NonNull String, @NonNull List<@NonNull OperationDependencyStep>> map = new HashMap<String, List<OperationDependencyStep>>();
            for (List<OperationDependencyStep> list : this.returnPaths) {
                map.put(String.valueOf(list), list);
            }
            ArrayList<@NonNull K> sortedKeys = new ArrayList(map.keySet());
            Collections.sort(sortedKeys);
            ArrayList<@NonNull List<@NonNull OperationDependencyStep>> sortedList = new ArrayList<List<OperationDependencyStep>>();
            for (String key : sortedKeys) {
                @NonNull List steps = (List)map.get(key);
                assert (steps != null);
                sortedList.add(steps);
            }
            return sortedList;
        }

        protected static boolean isRedundant(@NonNull Set<@NonNull List<@NonNull OperationDependencyStep>> paths, @NonNull Property property) {
            for (List<OperationDependencyStep> path : paths) {
                int size = path.size();
                if (size <= 0) {
                    return false;
                }
                OperationDependencyStep dependencyStep = path.get(size - 1);
                if (!(dependencyStep instanceof NavigationDependencyStep)) {
                    return false;
                }
                if (((NavigationDependencyStep)dependencyStep).getProperty() == property) continue;
                return false;
            }
            return true;
        }

        public @NonNull String toString() {
            StringBuilder s = new StringBuilder();
            s.append("{");
            Iterable<@NonNull List<@NonNull OperationDependencyStep>> returnPaths2 = this.getReturnPaths();
            boolean iFirst = true;
            for (List<OperationDependencyStep> path : returnPaths2) {
                if (!iFirst) {
                    s.append("|");
                }
                boolean jFirst = true;
                for (OperationDependencyStep step : path) {
                    if (!jFirst) {
                        s.append("::");
                    }
                    s.append(step.getName());
                    jFirst = false;
                }
                iFirst = false;
            }
            s.append("}++{");
            Iterable<@NonNull List<@NonNull OperationDependencyStep>> hiddenPaths2 = this.getHiddenPaths();
            iFirst = true;
            for (List<OperationDependencyStep> path : hiddenPaths2) {
                if (!iFirst) {
                    s.append("|");
                }
                boolean jFirst = true;
                for (OperationDependencyStep step : path) {
                    if (!jFirst) {
                        s.append("::");
                    }
                    s.append(step.getName());
                    jFirst = false;
                }
                iFirst = false;
            }
            s.append("}");
            return s.toString();
        }
    }

    protected static abstract class BasicDependencyStep
    implements OperationDependencyStep {
        protected final @NonNull DomainUsage usage;
        protected final @NonNull Element element;

        protected BasicDependencyStep(@NonNull DomainUsage usage, @NonNull Element element) {
            this.usage = usage;
            this.element = element;
        }

        @Override
        public @NonNull Element getElement() {
            return this.element;
        }

        public @Nullable CallExp getCallExp() {
            return null;
        }

        public @Nullable Property getProperty() {
            return null;
        }

        @Override
        public @NonNull DomainUsage getUsage() {
            return this.usage;
        }

        public boolean isParameter() {
            return false;
        }
    }

    protected static class ClassDependencyStep
    extends BasicDependencyStep
    implements OperationDependencyStep.ClassStep {
        private final @NonNull Class type;

        public ClassDependencyStep(@NonNull DomainUsage usage, @NonNull Class type, @NonNull Element element) {
            super(usage, element);
            this.type = type;
            assert (!(type instanceof CollectionType));
            assert (!(type instanceof VoidType));
        }

        @Override
        public @NonNull Class getElementalType() {
            return this.type;
        }

        public String getName() {
            return this.type.getName();
        }

        @Override
        public @NonNull Element getPathElement() {
            return this.type;
        }

        public String toString() {
            return this.usage + " \u00ab" + this.type.eClass().getName() + "\u00bb" + this.type.toString();
        }
    }

    protected class DependencyAnalyzerVisitor
    extends AbstractExtendingQVTcoreVisitor<BasicDependencyPaths, Object> {
        private final @NonNull AbstractOperationAnalysis analysis;
        private final boolean exactResult;
        private final @Nullable DependencyAnalyzerVisitor parent;
        private final @NonNull Map<@NonNull VariableDeclaration, @NonNull BasicDependencyPaths> variable2dependencies;

        protected DependencyAnalyzerVisitor(AbstractOperationAnalysis analysis, boolean exactResult) {
            super(null);
            this.variable2dependencies = new HashMap<VariableDeclaration, BasicDependencyPaths>();
            this.analysis = analysis;
            this.exactResult = exactResult;
            this.parent = null;
        }

        protected DependencyAnalyzerVisitor(DependencyAnalyzerVisitor parent) {
            super(null);
            this.variable2dependencies = new HashMap<VariableDeclaration, BasicDependencyPaths>();
            this.analysis = parent.analysis;
            this.exactResult = parent.exactResult;
            this.parent = parent;
        }

        private @Nullable BasicDependencyPaths addHidden(@Nullable BasicDependencyPaths accumulatingResult, @Nullable BasicDependencyPaths additionalResult) {
            if (this.exactResultRequired()) {
                if (accumulatingResult == null || additionalResult == null) {
                    return null;
                }
                return accumulatingResult.addHidden(additionalResult);
            }
            assert (accumulatingResult != null);
            if (additionalResult == null) {
                return accumulatingResult;
            }
            return accumulatingResult.addHidden(additionalResult);
        }

        private @Nullable BasicDependencyPaths addReturn(@Nullable BasicDependencyPaths accumulatingResult, @Nullable BasicDependencyPaths additionalResult) {
            if (this.exactResultRequired()) {
                if (accumulatingResult == null || additionalResult == null) {
                    return null;
                }
                return accumulatingResult.addReturn(additionalResult);
            }
            assert (accumulatingResult != null);
            if (additionalResult == null) {
                return accumulatingResult;
            }
            return accumulatingResult.addReturn(additionalResult);
        }

        private void addVariable(@NonNull VariableDeclaration variable, @NonNull BasicDependencyPaths value) {
            this.variable2dependencies.put(variable, value);
        }

        public @Nullable BasicDependencyPaths analyze(Visitable element) {
            return (BasicDependencyPaths)element.accept((Visitor)this);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull OperationDependencyPaths analyzeOperation(@NonNull OperationCallExp operationCallExp) {
            Operation referredOperation = operationCallExp.getReferredOperation();
            assert (referredOperation != null);
            List<@NonNull BasicDependencyPaths> resultPaths = this.getResultPaths(operationCallExp);
            assert (resultPaths != null);
            List<@NonNull BasicDependencyPaths> allSourceAndArgumentPaths = this.getAllSourceAndArgumentPaths(resultPaths);
            BasicDependencyPaths result = OperationDependencyAnalysis.this.emptyDependencyPaths;
            for (List<BasicDependencyPaths> aSourceAndArgumentPaths : this.getEachSourceAndArgumentPaths(allSourceAndArgumentPaths)) {
                OperationDependencyPaths sourcePaths = aSourceAndArgumentPaths.get(0);
                for (List<OperationDependencyStep> steps : sourcePaths.getReturnPaths()) {
                    for (OperationDependencyStep step : steps) {
                        Class sourceClass = step.getElementalType();
                        CompleteClass selfClass = OperationDependencyAnalysis.this.completeModel.getCompleteClass((Type)sourceClass);
                        Iterable<@NonNull Operation> overrides = this.getOverrides(selfClass, referredOperation);
                        for (Operation operation : overrides) {
                            BasicDependencyPaths operationResult;
                            OperationAnalysis operationAnalysis;
                            OperationId operationId = operation.getOperationId();
                            @NonNull @NonNull @NonNull Map args2result = (Map)OperationDependencyAnalysis.this.operation2paths2analysis.get(operationId);
                            if (args2result == null || (operationAnalysis = (OperationAnalysis)args2result.get(aSourceAndArgumentPaths)) == null || (operationResult = operationAnalysis.basicGetResult()) == null) continue;
                            result = result.addReturn(operationResult);
                        }
                    }
                }
            }
            return result;
        }

        private @NonNull BasicDependencyPaths analyzeOperationCallExp_oclContainer(@NonNull OperationCallExp operationCallExp, @NonNull List<@NonNull BasicDependencyPaths> sourceAndArgumentPaths) {
            assert (sourceAndArgumentPaths.size() == 1);
            BasicDependencyPaths sourcePath = sourceAndArgumentPaths.get(0);
            Iterable<@NonNull List<@NonNull OperationDependencyStep>> oldReturnPaths = sourcePath.getReturnPaths();
            BasicDependencyPaths result = null;
            if (Iterables.size(oldReturnPaths) == 1) {
                Property containmentProperty;
                Property containerProperty;
                List<@NonNull OperationDependencyStep> steps = oldReturnPaths.iterator().next();
                int n = steps.size();
                assert (n > 0);
                OperationDependencyStep lastStep = steps.get(n - 1);
                CompleteClass containedClass = OperationDependencyAnalysis.this.completeModel.getCompleteClass((Type)lastStep.getElementalType());
                Iterable<@NonNull Property> containmentProperties = OperationDependencyAnalysis.this.containmentAnalysis.getContainmentProperties(containedClass);
                if (Iterables.size(containmentProperties) == 1 && (containerProperty = (containmentProperty = containmentProperties.iterator().next()).getOpposite()) != null) {
                    result = sourcePath.append(OperationDependencyAnalysis.this.createPropertyDependencyStep(containerProperty, operationCallExp));
                }
            }
            if (result == null) {
                HashSet<@NonNull List<@NonNull OperationDependencyStep>> newReturnPaths = new HashSet<List<OperationDependencyStep>>();
                HashSet<@NonNull List<@NonNull OperationDependencyStep>> hashSet = new HashSet<List<OperationDependencyStep>>();
                Iterables.addAll(hashSet, oldReturnPaths);
                Iterables.addAll(hashSet, sourcePath.getHiddenPaths());
                for (List<OperationDependencyStep> steps : oldReturnPaths) {
                    int size = steps.size();
                    assert (size > 0);
                    OperationDependencyStep lastStep = steps.get(size - 1);
                    CompleteClass containedClass = OperationDependencyAnalysis.this.completeModel.getCompleteClass((Type)lastStep.getElementalType());
                    Iterable<@NonNull Property> containmentProperties = OperationDependencyAnalysis.this.containmentAnalysis.getContainmentProperties(containedClass);
                    for (Property containmentProperty : containmentProperties) {
                        Class containerClass = PivotUtil.getOwningClass((Property)containmentProperty);
                        ClassDependencyStep classDependencyStep = OperationDependencyAnalysis.this.createClassDependencyStep((Type)containerClass, (Element)operationCallExp);
                        newReturnPaths.add(Lists.newArrayList((Object[])new OperationDependencyStep[]{classDependencyStep}));
                        hashSet.add(Lists.newArrayList((Object[])new OperationDependencyStep[]{classDependencyStep, OperationDependencyAnalysis.this.createPropertyDependencyStep(containmentProperty, operationCallExp)}));
                    }
                }
                result = OperationDependencyAnalysis.this.createDependencyPaths(newReturnPaths, hashSet);
            }
            if (RESULT.isActive()) {
                StringBuilder s = new StringBuilder();
                for (OperationDependencyPaths operationDependencyPaths : sourceAndArgumentPaths) {
                    s.append("\n\t=> " + operationDependencyPaths.toString());
                }
                s.append("\n\t= " + result.toString());
                RESULT.println(operationCallExp.getReferredOperation() + s.toString());
            }
            return result;
        }

        private boolean exactResultRequired() {
            return this.exactResult || OperationDependencyAnalysis.this.pending.size() > 0;
        }

        protected @NonNull List<@NonNull BasicDependencyPaths> getAllSourceAndArgumentPaths(@NonNull List<@NonNull BasicDependencyPaths> resultPaths) {
            ArrayList<@NonNull BasicDependencyPaths> sourceAndArgumentPaths = new ArrayList<BasicDependencyPaths>(resultPaths.size());
            for (BasicDependencyPaths resultPath : resultPaths) {
                HashSet<@NonNull List<@NonNull OperationDependencyStep>> typePaths = new HashSet<List<OperationDependencyStep>>();
                for (List<OperationDependencyStep> path : resultPath.basicGetReturnPaths()) {
                    OperationDependencyStep lastStep = path.get(path.size() - 1);
                    TypedElement typedElement = (TypedElement)lastStep.getElement();
                    assert (typedElement != null);
                    Type type = typedElement.getType();
                    assert (type != null);
                    ClassDependencyStep classStep = OperationDependencyAnalysis.this.createClassDependencyStep(type, (Element)typedElement);
                    typePaths.add(Collections.singletonList(classStep));
                }
                sourceAndArgumentPaths.add(OperationDependencyAnalysis.this.createDependencyPaths(typePaths, null));
            }
            return sourceAndArgumentPaths;
        }

        protected @NonNull Iterable<@NonNull List<@NonNull BasicDependencyPaths>> getEachSourceAndArgumentPaths(@NonNull List<@NonNull BasicDependencyPaths> allSourceAndArgumentPaths) {
            ArrayList<@NonNull List<@NonNull BasicDependencyPaths>> eachSourceAndArgumentPaths = new ArrayList<List<BasicDependencyPaths>>();
            for (List<OperationDependencyStep> aSourceStep : allSourceAndArgumentPaths.get(0).getReturnPaths()) {
                ArrayList<@NonNull BasicDependencyPaths> aSourceAndArgumentPaths = new ArrayList<BasicDependencyPaths>();
                aSourceAndArgumentPaths.add(OperationDependencyAnalysis.this.createDependencyPaths(Collections.singleton(aSourceStep), null));
                int i = 1;
                while (i < allSourceAndArgumentPaths.size()) {
                    aSourceAndArgumentPaths.add(allSourceAndArgumentPaths.get(i));
                    ++i;
                }
                eachSourceAndArgumentPaths.add(aSourceAndArgumentPaths);
            }
            return eachSourceAndArgumentPaths;
        }

        protected @NonNull Iterable<@NonNull Operation> getOverrides(@NonNull CompleteClass selfClass, @NonNull Operation referredOperation) {
            if (selfClass == OperationDependencyAnalysis.this.oclVoidCompleteClass || selfClass == OperationDependencyAnalysis.this.oclInvalidCompleteClass) {
                return Collections.emptyList();
            }
            return OperationDependencyAnalysis.this.finalAnalysis.getOverrides(referredOperation, selfClass);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        protected @Nullable List<@NonNull BasicDependencyPaths> getResultPaths(@NonNull OperationCallExp operationCallExp) {
            ArrayList<@NonNull BasicDependencyPaths> resultPaths = new ArrayList<BasicDependencyPaths>();
            BasicDependencyPaths sourcePaths = this.analyze((Visitable)operationCallExp.getOwnedSource());
            if (sourcePaths == null) {
                return null;
            }
            resultPaths.add(OperationDependencyAnalysis.this.createDependencyPaths(sourcePaths.basicGetReturnPaths(), sourcePaths.basicGetHiddenPaths()));
            @NonNull List arguments = ClassUtil.nullFree((List)operationCallExp.getOwnedArguments());
            for (OCLExpression argument : arguments) {
                BasicDependencyPaths argumentPaths = this.analyze((Visitable)argument);
                if (argumentPaths == null) {
                    return null;
                }
                resultPaths.add(OperationDependencyAnalysis.this.createDependencyPaths(argumentPaths.basicGetReturnPaths(), argumentPaths.basicGetHiddenPaths()));
            }
            return resultPaths;
        }

        protected @NonNull BasicDependencyPaths getVariable(@NonNull VariableDeclaration variable) {
            BasicDependencyPaths result = this.variable2dependencies.get(variable);
            if (result != null) {
                return result;
            }
            if (this.parent != null) {
                return this.parent.getVariable(variable);
            }
            EObject eContainer = variable.eContainer();
            if (eContainer instanceof CorePattern) {
                return OperationDependencyAnalysis.this.createParameterDependencyPaths(variable);
            }
            return OperationDependencyAnalysis.this.createDependencyPaths((TypedElement)variable);
        }

        public @Nullable BasicDependencyPaths visiting(@NonNull Visitable visitable) {
            throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + visitable.getClass().getSimpleName());
        }

        public @Nullable BasicDependencyPaths visitCollectionLiteralExp(@NonNull CollectionLiteralExp collectionLiteralExp) {
            BasicDependencyPaths result = OperationDependencyAnalysis.this.emptyDependencyPaths;
            for (CollectionLiteralPart ownedPart : ClassUtil.nullFree((List)collectionLiteralExp.getOwnedParts())) {
                result = this.addReturn(result, this.analyze((Visitable)ownedPart));
            }
            return result;
        }

        public @Nullable BasicDependencyPaths visitCollectionItem(@NonNull CollectionItem collectionItem) {
            return this.analyze((Visitable)collectionItem.getOwnedItem());
        }

        public @Nullable BasicDependencyPaths visitCollectionRange(@NonNull CollectionRange collectionRange) {
            return null;
        }

        public @Nullable BasicDependencyPaths visitIfExp(@NonNull IfExp ifExp) {
            if (ifExp.toString().contains("lookupPackage")) {
                ifExp.toString();
            }
            BasicDependencyPaths result = this.analyze((Visitable)ifExp.getOwnedThen());
            result = this.addReturn(result, this.analyze((Visitable)ifExp.getOwnedElse()));
            result = this.addHidden(result, this.analyze((Visitable)ifExp.getOwnedCondition()));
            return result;
        }

        public @Nullable BasicDependencyPaths visitLetExp(@NonNull LetExp letExp) {
            Variable ownedVariable = letExp.getOwnedVariable();
            BasicDependencyPaths initResult = this.analyze((Visitable)ownedVariable.getOwnedInit());
            if (initResult == null) {
                return null;
            }
            DependencyAnalyzerVisitor nestedAnalyzer = new DependencyAnalyzerVisitor(this);
            nestedAnalyzer.addVariable((VariableDeclaration)ownedVariable, initResult);
            BasicDependencyPaths inResult = nestedAnalyzer.analyze((Visitable)letExp.getOwnedIn());
            if (inResult == null) {
                return null;
            }
            BasicDependencyPaths result = this.addHidden(inResult, initResult);
            return result;
        }

        public @NonNull BasicDependencyPaths visitLiteralExp(@NonNull LiteralExp literalExp) {
            return OperationDependencyAnalysis.this.createDependencyPaths((TypedElement)literalExp);
        }

        public @Nullable BasicDependencyPaths visitLoopExp(@NonNull LoopExp loopExp) {
            BasicDependencyPaths sourcePaths = this.analyze((Visitable)loopExp.getOwnedSource());
            if (sourcePaths == null) {
                return null;
            }
            DependencyAnalyzerVisitor nestedAnalyzer = new DependencyAnalyzerVisitor(this);
            for (Variable iterator : loopExp.getOwnedIterators()) {
                nestedAnalyzer.addVariable((VariableDeclaration)iterator, sourcePaths);
            }
            return this.addHidden(nestedAnalyzer.analyze((Visitable)loopExp.getOwnedBody()), sourcePaths);
        }

        public @Nullable BasicDependencyPaths visitMapLiteralExp(@NonNull MapLiteralExp mapLiteralExp) {
            BasicDependencyPaths result = OperationDependencyAnalysis.this.emptyDependencyPaths;
            for (MapLiteralPart ownedPart : mapLiteralExp.getOwnedParts()) {
                result = this.addReturn(result, this.analyze((Visitable)ownedPart));
            }
            return result;
        }

        public @Nullable BasicDependencyPaths visitMapLiteralPart(@NonNull MapLiteralPart mapLiteralPart) {
            return this.analyze((Visitable)mapLiteralPart.getOwnedValue());
        }

        public @Nullable BasicDependencyPaths visitNavigationCallExp(@NonNull NavigationCallExp navigationCallExp) {
            BasicDependencyPaths sourcePaths = this.analyze((Visitable)navigationCallExp.getOwnedSource());
            if (sourcePaths == null) {
                return null;
            }
            NavigationDependencyStep dependencyStep = OperationDependencyAnalysis.this.createPropertyDependencyStep(navigationCallExp);
            BasicDependencyPaths result = sourcePaths.append(dependencyStep);
            return result.addHidden(sourcePaths);
        }

        public @Nullable BasicDependencyPaths visitNullLiteralExp(@NonNull NullLiteralExp object) {
            return OperationDependencyAnalysis.this.emptyDependencyPaths;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @Nullable BasicDependencyPaths visitOperationCallExp(@NonNull OperationCallExp operationCallExp) {
            StringBuilder stringBuilder;
            Operation referredOperation = operationCallExp.getReferredOperation();
            assert (referredOperation != null);
            List<@NonNull BasicDependencyPaths> resultPaths = this.getResultPaths(operationCallExp);
            if (resultPaths == null) {
                return null;
            }
            List<@NonNull BasicDependencyPaths> allSourceAndArgumentPaths = this.getAllSourceAndArgumentPaths(resultPaths);
            if (CALL.isActive()) {
                StringBuilder s2 = new StringBuilder();
                for (OperationDependencyPaths operationDependencyPaths : allSourceAndArgumentPaths) {
                    s2.append("\n\t=> " + operationDependencyPaths.toString());
                }
                CALL.println(referredOperation + s2.toString());
            }
            BasicDependencyPaths result = OperationDependencyAnalysis.this.emptyDependencyPaths;
            StringBuilder stringBuilder2 = stringBuilder = ATTEMPT.isActive() || RESULT.isActive() ? new StringBuilder() : null;
            if (stringBuilder != null) {
                Operation containingOperation = PivotUtil.getContainingOperation((EObject)operationCallExp);
                if (containingOperation != null) {
                    stringBuilder.append("\n\tin: " + containingOperation);
                } else {
                    Mapping containingMapping = QVTcoreUtil.getContainingMapping((EObject)operationCallExp);
                    if (containingMapping != null) {
                        stringBuilder.append("\n\tin: " + containingMapping);
                    }
                }
                String indent = "\n\t";
                DependencyAnalyzerVisitor visitor = this;
                while (visitor != null) {
                    indent = String.valueOf(indent) + "  ";
                    ArrayList<@NonNull VariableDeclaration> variables = new ArrayList<VariableDeclaration>(visitor.variable2dependencies.keySet());
                    Collections.sort(variables, NameUtil.NAMEABLE_COMPARATOR);
                    for (VariableDeclaration variable : variables) {
                        stringBuilder.append(indent);
                        stringBuilder.append(variable.getName());
                        stringBuilder.append(": ");
                        stringBuilder.append(visitor.variable2dependencies.get(variable));
                    }
                    visitor = visitor.parent;
                }
            }
            for (List<BasicDependencyPaths> aSourceAndArgumentPaths : this.getEachSourceAndArgumentPaths(allSourceAndArgumentPaths)) {
                if (stringBuilder != null) {
                    int i = 0;
                    for (BasicDependencyPaths callPath : aSourceAndArgumentPaths) {
                        stringBuilder.append("\n\t=> ");
                        stringBuilder.append(i == 0 ? "self" : ((Parameter)referredOperation.getOwnedParameters().get(i - 1)).getName());
                        stringBuilder.append(": ");
                        stringBuilder.append(callPath.toString());
                        ++i;
                    }
                }
                BasicDependencyPaths aSourcePath = aSourceAndArgumentPaths.get(0);
                Iterable<@NonNull List<@NonNull OperationDependencyStep>> aSourceReturnPaths = aSourcePath.getReturnPaths();
                assert (Iterables.size(aSourceReturnPaths) == 1);
                List<@NonNull OperationDependencyStep> steps2 = aSourceReturnPaths.iterator().next();
                int size = steps2.size();
                assert (size > 0);
                OperationDependencyStep lastStep = steps2.get(size - 1);
                Class sourceClass = lastStep.getElementalType();
                CompleteClass selfClass = OperationDependencyAnalysis.this.completeModel.getCompleteClass((Type)sourceClass);
                @NonNull ArrayList sortedOverrides = Lists.newArrayList(this.getOverrides(selfClass, referredOperation));
                Collections.sort(sortedOverrides, NameUtil.ToStringComparator.INSTANCE);
                for (Operation operation : sortedOverrides) {
                    OperationAnalysis operationAnalysis;
                    OperationId operationId = operation.getOperationId();
                    HashMap<@NonNull List<@NonNull BasicDependencyPaths>, @NonNull OperationAnalysis> args2result = (HashMap<List<BasicDependencyPaths>, OperationAnalysis>)OperationDependencyAnalysis.this.operation2paths2analysis.get(operationId);
                    if (args2result == null) {
                        args2result = new HashMap<List<BasicDependencyPaths>, OperationAnalysis>();
                        OperationDependencyAnalysis.this.operation2paths2analysis.put(operationId, args2result);
                    }
                    if ((operationAnalysis = (OperationAnalysis)args2result.get(aSourceAndArgumentPaths)) == null) {
                        if (referredOperation.getBodyExpression() != null) {
                            operationAnalysis = new OperationAnalysis(OperationDependencyAnalysis.this, operation, aSourceAndArgumentPaths, null);
                            OperationDependencyAnalysis.this.addPendingAnalysis(operationAnalysis);
                            result = null;
                        } else {
                            BasicDependencyPaths localResult = PivotUtil.isSameOperation((OperationId)operationId, (OperationId)OperationDependencyAnalysis.this.standardLibraryHelper.getOclElementOclContainerId()) ? this.analyzeOperationCallExp_oclContainer(operationCallExp, aSourceAndArgumentPaths) : OperationDependencyAnalysis.this.createDependencyPaths((TypedElement)operationCallExp);
                            operationAnalysis = new OperationAnalysis(OperationDependencyAnalysis.this, operation, aSourceAndArgumentPaths, localResult);
                            result = this.addReturn(result, localResult);
                        }
                        for (BasicDependencyPaths callPath : aSourceAndArgumentPaths) {
                            assert (Iterables.isEmpty(callPath.getHiddenPaths()));
                        }
                        args2result.put(aSourceAndArgumentPaths, operationAnalysis);
                    }
                    BasicDependencyPaths operationResult = operationAnalysis.getResult(this.analysis);
                    if (stringBuilder != null) {
                        stringBuilder.append("\n\tto: " + operation);
                        stringBuilder.append("\n\t\t<= " + operationResult);
                    }
                    if (operationResult != null) {
                        result = this.addReturn(result, operationResult);
                        continue;
                    }
                    if (this.exactResultRequired()) {
                        result = null;
                        continue;
                    }
                    Type type = operation.getType();
                    assert (type != null);
                    ClassDependencyStep classDependencyStep = OperationDependencyAnalysis.this.createClassDependencyStep(type, (Element)operationCallExp);
                    BasicDependencyPaths dependencyPaths = OperationDependencyAnalysis.this.createDependencyPaths(classDependencyStep);
                    result = this.addReturn(result, dependencyPaths);
                }
            }
            if (result != null) {
                for (BasicDependencyPaths argumentPath : resultPaths) {
                    result = this.addHidden(result, argumentPath);
                }
            }
            if (stringBuilder != null) {
                stringBuilder.append("\n\t" + (this.exactResultRequired() ? "\u00abexact\u00bb " : "\u00abpartial\u00bb ") + result);
                (result != null ? RESULT : ATTEMPT).println(operationCallExp + stringBuilder.toString());
            }
            return result;
        }

        public @Nullable BasicDependencyPaths visitOppositePropertyAssignment(@NonNull OppositePropertyAssignment propertyAssignment) {
            return this.visiting((Visitable)propertyAssignment);
        }

        public @Nullable BasicDependencyPaths visitPropertyAssignment(@NonNull PropertyAssignment propertyAssignment) {
            return this.visiting((Visitable)propertyAssignment);
        }

        public @Nullable BasicDependencyPaths visitShadowExp(@NonNull ShadowExp shadowExp) {
            BasicDependencyPaths result = OperationDependencyAnalysis.this.createDependencyPaths((TypedElement)shadowExp);
            for (ShadowPart ownedPart : shadowExp.getOwnedParts()) {
                result = this.addReturn(result, this.analyze((Visitable)ownedPart));
            }
            return result;
        }

        public @Nullable BasicDependencyPaths visitShadowPart(@NonNull ShadowPart shadowPart) {
            return this.analyze((Visitable)shadowPart.getOwnedInit());
        }

        public @Nullable BasicDependencyPaths visitTupleLiteralExp(@NonNull TupleLiteralExp tupleLiteralExp) {
            BasicDependencyPaths result = OperationDependencyAnalysis.this.emptyDependencyPaths;
            for (TupleLiteralPart ownedPart : tupleLiteralExp.getOwnedParts()) {
                result = this.addReturn(result, this.analyze((Visitable)ownedPart));
            }
            return result;
        }

        public @Nullable BasicDependencyPaths visitTupleLiteralPart(@NonNull TupleLiteralPart tupleLiteralPart) {
            return this.analyze((Visitable)tupleLiteralPart.getOwnedInit());
        }

        public @Nullable BasicDependencyPaths visitTypeExp(@NonNull TypeExp typeExp) {
            return OperationDependencyAnalysis.this.emptyDependencyPaths;
        }

        public @Nullable BasicDependencyPaths visitVariableExp(@NonNull VariableExp variableExp) {
            VariableDeclaration referredVariable = variableExp.getReferredVariable();
            assert (referredVariable != null);
            return this.getVariable(referredVariable);
        }
    }

    protected static class DependencyStepFactory {
        protected final @NonNull DomainUsage usage;
        private final @NonNull Map<@NonNull Class, @NonNull ClassDependencyStep> class2step = new HashMap<Class, ClassDependencyStep>();
        private final @NonNull Map<@NonNull VariableDeclaration, @NonNull ParameterDependencyStep> parameter2step = new HashMap<VariableDeclaration, ParameterDependencyStep>();
        private final @NonNull Map<@NonNull Property, @NonNull NavigationDependencyStep> property2step = new HashMap<Property, NavigationDependencyStep>();

        protected DependencyStepFactory(@NonNull DomainUsage usage) {
            this.usage = (DomainUsage)ClassUtil.nonNullState((Object)usage);
        }

        public @NonNull ClassDependencyStep createClassDependencyStep(@NonNull Class type, @NonNull Element element) {
            ClassDependencyStep dependencyStep = this.class2step.get(type);
            if (dependencyStep == null) {
                dependencyStep = new ClassDependencyStep(this.usage, type, element);
                this.class2step.put(type, dependencyStep);
            }
            return dependencyStep;
        }

        public @NonNull ParameterDependencyStep createParameterDependencyStep(@NonNull Class type, @NonNull VariableDeclaration parameter) {
            ParameterDependencyStep dependencyStep = this.parameter2step.get(parameter);
            if (dependencyStep == null) {
                dependencyStep = new ParameterDependencyStep(this.usage, type, parameter);
                this.parameter2step.put(parameter, dependencyStep);
            }
            return dependencyStep;
        }

        public @NonNull NavigationDependencyStep createPropertyDependencyStep(@NonNull NavigationCallExp navigationCallExp) {
            Property property = PivotUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
            assert (property != null);
            NavigationDependencyStep dependencyStep = this.property2step.get(property);
            if (dependencyStep == null) {
                dependencyStep = new NavigationDependencyStep(this.usage, property, (CallExp)navigationCallExp);
                this.property2step.put(property, dependencyStep);
            }
            return dependencyStep;
        }

        public @NonNull NavigationDependencyStep createPropertyDependencyStep(@NonNull Property containerProperty, @NonNull OperationCallExp oclContainerCallExp) {
            NavigationDependencyStep dependencyStep = this.property2step.get(containerProperty);
            if (dependencyStep == null) {
                dependencyStep = new NavigationDependencyStep(this.usage, containerProperty, (CallExp)oclContainerCallExp);
                this.property2step.put(containerProperty, dependencyStep);
            }
            return dependencyStep;
        }

        public @NonNull DomainUsage getUsage() {
            return this.usage;
        }
    }

    protected static class NavigationDependencyStep
    extends BasicDependencyStep
    implements OperationDependencyStep.PropertyStep {
        protected final @NonNull Property property;

        public NavigationDependencyStep(@NonNull DomainUsage usage, @NonNull Property property, @NonNull CallExp element) {
            super(usage, (Element)element);
            this.property = property;
        }

        @Override
        public @NonNull CallExp getCallExp() {
            return (CallExp)this.element;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public @NonNull Class getElementalType() {
            type = this.property.getType();
            if (NavigationDependencyStep.$assertionsDisabled || type != null) ** GOTO lbl7
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                type = ((CollectionType)type).getElementType();
                if (!NavigationDependencyStep.$assertionsDisabled && type == null) {
                    throw new AssertionError();
                }
lbl7:
                // 3 sources

                ** while (type instanceof CollectionType)
            }
lbl8:
            // 1 sources

            return (Class)type;
        }

        public String getName() {
            return this.property.getName();
        }

        @Override
        public @NonNull Element getPathElement() {
            return this.property;
        }

        @Override
        public @NonNull Property getProperty() {
            return this.property;
        }

        public String toString() {
            return this.usage + " \u00ab" + this.property.eClass().getName() + "\u00bb" + this.property.toString();
        }
    }

    protected static class OperationAnalysis
    extends AbstractOperationAnalysis {
        private final @NonNull Operation operation;
        private final @NonNull List<@NonNull BasicDependencyPaths> sourceAndArgumentPaths;

        public OperationAnalysis(@NonNull OperationDependencyAnalysis operationDependencyAnalysis, @NonNull Operation operation, @NonNull List<@NonNull BasicDependencyPaths> sourceAndArgumentPaths, @Nullable BasicDependencyPaths result) {
            super(operationDependencyAnalysis);
            this.operation = operation;
            this.sourceAndArgumentPaths = sourceAndArgumentPaths;
            this.result = result;
            CREATE.println(this.toString());
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public void analyze(boolean exactResult) {
            OCLExpression ownedBody;
            List ownedParameters;
            assert (this.result == null);
            if (START.isActive()) {
                StringBuilder s = new StringBuilder();
                this.toDebug(s);
                START.println(s.toString());
            }
            this.resetInvokedFutureAnalyses();
            DependencyAnalyzerVisitor visitor = this.operationDependencyAnalysis.createDependencyAnalyzerVisitor(this, exactResult);
            if (this.operation instanceof Function) {
                Function function = (Function)this.operation;
                Transformation transformation = QVTbaseUtil.getContainingTransformation((EObject)function);
                Variable thisVariable = QVTbaseUtil.getContextVariable((StandardLibrary)this.operationDependencyAnalysis.metamodelManager.getStandardLibrary(), (Transformation)transformation);
                visitor.addVariable((VariableDeclaration)thisVariable, (BasicDependencyPaths)ClassUtil.nonNullState((Object)this.sourceAndArgumentPaths.get(0)));
                ownedParameters = function.getOwnedParameters();
                ownedBody = function.getQueryExpression();
            } else {
                ExpressionInOCL specification;
                LanguageExpression bodyExpression = (LanguageExpression)ClassUtil.nonNullState((Object)this.operation.getBodyExpression());
                try {
                    specification = this.operationDependencyAnalysis.environmentFactory.parseSpecification(bodyExpression);
                }
                catch (ParserException e) {
                    throw new IllegalStateException(e);
                }
                visitor.addVariable((VariableDeclaration)ClassUtil.nonNullState((Object)specification.getOwnedContext()), (BasicDependencyPaths)ClassUtil.nonNullState((Object)this.sourceAndArgumentPaths.get(0)));
                ownedParameters = specification.getOwnedParameters();
                ownedBody = specification.getOwnedBody();
            }
            int iMax = Math.min(ownedParameters.size(), this.sourceAndArgumentPaths.size() - 1);
            int i = 0;
            while (i < iMax) {
                visitor.addVariable((VariableDeclaration)ClassUtil.nonNullState((Object)((VariableDeclaration)ownedParameters.get(i))), (BasicDependencyPaths)ClassUtil.nonNullState((Object)this.sourceAndArgumentPaths.get(i + 1)));
                ++i;
            }
            BasicDependencyPaths analysisResult = visitor.analyze((Visitable)ownedBody);
            @NonNull Collection invokedFutureAnalyses2 = this.invokedFutureAnalyses;
            if (analysisResult != null) {
                Set invokingFutureAnalyses2;
                if (exactResult) {
                    assert (invokedFutureAnalyses2 == null || invokedFutureAnalyses2.size() == 0);
                } else {
                    this.resetInvokedFutureAnalyses();
                    this.operationDependencyAnalysis.removeRefiningAnalysis(this);
                }
                if ((invokingFutureAnalyses2 = this.invokingFutureAnalyses) != null) {
                    ArrayList<@NonNull E> sortedInvokingFutureAnalyses = new ArrayList(invokingFutureAnalyses2);
                    Collections.sort(sortedInvokingFutureAnalyses, NameUtil.ToStringComparator.INSTANCE);
                    for (AbstractOperationAnalysis invokingFutureAnalysis : sortedInvokingFutureAnalyses) {
                        this.operationDependencyAnalysis.addPendingAnalysis(invokingFutureAnalysis);
                        invokingFutureAnalysis.removeInvokedAnalysis(this);
                    }
                    invokingFutureAnalyses2.clear();
                }
                this.result = analysisResult;
            } else {
                assert (invokedFutureAnalyses2 != null && invokedFutureAnalyses2.size() > 0);
                if (!this.operationDependencyAnalysis.pending.contains(this)) {
                    this.operationDependencyAnalysis.addRefiningAnalysis(this);
                }
            }
            if (this.result != null && RESULT.isActive()) {
                StringBuilder s = new StringBuilder();
                this.toDebug(s);
                RESULT.println(s.toString());
            }
        }

        public @Nullable BasicDependencyPaths getResult(@NonNull AbstractOperationAnalysis invokingAnalysis) {
            if (this.result != null) {
                return this.result;
            }
            this.addInvokingFutureAnalysis(invokingAnalysis);
            invokingAnalysis.addInvokedFutureAnalysis(this);
            return null;
        }

        private void toDebug(@NonNull StringBuilder s) {
            s.append(this.operation);
            int i = 0;
            for (OperationDependencyPaths operationDependencyPaths : this.sourceAndArgumentPaths) {
                s.append("\n\t=> ");
                s.append(i == 0 ? "self" : ((Parameter)this.operation.getOwnedParameters().get(i - 1)).getName());
                s.append(": " + operationDependencyPaths);
                ++i;
            }
            s.append("\n\t<= " + this.result);
        }

        public @NonNull String toString() {
            return String.valueOf(this.operation.toString()) + "; " + this.result + " <= " + this.sourceAndArgumentPaths;
        }
    }

    protected static class ParameterDependencyStep
    extends BasicDependencyStep {
        private final @NonNull Class type;

        public ParameterDependencyStep(@NonNull DomainUsage usage, @NonNull Class type, @NonNull VariableDeclaration parameter) {
            super(usage, (Element)parameter);
            this.type = type;
            assert (!(type instanceof CollectionType));
        }

        @Override
        public @NonNull Class getElementalType() {
            return this.type;
        }

        public String getName() {
            return ((VariableDeclaration)this.element).getName();
        }

        @Override
        public boolean isParameter() {
            return true;
        }

        @Override
        public @NonNull Element getPathElement() {
            return this.element;
        }

        public String toString() {
            return this.usage + " \u00ab" + this.type.eClass().getName() + "\u00bb" + ((VariableDeclaration)this.element).getName() + ":" + this.type.toString();
        }
    }

    protected static class RootOperationAnalysis
    extends AbstractOperationAnalysis {
        protected final @NonNull OperationCallExp operationCallExp;
        protected final @NonNull DependencyAnalyzerVisitor visitor;

        public RootOperationAnalysis(@NonNull OperationDependencyAnalysis operationDependencyAnalysis, @NonNull OperationCallExp operationCallExp) {
            super(operationDependencyAnalysis);
            this.operationCallExp = operationCallExp;
            this.visitor = operationDependencyAnalysis.createDependencyAnalyzerVisitor(this, true);
        }

        @Override
        public void analyze(boolean exactResult) {
            this.visitor.analyze((Visitable)this.operationCallExp);
        }
    }
}

