/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcore.NavigationAssignment;
import org.eclipse.qvtd.pivot.qvtcore.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtschedule.CastEdge;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.DependencyNode;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.ErrorNode;
import org.eclipse.qvtd.pivot.qvtschedule.ExpressionEdge;
import org.eclipse.qvtd.pivot.qvtschedule.InputNode;
import org.eclipse.qvtd.pivot.qvtschedule.IteratedEdge;
import org.eclipse.qvtd.pivot.qvtschedule.IteratorNode;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.NullNode;
import org.eclipse.qvtd.pivot.qvtschedule.OperationNode;
import org.eclipse.qvtd.pivot.qvtschedule.PatternTypedNode;
import org.eclipse.qvtd.pivot.qvtschedule.PatternVariableNode;
import org.eclipse.qvtd.pivot.qvtschedule.PredicateEdge;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.StatusNode;
import org.eclipse.qvtd.pivot.qvtschedule.TrueNode;
import org.eclipse.qvtd.pivot.qvtschedule.UnknownNode;
import org.eclipse.qvtd.pivot.qvtschedule.VariableNode;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class RegionHelper<R extends Region>
extends QVTscheduleUtil
implements Nameable {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull R region;

    public RegionHelper(@NonNull ScheduleManager scheduleManager, @NonNull R region) {
        this.scheduleManager = scheduleManager;
        this.region = region;
    }

    public @NonNull NavigableEdge createCastEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode) {
        Role phase;
        Role edgeRole = phase = RegionHelper.mergeToLessKnownPhase((Role)RegionHelper.getNodeRole((Node)sourceNode), (Role)RegionHelper.getNodeRole((Node)targetNode));
        CastEdge castEdge = QVTscheduleFactory.eINSTANCE.createCastEdge();
        castEdge.initialize(edgeRole, sourceNode, source2targetProperty.getName(), targetNode);
        castEdge.initializeProperty(source2targetProperty);
        return castEdge;
    }

    public @NonNull Node createDataTypeNode(@NonNull String name, @NonNull Node sourceNode, @NonNull NavigationCallExp navigationCallExp) {
        Property property = PivotUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
        boolean isMatched = sourceNode.isMatched() && RegionHelper.isMatched((TypedElement)property);
        Role nodeRole = this.getPatternNodeRole(sourceNode, property);
        assert (sourceNode.isClass() || property.getOpposite() != null);
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(nodeRole, this.region, name, this.scheduleManager.getClassDatum((TypedElement)navigationCallExp));
        node.setMatched(isMatched);
        node.addTypedElement((TypedElement)navigationCallExp);
        return node;
    }

    public @NonNull Node createDataTypeNode(@NonNull Node targetNode, @NonNull NavigationAssignment navigationAssignment) {
        Role nodeRole = RegionHelper.getNodeRole((Node)targetNode);
        Property property = QVTcoreUtil.getTargetProperty((NavigationAssignment)navigationAssignment);
        String name = property.getName();
        assert (name != null);
        Class type = (Class)property.getType();
        assert (type != null);
        TypedModel typedModel = RegionHelper.getTypedModel((ClassDatum)RegionHelper.getClassDatum((Node)targetNode));
        ClassDatum classDatum = this.scheduleManager.getClassDatum(typedModel, type);
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(nodeRole, this.region, name, classDatum);
        node.setMatched(true);
        node.addTypedElement((TypedElement)property);
        return node;
    }

    public @NonNull Node createDataTypeNode(@NonNull Node sourceNode, @NonNull Property property) {
        Role nodeRole = this.getPatternNodeRole(sourceNode, property);
        return this.createPatternNode(nodeRole, sourceNode, property, sourceNode.isMatched() && RegionHelper.isMatched((TypedElement)property));
    }

    public @NonNull Node createDependencyClassNode(@NonNull Node parentNode, @NonNull NavigationAssignment navigationAssignment) {
        assert (parentNode.isClass());
        Property property = QVTcoreUtil.getTargetProperty((NavigationAssignment)navigationAssignment);
        assert (property != null);
        Class type = (Class)property.getType();
        assert (type != null);
        TypedModel typedModel = RegionHelper.getTypedModel((ClassDatum)RegionHelper.getClassDatum((Node)parentNode));
        ClassDatum classDatum = this.scheduleManager.getClassDatum(typedModel, type);
        String name = property.getName();
        assert (name != null);
        return this.createDependencyNode(name, classDatum);
    }

    public @NonNull Node createDependencyNode(@NonNull String name, @NonNull ClassDatum classDatum) {
        Role nodeRole = Role.PREDICATED;
        DependencyNode node = QVTscheduleFactory.eINSTANCE.createDependencyNode();
        node.initialize(nodeRole, this.region, name, classDatum);
        return node;
    }

    public @NonNull Edge createEqualsEdge(@NonNull Node sourceNode, @NonNull Node targetNode) {
        System.err.println("Unexpected \u00abequals\u00bb edge from " + sourceNode + " to " + targetNode);
        return this.createExpressionEdge(sourceNode, "\u00abequals\u00bb", targetNode);
    }

    public @NonNull Node createErrorNode(@NonNull String name, @NonNull ClassDatum classDatum) {
        Role nodeRole = Role.OTHER;
        ErrorNode node = QVTscheduleFactory.eINSTANCE.createErrorNode();
        node.initialize(nodeRole, this.region, name, classDatum);
        return node;
    }

    public @NonNull Edge createExpressionEdge(@NonNull Node sourceNode, @NonNull String name, @NonNull Node targetNode) {
        Role edgeRole = RegionHelper.getNodeRole((Node)sourceNode);
        ExpressionEdge edge = QVTscheduleFactory.eINSTANCE.createExpressionEdge();
        edge.initialize(edgeRole, sourceNode, name, targetNode);
        return edge;
    }

    public @NonNull Node createInputNode(@NonNull Role nodeRole, @NonNull String name, @NonNull ClassDatum classDatum) {
        InputNode node = QVTscheduleFactory.eINSTANCE.createInputNode();
        node.initialize(nodeRole, this.region, name, classDatum);
        return node;
    }

    public @NonNull Edge createIteratedEdge(@NonNull Node sourceNode, @NonNull String name, @NonNull Node targetNode) {
        Role edgeRole = RegionHelper.getNodeRole((Node)sourceNode);
        IteratedEdge edge = QVTscheduleFactory.eINSTANCE.createIteratedEdge();
        edge.initialize(edgeRole, sourceNode, name, targetNode);
        return edge;
    }

    public @NonNull VariableNode createIteratorNode(@NonNull Variable iterator, @NonNull Node sourceNode) {
        Role nodeRole = RegionHelper.getNodeRole((Node)sourceNode);
        IteratorNode node = QVTscheduleFactory.eINSTANCE.createIteratorNode();
        node.initialize(nodeRole, this.region, RegionHelper.getName((Nameable)iterator), this.scheduleManager.getClassDatum((TypedElement)iterator));
        node.initializeVariable(this.region, (VariableDeclaration)iterator);
        return node;
    }

    public @NonNull VariableNode createLetVariableNode(@NonNull Variable letVariable, @NonNull Node inNode) {
        Role nodeRole = RegionHelper.getNodeRole((Node)inNode);
        PatternVariableNode node = QVTscheduleFactory.eINSTANCE.createPatternVariableNode();
        node.initialize(nodeRole, this.region, RegionHelper.getName((Nameable)letVariable), this.scheduleManager.getClassDatum((TypedElement)letVariable));
        node.initializeVariable(this.region, (VariableDeclaration)letVariable);
        node.setMatched(inNode.isMatched());
        return node;
    }

    public @NonNull VariableNode createLoadedStepNode(@NonNull VariableDeclaration stepVariable) {
        Role nodeRole = Role.LOADED;
        PatternVariableNode node = QVTscheduleFactory.eINSTANCE.createPatternVariableNode();
        node.initialize(nodeRole, this.region, RegionHelper.getName((Nameable)stepVariable), this.scheduleManager.getClassDatum((TypedElement)stepVariable));
        node.initializeVariable(this.region, stepVariable);
        node.setMatched(true);
        return node;
    }

    public @NonNull NavigableEdge createNavigationEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable Boolean isPartial) {
        Role phase;
        Role edgeRole = phase = RegionHelper.mergeToLessKnownPhase((Role)RegionHelper.getNodeRole((Node)sourceNode), (Role)RegionHelper.getNodeRole((Node)targetNode));
        NavigationEdge edge = QVTscheduleFactory.eINSTANCE.createNavigationEdge();
        edge.initialize(edgeRole, sourceNode, source2targetProperty.getName(), targetNode);
        edge.initializeProperty(source2targetProperty, isPartial);
        return edge;
    }

    public @NonNull Node createNullNode(boolean isMatched, @Nullable TypedElement typedElement) {
        Role nodeRole = Role.CONSTANT;
        ClassDatum classDatum = typedElement != null ? this.scheduleManager.getClassDatum(typedElement) : this.scheduleManager.getOclVoidClassDatum();
        NullNode node = QVTscheduleFactory.eINSTANCE.createNullNode();
        node.initialize(nodeRole, this.region, "\u00abnull\u00bb", classDatum);
        node.setMatched(isMatched);
        if (typedElement != null) {
            node.addTypedElement(typedElement);
        }
        return node;
    }

    public @NonNull VariableNode createOldNode(@NonNull VariableDeclaration variable) {
        Role phase;
        DomainUsage domainUsage = this.scheduleManager.getDomainUsage((Element)variable);
        boolean isEnforceable = domainUsage.isOutput() || domainUsage.isMiddle();
        Role nodeRole = phase = isEnforceable ? Role.PREDICATED : Role.LOADED;
        PatternVariableNode node = QVTscheduleFactory.eINSTANCE.createPatternVariableNode();
        node.initialize(nodeRole, this.region, RegionHelper.getName((Nameable)variable), this.scheduleManager.getClassDatum((TypedElement)variable));
        node.initializeVariable(this.region, variable);
        node.setMatched(true);
        return node;
    }

    public @NonNull Node createOperationNode(boolean isMatched, @NonNull String name, @NonNull TypedElement typedElement, Node ... argNodes) {
        Role nodeRole = RegionHelper.getOperationNodePhase(this.region, (TypedElement)typedElement, (Node[])argNodes);
        OperationNode node = QVTscheduleFactory.eINSTANCE.createOperationNode();
        node.initialize(nodeRole, this.region, name, this.scheduleManager.getClassDatum(typedElement));
        node.setMatched(isMatched);
        node.addTypedElement(typedElement);
        return node;
    }

    public @NonNull Node createPatternNode(@NonNull Role nodeRole, @NonNull Node sourceNode, @NonNull Property source2targetProperty, boolean isMatched) {
        TypedModel typedModel;
        assert (sourceNode.isClass());
        Class type = (Class)source2targetProperty.getType();
        assert (type != null);
        Type elementType = PivotUtil.getElementalType((Type)type);
        TypedModel typedModel2 = typedModel = elementType instanceof DataType ? this.scheduleManager.getDomainUsageAnalysis().getPrimitiveTypeModel() : sourceNode.getClassDatum().getReferredTypedModel();
        assert (typedModel != null);
        ClassDatum classDatum = this.scheduleManager.getClassDatum(typedModel, type);
        String name = source2targetProperty.getName();
        assert (name != null);
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(nodeRole, this.region, name, classDatum);
        node.setMatched(isMatched);
        return node;
    }

    public @NonNull Edge createPredicateEdge(@NonNull Node sourceNode, @Nullable String name, @NonNull Node targetNode) {
        Role edgeRole = RegionHelper.getNodeRole((Node)sourceNode);
        PredicateEdge edge = QVTscheduleFactory.eINSTANCE.createPredicateEdge();
        edge.initialize(edgeRole, sourceNode, name, targetNode);
        return edge;
    }

    public @NonNull Node createPredicatedStepNode(@NonNull Node typedNode, boolean isMatched) {
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(Role.PREDICATED, this.region, RegionHelper.getName((Nameable)typedNode), RegionHelper.getClassDatum((Node)typedNode));
        node.setMatched(isMatched);
        return node;
    }

    public @NonNull Node createRealizedDataTypeNode(@NonNull Node sourceNode, @NonNull Property source2targetProperty) {
        Role nodeRole = Role.REALIZED;
        return this.createPatternNode(nodeRole, sourceNode, source2targetProperty, sourceNode.isMatched());
    }

    public @NonNull Edge createRealizedExpressionEdge(@NonNull Node sourceNode, @Nullable String name, @NonNull Node targetNode) {
        Role edgeRole = Role.REALIZED;
        ExpressionEdge edge = QVTscheduleFactory.eINSTANCE.createExpressionEdge();
        edge.initialize(edgeRole, sourceNode, name, targetNode);
        return edge;
    }

    public @NonNull NavigableEdge createRealizedNavigationEdge(@NonNull Node sourceNode, @NonNull Property source2targetProperty, @NonNull Node targetNode, @Nullable Boolean isPartial) {
        Role edgeRole = Role.REALIZED;
        NavigationEdge forwardEdge = QVTscheduleFactory.eINSTANCE.createNavigationEdge();
        forwardEdge.initialize(edgeRole, sourceNode, source2targetProperty.getName(), targetNode);
        forwardEdge.initializeProperty(source2targetProperty, isPartial);
        return forwardEdge;
    }

    public @NonNull VariableNode createRealizedStepNode(@NonNull VariableDeclaration stepVariable) {
        Role nodeRole = Role.REALIZED;
        PatternVariableNode node = QVTscheduleFactory.eINSTANCE.createPatternVariableNode();
        node.initialize(nodeRole, this.region, RegionHelper.getName((Nameable)stepVariable), this.scheduleManager.getClassDatum((TypedElement)stepVariable));
        node.initializeVariable(this.region, stepVariable);
        node.setMatched(true);
        return node;
    }

    public @NonNull StatusNode createStatusNode() {
        Class booleanType = this.scheduleManager.getStandardLibrary().getBooleanType();
        RootDomainUsageAnalysis.DomainUsageConstant primitiveUsage = this.scheduleManager.getDomainUsageAnalysis().getPrimitiveUsage();
        ClassDatum classDatum = this.scheduleManager.getClassDatum((TypedModel)ClassUtil.nonNullState((Object)primitiveUsage.getTypedModel(null)), booleanType);
        Role nodeRole = Role.REALIZED;
        StatusNode node = QVTscheduleFactory.eINSTANCE.createStatusNode();
        node.initialize(nodeRole, this.region, "\u00abstatus\u00bb", classDatum);
        node.setHead();
        return node;
    }

    public @NonNull Node createStepNode(@NonNull String name, @NonNull CallExp callExp, @NonNull Node sourceNode, boolean isMatched) {
        Role phase;
        DomainUsage domainUsage = this.scheduleManager.getDomainUsage((Element)callExp);
        boolean isMiddleOrOutput = domainUsage.isOutput() || domainUsage.isMiddle();
        boolean isDirty = false;
        if (callExp instanceof NavigationCallExp) {
            Property referredProperty = PivotUtil.getReferredProperty((NavigationCallExp)((NavigationCallExp)callExp));
            isDirty = this.scheduleManager.isDirty(referredProperty);
        }
        Role stepNodeRole = phase = isMiddleOrOutput || isDirty ? Role.PREDICATED : Role.LOADED;
        PatternTypedNode node = QVTscheduleFactory.eINSTANCE.createPatternTypedNode();
        node.initialize(stepNodeRole, this.region, name, this.scheduleManager.getClassDatum((TypedElement)callExp));
        node.setMatched(isMatched);
        node.addTypedElement((TypedElement)callExp);
        return node;
    }

    public @NonNull Node createTrueNode() {
        Class booleanType = this.scheduleManager.getStandardLibrary().getBooleanType();
        RootDomainUsageAnalysis.DomainUsageConstant primitiveUsage = this.scheduleManager.getDomainUsageAnalysis().getPrimitiveUsage();
        ClassDatum classDatum = this.scheduleManager.getClassDatum((TypedModel)ClassUtil.nonNullState((Object)primitiveUsage.getTypedModel(null)), booleanType);
        Role nodeRole = Role.CONSTANT;
        TrueNode node = QVTscheduleFactory.eINSTANCE.createTrueNode();
        node.initialize(nodeRole, this.region, "\u00abtrue\u00bb", classDatum);
        node.setHead();
        return node;
    }

    public @NonNull Node createUnknownNode(@NonNull String name, @NonNull TypedElement typedElement) {
        Role nodeRole = Role.OTHER;
        UnknownNode node = QVTscheduleFactory.eINSTANCE.createUnknownNode();
        node.initialize(nodeRole, this.region, name, this.scheduleManager.getClassDatum(typedElement));
        return node;
    }

    public @NonNull String getName() {
        return QVTscheduleUtil.getName(this.region);
    }

    protected @NonNull Role getPatternNodeRole(@NonNull Node sourceNode, @NonNull Property property) {
        Role phase;
        switch (RegionHelper.getNodeRole((Node)sourceNode)) {
            case REALIZED: {
                phase = Role.REALIZED;
                break;
            }
            case PREDICATED: {
                phase = Role.PREDICATED;
                break;
            }
            case LOADED: {
                boolean isDirty = this.scheduleManager.isDirty(property);
                phase = isDirty ? Role.PREDICATED : Role.LOADED;
                break;
            }
            case CONSTANT: {
                phase = Role.CONSTANT;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return phase;
    }

    public @NonNull R getRegion() {
        return this.region;
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }
}

