/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtm2qvts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ExpressionAnalyzer;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public abstract class RuleAnalysis
extends RegionHelper<RuleRegion> {
    protected final @NonNull ExpressionAnalyzer expressionAnalyzer;
    private List<@NonNull Node> dependencyHeadNodes = null;

    protected RuleAnalysis(@NonNull ScheduleManager scheduleManager, @NonNull RuleRegion ruleRegion) {
        super(scheduleManager, ruleRegion);
        this.expressionAnalyzer = scheduleManager.createExpressionAnalyzer(this);
        assert (scheduleManager.getScheduleModel().getOwnedMappingRegions().contains((Object)ruleRegion));
    }

    public abstract void analyze();

    public @NonNull Node createDependencyHead(@NonNull ClassDatum classDatum) {
        if (this.dependencyHeadNodes == null) {
            this.dependencyHeadNodes = new ArrayList<Node>();
        }
        Node dependencyHeadNode = this.createDependencyNode("\u00abextra-" + (this.dependencyHeadNodes.size() + 1) + "\u00bb", classDatum);
        dependencyHeadNode.setHead();
        this.dependencyHeadNodes.add(dependencyHeadNode);
        return dependencyHeadNode;
    }

    public @Nullable Node getDependencyHead(@NonNull ClassDatum classDatum) {
        if (this.dependencyHeadNodes != null) {
            for (Node dependencyHeadNode : this.dependencyHeadNodes) {
                if (QVTscheduleUtil.getClassDatum((Node)dependencyHeadNode) != classDatum) continue;
                return dependencyHeadNode;
            }
        }
        return null;
    }

    public abstract @NonNull Node getReferenceNode(@NonNull VariableDeclaration var1);

    public @NonNull Rule getRule() {
        return QVTscheduleUtil.getReferredRule((RuleRegion)((RuleRegion)this.region));
    }

    public @NonNull Node getUnknownNode(@NonNull TypedElement typedElement) {
        assert (!(typedElement instanceof Property));
        Node node = ((RuleRegion)this.region).getNode(typedElement);
        if (node == null) {
            node = this.createUnknownNode((String)ClassUtil.nonNullState((Object)typedElement.getType().toString()), typedElement);
        }
        return node;
    }

    public abstract boolean isPropertyAssignment(@NonNull Node var1, @NonNull Property var2);

    public void registerConsumptionsAndProductions() {
        ClassDatum classDatum;
        for (Node newNode : ((RuleRegion)this.region).getNewNodes()) {
            classDatum = QVTscheduleUtil.getClassDatum((Node)newNode);
            classDatum.getProducingRegions().add((Object)((RuleRegion)this.region));
        }
        for (Node predicatedNode : ((RuleRegion)this.region).getOldNodes()) {
            classDatum = QVTscheduleUtil.getClassDatum((Node)predicatedNode);
            classDatum.getConsumingRegions().add((Object)((RuleRegion)this.region));
        }
    }

    public @NonNull String toString() {
        return this.getName();
    }
}

