/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameAdapter;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameReservation;

public class QVTs2QVTi
extends QVTimperativeHelper {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ProblemHandler problemHandler;

    public QVTs2QVTi(@NonNull ScheduleManager scheduleManager, @NonNull ProblemHandler problemHandler, @NonNull QVTbaseEnvironmentFactory environmentFactory) {
        super((EnvironmentFactory)environmentFactory);
        this.scheduleManager = scheduleManager;
        this.problemHandler = problemHandler;
        assert (scheduleManager.getEnvironmentFactory() == environmentFactory);
    }

    protected void resolveImports(@NonNull Model model) {
        HashSet<@NonNull Object> importedNamespaces = new HashSet<Object>();
        for (EObject eObject : new TreeIterable((EObject)model, false)) {
            Property asProperty;
            Package asPackage;
            Class asClass;
            if (eObject instanceof ImperativeTypedModel) {
                for (Namespace importedNamespace : ClassUtil.nullFree((EList)((ImperativeTypedModel)eObject).getUsedPackage())) {
                    if (importedNamespaces.contains(importedNamespace)) continue;
                    importedNamespaces.add(importedNamespace);
                }
                continue;
            }
            if (eObject instanceof OperationCallExp) {
                Operation asOperation = ((OperationCallExp)eObject).getReferredOperation();
                if (asOperation == null || (asClass = asOperation.getOwningClass()) == null || (asPackage = asClass.getOwningPackage()) == null) continue;
                importedNamespaces.add(asPackage);
                continue;
            }
            if (eObject instanceof LoopExp) {
                Iteration asIteration = ((LoopExp)eObject).getReferredIteration();
                if (asIteration == null || (asClass = asIteration.getOwningClass()) == null || (asPackage = asClass.getOwningPackage()) == null) continue;
                importedNamespaces.add(asPackage);
                continue;
            }
            if (eObject instanceof PropertyCallExp) {
                asProperty = ((PropertyCallExp)eObject).getReferredProperty();
                if (asProperty == null || (asClass = asProperty.getOwningClass()) == null || (asPackage = asClass.getOwningPackage()) == null) continue;
                importedNamespaces.add(asPackage);
                continue;
            }
            if (!(eObject instanceof OppositePropertyCallExp) || (asProperty = ((OppositePropertyCallExp)eObject).getReferredProperty()) == null || (asClass = asProperty.getOwningClass()) == null || (asPackage = asClass.getOwningPackage()) == null) continue;
            importedNamespaces.add(asPackage);
        }
        ArrayList<@NonNull E> sortedImportedNamespaces = new ArrayList(importedNamespaces);
        Collections.sort(sortedImportedNamespaces, NameUtil.NAMEABLE_COMPARATOR);
        List ownedImports = model.getOwnedImports();
        for (Namespace importedNamespace : sortedImportedNamespaces) {
            ownedImports.add(this.createImport("mm_" + importedNamespace.getName() + "MM", importedNamespace));
        }
    }

    protected void resolveTransformation(@NonNull Model model, @NonNull ScheduledRegion scheduledRegion) {
        Transformation qvtiTransformation;
        SymbolNameAdapter symbolNameReservation = this.scheduleManager.getScheduleModel().getSymbolNameAdapter();
        Transformation transformation = QVTscheduleUtil.getReferredTransformation((ScheduledRegion)scheduledRegion);
        QVTs2QVTiVisitor visitor = new QVTs2QVTiVisitor(this.scheduleManager, this.problemHandler, this, transformation, (SymbolNameReservation)symbolNameReservation);
        Transformation qvtiChild = qvtiTransformation = (Transformation)scheduledRegion.accept((Visitor)visitor);
        Package qvtmPackage = transformation.getOwningPackage();
        while (qvtmPackage != null) {
            @NonNull Package qvtiPackage = this.createPackage((String)ClassUtil.nonNull((Object)qvtmPackage.getName()), qvtmPackage.getNsPrefix(), qvtmPackage.getURI());
            if (qvtiChild instanceof Transformation) {
                qvtiPackage.getOwnedClasses().add(qvtiChild);
            } else {
                qvtiPackage.getOwnedPackages().add((Package)qvtiChild);
            }
            qvtiChild = qvtiPackage;
            qvtmPackage = qvtmPackage.getOwningPackage();
        }
        model.getOwnedPackages().add((Package)qvtiChild);
    }

    public @NonNull Model transform(@NonNull Model model, @NonNull ScheduledRegion scheduledRegion) {
        this.resolveTransformation(model, scheduledRegion);
        this.resolveImports(model);
        return model;
    }
}

