/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.ScheduleState;
import org.eclipse.qvtd.pivot.qvtschedule.DatumConnection;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.ScheduledRegion;

public class ScheduleIndexer
extends ScheduleState {
    protected final @NonNull ScheduleManager scheduleManager;

    public ScheduleIndexer(@NonNull ScheduleManager scheduleManager, @NonNull ScheduledRegion rootScheduledRegion) {
        super(rootScheduledRegion);
        this.scheduleManager = scheduleManager;
    }

    @Override
    protected void scheduleScheduledRegion(@NonNull ScheduledRegion scheduledRegion) {
        int regionCount = Iterables.size((Iterable)scheduledRegion.getCallableRegions());
        int iRegion = 0;
        while (iRegion < regionCount) {
            Region selectedRegion = this.selectNextRegion(scheduledRegion);
            this.scheduleRegion(selectedRegion);
            ++iRegion;
        }
        this.scheduleManager.writeDebugGraphs("6-indexed", false, true, true);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull Region selectNextRegion(@NonNull ScheduledRegion scheduledRegion) {
        @NonNull ArrayList unblockedRegionsList = Lists.newArrayList(this.getUnblockedRegions());
        Collections.sort(unblockedRegionsList, NameUtil.NAMEABLE_COMPARATOR);
        @NonNull ArrayList callableRegionsList = Lists.newArrayList(this.getBlockedCallableRegions());
        Collections.sort(callableRegionsList, NameUtil.NAMEABLE_COMPARATOR);
        @NonNull ArrayList mandatoryBlockedRegionsList = Lists.newArrayList(this.getMandatoryBlockedRegions());
        Collections.sort(mandatoryBlockedRegionsList, NameUtil.NAMEABLE_COMPARATOR);
        @NonNull ArrayList blockedConnectionsList = Lists.newArrayList(this.getBlockedConnections());
        Collections.sort(blockedConnectionsList, NameUtil.NAMEABLE_COMPARATOR);
        if (QVTm2QVTs.REGION_ORDER.isActive()) {
            QVTm2QVTs.REGION_ORDER.println("      unblocked regions:");
            for (Region region : unblockedRegionsList) {
                QVTm2QVTs.REGION_ORDER.println("        " + region);
            }
            QVTm2QVTs.REGION_ORDER.println("      callableRegion : blockedConnectionCount:");
            for (Region region : callableRegionsList) {
                QVTm2QVTs.REGION_ORDER.println("        " + region + " : " + this.getBlockedConnectionCount(region));
            }
            QVTm2QVTs.REGION_ORDER.println("      mandatory blocked regions:");
            for (Region region : mandatoryBlockedRegionsList) {
                QVTm2QVTs.REGION_ORDER.println("        " + region);
            }
            QVTm2QVTs.REGION_ORDER.println("      blocked connections:");
            for (DatumConnection connection : blockedConnectionsList) {
                int all = 0;
                int unblocked = 0;
                for (Region sourceRegion : connection.getSourceRegions()) {
                    ++all;
                    if (!Iterables.contains(this.getUnblockedRegions(), (Object)sourceRegion) && !Iterables.contains(this.getOrdering(), (Object)sourceRegion)) continue;
                    ++unblocked;
                }
                QVTm2QVTs.REGION_ORDER.println("        " + connection + " " + unblocked + "/" + all);
            }
        }
        if (unblockedRegionsList.size() > 0) {
            for (Region region : unblockedRegionsList) {
                if (this.isPassed(region)) continue;
                return region;
            }
            return (Region)unblockedRegionsList.get(0);
        }
        int bestBlockedConnectionCount = Integer.MAX_VALUE;
        ArrayList<@NonNull Region> bestRegions = new ArrayList<Region>();
        for (Region region : this.getBlockedCallableRegions()) {
            if (Iterables.isEmpty((Iterable)region.getOutgoingConnections())) continue;
            Integer blockedConnectionCount = this.getBlockedConnectionCount(region);
            assert (blockedConnectionCount != null);
            if (blockedConnectionCount < bestBlockedConnectionCount) {
                bestBlockedConnectionCount = blockedConnectionCount;
                bestRegions.clear();
            }
            if (blockedConnectionCount > bestBlockedConnectionCount) continue;
            bestRegions.add(region);
        }
        if (bestRegions.size() > 0) {
            Collections.sort(bestRegions, NameUtil.NAMEABLE_COMPARATOR);
            return (Region)bestRegions.get(0);
        }
        for (DatumConnection connection : blockedConnectionsList) {
            if (!connection.isPassed()) continue;
            int unblocked = 0;
            for (Region sourceRegion : connection.getSourceRegions()) {
                if (!Iterables.contains(this.getUnblockedRegions(), (Object)sourceRegion) && !Iterables.contains(this.getOrdering(), (Object)sourceRegion)) continue;
                ++unblocked;
            }
            if (unblocked <= 0) continue;
            for (Region targetRegion : connection.getTargetRegions()) {
                if (bestRegions.contains(targetRegion) || Iterables.contains(this.getOrdering(), (Object)targetRegion)) continue;
                bestRegions.add(targetRegion);
            }
        }
        if (bestRegions.size() > 0) {
            Collections.sort(bestRegions, NameUtil.NAMEABLE_COMPARATOR);
            return (Region)bestRegions.get(0);
        }
        throw new IllegalStateException("Failed to schedule " + scheduledRegion);
    }
}

