/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.MappingRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AssignmentPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.RealizedPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.SpeculatedPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.SpeculatingPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.SpeculationPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TraceClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.MicroMappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.StatusNode;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class MappingPartitioner {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull TransformationPartitioner transformationPartitioner;
    protected final @NonNull MappingRegion region;
    private @Nullable List<@NonNull TraceClassAnalysis> consumedTraceClassAnalyses = null;
    private @Nullable List<@NonNull TraceClassAnalysis> producedTraceClassAnalyses = null;
    private @Nullable Set<@NonNull TraceClassAnalysis> superProducedTraceClassAnalyses = null;
    private final @NonNull List<@NonNull Node> leafConstantNodes = new ArrayList<Node>();
    private final @NonNull Map<@NonNull Node, @NonNull Edge> node2traceEdge = new HashMap<Node, Edge>();
    private final @NonNull List<@NonNull Edge> predicatedEdges = new ArrayList<Edge>();
    private final @NonNull List<@NonNull Node> predicatedMiddleNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Node> predicatedOutputNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Node> realizedMiddleNodes = new ArrayList<Node>();
    private final @NonNull List<@NonNull Node> realizedOutputNodes = new ArrayList<Node>();
    private final @NonNull Set<@NonNull NavigableEdge> oldPrimaryNavigableEdges = new HashSet<NavigableEdge>();
    private final @NonNull Set<@NonNull Edge> realizedEdges = new HashSet<Edge>();
    private final @NonNull List<@NonNull Edge> realizedOutputEdges = new ArrayList<Edge>();
    private final @NonNull List<@NonNull Node> trueNodes = new ArrayList<Node>();
    private final @NonNull Map<@NonNull Node, @Nullable Node> traceNode2statusNode = new HashMap<Node, Node>();
    private final @NonNull List<@NonNull NavigableEdge> corrolaryEdges = new ArrayList<NavigableEdge>();
    private final @NonNull List<@NonNull Node> corrolaryNodes = new ArrayList<Node>();
    private final @NonNull Set<@NonNull Edge> alreadyConstantEdges = new HashSet<Edge>();
    private final @NonNull Set<@NonNull Edge> alreadyLoadedEdges = new HashSet<Edge>();
    private final @NonNull Set<@NonNull Edge> alreadyPredicatedEdges = new HashSet<Edge>();
    private final @NonNull Set<@NonNull Node> alreadyPredicatedNodes = new HashSet<Node>();
    private final @NonNull Map<@NonNull Edge, @NonNull AbstractPartition> alreadyRealizedEdges = new HashMap<Edge, AbstractPartition>();
    private final @NonNull Set<@NonNull Node> alreadyRealizedNodes = new HashSet<Node>();
    private final @NonNull Set<@NonNull Node> alreadyTrueNodes = new HashSet<Node>();
    private final @NonNull Map<@NonNull Edge, @NonNull List<@NonNull AbstractPartition>> debugEdge2partitions = new HashMap<Edge, List<AbstractPartition>>();

    public MappingPartitioner(@NonNull TransformationPartitioner transformationPartitioner, @NonNull MappingRegion region) {
        this.scheduleManager = transformationPartitioner.getScheduleManager();
        this.transformationPartitioner = transformationPartitioner;
        this.region = region;
        this.analyzeNodes();
        for (Node traceNode : this.analyzeTraceNodes()) {
            this.analyzeStatusNode(traceNode);
            this.analyzeTraceEdges(traceNode);
        }
        this.analyzeEdges();
    }

    private void addConsumptionOfMiddleNode(@NonNull Node node) {
        this.predicatedMiddleNodes.add(node);
        TraceClassAnalysis consumedTraceAnalysis = this.transformationPartitioner.addConsumer(node.getCompleteClass(), this);
        List<@NonNull TraceClassAnalysis> consumedTraceClassAnalyses2 = this.consumedTraceClassAnalyses;
        if (consumedTraceClassAnalyses2 == null) {
            this.consumedTraceClassAnalyses = consumedTraceClassAnalyses2 = new ArrayList<TraceClassAnalysis>();
        }
        consumedTraceClassAnalyses2.add(consumedTraceAnalysis);
    }

    private void addCorrolary(@NonNull NavigableEdge edge) {
        Node targetNode = edge.getTargetNode();
        assert (this.traceNode2statusNode.containsKey(edge.getSourceNode()));
        assert (targetNode.isRealized());
        assert (!targetNode.isStatus());
        assert (!this.corrolaryEdges.contains(edge));
        this.corrolaryEdges.add(edge);
        this.corrolaryNodes.add(targetNode);
        this.transformationPartitioner.addCorrolary(QVTscheduleUtil.getProperty((NavigableEdge)edge), this.region);
    }

    public void addEdge(@NonNull Edge edge, @NonNull Role newEdgeRole, @NonNull AbstractPartition partition) {
        if (newEdgeRole == Role.CONSTANT) {
            this.alreadyConstantEdges.add(edge);
        } else if (newEdgeRole == Role.LOADED) {
            this.alreadyLoadedEdges.add(edge);
        } else if (newEdgeRole == Role.PREDICATED) {
            this.alreadyPredicatedEdges.add(edge);
        } else if (newEdgeRole == Role.REALIZED) {
            this.alreadyRealizedEdges.put(edge, partition);
        }
        List<@NonNull AbstractPartition> partitions = this.debugEdge2partitions.get(edge);
        if (partitions == null) {
            partitions = new ArrayList<AbstractPartition>();
            this.debugEdge2partitions.put(edge, partitions);
        }
        assert (!partitions.contains(partition));
        partitions.add(partition);
    }

    public boolean addPredicatedNode(@NonNull Node node) {
        return this.alreadyPredicatedNodes.add(node);
    }

    public void addProblem(@NonNull CompilerProblem problem) {
        this.transformationPartitioner.addProblem(problem);
    }

    private void addProductionOfMiddleNode(@NonNull Node node) {
        this.realizedMiddleNodes.add(node);
        TraceClassAnalysis consumedTraceAnalysis = this.transformationPartitioner.addProducer(node.getCompleteClass(), this);
        List<@NonNull TraceClassAnalysis> producedTraceClassAnalyses2 = this.producedTraceClassAnalyses;
        if (producedTraceClassAnalyses2 == null) {
            this.producedTraceClassAnalyses = producedTraceClassAnalyses2 = new ArrayList<TraceClassAnalysis>();
        }
        producedTraceClassAnalyses2.add(consumedTraceAnalysis);
    }

    public boolean addRealizedNode(@NonNull Node node) {
        return this.alreadyRealizedNodes.add(node);
    }

    public boolean addTrueNode(@NonNull Node node) {
        return this.alreadyTrueNodes.add(node);
    }

    private void analyzeEdges() {
        for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)this.region)) {
            if (edge.isSecondary()) continue;
            if (edge.isPredicated()) {
                this.predicatedEdges.add(edge);
            }
            if (!edge.isNavigation()) continue;
            if (edge.isRealized()) {
                this.realizedEdges.add(edge);
                Node sourceNode = edge.getEdgeSource();
                Node targetNode = edge.getEdgeTarget();
                if (this.traceNode2statusNode.containsKey(sourceNode)) {
                    if (targetNode.isRealized() && !targetNode.isStatus()) {
                        this.addCorrolary((NavigableEdge)edge);
                    }
                } else if ((sourceNode.isPredicated() || sourceNode.isRealized()) && !this.traceNode2statusNode.containsKey(targetNode) && (targetNode.isPredicated() || targetNode.isRealized())) {
                    this.realizedOutputEdges.add(edge);
                }
                if (!targetNode.isLoaded()) continue;
                this.scheduleManager.isMiddle(sourceNode);
                continue;
            }
            if (!edge.isMatched() || edge.isCast()) continue;
            assert (!edge.isExpression());
            assert (!edge.isComputation());
            Node targetNode = edge.getEdgeTarget();
            targetNode.isExplicitNull();
        }
        for (Edge edge : this.region.getNavigationEdges()) {
            if (edge.isSecondary() || edge.isRealized()) continue;
            this.oldPrimaryNavigableEdges.add((NavigableEdge)edge);
        }
    }

    private void analyzeNodes() {
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.region)) {
            if (node.isTrue()) {
                this.trueNodes.add(node);
                continue;
            }
            if (node.isExplicitNull()) {
                assert (node.isConstant() && this.hasNoComputationInputs(node));
                this.leafConstantNodes.add(node);
                continue;
            }
            if (node.isPattern()) {
                if (node.isConstant() || node.isLoaded()) continue;
                if (this.scheduleManager.isMiddle(node)) {
                    if (node.isPredicated()) {
                        this.addConsumptionOfMiddleNode(node);
                        continue;
                    }
                    if (node.isRealized()) {
                        this.addProductionOfMiddleNode(node);
                        continue;
                    }
                    if (node.isExplicitNull()) continue;
                    throw new IllegalStateException("middle node must be predicated or realized : " + node);
                }
                if (node.isOperation()) continue;
                if (node.isPredicated()) {
                    this.predicatedOutputNodes.add(node);
                    continue;
                }
                if (!node.isRealized()) continue;
                this.realizedOutputNodes.add(node);
                continue;
            }
            if (!node.isOperation()) continue;
            if (node.isConstant()) {
                if (!this.hasNoComputationInputs(node)) continue;
                this.leafConstantNodes.add(node);
                continue;
            }
            if (!node.isRealized()) continue;
            this.realizedOutputNodes.add(node);
        }
    }

    private void analyzeStatusNode(@NonNull Node traceNode) {
        StatusNode statusNode = null;
        Property statusProperty = this.scheduleManager.basicGetStatusProperty(traceNode);
        if (statusProperty != null) {
            this.transformationPartitioner.getSuccessPropertyDatum(statusProperty);
            RegionHelper<@NonNull MappingRegion> regionHelper = new RegionHelper<MappingRegion>(this.scheduleManager, this.region);
            statusNode = regionHelper.createStatusNode();
            statusNode.setUtility(Node.Utility.STRONGLY_MATCHED);
            NavigableEdge navigableEdge = regionHelper.createNavigationEdge(traceNode, statusProperty, (Node)statusNode, false);
        }
        this.traceNode2statusNode.put(traceNode, (Node)statusNode);
    }

    private void analyzeTraceEdges(@NonNull Node traceNode) {
        for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)traceNode)) {
            if (!edge.isNavigation() || !edge.isRealized()) continue;
            Node tracedNode = QVTscheduleUtil.getTargetNode((Edge)edge);
            this.node2traceEdge.put(tracedNode, edge);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull List<@NonNull Node> analyzeTraceNodes() {
        if (this.realizedMiddleNodes.size() == 0) {
            return Collections.emptyList();
        }
        if (this.realizedMiddleNodes.size() == 1) {
            return Collections.singletonList(this.realizedMiddleNodes.get(0));
        }
        HashMap<@NonNull Node, @NonNull Set<@NonNull Node>> targetFromSourceClosure = new HashMap<Node, Set<Node>>();
        for (Node targetNode : this.realizedMiddleNodes) {
            targetFromSourceClosure.put(targetNode, Sets.newHashSet((Object[])new Node[]{targetNode}));
        }
        for (Node sourceNode : this.realizedMiddleNodes) {
            for (NavigableEdge navigationEdge : sourceNode.getRealizedNavigationEdges()) {
                Node targetNode = navigationEdge.getEdgeTarget();
                @NonNull Set sourceClosure = (Set)targetFromSourceClosure.get(targetNode);
                if (sourceClosure == null) continue;
                sourceClosure.add(sourceNode);
            }
        }
        MappingRegionAnalysis mappingRegionAnalysis = new MappingRegionAnalysis(this.region);
        List<@NonNull Node> headNodes = mappingRegionAnalysis.computeHeadNodes(targetFromSourceClosure, null);
        if (headNodes.size() == 0) {
            return Collections.emptyList();
        }
        return Collections.singletonList(headNodes.get(0));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void check() {
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.region)) {
            if (!node.isSpeculated() && !node.isRealized() || this.hasRealizedNode(node)) continue;
            this.transformationPartitioner.addProblem(CompilerUtil.createRegionError((Region)this.region, "Should have realized " + node, new Object[0]));
        }
        HashSet<@NonNull Edge> allPrimaryEdges = new HashSet<Edge>();
        for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)this.region)) {
            if (edge.isSecondary()) continue;
            allPrimaryEdges.add(edge);
            if (!edge.isRealized() || this.hasRealizedEdge(edge)) continue;
            this.transformationPartitioner.addProblem(CompilerUtil.createRegionError((Region)this.region, "Should have realized " + edge, new Object[0]));
        }
        Set<@NonNull Node> deadNodes = this.computeDeadNodes(QVTscheduleUtil.getOwnedNodes((Region)this.region));
        Set<@NonNull Edge> deadEdges = this.computeDeadEdges(deadNodes);
        allPrimaryEdges.removeAll(deadEdges);
        HashSet<@NonNull Edge> partitionedEdges = new HashSet<Edge>(this.debugEdge2partitions.keySet());
        if (!partitionedEdges.equals(allPrimaryEdges)) {
            @NonNull HashSet extraEdgesSet = Sets.newHashSet(partitionedEdges);
            CompilerUtil.removeAll(extraEdgesSet, allPrimaryEdges);
            for (Edge edge : extraEdgesSet) {
                this.transformationPartitioner.addProblem(CompilerUtil.createRegionWarning((Region)this.region, "Extra " + edge, new Object[0]));
            }
            @NonNull HashSet missingEdgesSet = Sets.newHashSet(allPrimaryEdges);
            missingEdgesSet.removeAll(partitionedEdges);
            for (Edge edge : missingEdgesSet) {
                if (this.transformationPartitioner.getCorrolaryOf(edge) != null) continue;
                this.transformationPartitioner.addProblem(CompilerUtil.createRegionWarning((Region)this.region, "Missing " + edge, new Object[0]));
            }
        }
    }

    private @NonNull Set<@NonNull Edge> computeDeadEdges(@NonNull Iterable<@NonNull Node> deadNodes) {
        HashSet<@NonNull Edge> deadEdges = new HashSet<Edge>();
        for (Node node : deadNodes) {
            Iterables.addAll(deadEdges, (Iterable)QVTscheduleUtil.getIncomingEdges((Node)node));
            Iterables.addAll(deadEdges, (Iterable)QVTscheduleUtil.getOutgoingEdges((Node)node));
        }
        return deadEdges;
    }

    /*
     * Unable to fully structure code
     */
    private @NonNull Set<@NonNull Node> computeDeadNodes(@NonNull Iterable<@NonNull Node> nodes) {
        deadNodes = new HashSet<Node>();
        moreDeadNodes = null;
        for (Node node : nodes) {
            if (node.isHead() || !this.isDead(node, null)) continue;
            if (moreDeadNodes == null) {
                moreDeadNodes = new HashSet<Node>();
            }
            moreDeadNodes.add(node);
        }
        if (moreDeadNodes != null) ** GOTO lbl27
        return deadNodes;
lbl-1000:
        // 1 sources

        {
            deadNodes.addAll((Collection<Node>)moreDeadNodes);
            moreDeadNodesList = new ArrayList<E>(moreDeadNodes);
            moreDeadNodes = null;
            for (Node deadNode : moreDeadNodesList) {
                for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)deadNode)) {
                    sourceNode = edge.getEdgeSource();
                    if (sourceNode.isHead() || !this.isDead(sourceNode, deadNodes)) continue;
                    if (moreDeadNodes == null) {
                        moreDeadNodes = new HashSet<E>();
                    }
                    moreDeadNodes.add(sourceNode);
                }
            }
            if (moreDeadNodes == null) break;
lbl27:
            // 2 sources

            ** while (moreDeadNodes.size() > 0)
        }
lbl28:
        // 2 sources

        return deadNodes;
    }

    private @NonNull MicroMappingRegion createAssignmentRegion(@NonNull Edge outputEdge, int i) {
        AssignmentPartition assignmentPartition = new AssignmentPartition(this, outputEdge);
        MicroMappingRegion microMappingRegion = assignmentPartition.createMicroMappingRegion("\u00abedge" + i + "\u00bb", "_p" + i);
        this.scheduleManager.writeDebugGraphs((Region)microMappingRegion, null);
        assignmentPartition.check(microMappingRegion);
        return microMappingRegion;
    }

    private @NonNull MicroMappingRegion createRealizedRegion() {
        RealizedPartition realizedPartition = new RealizedPartition(this);
        MicroMappingRegion microMappingRegion = realizedPartition.createMicroMappingRegion("\u00abrealized\u00bb", "_r0");
        this.scheduleManager.writeDebugGraphs((Region)microMappingRegion, null);
        realizedPartition.check(microMappingRegion);
        return microMappingRegion;
    }

    private @NonNull MicroMappingRegion createSpeculatedRegion() {
        SpeculatedPartition speculatedPartition = new SpeculatedPartition(this);
        MicroMappingRegion microMappingRegion = speculatedPartition.createMicroMappingRegion("\u00abspeculated\u00bb", "_p2");
        this.scheduleManager.writeDebugGraphs((Region)microMappingRegion, null);
        speculatedPartition.check(microMappingRegion);
        return microMappingRegion;
    }

    private @NonNull MicroMappingRegion createSpeculatingRegion() {
        SpeculatingPartition speculatingPartition = new SpeculatingPartition(this);
        MicroMappingRegion microMappingRegion = speculatingPartition.createMicroMappingRegion("\u00abspeculating\u00bb", "_p1");
        this.scheduleManager.writeDebugGraphs((Region)microMappingRegion, null);
        speculatingPartition.check(microMappingRegion);
        return microMappingRegion;
    }

    private @NonNull MicroMappingRegion createSpeculationRegion() {
        SpeculationPartition speculationPartition = new SpeculationPartition(this);
        MicroMappingRegion microMappingRegion = speculationPartition.createMicroMappingRegion("\u00abspeculation\u00bb", "_p0");
        this.scheduleManager.writeDebugGraphs((Region)microMappingRegion, null);
        speculationPartition.check(microMappingRegion);
        return microMappingRegion;
    }

    public @NonNull Iterable<@NonNull Edge> getAlreadyRealizedEdges() {
        return this.alreadyRealizedEdges.keySet();
    }

    public @Nullable Iterable<@NonNull TraceClassAnalysis> getConsumedTraceClassAnalyses() {
        return this.consumedTraceClassAnalyses;
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getCorrolaryEdges() {
        return this.corrolaryEdges;
    }

    public @NonNull Iterable<@NonNull Node> getCorrolaryNodes() {
        return this.corrolaryNodes;
    }

    public @NonNull Iterable<@NonNull Node> getLeafConstantNodes() {
        return this.leafConstantNodes;
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getOldPrimaryNavigableEdges() {
        return this.oldPrimaryNavigableEdges;
    }

    public @NonNull Iterable<@NonNull Edge> getPredicatedEdges() {
        return this.predicatedEdges;
    }

    public @NonNull Iterable<@NonNull Node> getPredicatedMiddleNodes() {
        return this.predicatedMiddleNodes;
    }

    public @NonNull Iterable<@NonNull Node> getPredicatedOutputNodes() {
        return this.predicatedOutputNodes;
    }

    public @Nullable Iterable<@NonNull TraceClassAnalysis> getProducedTraceClassAnalyses() {
        return this.producedTraceClassAnalyses;
    }

    public @NonNull Iterable<@NonNull Edge> getRealizedEdges() {
        return this.realizedEdges;
    }

    public @NonNull Iterable<@NonNull Node> getRealizedOutputNodes() {
        return this.realizedOutputNodes;
    }

    public @Nullable AbstractPartition getRealizingPartition(@NonNull Edge edge) {
        return this.alreadyRealizedEdges.get(edge);
    }

    public @NonNull MappingRegion getRegion() {
        return this.region;
    }

    protected @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @Nullable Node getStatusNode(@NonNull Node traceNode) {
        return this.traceNode2statusNode.get(traceNode);
    }

    public @Nullable Iterable<@NonNull TraceClassAnalysis> getSuperProducedTraceClassAnalyses() {
        List<@NonNull TraceClassAnalysis> producedTraceClassAnalyses2 = this.producedTraceClassAnalyses;
        if (producedTraceClassAnalyses2 != null) {
            Set<@NonNull TraceClassAnalysis> superProducedTraceClassAnalyses2 = this.superProducedTraceClassAnalyses;
            if (superProducedTraceClassAnalyses2 == null) {
                this.superProducedTraceClassAnalyses = superProducedTraceClassAnalyses2 = new HashSet<TraceClassAnalysis>();
            }
            for (TraceClassAnalysis producedTraceClassAnalysis : producedTraceClassAnalyses2) {
                Iterables.addAll(superProducedTraceClassAnalyses2, producedTraceClassAnalysis.getSuperTraceClassAnalyses());
            }
        }
        return this.superProducedTraceClassAnalyses;
    }

    public @NonNull TraceClassAnalysis getTraceClassAnalysis(@NonNull Node traceNode) {
        CompleteClass traceClass = traceNode.getCompleteClass();
        return this.transformationPartitioner.getTraceClassAnalysis(traceClass);
    }

    public @Nullable Edge getTraceEdge(@NonNull Node node) {
        return this.node2traceEdge.get(node);
    }

    public @NonNull Iterable<@NonNull Node> getTraceNodes() {
        return this.traceNode2statusNode.keySet();
    }

    public @NonNull TransformationPartitioner getTransformationPartitioner() {
        return this.transformationPartitioner;
    }

    public @NonNull Iterable<@NonNull Node> getTrueNodes() {
        return this.trueNodes;
    }

    private boolean hasNoComputationInputs(@NonNull Node node) {
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!edge.isComputation()) continue;
            return false;
        }
        return true;
    }

    public boolean hasConstantEdge(@NonNull Edge edge) {
        return this.alreadyConstantEdges.contains(edge);
    }

    public boolean hasLoadedEdge(@NonNull Edge edge) {
        return this.alreadyLoadedEdges.contains(edge);
    }

    public boolean hasPredicatedEdge(@NonNull Edge edge) {
        return this.alreadyPredicatedEdges.contains(edge);
    }

    public boolean hasPredicatedNode(@NonNull Node node) {
        return this.alreadyPredicatedNodes.contains(node);
    }

    public boolean hasRealizedEdge(@NonNull Edge edge) {
        return this.alreadyRealizedEdges.containsKey(edge);
    }

    public boolean hasRealizedNode(@NonNull Node node) {
        return this.alreadyRealizedNodes.contains(node);
    }

    public boolean hasTrueNode(@NonNull Node node) {
        return this.alreadyTrueNodes.contains(node);
    }

    public @Nullable List<@NonNull MappingRegion> getCorrolaryOf(@NonNull Edge edge) {
        return this.transformationPartitioner.getCorrolaryOf(edge);
    }

    public boolean isCyclic(@NonNull Node node) {
        CompleteClass traceClass = node.getCompleteClass();
        return this.transformationPartitioner.isCyclic(traceClass);
    }

    private boolean isDead(@NonNull Node node, @Nullable Set<@NonNull Node> knownDeadNodes) {
        if (node.isHead()) {
            return false;
        }
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            if (!edge.isNavigation() || knownDeadNodes != null && knownDeadNodes.contains(edge.getEdgeSource())) continue;
            return false;
        }
        for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
            if (!edge.isNavigation() && !edge.isExpression() || knownDeadNodes != null && knownDeadNodes.contains(edge.getEdgeTarget())) continue;
            return false;
        }
        return true;
    }

    public @NonNull Iterable<@NonNull MappingRegion> partition() {
        if (this.transformationPartitioner.getCycleAnalysis(this) == null) {
            return Collections.singletonList(this.region);
        }
        ArrayList<@NonNull MappingRegion> regions = new ArrayList<MappingRegion>();
        if (this.predicatedMiddleNodes.isEmpty()) {
            regions.add((MappingRegion)this.createRealizedRegion());
        } else {
            regions.add((MappingRegion)this.createSpeculationRegion());
            regions.add((MappingRegion)this.createSpeculatingRegion());
            regions.add((MappingRegion)this.createSpeculatedRegion());
        }
        for (Edge outputEdge : this.realizedOutputEdges) {
            if (this.hasRealizedEdge(outputEdge)) continue;
            regions.add((MappingRegion)this.createAssignmentRegion(outputEdge, regions.size()));
        }
        for (Edge edge : this.realizedEdges) {
            if (this.hasRealizedEdge(edge)) continue;
            regions.add((MappingRegion)this.createAssignmentRegion(edge, regions.size()));
        }
        this.check();
        return regions;
    }

    public String toString() {
        return this.region.getName();
    }
}

